/*
 * ShowLib : maintenance des librairies dynamiques GEM
 * (c) 1998/1199 Dominique Brziat
 * Tous droits rservs.
 */

#include <windom.h>	/* appl_getinfo() */
#include <stdio.h>
#include <stdlib.h>
#include <ldg.h>
#include <string.h>
#include <tos.h>

struct lib {
	char name[32];          	/* nom AES de la lib */
	LDG *ldg;               	/* adresse de la LDG */
	int *usedby;     			/* liste des clients */
} *listlib;

#define LISTFONC	0x0001
#define HEADER		0x0002
#define LDGINFO		0x0004
#define MANAGER		0x0008
#define HOLDKEY		0x0010
#define	APPLSEARCH	0x0020

int apid;
int ldg_snd_msg(int frm, int to, int msg, int w3, int w4, int w5, int w6, int w7);
int flags = 0;

/* Pour identifier un process */

#define AES_PROCESS		4

int is_appl_search( void) {
	int dum, parm3;
	if( has_appl_getinfo()) {
		appl_getinfo( AES_PROCESS, &dum, &dum, &parm3, &dum);
		if( parm3 == 1) return 1;	
	}
	return 0;
}

char *appl_name( int id)
{
	int i,m=0x0F;
	static char name[9]; 
	char name2[9];
	
	if( appl_search(0, name2, &m, &i) && i != id) {
		while( appl_search(1, name2, &m, &i)) {
			if( i == id )
				break;
		}
	}
	sscanf( name2, "%s", name);
	return name;
}

/* gestion  des erreurs */

void get_error( char *lib, int type) {
	int error = ldg_error();
	int buf[8];
		
	if( error == 0) {
		do {
			evnt_mesag( buf);
		} while( buf[0] != LDG_ERROR);
		error = buf[3];
	}
	if( type)
		fprintf( stdout, "Error with %s: ", lib);
	else
		fprintf( stdout, "error : ");
	switch( buf[3]) {
		case LDG_LIB_FULLED:
				fprintf( stdout, "not enough memory to declare a library\n");
				break;
		case LDG_APP_FULLED:
				fprintf( stdout, "not enough memory to declare an application\n");
				break;
		case LDG_ERR_EXEC:
				fprintf( stdout, "library is not GemDos executable\n");
				break;
		case LDG_BAD_FORMAT:
				fprintf( stdout, "bad library has format\n");
			break;
		case LDG_LIB_LOCKED:
				fprintf( stdout, "library is locked\n");
				break;
		case LDG_NO_MANAGER:
				fprintf( stdout, "LDG-manager found\n");
				break;
		case LDG_NOT_FOUND:
				fprintf( stdout, "library not found\n");
				break;
		default:
			fprintf( stdout, "unknown error (use a more recent version of showlib)\n");
			break;
		}
	}

void show_lib( char *lib) {
	LDG *ldg;
	int i;
		
	ldg = ldg_exec( apid, lib);
	if( !ldg && !strrchr( lib, '.')) {
		strcat( lib, ".ldg");
		ldg = ldg_exec( apid, lib);
	}
	if( !ldg && strrchr( lib, '\\') && lib[1] != ':') {
		char *p = NULL;
		LDG_INFOS *cook;
	
		if( ldg_cookie( LDG_COOKIE, (long*)&cook)) p = cook->path;
		if( !p) shel_envrn( &p, "LDGPATH=");
		if( !p) p = getenv( "LDGPATH");

		if( p) {
			char buf[128];
			
			strcpy( buf, p);
			strcat( buf, "\\");
			strcat( buf, lib);
			ldg = ldg_exec( apid, buf);
		}
	}
	if( ldg) {
		if( flags & HEADER) {
			fprintf( stdout, "library header %s :\n", lib);
			fprintf( stdout, "          Launched by : %d ", ldg->id);
			if( appl_find( "LDGMGR  ") == ldg->id)
				fprintf( stdout, "(LDG Manager)\n");
			else if( ldg->id == apid)
				fprintf( stdout, "(ShowLib)\n");
			else
				fprintf( stdout, "(??)\n");
			fprintf( stdout, "        Infos library : %s\n", ldg->infos);
			fprintf( stdout, "          Lib version : %X.%02X\n", ldg->vers >> 8, ldg->vers & 0x00FF);
			fprintf( stdout, "  Number of functions : %d\n", ldg->num);
			fprintf( stdout, "            Shareable : %s\n", (ldg->flags & LDG_NOT_SHARED)?"no":"yes");
			fprintf( stdout, "               Locked : %s\n", (ldg->flags & LDG_LOCKED)?"yes":"no");
			fprintf( stdout, "             Resident : %s\n", (ldg->flags & LDG_RESIDENT)?"yes":"no");
			fprintf( stdout, "     Closure function : %s\n", ldg->close?"yes":"no");
			if( ldg->vers_ldg == 0)
				fprintf( stdout, "WARNING: lib was probably compiled with a version of LDG older than 1.00.\n");
			else {
				fprintf( stdout, "         Localization : %s\n", ldg->path);
				fprintf( stdout, " LDG protocol version : %X.%02X\n", ldg->vers_ldg >> 8, ldg->vers_ldg & 0x00FF);
				fprintf( stdout, "Private lib extension : %s\n", ldg->user_ext?"yes":"no");
				fprintf( stdout, "    Special extension : %s\n", ldg->addr_ext?"yes":"no");
			}
		}
		
		if( flags & LISTFONC) {
			if( ldg->num == 0)
				fprintf( stdout, "Warning, this library contents any function!\n");
			else {
				fprintf( stdout, "List of %s functions:\n", lib);
				for( i=0; i<ldg->num; i++) 
					fprintf( stdout, "    [%d] %s : %s\n", i, ldg->list[i].name, ldg->list[i].info);
			}
		}
		
		if( (flags & LISTFONC) == 0 && (flags & HEADER) == 0) {
			if( ldg)
				fprintf( stdout, "Librairie %s: %s\n", lib, ldg->infos);
		}
		
		fprintf( stdout, "\n");
		ldg_term( apid, ldg);
	} else 
		get_error( lib, 1);
}

void show_manager( void) {
	if( appl_find( "LDGMGR  ") != -1) {
		int i,j,buf[8],count;
			
		ldg_snd_msg( apid, appl_find( "LDGMGR  "), LDG_LIST, 0,0,0,0,0);
		i=0;
		/* Attente de la rponse */
		do {
			evnt_mesag( buf);
			i++;
		} while( buf[0] != LDG_LIST && i < 20);
		
		if( buf[0] == LDG_LIST) {
			fprintf( stdout, "Informations about the LDG-manager :\n");
			fprintf( stdout, "      Version : %x.%02x\n", buf[7]>>8, buf[7]&0x00FF);
			fprintf( stdout, "  Max clients : %d\n", buf[6]);
			fprintf( stdout, "     Max libs : %d\n", buf[5]);
			fprintf( stdout, "List of libs and clients :\n");
			listlib = *(struct lib**) &buf[3];
			fprintf( stdout, "  name           adress   used by \n");
			fprintf( stdout, "-------------------------------------------\n");
 			for(i=0;i<buf[5];i++) {
  				if( listlib[i].ldg) {
			    	fprintf( stdout, ". %-13s 0x%lX  ", listlib[i].name,  listlib[i].ldg);
			    	count = 0;
					for( j=0; j<buf[6]; j++) {
						if( listlib[i].usedby[j] != -1) {
							count ++;
							fprintf( stdout, "%d (%s) ", listlib[i].usedby[j],
									 (flags&APPLSEARCH)?appl_name(listlib[i].usedby[j]):"??");
						}
					}
					if( count == 0) {
						if( listlib[i].ldg -> flags & LDG_RESIDENT)
							fprintf( stdout, "(resident in memory)");
						else
							fprintf( stdout, "(client probably crashed)");
					}
					fprintf( stdout, "\n");
				}
			}
		}
		if( i == 19)	fprintf( stdout, "Error : LDG-manager time out\n");
	} else
		fprintf( stdout, "Error : no LDG-manager in memory.\n");
	fprintf( stdout, "\n");
}

void show_help(void) {
	fprintf( stderr, "showlib TTP version 1.30 by D.Brziat 1998\n");
	fprintf( stderr, "compiled with LDG version %s on %s\n",ldg_version.name,__DATE__);
	fprintf( stderr, "syntax is: showlib [options] lib1 lib2 ...\n");
	fprintf( stderr, "options are:\n"
					 "\t-help,-h: print this help\n"
					 "\t-ldg,-l: print info about LDG cookie and enviromentals values\n"
					 "\t-inspect,-i [path]: inspect and list content of LDG-path or [path]\n"
					 "\t-f,-function: print functions of lib\n"
					 "\t-p,-header: print header lib information\n"
					 "\t-manager,-m: print info about the LDG-manager\n"
					 "\t-garbage,-g: perform garbage collector to LDG-manager\n"
					 "\t-all,-a: cumulate all options (execpt -h and -g)\n"
					 "\t-key,-k: press a key to finish program\n\n");
}

void show_info( void) {
	char *p;
	LDG_INFOS *cook;

	fprintf( stdout, "Information sur la configuration :\n");
	
	fprintf( stdout, "  Par cookie 'LDGM':\n");
	
	if( ldg_cookie( LDG_COOKIE, (long*)&cook)) {
		fprintf( stdout, "    version : 0x%-4X\n", cook->version);
		fprintf( stdout, "     chemin : %s\n", cook->path);
		fprintf( stdout, "    garbage : %d sec\n", cook->garbage);
		fprintf( stdout, "       idle : %d msec\n\n", cook->idle);
	} else
		fprintf( stdout, "    pas de cookie 'LDGM' en mmoire.\n");
	fprintf( stdout, "  Par variables d'environnements:\n");
	shel_envrn( &p, "LDGPATH=");
	if( p) fprintf( stdout, "    LDGPATH=%s\n", p);
	shel_envrn( &p, "LDG_GARBAGE=");
	if( p) fprintf( stdout, "    LDG_GARBAGE=%s\n", p);
	shel_envrn( &p, "LDG_IDLE=");
	if( p) fprintf( stdout, "    LDG_IDLE=%s\n", p);
	shel_envrn( &p, "LDG_DEBUG=");
	if( p) fprintf( stdout, "    LDG_DEBUG=%s\n", p);
	fprintf( stdout, "\n");
}

void list_dir( char *p) {
	char buf[255];
	LDG *ldg;
	DTA *save, dta;
	
	
	save = Fgetdta();
	Fsetdta( &dta);
	
	strcpy( buf, p);
	strcat( buf, "\\*");
	
	if( Fsfirst( buf, FA_SUBDIR) >= 0 ) {
		if( strcmp( dta.d_fname, ".") &&
			strcmp( dta.d_fname, "..") &&
			dta.d_attrib & FA_SUBDIR ) {
			strcpy( buf, p);
			strcat( buf, "\\");
			strcat( buf, dta.d_fname);
			list_dir( buf);
		}
		while( Fsnext() >= 0) {
			if( strcmp( dta.d_fname, ".") &&
				strcmp( dta.d_fname, "..") &&
				dta.d_attrib & FA_SUBDIR) {
				strcpy( buf, p);
				strcat( buf, "\\");
				strcat( buf, dta.d_fname);
				list_dir( buf);
			}
		}
	} 
	
	fprintf( stdout, "Content of %s:\n", p);
	
	strcpy( buf, p);
	strcat( buf, "\\*.LDG");
	
	if( Fsfirst( buf, 0) >= 0 ) {
		strcpy( buf, p);
		strcat( buf, "\\");
		strcat( buf, dta.d_fname);
		ldg = ldg_exec( apid, buf);
		fprintf( stdout, "  %13s | %s", dta.d_fname, ldg?ldg->infos:"");
		if( !ldg) get_error(dta.d_fname,0);
		printf( "\n");
		ldg_term( apid, ldg);
		while( Fsnext() >= 0) {
			strcpy( buf, p);
			strcat( buf, "\\");
			strcat( buf, dta.d_fname);
			ldg = ldg_exec( apid, buf);
			fprintf( stdout, "  %13s | %s", dta.d_fname, ldg?ldg->infos:"");
			if( !ldg) get_error(dta.d_fname,0);
			fprintf( stdout, "\n");
			ldg_term( apid, ldg);
		}
	}
	fprintf( stdout, "\n");
	Fsetdta( save);
}

void inspect( char *path) {
	LDG_INFOS *cook;
	char *p;
	if( path) {
		list_dir( path);	
	} else if( ldg_cookie( LDG_COOKIE, (long*)&cook)) {
		/* Rpertoire du cookie */
		list_dir( cook->path);
	} else {
		shel_envrn( &p, "LDGPATH=");
		if( p) {
			list_dir( p);
		} else {
			fprintf( stdout, "Error : set LDG cookie or LDG variables (see \"Installation of LDG\" in LDG.HYP\n");
		}
	}
}

int main( int argc, char *argv[]) {
	int arg = 1;


	if( argc == 1) {
		fprintf( stdout, "Type showlib -h to get some informations.\n");
		return 0;
	}
	apid = appl_init();
	if( is_appl_search	() ) flags |= APPLSEARCH;
	while( arg < argc) {
		if( !strcmp( argv[arg], "-inspect") ||
			!strcmp( argv[arg], "-i")) {
			if( arg+1  < argc && *argv[arg+1] != '-' ) {
				inspect( argv[arg+1]);
				arg += 2;
			} else {
				arg ++;
				inspect(NULL);
			}
		} else
		if( !strcmp( argv[arg], "-ldg") ||
			!strcmp( argv[arg], "-l")) {
			arg ++;
			flags |= LDGINFO;
			show_info();
		} else
		if( !strcmp( argv[arg], "-help") ||
			!strcmp( argv[arg], "-h")) {
			arg ++;
			show_help();
		} else
		if( !strcmp( argv[arg], "-manager") ||
			!strcmp( argv[arg], "-m")) {
			arg ++;
			flags |= MANAGER;
			show_manager();
		} else
		if( !strcmp( argv[arg], "-function") ||
			!strcmp( argv[arg], "-f")) {
			arg ++;
			flags |= LISTFONC;
		} else
		if( !strcmp( argv[arg], "-header") ||
			!strcmp( argv[arg], "-p")) {
			arg ++;
			flags |= HEADER;
		} else
		if( !strcmp( argv[arg], "-all") ||
			!strcmp( argv[arg], "-a")) {
			arg ++;
			flags |= (HEADER|LISTFONC|MANAGER|LDGINFO);
			show_info();
			show_manager();
		} else 
		if( !strcmp( argv[arg], "-key") ||
			!strcmp( argv[arg], "-k")) {
			arg ++;
			flags |= HOLDKEY;
		} else
		if( !strcmp( argv[arg], "-garbage") ||
			!strcmp( argv[arg], "-g")) {
			arg ++;
			ldg_snd_msg( apid, appl_find( "LDGMGR  "), LDG_GARBAGE, 0,0,0,0,0);
		} else
		if( argv[arg][0] != '-')
			show_lib( argv[arg++]);
		else
			fprintf( stdout, "unknown option %s\n", argv[arg++]);
	
	}

/*	if( flags & LDGINFO) show_info();
	if( flags & MANAGER) show_manager();
*/	
	if( flags & HOLDKEY) {
		fprintf( stdout, "Press any key to finish\n");
		bios(2,2);
	}

	appl_exit();
	return 0;
}

