	opt o+,ow-

	opt d-
	output \assemble\prg\moc.prg

dos equ 1   
bios equ 13
xbios equ 14
esc equ 27 

ecran=$44e
palette=$ffff8240
chipvideo=$ff8205
chipsonore=$ffff8800
dma=$ff8604
clavier=$fffc02
hbl=$68
vblqueue=$4ce+4
timerb=$120
ctrlb=$fffffa1b
datab=$fffffa21
timera=$134
ctrla=$fffffa19
dataa=$fffffa1f

save:	macro
	movem.l \1,-(sp)
	endm

load:	macro
	movem.l (sp)+,\1
	endm

appel:	macro
	move.w #\2,-(sp)
	trap #\1
	add.l #\3,sp
	endm

wait:	macro
	appel dos,7,2
	endm

resolut:	macro
	move.w \1,-(sp)
	move.l \2,-(sp)
	move.l \2,-(sp)
	appel xbios,5,12
	endm

syncro:	macro
	appel xbios,$25,2
	endm

init:	macro
	move.l a7,a5
	move.l 4(a5),a5
	move.l $c(a5),d0
	add.l $14(a5),d0
	add.l $1c(a5),d0
	add.l #$250,d0
	move.l d0,d1
	add.l a5,d1
	and.l #-2,d1
	sub.l #16,d1
	move.l d1,a7
	move.l d0,-(sp)
	move.l a5,-(sp)
	clr.w -(sp)
	appel dos,$4a,12
	endm

supervisor:	macro
	clr.l -(sp)
	appel dos,$20,6
	move.l d0,mpile
 BSS
mpile:	ds.l 1
 TEXT
	endm

user:	macro
	move.l mpile,-(sp)
	appel dos,$20,6
	endm

mouseoff:	macro
	move.b #$12,clavier
	endm

mouseon:	macro
	move.b #$08,clavier
	endm

clicoff:	macro
	bclr #0,$484
	endm

clicon:	macro
	bset #0,$484
	endm

write:	macro
	appel dos,9,6
	endm

 section TEXT
debut:	init		; ASS
	supervisor

HAUT=136	; large=224

NB_LVL=8
********** I N I T S **********
RECORD_A=2*(2+1+1+2)
	mouseoff


	move.l sp,pile
	move.l #bidon,musique
*	jsr zik1+4			; ASS
*	moveq #4,d0
*	jsr zik2
	jsr init_all1
	lea ecran2,a0		; ecran2
	move.b 1(a0),$ffff8201.w
	move.b 2(a0),$ffff8203.w

	lea texte_avertissement,a0
	jsr write_txt(pc)
	
	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

degage:	jsr get_clav
	cmp.b #$39,d0
	bne.s degage

	jsr fade_out
	move.l ecran2,a6
	jsr clr_scr

	lea texte_tt,a0
	jsr write_txt(pc)
	
	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

	move #1,tt
tt_ou_pas:	jsr get_clav
	cmp.b #2,d0
	beq restart
	cmp.b #4,d0
	beq high
	cmp.b #5,d0
	beq.s falcon
	cmp.b #3,d0
	bne.s tt_ou_pas
	move.w #8,offset1
	move.w #136-8-3,j2
	move.w #(136-8-3)*160,offj2
	bra stf

falcon:	btst.b #4,save_mode+1
	beq.s tv

	move.w #7,offset1
	move.w #136-7-3,j2
	move.w #(136-7-3)*160,offj2
	move #-1,is_falcon

	move.l #26*160,offset_ovr	; pour decaler
	lea mvga,a1
	bsr axel
	bra restart

tv:	btst.b #5,save_mode+1
	beq.s ntsc

	move.w #0,offset1
	move.w #136,j2
	move.w #136*160,offj2
	move #-1,is_falcon

	move.l #(26+8)*160,offset_ovr	; pour decaler
	lea mpal,a1
	bsr axel
	bra restart

ntsc:	move.w #7,offset1
	move.w #136-7-3,j2
	move.w #(136-7-3)*160,offj2
	move #-1,is_falcon

	move.l #26*160,offset_ovr	; pour decaler
	lea mntsc,a1
	bsr axel
	bra restart

axel:	lea save_regs,a0
	MOVE.W	$FFFF82A4.W,(A0)+
	MOVE.W	$FFFF82A6.W,(A0)+
	MOVE.W	$FFFF82A8.W,(A0)+
	MOVE.W	$FFFF82AA.W,(A0)+

	*lea REGS,A1
	MOVE.W	(A1)+,$FFFF82A4.W
	MOVE.W	(A1)+,$FFFF82A6.W
	MOVE.W	(A1)+,$FFFF82A8.W
	MOVE.W	(A1)+,$FFFF82AA.W
	rts
 DATA
mvga:	DC.W	$0415,$0025,$0025,$0415	; st basse VGA -> 200:252 max
mntsc:	DC.W	$0207,$000D,$000D,$0207 ; st basse NTSC-> 200:252 max
mpal:	DC.W	$0269,$0049,$0049,$0269 ; st basse PAL -> 200:272 not max
 BSS
is_falcon:	ds.w 1
save_mode:	ds.w 1
save_st_rez:	ds.w 1
save_regs:	ds.w 4
 TEXT

high:	clr offset1
	move.w #136,j2
	move.w #136*160,offj2

stf:	clr tt
	move.l #35*160,offset_ovr	; pour decaler
	jsr fade_out
	jsr init_all2

restart:	clr connecte
	clr.l nb_clav		; clear bnuffers
	clr.l nb_j1
	mouseoff
	move.l #bidon,musique
*	move.l #$08080000,(chipsonore).w
*	move.l #$09090000,(chipsonore).w
*	move.l #$0a0a0000,(chipsonore).w
	move.l pile,sp		; load pile
	jsr fade_out
	move.l ecran2,a6
	jsr clr_scr
	lea ecran2,a0		; ecran2
	move.b 1(a0),$ffff8201.w
	move.b 2(a0),$ffff8203.w
*	bra pas_presentation		; ASS

	lea logo,a0
	move.l ecran1,a1
	move #fin_logo-logo,d0
aff_logo1:	move.b (a0)+,(a1)+
	dbf d0,aff_logo1
	move.l ecran1,a0
	jsr ice_unpack

	movem.l 2(a0),d0-d7
	movem.l d0-d7,pilette
	add #34,a0
	move.l ecran2,a1
	add.l offset_ovr,a1	; deja over
	move #32000/4-1,d0
move_ecr:	move.l (a0)+,(a1)+
	dbf d0,move_ecr
	jsr fade_in

	clr.w cpt
presentation1:
	jsr get_clav
	cmp.b #$39,d0
	beq cont_present
	move.w cpt,d1
	cmp.w #WAIT_DEMO*50,d1
	bne.s presentation1

	jsr the_mega_demo

cont_present:
	jsr fade_out
*	move.l #zik1,musique		; ASS

	move.l ecran2,a6
	jsr clr_scr

	lea chaos_m,a0
	move.l ecran1,a1
	move #fin_chaos_m-chaos_m,d0
aff_logo2b:	move.b (a0)+,(a1)+
	dbf d0,aff_logo2b
	move.l ecran1,a0
	jsr ice_unpack

	movem.l 2(a0),d0-d7
	movem.l d0-d7,pilette
	add #34,a0
	move.l ecran2,a1
	add.l offset_ovr,a1	; deja over
	move #32000/4-1,d0
move_ecr2b:	move.l (a0)+,(a1)+
	dbf d0,move_ecr2b
	jsr fade_in

	clr.w cpt
presentation2c:
	jsr get_clav
	cmp.b #$39,d0
	beq.s presentation2b
	cmp.b #$1c,d0
	beq.s presentation2b
	move.w cpt,d1
	cmp.w #WAIT_SCR*50,d1
	bne.s presentation2c

presentation2b:
	jsr fade_out
	move.l ecran2,a6
	jsr clr_scr

*******************************
pas_presentation:
	lea texte_c,a0
	jsr write_txt(pc)

	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

	clr maitre_esclave
alors_quoi:	jsr get_clav
	cmp.b #$39,d0
	beq.s pas_4
	cmp.b #1,d0			; ASS
	beq touche_app
	cmp.b #$2e,d0
	bne.s alors_quoi

	move #25,d0
	jsr put_midi
	jsr get_midi
	cmp.b #25,d0
	beq.s i_am_slave

att_autre:	jsr get_clav
	cmp.b #1,d0
	beq.s pas_4
pas_25:	jsr get_midi
	cmp.b #127,d0
	beq.s att_autre
*	cmp.b #128,d0	; pb de deconnection
*	beq.s att_autre
	cmp.b #25,d0
	bne.s pas_25	; ZOB
	move #1,maitre_esclave

i_am_slave:	move #1,connecte
******************************
pas_4:	tst tt
	bne rien_a_voir
	jsr fade_out
	move.l ecran2,a6
	jsr clr_scr
	lea texte,a0
	jsr write_txt(pc)

	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

	mouseon

ecriture:	move.b over_1,d0
	lea ovr_1,a0
	jsr dec_hexa
	move.b over_2,d0
	lea ovr_2,a0
	jsr dec_hexa
	move.b over_3,d0
	lea ovr_3,a0
	jsr dec_hexa
	move.b over_4,d0
	lea ovr_4,a0
	jsr dec_hexa
	move.l #'TWO ',nbplayrs
	move.l #'    ',m_e
	tst connecte
	beq.s pas_connect
	move.l #'FOUR',nbplayrs
	move.l #'MSTR',m_e
	tst maitre_esclave
	beq.s pas_connect
	move.l #'SLAV',m_e
	
pas_connect:
	lea texte,a0
	jsr write_txt(pc)

attdr:	jsr get_clav
	cmp.b #$3b,d0
	bne.s lbl_0
	sub.b #1,over_1
	bra ecriture
lbl_0:	cmp.b #$3c,d0
	bne.s lbl_1
	add.b #1,over_1
	bra ecriture
lbl_1:
	cmp.b #$3d,d0
	bne.s lbl_2
	sub.b #1,over_2
	bra ecriture
lbl_2:	cmp.b #$3e,d0
	bne.s lbl_3
	add.b #1,over_2
	bra ecriture
lbl_3:
	cmp.b #$3f,d0
	bne.s lbl_4
	sub.b #1,over_3
	bra ecriture
lbl_4:	cmp.b #$40,d0
	bne.s lbl_5
	add.b #1,over_3
	bra ecriture
lbl_5:	
	cmp.b #$41,d0
	bne.s lbl_6
	sub.b #1,over_4
	bra ecriture
lbl_6:	cmp.b #$42,d0
	bne.s lbl_7
	add.b #1,over_4
	bra ecriture
lbl_7:
	cmp.b #$1c,d0
	bne attdr

rien_a_voir:mouseoff

	jsr fade_out
	move.l #bidon,musique		; ASS
*	move.l #$08080000,(chipsonore).w
*	move.l #$09090000,(chipsonore).w
*	move.l #$0a0a0000,(chipsonore).w
*	move.l #zik2+8,musique

	move.l ecran1,a6
	jsr clr_scr
	move.l ecran2,a6
	jsr clr_scr

	jsr set_laby_trans	; + players + projectiles + luminosit

	move maitre_esclave,d0
	lea buff_joueurs,a0
	lea ad_j1,a1
	mulu #RECORD_J*2,d0
	add d0,a0
	move.l a0,(a1)+
	add #RECORD_J,a0
	move.l a0,(a1)+ 

	tst.w connecte
	beq.s pas_j34_1
	move maitre_esclave,d0		; autre ordinateur
	eor.w #1,d0
	lea buff_joueurs,a0
	mulu #RECORD_J*2,d0
	add d0,a0
	move.l a0,(a1)+
	add #RECORD_J,a0
	move.l a0,(a1)
pas_j34_1:

	movem.l colors1,d0-d7
	movem.l d0-d7,palette

************** FIN INITS ******************
tourne:
	jsr affiche_sols_plaf	; et efface ecran

	jsr affiche_icones	; les points de vie etc ...
	jsr affiche_murs
	jsr efface_anim_expl

	jsr test_position1	; si trappe , dalle ...
	jsr test_position2	; si teleport , quart/tour
	jsr test_pos_color	; pour fade sur couleurs
	jsr test_declanche

	jsr prepare_buffers	; tri des buffers / joueur
	
	jsr test_posi_projectiles
	jsr mouvement_projectiles
	jsr mouvement_joueurs
	jsr test_position3		; escaliers

	add #1,cpt2
	move.w cpt2,d0
	and.w #7,d0
	cmp #4,d0  
auto_modif:	bne.s pas_mvt_m
			; tout ce qui suit : une fois / 4
	jsr mouvement_monstres
	jsr tir_monstres	;on met la : pas prendre son propre tir
	jsr remonte_points
pas_mvt_m:
	jsr est_ce_la_fin
	jsr est_ce_la_fin2
	lea ecran1,a0
	move.b 1(a0),$ffff8201.w
	move.b 2(a0),$ffff8203.w

	move.l ecran1,d0
	move.l ecran2,ecran1
	move.l d0,ecran2

*	clr palette		; J'SAIS PAS POURQUOI
	
	move cpt,d0

attd_sync:	*cmp.b #$43,clavier	; BE VERY CAREFUL ( VERY VERY )
	*beq restart

	cmp cpt,d0
	beq.s attd_sync		

	bra tourne

***********  THE  END  **************

touche_app:	jsr int_off			; ASS

	mouseon
	user
	wait
	appel dos,0,2

****** Rout. qui met une donnee en charactere
dec_hexa:	and.l #$000000ff,d0
	divu #16,d0
	move.b hexa(pc,d0.w),d0
	move.b d0,(a0)
	swap d0
	move.b hexa(pc,d0.w),d0
	move.b d0,1(a0)
	rts
hexa:	dc.b '0123456789ABCDEF'
***************************************
remonte_points:
	lea buff_joueurs,a0
	moveq #4-1,d7
nb_pt_j:	jsr r_pts(pc)
	add.w #RECORD_J,a0
	dbf d7,nb_pt_j
	rts
r_pts:	tst 16(a0)
	ble.s pas_ressucite
	moveq #3-1,d6
	lea 16(a0),a1
nb_pt_j2:	jsr r_pts2(pc)
	add.w #2,a1
	dbf d6,nb_pt_j2
pas_ressucite:
	rts
r_pts2:	move.w (a1),d0
	add.w #PTS7,d0
	cmp #PTS100,d0
	blt.s r_pts_n
	move.w #PTS100,d0
r_pts_n:	move.w d0,(a1)
	rts
***************************************
efface_anim_expl:	; efface les explosions des boules de feu
	lea explose,a0
	move #16-1,d0
toutes:	move #-1,(a0)
	add #6,a0
	dbf d0,toutes
	rts

*************************************
test_pos_color:	; pour diminuer la claret
	lea buff_joueurs,a0
	lea colors2,a1
	move #4-1,d0
	move save_etage,d2
quatre:	move 8(a0),d1
	cmp d2,d1
	blt.s pas_etage
	sub #4,d1
	mulu #16*2,d1
	add.w d1,a1
	movem.l (a1),d0-d7
	movem.l d0-d7,palette
	add #1,save_etage
	bra.s changed
pas_etage:	add.w #RECORD_J,a0
	dbf d0,quatre
changed:	rts
 BSS
save_etage:	ds.w 1
 TEXT
********************************************
* Pour faire une fin spciale : maxi-partouze
est_ce_la_fin:
	move.l final,d0
	move #4-1,d7
	clr d1	; nb J
	clr d2	; bit
les_autres:	btst d2,d0
	beq.s pas_la
	addq #1,d1
pas_la:	addq #1,d2
	dbf d7,les_autres
	cmp #1,d1
	ble.s pas_encore

	move.l #$ffff0000,final
	movem.l colors1,d0-d7
	movem.l d0-d7,palette

	lea posi_jfinal,a0	; recopie les infos des j dans BSS
	lea buff_joueurs,a1
	moveq #4-1,d0
set_final:	move.l (a0)+,(a1)
	move.l (a0)+,4(a1)
	move.w #5,8(a1)	; etage 5
	move #PTS100,16(a1)	; pts max
	add.w #RECORD_J,a1
	dbf d0,set_final

	lea posi_mfinal,a0
	move #(fin_enr_mfinal-posi_mfinal)/2-1,d0
set_mfinal:	move.w (a0)+,(a1)+
	dbf d0,set_mfinal
	move.w #-1,(a1)+

pas_encore:	rts

est_ce_la_fin2:
	tst.w final
	bpl.s pas_the_end
	tst.w buff_joueurs+4*RECORD_J
	bpl.s pas_the_end

	jsr fade_out
	move.l ecran2,a6
	jsr clr_scr
	lea ecran2,a0		; ecran2
	move.b 1(a0),$ffff8201.w
	move.b 2(a0),$ffff8203.w
	
	lea texte_final,a0
	jsr write_txt(pc)

	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

reset:	jsr get_clav
	cmp.b #$39,d0
	bne.s reset
	move.l $0.w,a7
	move.l $4.l,a6
	jmp (a6)

	rts
pas_the_end:
	rts

 DATA
posi_jfinal:dc.w 19,25,0,-1
	dc.w 18,26,0,1
	dc.w 18,25,-1,0
	dc.w 19,26,1,0

posi_mfinal:
	dc 22,24,0,1,5,0,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1	;1
	dc 20,22,0,1,5,1,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1
	dc 21,23,0,-1,5,2,0,-1,PTS200*12,PTSDOM*3,PTS100,-1,-1
	dc 17,22,1,0,5,0,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1	;2
	dc 15,24,1,0,5,1,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1
	dc 16,23,-1,0,5,3,0,-1,PTS200*12,PTSDOM*3,PTS100,-1,-1
	dc 20,29,-1,0,5,0,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1
	dc 22,27,1,0,5,2,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1	;3
	dc 21,28,1,0,5,3,0,-1,PTS200*12,PTSDOM*3,PTS100,-1,-1
	dc 17,29,0,-1,5,1,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1	;4
	dc 16,28,0,1,5,2,0,-1,PTS200*12,PTSDOM*3,PTS100,-1,-1
	dc 15,27,0,1,5,3,0,-1,PTS200*5,PTSDOM,PTS100,-1,-1

fin_enr_mfinal:
texte_final:dc.b esc,'Y',32,32,'  - YOU  DID  IT -  ',lf
	dc.b "YOU'VE FINISHED MOC "
	dc.b "YOU'RE SURE NO      "
	dc.b "LITTLE PLAYER MATE. ",LF
	dc.b "I GOT NO MEMORY LEFT"
	dc.b "TO SHOW YOU ANY     "
	dc.b "DECENT ENDING .SORRY",LF
	dc.b "REMEMBER GEN AND WAX"
	dc.b "THEY ARE OF THE BEST",0
 BSS
final:	ds.l 1
 TEXT
****************************************
* Affiche Sols en inversant 1 fois sur 2
zero:	dcb.l 14,0
clr_scr:	clr.l d0			; ecran dans a6
	move #160*ovr/4/32-1,d1
eff_ecr:
	rept 32
	move.l d0,(a6)+
	endr
	dbf d1,eff_ecr
	rts
******
affiche_sols_plaf:
	move.l ecran1,a6
	jsr clr_scr

	move #0,quel_j
	lea imp_mvt1,a0
	move.l ad_j1,a1
	save a0-a1
	jsr aff_sols
	load a0-a1
	jsr aff_plafond

	move #1,quel_j
	lea imp_mvt2,a0
	move.l ad_j1+4,a1
	save a0-a1
	jsr aff_sols
	load a0-a1
	jsr aff_plafond

	rts

aff_sols:
	tst 16(a1)
	ble.s mort_pas_sol
	move quel_j,d3	; ca depend du joueur
	mulu #6*8,d3

	move #14,d4		; nb. maps
	move #14*8,d5	; offset dessin
	move #HAUT-70,d6	; offset en lignes / haut
	move.l ecran1,add_ecran

	move #70,d7		; hauteur
	save d4-d7
	lea sols,a1		; ad. dessin
	tst (a0)
	beq.s other
	lea sols+99*112,a1
other:	jsr affiche_dessin
	load d4-d7
mort_pas_sol:
	rts
****
aff_plafond:
	tst 16(a1)
	ble.s mort_pas_plafond

	move quel_j,d3	; ca depend du joueur
	mulu #6*8,d3

	move #14,d4		; nb. maps
	move #14*8,d5	; offset dessin
	move #0,d6		; offset en lignes / haut

	move #29,d7		; hauteur
	save d4-d7
	lea sols+70*112,a1	; ad. dessin
	tst (a0)
	beq.s other2
	lea sols+169*112,a1
other2:	jsr affiche_dessin
	load d4-d7
mort_pas_plafond:
	rts

 DATA
imp_mvt1:	dc.w 0
imp_mvt2:	dc.w 0
imp_mvt34:	dc.w 0
sols:	incbin moc\graphics\sols.blk
 TEXT

********************************************
* Tir des monstres (a va faire mal)

tir_monstres:
	lea buff_joueurs+4*RECORD_J,a6
tir_m:	tst (a6)		; fin enregistrements ?
	bmi fini_mvt_m	
	cmp #1,10(a6)
	bgt.s tir_another	; que les demons & dragons
	move 14(a6),d0	; pas tirer si non actif
	bmi.s tir_another	

	mulu #RECORD_J,d0
	lea buff_joueurs,a1	; ad du j. cours
	add.w d0,a1
	move (a6),d0
	move 2(a6),d1

	cmp (a1),d0
	beq.s mm_x
	cmp 2(a1),d1
	bne.s tir_another	; ou meme x ou meme y
	move (a1),d7
	sub (a6),d7		; pour apres : calculer distance
	clr d3		; meme y
	cmp (a1),d0
	bpl.s sup01
	moveq #1,d2
	bra.s et_apres
sup01:	moveq #-1,d2
	bra.s et_apres
mm_x:	move 2(a1),d7
	sub 2(a6),d7	; pour apres : calculer distance
	clr d2		; meme x
	cmp 2(a1),d1
	bpl.s sup02
	moveq #1,d3
	bra.s et_apres
sup02:	moveq #-1,d3

et_apres:	move 8(a6),d4	: meme niveau ?
	cmp 8(a1),d4
	bne.s tir_another

	tst d7
	bpl.s val_abs
	neg d7
val_abs:	cmp #4,d7		; ne pas tirer si + de 4
	bgt.s tir_another

	move #0,d5		; type boule feu : 0
	move #PTS3,d6	; force
	clr d7		; pour boule-feu numero gal 0
	jsr cree_projectile

tir_another:add.w #RECORD_J,a6
	bra tir_m
fini_tir_m:	rts
********************************************
* Mouvement des Monstres : Mthode Pac-Man

mouvement_monstres:
	lea buff_joueurs+4*RECORD_J,a0
mvt_m:	tst (a0)		; fin enregistrements ?
	bmi.s fini_mvt_m	
	tst 14(a0)		; pas bouger si non actif
	bmi.s move_another	
			; si mort : plus la
	jsr mvt_pac_man(pc)
	tst.w d2
	bmi.s j_enface
	add.w d0,d3
	add.w d1,d4
	move.w d3,(a0)
	move.w d4,2(a0)
j_enface:	move.w d0,4(a0)
	move.w d1,6(a0)
move_another:
	add.w #RECORD_J,a0
	bra.s mvt_m
fini_mvt_m:	rts

j_mort_stop:move #-1,14(a0)
	move #-1,d2
	rts
mvt_pac_man:		; pac = joueur
			; phantom = monstre
	move.w 14(a0),d5	; joueur suivi

	lea buff_joueurs,a1
	mulu #RECORD_J,d5
	add.w d5,a1

	move.w 4(a0),a4	; dx monstre
	move.w 6(a0),a5	; dy monstre
	move.w a4,d0
	move.w a5,d1

	tst 16(a1)
	ble.s j_mort_stop	; ATTENTION : NE PAS COURSER UN J MORT

	tst.w d0
	beq.s pas_bouge_x
	move.w 2(a1),d2	; y joueur
	move.w (a0),d3
	move.w 2(a0),d4
	sub.w d4,d2
	jsr new_move(pc)
	bra.s pas_bouge
pas_bouge_x:move.w (a1),d2	; x joueur
	move.w (a0),d3
	move.w 2(a0),d4
	sub.w d3,d2
	jsr new_move(pc)
pas_bouge:	rts

new_move:	tst.w d2
	beq.s m_axe1
	tst.w d0
	bpl.s m_absdx
	neg.w d0
m_absdx:	tst.w d1
	bpl.s m_absdy
	neg.w d1
m_absdy:	tst.w d2
	bmi.s m_descend1
	exg d0,d1
	bra.s m_axe1
m_descend1:	exg d0,d1
	neg.w d1
	neg.w d0
m_axe1:	move.w d0,d6
	move.w d1,d7
	add.w d3,d0
	add.w d4,d1
	jsr test_obstacle(pc)
	tst.w d0
	bmi good_pac
	cmp.w #1,d0
	beq j_trouve

	move.w a4,d0
	move.w a5,d1
	move.w d6,d5
	move.w d7,a3
	tst.w d2
	bne.s m_noaxe1
	jsr trigo
m_noaxe1:	move.w d0,d6
	move.w d1,d7
	add.w d3,d0
	add.w d4,d1
	jsr test_obstacle(pc)
	tst.w d0
	bmi.s good_pac
	cmp.w #1,d0
	beq.s j_trouve

	move.w d5,d0
	move.w a3,d1
	tst.w d2
	bne.s m_noaxe2
	move.w d6,d0
	move.w d7,d1
m_noaxe2:	jsr trigo
	jsr trigo
	move.w d0,d6
	move.w d1,d7
	add.w d3,d0
	add.w d4,d1
	jsr test_obstacle(pc)
	tst.w d0
	bmi.s good_pac
	cmp.w #1,d0
	beq.s j_trouve
	move.w a4,d0
	move.w a5,d1
	jsr trigo
	jsr trigo
	move.w d0,d6
	move.w d1,d7
	add.w d3,d0
	add.w d4,d1
	jsr test_obstacle(pc)
	tst.w d0
	bmi.s good_pac
	bra.s j_trouve
good_pac:	move.w d6,d0
	move.w d7,d1
	clr.w d2
	rts	
j_trouve:	moveq #-1,d2
	move.w d6,d0
	move.w d7,d1
	rts
test_obstacle:
	save d1-d7/a1-a6
	move.w d0,d2
	move.w d1,d3
	lea laby_testerm,a1		; a0 = fiche signaltique
	save a0
	jsr test_si_quelquechose2	; test diffts monstres
	load a0

	cmp #1,d0
	bne.s pas_nouv
	move.l a1,a2	; sauve pour apres ..
	sub.l #buff_joueurs,a1
	move.l a1,d1
	divu #RECORD_J,d1	; METTRE LE MONSTRE EN ROUTE
	move d1,14(a0)	; d1=num du j a courser
*	move.w cpt2,d2
*	and.w #3,d2
*	cmp.w #1,d2
*	bne.s pas_nouv	; pas frappe
	move.w #5678,14(a2)	; boom
	move.w 18(a0),d2
	sub.w d2,16(a2)	; dans la tete
	bgt.s pas_nouv
	move.l a2,a1	; s'il est mort : objets tombent
	clr d2
	clr d3
	jsr objets_tombent

pas_nouv:	load d1-d7/a1-a6
	rts

 DATA	; pour tests (murs inv - trappes (+inv) -transporteurs-portes)
laby_testerm:dc.l laby_fmurs,laby_trappes,laby_tr_inv,laby_tous_t
	dc.l laby_bois,laby_fer,-1
 TEXT

********************************************
* Mouvement des Projectiles
RECORD_P=2*(2+2+1+1+1+1)

mouvement_projectiles:
	lea buff_objets,a0

tr_suiv:	tst (a0)
	bmi.s fini_proj
	tst.l 4(a0)		; ruse dx=dy=0 ?
	beq.s revient
	move (a0),d2	; x
	move 2(a0),d3
	add 4(a0),d2
	add 6(a0),d3	; future position

	lea laby_project,a1
	save d2/d3/a0
	jsr test_si_quelquechose2
	load d2/d3/a0

	cmp #2,d0		; mur ?
	beq.s collision_mur
	tst d0
	bpl heurte_jou

	move d2,(a0)	; la nouvelle pos
	move d3,2(a0)

revient:	add.w #RECORD_P,a0
	bra.s tr_suiv
fini_proj:	rts

*************** collisions
collision_mur:		; pour se prendre sa propre boule feu
	move #-1,d0
	move (a0),d2	; x
	move 2(a0),d3
	move 8(a0),d1	; quel level ?
	lea buff_joueurs,a1	; debut des tests
	jsr y_a_joueur

	cmp #1,d0		; mais pas pour un monstre
	beq.s heurte_jou

eclate:	tst ruse1		;tous reviennent ici evtelmt vire b-feu
	beq.s pas_ruse1	; RUSE pour utiliser la meme routine
	rts
pas_ruse1:	tst 10(a0)		; un objet lanc n'est pas detruit
	bne.s tombe_terre	; sauf boule-feu

	lea explose,a1
allez:	tst (a1)
	bpl.s non
	move (a0),(a1)+
	move 2(a0),(a1)+
	move 8(a0),(a1)
	bra.s fait	
non:	add #6,a1
	bra.s allez
fait:
	save a0
eclate2:	tst RECORD_P(a0)	; on dcale toute la file
	bmi.s a_decale_file
	move #RECORD_P/2-1,d0
decale_f:	move.w RECORD_P(a0),(a0)+
	dbf d0,decale_f
	bra.s eclate2

a_decale_file:
	move #-1,(a0)	; car a0 pointe sur le dernier
	load a0		; BORDEL C'EST PAS PARCQUE 1 EXPL
	bra tr_suiv		; deja recopi donc on le zappe
			; pour pas faire ADD #RECORD_P

tombe_terre:clr 4(a0)
	clr 6(a0)
	bra revient

******** on decale la file si monstre mort
heurte_jou:			; on a le pointeur du j dans a1
	tst 12(a1)
	beq.s pas_pour_mstr
	move #5678,14(a1)	; code qui veut dire AILLE
	tst 10(a0)
	bne.s pas_pour_mstr
	move #1234,14(a1)	; code qui veut dire ECRAN-FEU
pas_pour_mstr:
	tst 10(a0)
	bne.s pas_bfeu
	move 4(a0),d0
	add d0,(a0)
	move 6(a0),d0
	add d0,2(a0)	; la boule explose sur le mec
	
pas_bfeu:	move 16(a1),d0
	sub 12(a0),d0	; domages pour objets lancs
	move d0,16(a1)
	ble.s faut_il_decaler	; si <=0 : mort
	bra eclate

faut_il_decaler:		; MONSTRE mort=virer de la file
	clr d2
	clr d3
	jsr objets_tombent

	tst 12(a1)
	bne eclate		; Gentil : ne pas decaler la dite file

next_eras:	tst RECORD_J(a1)	; on dcale toute la file
	bmi.s mark_end	; fini
	move #RECORD_J/2-1,d0
decale_fj:	move.w RECORD_J(a1),(a1)+
	dbf d0,decale_fj
	bra.s next_eras

mark_end:	move #-1,(a1)
	bra eclate

objets_tombent:
	move 24(a1),d4
	move 8(a1),d5
	move #-1,24(a1)
	jsr un_objet_tombe	; tombe ou vole
main_droite_tombe:
	move 22(a1),d4
	move 8(a1),d5
	move #-1,22(a1)
	jsr un_objet_tombe
	rts

un_objet_tombe:
	move (a1),d0	; x
	move 2(a1),d1
	tst d4		; num
	bmi.s ren_ds_m	; rien dans la main

	save a1
	jsr nouvelle_determination
	load a1
ren_ds_m:	rts
	
nouvelle_determination:
	lea buff_objets,a1
	
pas_retrouv:tst (a1)
	bmi.s bugguz
	cmp 14(a1),d4
	bne.s pas_celuila

	move d0,(a1)	;x
	move d1,2(a1)
	move d2,4(a1)	;dx
	move d3,6(a1)
	move d5,8(a1)	;d5=lvl
	rts

pas_celuila:add.w #RECORD_P,a1
	bra.s pas_retrouv
			; ASS
bugguz:	*move #$700,palette	; si on ne retrouve pas 1 obj ds liste(BUG)
	rts

********* creation d'un  projectile
cree_projectile:		; C'EST FORCEMENT UNE BOULE DE FEU
	lea buff_objets,a0	; CAR ON NE CREE PAS UN OBJET
not_found:	tst (a0)
	bmi.s found_place
	add.w #RECORD_P,a0
	cmp.l #fin_buff_objets,a0
	bge.s fin_cree_pr
	bra.s not_found
found_place:
	move d0,(a0)+	; x
	move d1,(a0)+	; y
	move d2,(a0)+	; dx
	move d3,(a0)+	; dy
	move d4,(a0)+	; lvl
	move d5,(a0)+	; type
	move d6,(a0)+	; domages
	move d7,(a0)+	; numero
	move #-1,(a0)
fin_cree_pr:rts

 DATA
laby_project:dc.l laby_fmurs,laby_bois,laby_fer,-1; laby a tester pour stopper 1 project

 BSS
explose:	ds.w 16*3

 TEXT

********************************************
* Mouvement des Joueurs au clavier : fleches

; GEN MAX
mouvement_joueurs:
	tst.w connecte
	beq.s i_am_alone
	tst.w maitre_esclave
	bne.s toi_esclave
	jsr traite_j_ici(pc)
	jsr traite_j_labas(pc)
	rts
toi_esclave:jsr traite_j_labas(pc)
i_am_alone:	jsr traite_j_ici(pc)
	rts

traite_j_ici:
	jsr recup_touches(pc)
	move.b touche_j1,d2
	cmp.b #127,d2
	beq.s j_pas_bouge1
	move.l ad_j1,a0
	lea imp_mvt1,a2
	lea touches1,a3
	jsr move_j
j_pas_bouge1:
	move.b touche_j2,d2
	cmp.b #127,d2
	beq.s j_pas_bouge2
	move.l ad_j1+4,a0	; posi puis regard
	lea imp_mvt2,a2
	lea touches2,a3
	jsr move_j
j_pas_bouge2:
	rts

recup_touches:
	lea buffer_j1,a0
	lea nb_j1,a1
	move.b #127,d2	; si rien : retourne 127
	jsr defilete
	move.b d2,touche_j1
	lea buffer_j2,a0
	lea nb_j2,a1
	move.b #127,d2	; si rien : retourne 127
	jsr defilete
	move.b d2,touche_j2
	tst.w connecte
	beq.s pas_j34_2
	jsr emmets_touches(pc)
pas_j34_2:	rts

traite_j_labas:
	jsr recoit_touches(pc)
	move.b touche_j3,d2
	cmp.b #127,d2
	beq.s pas_j3
	move.l ad_j1+8,a0
	lea imp_mvt34,a2	; bidon
	lea touches1,a3
	jsr move_j
pas_j3:	move.b touche_j4,d2
	cmp.b #127,d2
	beq.s pas_j34_2
	move.l ad_j1+12,a0
	lea imp_mvt34,a2	; bidon
	lea touches2,a3
	jsr move_j
	rts

*** Reception-emmision Midi des touches ****
emmets_touches:
	move.b touche_j1,d0
	jsr put_joueur_midi(pc)
	move.b touche_j2,d0
	jsr put_joueur_midi(pc)
	rts
NB_TOUCHE=3
recoit_touches:
	lea touche_j3,a2
	jsr get_joueur_midi(pc)
	lea touche_j4,a2
	jsr get_joueur_midi(pc)
	rts
put_joueur_midi:
	cmp.b #127,d0
	bne.s pas_127_126
	sub.b #1,d0
pas_127_126:moveq #NB_TOUCHE-1,d7
envoie_sur:	jsr put_midi	; envoie des touches
	divs #40,d1		; pour la synchro entre 2 envois
	dbf d7,envoie_sur
	moveq #NB_TOUCHE-1-1,d7
	move.b #125,d0	; caractere de synchro
envoie_sur2:jsr put_midi
	divs #40,d1
	dbf d7,envoie_sur2
	rts
get_joueur_midi:
	tst.w connecte
	beq pas_126
	jsr get_midi
	cmp.b #127,d0
	beq.s get_joueur_midi	; pas de caractere
	cmp.b #125,d0
	beq.s get_joueur_midi	; caractere de synchro
	lea buff_touch_34,a3
	move.b d0,(a3)+
	moveq #1,d7
recoit_sur:	jsr get_midi
	cmp.b #127,d0	; on veut un caractere jouable
	beq.s recoit_sur	; ou un caratere de synchro
	cmp.b #125,d0
	beq.s synchro_midi
	move.b d0,(a3)+
	add.w #1,d7
	bra.s recoit_sur
synchro_midi:
	lea buff_touch_34,a3
	moveq #0,d0
	moveq #0,d1
	cmp.w #NB_TOUCHE,d7
	*beq.s r_4		; ASS
	*move.w #$7,palette	; BUG
r_4:	move.w d7,d6
	sub.w #1,d6
calc_moy:	move.b (a3)+,d1
	add.w d1,d0
	dbf d6,calc_moy
	divu d7,d0
	move.l d0,d1
	swap d0		; la moyenne est entiere ?
	tst.w d0
	beq.s r_bon		; oui
	*move.w #$70,palette	; BUG (ASS)
	move.b buff_touch_34,d1	; premiere touche (defaut)

	cmp.w #NB_TOUCHE,d7		; 3 arrivees ?
	bne.s r_bon
	move.b buff_touch_34+1,d1	; oui
	cmp.b buff_touch_34,d1		; compare les 2 1er
	beq.s r_bon			; identiques ?
	move.b buff_touch_34+2,d1	; non,on prend la 3eme

r_bon:	cmp.b #126,d1
	bne.s pas_126
	add.b #1,d1
pas_126:	move.b d1,(a2)
	rts

; GEN MAX
 BSS
touche_j1:	ds.b 1
touche_j2:	ds.b 1
touche_j3:	ds.b 1
touche_j4:	ds.b 1
buff_touch_34:
	ds.b 8
 TEXT
;
defilete:	move (a1),d1	; nb. carac
	beq.s nada
	move.b (a0),d2
	subq #1,d1		; -1 puis stoke
	move d1,(a1)
defilere:	move.b 1(a0),(a0)+
	dbf d1,defilere
nada:	rts


move_j:	tst 16(a0)		; est-il mort ?
	bgt.s vivant
	rts

vivant:	move.w 4(a0),d0	; dx
	move.w 6(a0),d1	; dy

	cmp.b (a3)+,d2
	beq droit
	cmp.b (a3)+,d2
	beq gauche
	cmp.b (a3)+,d2
	beq arriere
	cmp.b (a3)+,d2
	beq droite

	cmp.b (a3)+,d2	; tourne gauche
	bne.s pas_tourneg
	jsr trigo
	move d0,4(a0)
	move d1,6(a0)
	jsr change
	rts

pas_tourneg:cmp.b (a3)+,d2	; tourne droite
	bne fin_tst1
	jsr trigo
	jsr trigo
	jsr trigo
	move d0,4(a0)
	move d1,6(a0)
	jsr change
	rts
fin_tst1:	cmp.b (a3)+,d2	; tirer ?
	bne.s fin_tst2
	move (a0),d0	; x
	move 2(a0),d1
	move 4(a0),d2
	move 6(a0),d3
*	add d2,d0		; pour pas se le prendre...
*	add d3,d1
	move 8(a0),d4
	move #0,d5		; type boule feu : 0
	move #PTS3,d6	; force
	move #0000,d7	; pour boule-feu numero gal
	cmp #PTS4,20(a0)
	blt.s plus_mana
	sub #PTS4,20(a0)	: enlve du mana
	jsr cree_projectile
plus_mana:	rts
****************** BOUTONS
RECORD_B=2*(2+1+1+1+2+2)

fin_tst2:	cmp.b (a3)+,d2	; push button ?
	bne.s fin_tst3

	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2
	add 4(a0),d0	; position en face
	add 6(a0),d1
	lea boutons,a1

recom_bou:	tst (a1)
	bmi.s fin_bou	
	cmp (a1),d0		; x
	bne.s next_bou
	cmp 2(a1),d1
	bne.s next_bou
	cmp 4(a1),d2	; lvl
	bne.s next_bou
	move.l 8(a1),d3	; motif
	move.l 12(a1),a2	; offset

	tst 6(a1)		; type
	beq.s bou_clr
	cmp.w #1,6(a1)
	beq.s bou_set


	eor.l d3,(a2)	; change
	bra.s fin_bou
		
next_bou:	add.w #RECORD_B,a1
	bra.s recom_bou
fin_bou:	rts

bou_clr:	not.l d3
	and.l d3,(a2)
	bra.s fin_bou
bou_set:	or.l d3,(a2)
	bra.s fin_bou

fin_tst3:	cmp.b (a3)+,d2	; swap objects ?
	bne.s fin_tst4

swapy:	move 22(a0),d0
	move 24(a0),d1
	move d1,22(a0)
	move d0,24(a0)
	rts
***
fin_tst4:	cmp.b (a3)+,d2	; prendre objets
	bne.s fin_tst5

	tst 22(a0)
	bmi.s rieng
	jsr swapy
	tst 22(a0)
	bpl.s mains_p	; les 2 mains prises
	
rieng:	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

	lea buff_objets,a1
	
pas_retrouve:tst (a1)
	bmi.s mains_p
	cmp (a1),d0
	bne.s pas_prendre
	cmp 2(a1),d1
	bne.s pas_prendre
	cmp 8(a1),d2
	bne.s pas_prendre

	move 14(a1),22(a0)	; on le prend !
	move.l #$00ff00ff,(a1)	; x=y=255
	rts

pas_prendre:add.w #RECORD_P,a1
	bra.s pas_retrouve

mains_p:	rts
***
fin_tst5:	cmp.b (a3)+,d2	; laisser tomber objet
	bne.s fin_tst6

	move 22(a0),d4	; num

	bpl.s qqchos
	rts
qqchos:	clr d2		; dx
	clr d3

	move.l a0,a1
	bra main_droite_tombe	; RTS

**
fin_tst6:	cmp.b (a3)+,d2	; lancer objet
	bne.s fin_tst7

	move 22(a0),d4	; num

	bpl.s qqchos2
	rts
qqchos2:	move 4(a0),d2	; dx
	move 6(a0),d3
	move.l a0,a1
	bra main_droite_tombe	; RTS
***
fin_tst7:	cmp.b (a3)+,d2	; frapper un mec
	bne fin_tst8

	moveq #-1,d0
	move (a0),d2	; x
	move 2(a0),d3	; y
	add 4(a0),d2
	add 6(a0),d3
	move 8(a0),d1	; quel level ?
	lea buff_joueurs,a1	; debut des tests
	jsr y_a_joueur

	tst d0
	bmi.s a_rien

	tst 22(a0)
	bmi.s au_poing	; si aucune arme
			; sinon on la recherche
	move 22(a0),d0
	lea buff_objets,a2
pas_found:	tst (a2)
	bmi bugguz
	cmp 14(a2),d0
	beq.s founde
	add.w #RECORD_P,a2
	bra.s pas_found
founde:
	move 12(a2),d0	; domages
	cmp #2,10(a2)	; clef
	beq.s pas_poing
au_poing:	move #PTS6,d0
pas_poing:	sub d0,16(a1)	; on enleve les pts
	tst 12(a1)
	beq.s pas_effsp	; pas pour un monstre
	move #5678,14(a1)
pas_effsp:	tst 16(a1)
	bgt.s a_rien
	move #1,ruse1	; params : a1=info j & ruse1
	jsr faut_il_decaler	; on rebranche la routine pour
	clr ruse1
a_rien:	rts		; decaler si monstre & tomber objets
	
ruse1:	dc.w 0
***
RECORD_S=2*(2+1+1+2+1+2)

fin_tst8:	cmp.b (a3)+,d2	; mettre une clef
	bne.s fin_tst9

	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2
	add 4(a0),d0	; position en face
	add 6(a0),d1
	lea serrures,a1

recom_ser:	tst (a1)
	bmi.s fin_ser
	cmp (a1),d0		; x
	bne.s next_ser
	cmp 2(a1),d1
	bne.s next_ser
	cmp 4(a1),d2	; lvl
	bne.s next_ser
	move 22(a0),d0
	cmp 6(a1),d0
	bne.s fin_ser

	move.w 12(a1),d3	; motif
	move.l 14(a1),a2	; offset

	eor.w d3,(a2)	; change
	move #-1,22(a0)
	bra.s fin_ser		

next_ser:	add.w #RECORD_S,a1
	bra.s recom_ser
fin_ser:	rts
	
fin_tst9:	move.w #$777,palette	; BUG
	rts

***************************************

droite:	jsr trigo
arriere:	jsr trigo
gauche:	jsr trigo
droit:	move.w (a0),d2
	move.w 2(a0),d3
	add d0,d2		; d2=x
	add d1,d3		; d3=y

	save d2-d3
	jsr test_si_quelquechose	; 2=mur,1=joueur
	load d2-d3
	
	tst d0
	bmi.s avancer

	sub #PTS1,16(a0)
	bgt.s viva
	clr d2
	clr d3
	move.l a0,a1
	bra objets_tombent
viva:	rts

avancer:	move.w d2,(a0)
	move.w d3,2(a0)
	jsr change
	rts


trigo:	exg d0,d1		; rotation de +pi/2
	neg d0
	rts
change:	move #1,d0		; inverse flag pour bouger le sol
	sub (a2),d0
	move d0,(a2)
	rts	

**** Sert pour Pac-Man et Mvt Joueurs **************
test_si_quelquechose:		; params en a0
	lea laby_tester,a1

test_si_quelquechose2:		; params en a0
	moveq #-1,d0	; revoie -1 si rien,2 si mur

	save d3		; pour tests suivants
	lsl.w #2,d3
	move 8(a0),d1	; quel level ?
	mulu #32*4,d1
	add.w d1,d3
	
once_a:	move.l (a1)+,a3
	cmp.l #-1,a3
	beq.s that_last
	move.l 0(a3,d3.w),d1
	btst.l d2,d1
	beq.s once_a
	moveq #2,d0		; il y a quelquechose (mur)
	load d3
	rts 		; donc pas la peine d'aller plus loin
that_last:	load d3

monstre_ici:
	move 8(a0),d1	; quel level ?
	lea buff_joueurs,a1	; debut des tests

y_a_joueur:	cmp.l a0,a1
	beq.s moi_mem
	tst (a1)
	bmi.s finishe	; si fin donnees

	cmp (a1),d2		; x
	bne.s moi_mem
	cmp 2(a1),d3	; y
	bne.s moi_mem
	cmp 8(a1),d1	; lvl
	bne.s moi_mem
	tst.w 16(a1)
	ble.s moi_mem	; un cadavre ne GEN personne ..
	move 12(a1),d0	; il y a quelquechose : type mons/gent
	rts
moi_mem:	add.w #RECORD_J,a1
	bra.s y_a_joueur
finishe:
	rts

PTS1=3	; points de domage : heurter un mur
PTS2=10			tomber d'une trappe
PTS3=30	; boule de feu dans la gueule
PTS5=7	; prendre une arme lancee dans la tronche
PTS6=5	; coup de poing

PTS4=37	; pts de magie pour crer une boule
PTS7=4	; increment des points

PTSDOM=9	; points de base domages attaque du monstre
PTSARM=10	; points de base domages des armes

PTS100=600	; points au debut(vie,magie)
PTS200=52	; points de base au debut monstre

 DATA
laby_tester:dc.l laby_fmurs,laby_bois,laby_fer,-1

	; h,g,b,d,tg,td,tir,bouton,swap,prendre
NBTOUCHES=14
touches1:	dc.b $11,$1e,$2d,$20,$10,$12,$1f,$05,$02,$03,$04,$13,$21,$2e
touches2:	dc.b $68,$6a,$6e,$6c,$67,$69,$6b,$66,$63,$64,$65,$4a,$4e,$72

RECORD_J=2*(2+2+1+1+1+1+3+2)
	; demon,dragon,cheva,scorp
 TEXT
**********************************************
* Pour mettre les monstres en rute
test_declanche:

	lea lesquelles,a2
	moveq #21-1,d6
toutes_cases:
	moveq #4-1,d7
	lea buff_joueurs,a0
for_play:	move #-1,d0
	move (a0),d2
	move 2(a0),d3
	add (a2),d2
	add 2(a2),d3
	jsr monstre_ici
	tst d0
	bne.s pas_mon

	tst 14(a1)		; deja actif?
	bpl.s pas_mon
	move.l a0,d0
	sub.l #buff_joueurs,d0
	divu #RECORD_J,d0	; METTRE LE MONSTRE EN ROUTE
	move d0,14(a1)	; d0=num du j a courser


pas_mon:	add.w #RECORD_J,a0
	dbf d7,for_play
	addq #4,a2
	dbf d6,toutes_cases

	rts
 DATA
lesquelles:	dc.w 3,0,-3,0,0,3,0,-3		;4
	dc.w 3,1,3,-1,-3,1,-3,-1	;4
	dc.w 1,3,1,-3,-1,3,-1,-3	;4
	dc.w 2,2,2,-2,-2,2,-2,-2	;4
	dc.w -1,2,2,0,-1,-2,-1,0	;4
	dc.w 1,-1			;1
 TEXT
**********************************************
* Si le joueur/monstre tombe ou est transport
test_position1:		; trappes , dalles
	
	lea buff_joueurs,a0
next_test_pos:
	tst (a0)
	bmi.s finish
	tst 16(a0)
	ble.s voyons	: mort
	save a0
	jsr verify1
	load a0

voyons:	add.w #RECORD_J,a0
	bra.s next_test_pos

finish:	rts

test_position2:		; dalles quart et teleporteur
	
	lea buff_joueurs,a0
next_test_pos2:
	tst (a0)
	bmi.s finish2
	tst 16(a0)
	ble.s voyons2	: mort
	save a0
	jsr verify2
	load a0

voyons2:	add.w #RECORD_J,a0
	bra.s next_test_pos2

finish2:	rts

test_position3:		; escaliers
	
	lea buff_joueurs,a0
next_test_pos3:
	tst (a0)
	bmi.s finish3
	tst 16(a0)
	ble.s voyons3
	save a0

	lea debut_escal,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

teleport2:	cmp.l #fin_escal,a1
	beq.s end_escal
	move.w (a1)+,d3
	move.w (a1)+,d4
	move.w (a1)+,d5
	addq #2*3,a1	; parceque (a1)+

	cmp d0,d3
	bne.s teleport2
	cmp d1,d4
	bne.s teleport2
	cmp d2,d5
	bne.s teleport2
	move -6(a1),(a0)	; destination inconnu
	move -4(a1),2(a0)
	move -2(a1),8(a0)

end_escal:
	load a0

voyons3:	add.w #RECORD_J,a0
	bra.s next_test_pos3

finish3:	rts

******************* VERIFY 2
			; test des transporteurs non escaliers
verify2:	lea fin_escal,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

teleport:	move.w (a1)+,d3
	bmi.s fin_trans
	move.w (a1)+,d4
	move.w (a1)+,d5
	addq #2*3,a1	; parceque (a1)+

	cmp d0,d3
	bne.s teleport
	cmp d1,d4
	bne.s teleport
	cmp d2,d5
	bne.s teleport
	move -6(a1),(a0)	; destination inconnu
	move -4(a1),2(a0)
	move -2(a1),8(a0)
fin_trans:	
******************	
RECORD_DQ=2*(3+2)		; dalles quart de tour
	lea dalles_quart,a1	; on a deja dans d0,d1,d2...

recom_dalquart:
	tst (a1)
	bmi.s fin_dalquart
	cmp (a1),d0		; x
	bne.s next_dalquart
	cmp 2(a1),d1
	bne.s next_dalquart
	cmp 4(a1),d2	; lvl
	bne.s next_dalquart
*	tst 12(a0)		: les monstres agissent pas dessus(ouf)
*	beq.s next_dalquart
	cmp.l 6(a1),a0	; pour pas tourner  l'infini
	beq.s fin_dalquart

	save d0/d1
	move 4(a0),d0
	move 6(a0),d1
	jsr trigo
	move d0,4(a0)
	move d1,6(a0)
	load d0/d1
	
	move.l a0,6(a1)	; yaura p'tete un schmilblik si pas clr

	bra.s pas_lui4	; pour 1/2 tour
next_dalquart:
	cmp.l 6(a1),a0
	bne.s pas_lui4
	clr.l 6(a1)
pas_lui4:	add.w #RECORD_DQ,a1
	bra.s recom_dalquart

fin_dalquart:

	rts
******************* VERIFY 1
verify1:	lea test_case_spe,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

	lsl.w #2,d1
	mulu #32*4,d2
	add.w d2,d1
	
esca_tra:	move.l (a1)+,a2
	cmp.l #-1,a2
	beq.s der
	move.l 0(a2,d1.w),d3
	btst.l d0,d3
	beq.s esca_tra
	sub #1,8(a0)	; y se casse la geule
	sub #PTS2,16(a0)
	tst 16(a0)
	bgt.s viv
	clr d2
	clr d3
	move.l a0,a1
	bra objets_tombent
viv:	rts
der:

RECORD_D=2*(2+1+1+2+2+2)	; 2 de moins que boutons
	lea dalles,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

			; test des dalles
recom_dal:	tst (a1)
	bmi.s fin_dal
	cmp (a1),d0		; x
	bne.s next_dal
	cmp 2(a1),d1
	bne.s next_dal
	cmp 4(a1),d2	; lvl
	bne.s next_dal
	cmp.l 16(a1),a0	; pour pas clignoter
	beq.s fin_dal

	move.l 8(a1),d3	; motif
	move.l 12(a1),a2	; offset

	tst 6(a1)		; type
	beq.s dal_clr
	cmp.w #1,6(a1)
	beq.s dal_set

	eor.l d3,(a2)	; change
	move.l a0,16(a1)	; yaura p'tete un schmilblik si pas clr
	bra.s fin_dal	; ex : 4 mecs sur 4 dalles
		
next_dal:	cmp.l 16(a1),a0
	bne.s pas_lui
	clr.l 16(a1)
pas_lui:	add.w #RECORD_D,a1
	bra.s recom_dal

dal_clr:	not.l d3
	and.l d3,(a2)
	move.l a0,16(a1)
	bra.s fin_dal
dal_set:	or.l d3,(a2)
	move.l a0,16(a1)
	bra.s fin_dal
fin_dal:	

	tst 12(a0)		: les monstres agissent pas dessus(ouf)
	bne.s uniq_joueurs
	rts
uniq_joueurs:
			; a partir d'ici c'est seul pour joueur
***
RECORD_DC=2*(2+1+2+1+1+1+1+2)	; dalles generatrices de monstres
	lea dalles_cree,a1	; on a deja dans d0,d1,d2...

			; test des dalles creatrices
recom_dalc:	tst (a1)
	bmi fin_dalc
	cmp (a1),d0		; x
	bne.s next_dalc
	cmp 2(a1),d1
	bne.s next_dalc
	cmp 4(a1),d2	; lvl
	bne.s next_dalc
*	tst 12(a0)		: les monstres agissent pas dessus(ouf)
*	beq.s next_dalc
	cmp.l 18(a1),a0	; pour pas crer  l'infini
	beq.s fin_dalc

	move.l a0,18(a1)	; yaura p'tete un schmilblik si pas clr

	save a0
	lea buff_joueurs+4*RECORD_J,a0
not_foundj:	tst (a0)
	bmi.s found_placej
	add.w #RECORD_J,a0
	cmp.l #fin_buff_joueurs,a0
	bge.s fin_dalc2	; pas sortir du buffer
	bra.s not_foundj
found_placej:
	move 6(a1),(a0)+	; x
	move 8(a1),(a0)+	; y
	move #1,(a0)+	; dx
	move #0,(a0)+	; dy
	move 10(a1),(a0)+	; lvl
	move 12(a1),(a0)+	; type
	clr (a0)+		; monstre
	move #-1,(a0)+	; non actif
	move 14(a1),(a0)+	; pts vie
	move 16(a1),(a0)+	; pts domage
	addq.w #2,a0	; pas pts magie ...
	move.l #-1,(a0)+	; rien dans les mains
	move #-1,(a0)
	load a0
	bra.s fin_dalc

next_dalc:	cmp.l 18(a1),a0
	bne.s pas_lui2
	clr.l 18(a1)
pas_lui2:	add.w #RECORD_DC,a1
	bra recom_dalc
			; ASS
fin_dalc2:	*move #$770,palette	; si trop plein BUG
	load a0
fin_dalc:

***
RECORD_DCBF=2*(3+2+2+1+2)	; dalles generatrices de boules feu
	lea dalles_cbf,a1	; on a deja dans d0,d1,d2...

recom_dalcbf:
	tst (a1)
	bmi fin_dalcbf
	cmp (a1),d0		; x
	bne.s next_dalcbf
	cmp 2(a1),d1
	bne.s next_dalcbf
	cmp 4(a1),d2	; lvl
	bne.s next_dalcbf
*	tst 12(a0)		: les monstres agissent pas dessus(ouf)
*	beq.s next_dalcbf
	cmp.l 16(a1),a0	; pour pas crer  l'infini
	beq.s fin_dalcbf

	move.l a0,16(a1)	; yaura p'tete un schmilblik si pas clr

	move 6(a1),d0	; x
	move 8(a1),d1
	move 10(a1),d2
	move 12(a1),d3
	move 14(a1),d4
	move #0,d5		; type boule feu : 0
	move #PTS3,d6	; force
	move #0000,d7	; pour boule-feu numero gal
	save a0		; rien apres
	jsr cree_projectile
	load a0

	bra.s fin_dalcbf

next_dalcbf:cmp.l 16(a1),a0
	bne.s pas_lui3
	clr.l 16(a1)
pas_lui3:	add.w #RECORD_DCBF,a1
	bra recom_dalcbf

fin_dalcbf:
	rts

 DATA
test_case_spe:dc.l laby_trappes,laby_tr_inv,-1
 TEXT

**********************************************
* Si le projectile est dvi
test_posi_projectiles:
	
	lea buff_objets,a0
next_test_proj:
	tst (a0)
	bmi.s finish_p
	cmp.l #$00ff00ff,(a0)
	beq.s on_le_porte

	save a0
	jsr verify_p
	load a0

on_le_porte:add.w #RECORD_P,a0
	bra.s next_test_proj

finish_p:	rts

verify_p:	tst.l 4(a0)
	bne.s derni		; seulement si bouge pas
	lea test_case_spe,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

	lsl.w #2,d1
	mulu #32*4,d2
	add.w d2,d1
	
tomber:	move.l (a1)+,a2
	cmp.l #-1,a2
	beq.s derni
	move.l 0(a2,d1.w),d3
	btst.l d0,d3
	beq.s tomber
	sub #1,8(a0)	; y se casse la geule
	rts

derni:	tst.l 4(a0)		; si bouge pas
	beq.s fin_transpo	; test des transporteurs
	lea transporteurs,a1
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2

telep:	move.w (a1)+,d3
	bmi.s fin_transpo
	move.w (a1)+,d4
	move.w (a1)+,d5
	addq #2*3,a1	; parceque (a1)+

	cmp d0,d3
	bne.s telep
	cmp d1,d4
	bne.s telep
	cmp d2,d5
	bne.s telep
	move -6(a1),(a0)	; destination inconnu
	move -4(a1),2(a0)
	move -2(a1),8(a0)
	rts
fin_transpo:	
	tst.l 4(a0)
	bne.s fin_dalp
	move (a0),d0
	move 2(a0),d1
	move 8(a0),d2
	lea dalles,a1	; on a deja dans d0,d1,d2...

			; test des dalles

recom_dalp:	tst (a1)
	bmi.s fin_dalp
	cmp (a1),d0		; x
	bne.s next_dalp
	cmp 2(a1),d1
	bne.s next_dalp
	cmp 4(a1),d2	; lvl
	bne.s next_dalp
	cmp.l 16(a1),a0	; pour pas clignoter
	beq.s fin_dalp

	move.l 8(a1),d3	; motif
	move.l 12(a1),a2	; offset

	tst 6(a1)		; type
	beq.s dal_clrp
	cmp.w #1,6(a1)
	beq.s dal_setp

	eor.l d3,(a2)	; change
	move.l a0,16(a1)	; yaura p'tete un schmilblik si pas clr
	bra.s fin_dalp	; ex : 4 mecs sur 4 dalles
		
next_dalp:	cmp.l 16(a1),a0
	bne.s pas_luip
	clr.l 16(a1)
pas_luip:	add.w #RECORD_D,a1
	bra.s recom_dalp

dal_clrp:	not.l d3
	and.l d3,(a2)
	move.l a0,16(a1)
	bra.s fin_dalp
dal_setp:	or.l d3,(a2)
	move.l a0,16(a1)
	bra.s fin_dalp
fin_dalp:
	rts

*********************************************
* Test des murs pour appel routine d'affichage

affiche_murs:
	move.l ecran1,add_ecran
	move.l ad_j1,a0
	move #0,quel_j	
	jsr affiche_tout_ecr		; avec a2=ad labyrinthe

	move.l ecran1,add_ecran
	add.l #6*8,add_ecran
	move.l ad_j1+4,a0
	move #1,quel_j	
	jsr affiche_tout_ecr
	rts

affiche_tout_ecr:		; parametre a0
	tst 16(a0)
	bgt.s pas_mortus
	rts

pas_mortus:	lea lequel_ou,a3
next_pos:	move.w (a3)+,d0	; pour tester si <0
	bmi.s the_last_one
	move d0,pos_x
	move.w (a3)+,pos_y

again:	move.w (a3)+,d0
	bmi.s next_pos
	move d0,type
	lsl.w #2,d0	
	move.l ad_types(pc,d0.w),a2
	move 8(a0),d0	; le level
	mulu #32*4,d0
	add.w d0,a2
	save a0		; passe posx,posy
	jsr traite		; passe a2 : ad. labyrinthe a tester
	load a0
	bra.s again
the_last_one:
	cmp #1234,14(a0)
	bne.s pas_specia

	clr 14(a0)		; une fois ca suffit
	clr d3		; offset ecran x
	moveq #14,d4	; nb. maps
	move #14*8,d5	; offset dessin
	moveq #17,d7	; hauteur
	clr d6		; offset en lignes / haut
	lea mur_feu,a1
	moveq #8-1,d2
gain1:	save  d2-d7/a1
	jsr affiche_dessin
	load  d2-d7/a1
	add #17,d6
	dbf d2,gain1

pas_specia:	
	cmp #5678,14(a0)
	bne.s pas_specia2

	clr 14(a0)		; une fois ca suffit
	move.w #8*4,d3	; offset ecran x
	moveq #5,d4		; nb. maps
	move #5*8,d5	; offset dessin
	move #35,d6		; offset en lignes / haut
	move #45,d7		; hauteur
	lea flash,a1
	jsr affiche_dessin

pas_specia2:
	rts

ad_types:	dc.l laby_murs,laby_trappes+4*32,laby_trappes,laby_dalles
	dc.l laby_tr_inv,laby_transp,laby_esca_d,laby_esca_m
	dc.l laby_bouton,laby_bouton,laby_esca_m,laby_esca_d
	dc.l laby_autels,laby_autels,laby_chaines
	dc.l laby_anneaux,laby_anneaux,laby_arches,laby_bois,laby_fer
	dc.l laby_iron,laby_iron,laby_or,laby_or

traite:	move 4(a0),d0
	move 6(a0),d1

	move (a0),d2
	move 2(a0),d3
	
	move pos_x,d4
	move pos_y,d5	; on add. le regard droit autant que DY
	beq.s nuli
	subq #1,d5
addi:	add d0,d2
	add d1,d3
	dbf d5,addi
nuli:	
	sub #2,d4
	bmi.s nega
	beq.s drut		; tout doit
	neg d4		; ruse cherchez pas a comprendre
	jsr trigo
	jsr trigo
nega:	jsr trigo		; 1 seul
	neg d4
	subq #1,d4
g_d:	add d0,d2
	add d1,d3
	dbf d4,g_d

drut:	
	cmp #50,type	; RUSE
	beq aff_perso_obj

	lsl.w #2,d3
	move.l 0(a2,d3.w),d4	; car btst.l ...
	btst.l d2,d4	; ici a2=laby_murs
	beq.s zappos
	save a0-a2
	jsr affiche_labyrinthe
	load a0-a2
zappos:	rts

******* afficher les entits mobiles et les bojets
aff_perso_obj:			; les objets d'abord
	move 8(a0),d1	; quel level ?

	lea buff_objets,a1	; test boules de feu & objets

tst_aff_ob:	tst (a1)
	bmi end_tst_ob

	cmp (a1),d2		; x
	bne.s ren_22
	cmp 2(a1),d3	; y
	bne.s ren_22
	cmp 8(a1),d1	; lvl
	bne.s ren_22

	jsr affiche_objet	;MOVE 14(A1),D0

ren_22:	add.w #RECORD_P,a1
	bra.s tst_aff_ob

******************
affiche_objet:		; AFFICHE OBJETS
	save d1-d5/a0-a3
*	move pos_x,d0
*	subq #1,d0
*	lsl.w #1,d0		; x*2
*	move pos_y,d1
*	subq #1,d1		; -1 (si 0 on modif apres)
*	mulu #3*2,d1	; y*6
*	add d0,d1
*	lea table_decal_x,a0
*	move 0(a0,d1.w),d3	; offset x

	move pos_y,d1
	lsl.w #1,d1		; y*2
	lea table_decal_y,a0
	move 0(a0,d1.w),d6	; offset y en lignes / haut
	tst.l 4(a1)
	beq.s tombe_terr
	move #40,d6		; si en l'air
tombe_terr:

	lea type_objets,a0
	move 14(a1),d0	; numero obj
	lsl.w #2,d0		; table de .L
	add.w d0,a0
	move.l (a0),a0
	move pos_y,d0
	subq #1,d0
	bpl.s pas_pied	; ruse de partouze =>aff. obj aux pieds
	clr d0
pas_pied:	lsl.w #3,d0		; y*(4+2+2)

	tst 10(a1)		; b feu
	bne.s pas_feu
	lea ob9,a0
*	tst pos_y		; ASS2
*	beq.s si_zappe	; ne pas afficher b-f qd dessus

pas_feu:	add.w d0,a0
	move.l (a0),a1	; adresse des dessins
	move 4(a0),d4	; nb map
	move 6(a0),d7	; h
	
	move d4,d5		; offset dessin
	lsl.w #3,d5

	cmp #2,pos_x	; centrer objet qd au centre
	bne.s pas_centrer
	move #14,d3
	sub d4,d3
	lsr.w #1,d3		; (14-long)/2
	lsl.w #3,d3		; *8 (d3=offset X) on peut optimiser

pas_centrer:cmp #1,pos_x
	bne.s pas_centrer2
	move pos_y,d3
	subq #1,d3
	lsl.w #3,d3
pas_centrer2:cmp #3,pos_x	; pour faire plaisir  dieu
	bne.s pas_centrer3
	move #14,d3
	sub d4,d3
	move pos_y,d0
	subq #1,d0
	sub d0,d3
	lsl.w #3,d3
pas_centrer3:
	jsr affiche_dessin
		
si_zappe:	load d1-d5/a0-a3
	rts
************************************
end_tst_ob:			; AFFICHE PERSO

	tst d4		; pour afficher les objets a ses pieds
	bne.s pas_pieds	; et zapper persos
	tst d5
	beq das_end
pas_pieds:
	lea buff_joueurs,a1	; on peut pas etre au four et au moulin

nextos:	tst (a1)
	bmi das_end

	cmp (a1),d2		; x
	bne ren
	cmp 2(a1),d3	; y
	bne ren
	cmp 8(a1),d1	; lvl
	bne ren
	tst.w 16(a1)
	ble ren		; il est mort !!!!

	move 10(a1),d0	; c'est le type du joueur vu

pas_folle:	save d1-d3/a0-a3
	move.l a0,a2	; pour apres
	lea diff_types,a0
	mulu #20,d0
	add.w d0,a0

	move 4(a2),d0
	move 6(a2),d1
	muls 4(a1),d0
	muls 6(a1),d1
	add d0,d1		; prod. scal des regards
	
	move.l 4(a0),a2	; c'est le graph a aff.
	tst d1
	bmi.s s_neg		; si -1
	beq.s pi_2		; si 0
	move.l 16(a0),a2
	bra.s s_neg
pi_2:	move.l 12(a0),a2

s_neg:
	move.l (a0),a0	; ad. des dessins

	move pos_x,d0
	subq #1,d0		; (1,2,3) / 0
	move pos_y,d1
	mulu #3,d1
	add d0,d1
	mulu #4+2+2+2+2+2,d1
	add.w d1,a0

	move.l (a0)+,a1	; ad. dessin
	add.l a2,a1
	move (a0)+,d4	; nb. maps
	move (a0)+,d7	; hauteur
	move (a0)+,d3	; offset ecran x
	move (a0)+,d6	; offset en lignes / haut
	move cpt2,d0	; CA PETILLE
	and #3,d0
	add d0,d6
	move (a0)+,d5	; offset dessin

	jsr affiche_personnage

	load d1-d3/a0-a3
	bra.s das_end	; parce qu'une case a peut-etre boule-f
ren:	add.w #RECORD_J,a1
	bra nextos
das_end:	
	lea explose,a1
	
plusieures:	tst (a1)
	bmi dern
	cmp (a1),d2
	bne pas_ecl
	cmp 2(a1),d3
	bne pas_ecl
	cmp 4(a1),d1
	bne.s pas_ecl
**********
	save d1-d5/a0-a3
	move pos_x,d0
	subq #1,d0
	lsl.w #1,d0		; x*2
	move pos_y,d1
	subq #1,d1
	bmi.s pas_voir_dessus
	mulu #3*2,d1	; y*6
	add d0,d1
	lea table_decal_x2,a0
	move 0(a0,d1.w),d3	; offset x

	move pos_y,d1
	subq #1,d1
	lsl.w #1,d1		; y*2
	lea table_decal_y2,a0
	move 0(a0,d1.w),d6	; offset y en lignes / haut

	lea type_objets2,a0
	move pos_y,d0	; numero obj
	subq #1,d0
	lsl.w #3,d0		; table de .L +.W +.W
	add.w d0,a0

	move.l (a0),a1	; adresse des dessins
	move 4(a0),d4	; nb map
	move 6(a0),d7	; h
	
	move d4,d5		; offset dessin
	lsl.w #3,d5

	cmp #1,pos_y
	bne.s goo1
	cmp #2,pos_x
	bne.s pas_voir_dessus	; pas face  gauche et droite
goo1:
	jsr affiche_dessin
pas_voir_dessus:		
	load d1-d5/a0-a3

pas_ecl:	add #6,a1
	bra plusieures

dern:	rts

*************************************
ob1:	dc.l g_objets	; masse d'arme
	dc.w 5,16
	dc.l g_objets+5*8*16
	dc.w 4,10
	dc.l g_objets+8*(5*16+4*10)
	dc.w 3,8
ob2:	dc.l g_objets+1152	; epee
	dc.w 5,8
	dc.l g_objets++1152+8*5*8
	dc.w 4,5
	dc.l g_objets+1152+8*(5*8+4*5)
	dc.w 3,4
ob3:	dc.l g_objets+1728	; epee tortillee
	dc.w 5,15
	dc.l g_objets+1728+8*5*15
	dc.w 4,9
	dc.l g_objets+1728+8*(5*15+4*9)
	dc.w 3,4
ob4:	dc.l g_objets+2784	; mace
	dc.w 4,14
	dc.l g_objets+2784+8*4*14
	dc.w 3,9
	dc.l g_objets+1728+8*(4*14+3*9)
	dc.w 2,7
ob5:	dc.l g_objets+3560	; hache
	dc.w 4,17
	dc.l g_objets+3560+8*4*17
	dc.w 3,10
	dc.l g_objets+3560+8*(4*17+3*10)
	dc.w 2,8
ob6:	dc.l g_objets+4472	; staff
	dc.w 5,9
	dc.l g_objets+4472+8*5*9
	dc.w 4,5
	dc.l g_objets+4472+8*(5*9+4*5)
	dc.w 3,4
ob7:	dc.l g_objets+5088	; cle or
	dc.w 1,5
	dc.l g_objets+5088+8*1*5
	dc.w 1,3
	dc.l g_objets+5088+8*1*5
	dc.w 1,3
ob8:	dc.l g_objets+5152	; cle fer
	dc.w 1,4
	dc.l g_objets+5152+8*1*4
	dc.w 1,3
	dc.l g_objets+5152+8*1*4
	dc.w 1,3
ob9:	dc.l g_objets+5208	; boule feu
	dc.w 2,29
	dc.l g_objets+5208+8*2*29
	dc.w 2,19
	dc.l g_objets+5208+8*(2*29+2*19)
	dc.w 1,13

table_decal_x:dc.w 8*0,8*4,8*9
	dc.w 8*0,8*4,8*11
	dc.w 8*0,8*6,8*10
	dc.w 8*1,8*6,8*10

table_decal_y:dc.w 136-17,100,80,69

type_objets:dc.l ob1,ob1,ob1,ob1,ob1,ob2,ob1,ob1
	dc.l ob1,ob6,ob2,ob1,ob2,ob2,ob2,ob2
	dc.l ob5,ob5,ob4,ob4,ob4,ob6,ob6,ob2
	dc.l ob2,ob2,ob2,ob2,ob1,ob1,ob1,ob1
	dc.l ob8,ob8,ob8,ob8,ob8,ob8,ob8,ob8
	dc.l ob7,ob7,ob7,ob7,ob7,ob7,ob7,ob7

g_objets:	incbin moc\graphics\g_objets.blk
*****
type_objets2:
	dc.l dess_explose
	dc.w 10,108
	dc.l dess_explose+8*10*108
	dc.w 5,52
	dc.l dess_explose+8*(10*108+5*52)
	dc.w 4,40
table_decal_x2:
	dc.w 8*0,8*2,8*4
	dc.w 8*0,8*5,8*9
	dc.w 8*0,8*5,8*10

table_decal_y2:
	dc.w 13,25,28
 DATA
dess_explose:incbin moc\graphics\explose.blk
 TEXT
***************************
diff_types:	; de face , attaque , gauche , deriere
	dc.l demon_blk,demon,demon+4872,demon+4872*2,demon+4872*3
	dc.l dragon_blk,dragon,dragon,dragon+11480,dragon+11480*2
	dc.l cheva_blk,cheva,cheva,cheva+4872,cheva+4872*2
	dc.l scorp_blk,scorp,scorp,scorp+8128,scorp+8128*2

demon_blk:	dcb.b 14*3,0 
	dc.l 3*8		; offset dans fichier (meme pour 4)
	dc.w 1,89,0*8,32,4*8	; nb map aff,haut,offset x,delta y,long mem
	dc.l 0
	dc.w 4,89,5*8,32,4*8	;face
	dc.l 0
	dc.w 1,89,13*8,32,4*8

	dc.l 89*4*8
	dc.w 3,55,0*8,35,3*8
	dc.l 89*4*8
	dc.w 3,55,5*8,35,3*8
	dc.l 89*4*8
	dc.w 3,55,10*8,35,3*8

	dc.l 8*(4*89+3*55)
	dc.w 2,44,2*8,33,2*8
	dc.l 8*(4*89+3*55)
	dc.w 2,44,6*8,33,2*8
	dc.l 8*(4*89+3*55)
	dc.w 2,44,10*8,33,2*8

dragon_blk:	dcb.b 14*3,0 
	dc.l 7*8
	dc.w 2,94,0*8,25,9*8
	dc.l 0
	dc.w 9,94,3*8,25,9*8	;face
	dc.l 0
	dc.w 2,94,12*8,25,9*8

	dc.l 94*9*8
	dc.w 6,59,0*8,32,6*8
	dc.l 94*9*8
	dc.w 6,59,4*8,32,6*8
	dc.l 94*9*8
	dc.w 6,59,8*8,32,6*8

	dc.l 8*(9*94+6*59)
	dc.w 5,47,0*8,30,5*8
	dc.l 8*(9*94+6*59)
	dc.w 5,47,5*8,30,5*8
	dc.l 8*(9*94+6*59)
	dc.w 5,47,9*8,30,5*8

cheva_blk:	dcb.b 14*3,0 
	dc.l 3*8
	dc.w 1,89,0*8,32,4*8
	dc.l 0
	dc.w 4,89,5*8,32,4*8	;face
	dc.l 0
	dc.w 1,89,13*8,32,4*8

	dc.l 89*4*8
	dc.w 3,55,0*8,36,3*8
	dc.l 89*4*8
	dc.w 3,55,6*8,36,3*8
	dc.l 89*4*8
	dc.w 3,55,11*8,36,3*8

	dc.l 8*(4*89+3*55)
	dc.w 2,43,2*8,33,2*8
	dc.l 8*(4*89+3*55)
	dc.w 2,43,6*8,33,2*8
	dc.l 8*(4*89+3*55)
	dc.w 2,43,10*8,33,2*8

scorp_blk:	dcb.b 14*3,0 
	dc.l 6*8
	dc.w 1,84,0*8,35,7*8
	dc.l 0
	dc.w 7,84,3*8,35,7*8	;face
	dc.l 0
	dc.w 1,84,13*8,35,7*8

	dc.l 84*7*8
	dc.w 5,52,0*8,37,5*8
	dc.l 84*7*8
	dc.w 5,52,4*8,37,5*8
	dc.l 84*7*8
	dc.w 5,52,9*8,37,5*8

	dc.l 8*(7*84+5*52)
	dc.w 4,42,1*8,34,4*8
	dc.l 8*(7*84+5*52)
	dc.w 4,42,5*8,34,4*8
	dc.l 8*(7*84+5*52)
	dc.w 4,42,9*8,34,4*8

affiche_personnage:
	move.l add_ecran,a6
	move.w quel_j,d0
	mulu offj2,d0
	add.l d0,a6

	sub.w offset1,d6		; rabiote en haut
	bpl pas_coup_h
	neg.w d6
	sub.w d6,d7
	ble.s pas_aff_per
	mulu d5,d6
	add.w d6,a1
	clr.w d6
pas_coup_h:	move.w d6,d0
	add.w d7,d0
	sub.w J2,d0 		; rabiote en bas
	bmi pas_coup_b
	sub d0,d7
pas_coup_b:	tst.w d7
	ble.s pas_aff_per
	mulu #160,d6
	add.w d6,a6
	add.w d3,a6
	subq #1,d4
	subq #1,d7
on_line:	move.l a1,a0
	move.l a6,a2
	move.w d4,d0
on_map:	move.l (a0)+,d1
	move.l (a0)+,d2
	move.l d1,d3
	move.l d2,d6
*	not.w d3
*	not.w d6

	swap d6
	not d6
	swap d6

	or.l d3,d6
	move.l d6,d3
	swap d6
	or.l d3,d6
	and.l d6,d1
	and.l d6,d2
	not.l d6
	and.l d6,(a2)
	and.l d6,4(a2)
	or.l d1,(a2)+
	or.l d2,(a2)+
	dbf d0,on_map
	add.w d5,a1
	add.w #160,a6
	dbf d7,on_line
pas_aff_per:rts

 DATA
; 0:murs 1:trappes plafond 2:trappes sol 3:dalles 4:tr_invisi 5:transport
; 6:escalier bas 7:escalier haut ; 8 & 9 : boutons(de face , cote)
; 10:escal monte2,11:escal descend2,12 & 13:autels,14:chaines
; 15 & 16:anneaux,17:arches,18:portes en bois,19:grilles en fer
; 20 & 21:serrure iron,22 & 23:serrure or
lequel_ou:	
	dc.w 0,3,0,-1
	dc.w 1,3,2,3,50,5,10,11,0,13,14,16,18,19,21,23,-1
	dc.w 4,3,0,-1
	dc.w 3,3,2,3,50,5,10,11,0,13,14,16,18,19,21,23,-1
	dc.w 2,3,2,3,17,50,5,10,11,0,12,15,18,19,21,23,-1

	dc.w 1,2,1,2,3,50,5,6,7,10,11,0,8,12,13,14,15,16,18,19,20,21,22,23,-1
	dc.w 3,2,1,2,3,50,5,6,7,10,11,0,8,12,13,14,15,16,18,19,20,21,22,23,-1
	dc.w 2,2,1,2,3,17,50,5,4,10,11,0,8,12,15,18,19,21,23,-1

	dc.w 1,1,1,2,3,4,6,7,10,11,50,5,0,9,12,14,15,18,19,20,22,-1
	dc.w 3,1,1,2,3,4,6,7,10,11,50,5,0,9,12,14,15,18,19,20,22,-1
	dc.w 2,1,1,2,3,4,6,7,17,50,5,0,8,12,14,15,18,19,21,23,-1; perso avant le mur

	dc.w 1,0,1,2,4,5,6,7,0,-1
	dc.w 3,0,1,2,4,5,6,7,0,-1
	dc.w 2,0,1,2,4,50,-1
	dc.w -1
 TEXT
****************************************
* Sous programme de gestion des decors *
****************************************
affiche_labyrinthe:
	lea table_type,a0
	move.w type,d0		; qu'est ce qu'on veut ?
	beq.s les_murs		; cas particulier des murs
	lsl.w #3,d0
	move.l 4(a0,d0.w),a1
	move.l 0(a0,d0.w),a0	; a0 = add des dessins
	move.w pos_y,d0
	move.w pos_x,d1
	sub.w #1,d1
	mulu #30,d0
	mulu #10,d1
	add.w d1,d0
	add.w d0,a0
	add.w (a0)+,a1		; add dessin
	move.w (a0)+,d4	; nb map
	move.w (a0)+,d7	; hauteur
	move.w (a0)+,d3	; offset x
	lsl.w #3,d3
	move.w (a0)+,d6	; offset y
	move.w d4,d5
	lsl.w #3,d5
	jsr affiche_dessin(pc)
	rts

les_murs:	lea offset_murs,a0
	move.w pos_y,d0
	mulu #30,d0
	add.w d0,a0

	move.l (a0)+,a1	; add des murs concernes
	move.w (a0)+,d6	; offset en y
	move.w (a0)+,d5	; longueurs en octets
	move.w (a0)+,d7	; hauteur
	move.w pos_x,d0
	lsl.w #2,d0
	add.w d0,a0
	move.w (a0)+,d3	; num map de depart
	move.w (a0)+,d4	; nb map

	lsl.w #3,d3
	add.w d3,a1

	lea offset_x,a0
	move.w pos_y,d1
	mulu #10,d1
	move.w pos_x,d0
	add.w d0,d0
	add.w d0,d1
	add.w d1,a0
	move.w (a0),d3		; d3 = offset en x
p:	jsr affiche_dessin(pc)
	rts

* add du dessin,long en map,hauteur,off. ligne suivante
* off. ligne
affiche_dessin:move.l add_ecran,a6
	move.w quel_j,d0
	mulu offj2,d0
	add.l d0,a6

	sub.w OFFSET1,d6	; rabiote en haut
	bpl.s pas_coupe_h
	neg.w d6
	sub.w d6,d7
	ble.s pas_aff_obj
	mulu d5,d6
	add.w d6,a1
	clr.w d6
pas_coupe_h:move.w d6,d0
	add.w d7,d0
	sub.w J2,d0 		; rabiote en bas
	bmi.s pas_coupe_b
	sub d0,d7
pas_coupe_b:tst.w d7
	ble.s pas_aff_obj
	mulu #160,d6
	add.w d6,a6
	add.w d3,a6
	subq #1,d4
	subq #1,d7
one_line:	move.l a1,a0
	move.l a6,a2
	move.w d4,d0
one_map:	move.l (a0)+,d1
	move.l (a0)+,d2
	move.l d1,d3
	move.l d2,d6
	not.w d3
	not.w d6
	or.l d3,d6
	move.l d6,d3
	swap d6
	or.l d3,d6
	and.l d6,d1
	and.l d6,d2
	not.l d6
	and.l d6,(a2)
	and.l d6,4(a2)
	or.l d1,(a2)+
	or.l d2,(a2)+
	dbf d0,one_map
	add.w d5,a1
	add.w #160,a6
	dbf d7,one_line
pas_aff_obj:rts
 DATA
flash:	incbin moc\graphics\flash.blk
mur_feu:	incbin moc\graphics\mur_feu.blk
murs:	incbin moc\graphics\murs.blk
trappes:	incbin moc\graphics\trappes.blk
dess_tr_i:	incbin moc\graphics\trap_inv.blk
dess_dalles:incbin moc\graphics\dalles.blk
dess_transp:incbin moc\graphics\transpor.blk
dess_escal_d:incbin moc\graphics\escal_d.blk
dess_escal_m:incbin moc\graphics\escal_m.blk
dess_bouton1:incbin moc\graphics\boutons.blk
dess_escal_m2:incbin moc\graphics\escal_m2.blk
dess_escal_d2:incbin moc\graphics\escal_d2.blk
dess_autels:incbin moc\graphics\autels.blk
dess_chaines:incbin moc\graphics\chaines.blk
dess_anneaux:incbin moc\graphics\anneaux.blk
dess_arches:incbin moc\graphics\portes.blk
dess_bois:	incbin moc\graphics\p_bois.blk
dess_fer:	incbin moc\graphics\p_fer.blk
dess_iron:	incbin moc\graphics\serrure1.blk
dess_or:	incbin moc\graphics\serrure2.blk

demon:	incbin moc\graphics\demon.blk
dragon:	incbin moc\graphics\dragon.blk
cheva:	incbin moc\graphics\chevalie.blk
scorp:	incbin moc\graphics\scorpion.blk

 ; add depart du type des dessins
 ; Offset y affichage,longeur,num. map,nb. map,hauteur ....

table_type:	dc.l 0,0,tr_plafond,trappes,tr_sol,trappes+2320
	dc.l dalle,dess_dalles,trappes_inv,dess_tr_i
	dc.l transport,dess_transp,escal_d,dess_escal_d
	dc.l escal_m,dess_escal_m,bouton11,dess_bouton1
	dc.l bouton12,dess_bouton1
	dc.l escal_m2,dess_escal_m2,escal_d2,dess_escal_d2
	dc.l autels1,dess_autels,autels2,dess_autels
	dc.l chaines,dess_chaines
	dc.l anneaux1,dess_anneaux,anneaux2,dess_anneaux
	dc.l arches,dess_arches,bois,dess_bois,fer,dess_fer
	dc.l iron1,dess_iron,iron2,dess_iron,or1,dess_or,or2,dess_or

offset_x:	dc.w 0,0,0,96,0
	dc.w 0,0,16,80,0
	dc.w 0,0,24,72,0
	dc.w 0,0,32,64,104

offset_murs:dc.l murs 		; cas particulier pour mur 0
	dc.w 0,64/2,136,0,0,0,2,0,0,2,2,0,0
	dc.l murs+2176*2
	dc.w 9,128,111,0,0,12,4,3,10,0,4,0,0
	dc.l murs+16*8*111+4*8*136
	dc.w 20,144,71,0,0,0,5,5,8,13,5,0,0
	dc.l murs+16*8*111+18*8*71+4*8*136
	dc.w 25,160,51,0,1,1,6,7,6,13,6,19,1

tr_plafond:	dc.w 0,1,4,0,0,32,12,4,1,0,416,1,4,13,0
	dc.w 448,4,8,0,8,704,10,9,2,8,1424,4,8,10,8
	dc.w 1680,5,5,0,19,1880,6,5,4,19,2120,5,5,9,19
tr_sol:	dc.w 0,2,12,0,124,192,12,11,1,125,1248,2,12,12,124
	dc.w 1440,4,24,0,93,2208,10,24,2,93,4128,4,24,10,93
	dc.w 4896,5,12,0,77,5376,6,12,4,77,5952,5,12,9,77
	dc.w 6432,5,8,0,67,6752,6,8,4,67,7136,5,8,9,67
trappes_inv:dc.w 0,2,12,0,124,trappes+2320-dess_tr_i+192,12,11,1,125,192,2,12,12,124,384,4,24,0,93
	dc.w 1152,10,24,2,93,3072,4,24,10,93,0,0,0,0,0,3840,6,12,4,78

dalle:	dcb.w 3*5,0
	dc.w 0,2,16,0,98,256,4,20,5,96,896,2,16,12,98,1152,4,10,0,79
 	dc.w 1472,4,11,5,78,1824,4,10,10,79,2144,3,5,2,69,2264,2,6,6,69,2360,3,5,9,69

transport:	dc.w 2176,2,136,0,0,0,0,0,0,0,8880,2,136,12,0
	dc.w 0,3,111,0,9,0,10,111,2,9,0,3,111,11,9
	dc.w 0,4,71,0,20,0,6,71,4,20,0,4,71,10,20
	dc.w 0,5,51,0,25,11152,4,51,5,25,0,5,51,9,25

escal_d:	dc.w 7280,1,12,0,76,0,0,0,0,0,7376,1,12,13,76
	dc.w 7472,2,39,2,60,0,10,91,2,18,8096,2,39,10,60
	dc.w 8800,2,5,3,57,0,0,0,0,0,8720,2,5,9,57
*dess_escal_d-dess_escal_m+
escal_m:	dc.w dess_escal_d-dess_escal_m+7280,1,12,0,76,0,0,0,0,0,dess_escal_d-dess_escal_m+7376,1,12,13,76
	dc.w 8000,2,43,2,58,0,10,100,2,9,8688,2,43,10,58
	dc.w dess_escal_d-dess_escal_m+8800,2,5,3,57,0,0,0,0,0,dess_escal_d-dess_escal_m+8720,2,5,9,57

bouton11:	dcb.w 4*5,0
	dc.w 0,2,11,6,53,0,0,0,0,0
	dc.w 176,2,7,1,49,176,2,7,6,49,176,2,7,11,49

bouton12:	dcb.w 3*5,0
	dc.w 384,2,6,2,53,0,0,0,0,0,288,2,6,10,54

escal_m2:	dcb.w 3*5,0
	dc.w 3968,2,100,0,9,0,0,0,0,0,3968,2,100,12,9
	dc.w 0,4,62,0,23,5568,6,62,4,23,1984,4,62,10,23
	dc.w 8544,5,46,0,26,12224,6,47,4,25,10384,5,46,9,26

escal_d2:	dcb.w 3*5,0
	dc.w 3968,2,91,0,19,0,0,0,0,0,3968,2,91,12,19
	dc.w 0,4,62,0,24,5424,6,62,4,24,1984,4,62,10,24
	dc.w 8400,5,41,0,29,11680,6,43,4,28,10040,5,41,9,29

autels1:	dcb.w 3*5,0
	dc.w 4520,2,48,2,36,0,6,56,4,36,5528,2,48,10,36
	dc.w 5288,1,30,4,38,2688,4,37,5,37,6296,1,30,9,38
	dc.w 0,0,0,0,0,3872,3,27,6,37
autels2:	dcb.w 6*5,0
	dc.w 2688,4,37,0,37,0,0,0,0,0,2688,4,37,10,37
	dc.w 3872,3,27,1,37,0,0,0,0,0,3872,3,27,10,37

chaines:	dcb.w 3*5,0
	dc.w 2256,2,39,2,42,0,6,47,4,44,3216,2,39,10,42
	dc.w 2880,1,25,4,42,0,0,0,0,0,3840,1,25,9,42
	dc.w 3080,1,17,5,42,0,0,0,0,0,4040,1,17,8,42

anneaux1:	dcb.w 3*5,0
	dc.w 816,1,19,3,37,0,2,27,6,36,1048,1,19,10,37
	dc.w 968,1,10,4,40,432,2,18,6,37,1200,1,10,9,40
	dc.w 0,0,0,0,0,720,1,12,6,37,0,0,0,0,0

anneaux2:	dcb.w 6*5,0
	dc.w 432,2,18,0,37,0,0,0,0,0,432,2,18,12,37
	dc.w 720,1,12,2,37,0,0,0,0,0,720,1,12,10,37

arches:	dcb.w 4*5,0
	dc.w 0,10,111,2,9,0,0,0,0,0
	dc.w 0,0,0,0,0,8880,8,71,3,20,0,0,0,0,0
	dc.w 0,0,0,0,0,13424,6,51,4,25

bois:	dcb.w 3*5,0
	dc.w 7376,2,87,0,15,0,6,87,4,15,7376,2,87,12,15
	dc.w 4176,4,60,0,23,4176,4,60,5,23,4176,4,60,10,23
	dc.w 6096,4,40,1,28,6096,4,40,5,28,6096,4,40,9,28

fer:	dcb.w 3*5,0
	dc.w 7376,2,87,0,15,0,6,87,4,15,7376,2,87,12,15
	dc.w 4176,4,60,0,23,4176,4,60,5,23,4176,4,60,10,23
	dc.w 6096,4,40,1,28,6096,4,40,5,28,6096,4,40,9,28

iron1:	dcb.w 3*5,0
	dc.w 792,1,19,3,39,0,0,0,0,0,1032,1,19,10,39
	dc.w 944,1,11,4,40,0,0,0,0,0,1184,1,11,9,40
iron2:	dcb.w 4*5,0
	dc.w 0,2,27,6,36,0,0,0,0,0
	dc.w 432,2,17,1,38,432,2,17,6,38,432,2,17,11,38
	dc.w 704,1,11,1,39,704,1,11,6,39,704,1,11,11,39

or1:	dcb.w 3*5,0
	dc.w 792,1,19,3,39,0,0,0,0,0,1032,1,19,10,39
	dc.w 944,1,11,4,40,0,0,0,0,0,1184,1,11,9,40
or2:	dcb.w 4*5,0
	dc.w 0,2,27,6,36,0,0,0,0,0
	dc.w 432,2,17,1,38,432,2,17,6,38,432,2,17,11,38
	dc.w 704,1,11,1,39,704,1,11,6,39,704,1,11,11,39

 BSS
add_ecran:	ds.l 1
type:	ds.w 1
pos_x:	ds.w 1
pos_y:	ds.w 1
quel_j:	ds.w 1
 TEXT
*********************************************
* Sous routine de gestion des point de vies *
**		             **
 ; -> a0= pointeur info du joueur  traiter + quel_j
ESP0=0
ESP1=3
ESP2=3 

affiche_icones:
	move.l ecran1,add_ecran
	move.l ad_j1,a0
	move.w #0,quel_j
	save a0
	jsr aff_icones(pc)
	load a0
	jsr aff_objets(pc)
	move.l ad_j1+4,a0
	move.w #1,quel_j
	save a0
	jsr aff_icones(pc)
	load a0
	jsr aff_objets(pc)
	rts
aff_icones:	move.l add_ecran,a6
	move.w quel_j,d0
	mulu OFFJ2,d0
	add.w #ESP0*160,d0
	add.w d0,a6
	move.w quel_j,d0
	sub.w #1,d0
	neg.w d0
	mulu #14*8,d0
	add.w d0,a6		; plac  l'cran

	lea icones_j,a1
	move.w #6-1,d6
	move.w 16(a0),d0	; mort ?
	bgt.s j_pas_mort
	lea icones_j+6*8*29,a1
j_pas_mort:	move.w #29-1,d7	; non
	save a6
	jsr aff_ic(pc)	; bloc main+barettes
	load a6

	lea icones_j+(6*29+6*29+6*33)*8,a1
	move.w maitre_esclave,d0
	lsl.w #1,d0
	add.w quel_j,d0
	mulu #2*29*8,d0
	add.w d0,a1
	save a6
	add.w #(29+ESP1+33+ESP2)*160+2*8,a6
	move.w #29-1,d7
	move.w #2-1,d6
	jsr aff_ic(pc)		; dessin perso
	load a6

	save a6
	add.w #(29+ESP1)*160,a6
	lea icones_j+2*6*29*8,a1
	move.w #6-1,d6
	move.w #33-1,d7
	jsr aff_ic(pc)		; bloc magie

	load a6

	move.w 16(a0),d0	; mort ?
	bgt.s dessin_barettes
	rts
dessin_barettes:
	add.w #2*160,a6
	lea 16(a0),a0
	lea motif_bar,a1
	move.w (a0)+,d6
	move.l (a1)+,d2
	move.l (a1)+,d3
	move.w #4*8,d0
	jsr aff_bar(pc)
	move.w (a0)+,d6
	move.l (a1)+,d2
	move.l (a1)+,d3
	move.w #5*8,d0
	jsr aff_bar(pc)
	move.w (a0)+,d6
	move.l (a1)+,d2
	move.l (a1)+,d3
	move.w #5*8,d0
	jsr aff_bar(pc)
	rts	

aff_bar:	tst d6
	bmi.s peut_pas
	mulu #25,d6
	divu #PTS100,d6
	sub.w #1,d6
	tst.w d6
	bmi.s peut_pas
	move.l a6,a5
	add.w d0,a5
	add.w #160*25,a5
h_bar:	move.l d2,d0
	move.l d3,d1
	or.l d0,d1
	move.l d1,d0
	swap d1
	or.l d1,d0
	not.l d0
	and.l d0,(a5)
	and.l d0,4(a5)
	or.l d2,(a5)
	or.l d3,4(a5)
	sub.w #160,a5
	dbf d6,h_bar
peut_pas:	rts

aff_ic:	move.w d6,d5
	move.l a6,a5
ic_map:	move.l (a1)+,(a5)+
	move.l (a1)+,(a5)+
	dbf d5,ic_map
	add.w #160,a6
	dbf d7,aff_ic
	rts

aff_objets:	move.l add_ecran,a6
	tst 16(a0)
	ble.s pas_main_ga	; ben voyons , il est mort
	move.w quel_j,d0
	mulu OFFJ2,d0
	add.w #ESP0*160,d0
	add.w d0,a6
	move.w quel_j,d0
	sub.w #1,d0
	neg.w d0
	mulu #14*8,d0
	add.w d0,a6		; plac  l'cran

	lea objets_j,a2
	add.w #1*8,a6
	add.w #10*160,a6

	move.w 22(a0),d0
	bmi.s pas_main_dr
	move.w #16-1,d7
	move.w #1-1,d6
	mulu #8*16,d0
	lea 0(a2,d0.w),a1
	save a6
	bsr aff_ic
	load a6
pas_main_dr:add.w #2*8,a6
	move.w 24(a0),d0
	bmi.s pas_main_ga
	move.w #16-1,d7
	move.w #1-1,d6
	mulu #8*16,d0
	lea 0(a2,d0.w),a1
	bsr aff_ic
pas_main_ga:rts	

 DATA
icones_j:	incbin moc\graphics\info.blk
objets_j:	incbin moc\graphics\objets.blk

motif_bar:	dc.w $0078,$0078,$0078,0	; 1er barette
	dc.w $7800,$7800,$7800,0	; 2e barette
	dc.w $0078,$0078,$0078,0	; 3e barette

*OFFSET1=20		; bouffe en bas (over : 2)
*J2=136-OFFSET1-16

offset1	dc.w 20
j2:	dc.w 136-20-16
offj2:	dc.w (136-20-16)*160
offset_ovr:	dc.l 0
maitre_esclave:dc.w 0
connecte:	dc.w 0		; 1=connecte
tt:	dc.w 0		; 1=tt
 BSS
ad_j1:	ds.l 4

 TEXT

********************************************************
* Initialisation des labyrinthes , joueurs , projectiles

set_laby_trans:
	clr.l final		; ben , pour le final

	move #4,save_etage
	move #6*2,d7	; passer la longeur d'un record
	lea laby_transp,a0
	lea trans_decla,a1
	jsr onelaby		; transp visibles
	lea laby_tous_t,a0
	lea transporteurs,a1
	jsr onelaby		; transp. pour test monstres
	move #RECORD_D,d7
	lea laby_dalles,a0
	lea dalles,a1
	jsr onelaby		; les  dalles
	move #RECORD_B,d7
	lea laby_bouton,a0
	lea boutons_dec,a1
	jsr onelaby		; les boutons
	move #RECORD_A,d7
 	lea laby_arches,a0
	lea portes,a1
	jsr onelaby		; les arches des portes
	bra.s set_escaliers
		
onelaby:	clr.l d0		; bset.L

	jsr clear_l		; routine qui fait un labyrinthe

label_1:	move.w (a1),d0	; x
	bmi.s end_init_trans
	move.w 2(a1),d1
	move.w 4(a1),d2	; lvl
	mulu #32*4,d2
	lsl.w #2,d1
	add.w d1,d2
	move.l 0(a0,d2.w),d3
	bset.l d0,d3
	move.l d3,0(a0,d2.w)
	add.w d7,a1
	bra.s label_1	
end_init_trans:rts

clear_l:	save a0
	move #32*NB_LVL-1,d1
put_zeros:	clr.l (a0)+
	dbf d1,put_zeros
	load a0
	rts

******* initialisaton des escaliers montants et descendants
set_escaliers:
	lea laby_esca_m,a0
	jsr clear_l
	lea laby_esca_d,a0
	jsr clear_l

	lea debut_escal,a0
	lea laby_esca_m,a1
	lea laby_esca_d,a2
	clr.l d0
	
set_next_e:	move (a0),d0	; x
	move 2(a0),d1
	move 4(a0),d2	; z1

	move 10(a0),d3	; z2

	move.l a1,a3
	cmp.w d2,d3
	bpl.s mont
	move.l a2,a3
mont:	
	mulu #32*4,d2
	lsl.w #2,d1
	add.w d1,d2
	move.l 0(a3,d2.w),d3
	bset.l d0,d3
	move.l d3,0(a3,d2.w)
	
	add.w #6*2,a0
	cmp.l #fin_escal,a0
	bne.s set_next_e
*******
set_players:lea posi_j1,a0	; recopie les infos des j & m dans BSS
	lea buff_joueurs,a1
	move #(fin_enr_jrs-posi_j1)/2-1,d0
set_pl:	move.w (a0)+,(a1)+
	dbf d0,set_pl
	move.w #-1,(a1)+

******* portes ouvertes ?
	lea laby_bois,a0
	jsr clear_l
	lea laby_fer,a0
	jsr clear_l
	lea portes,a0
*	lea laby_bois,a3
	clr.l d0
anothe:	tst (a0)
	bmi.s proj

	tst 6(a0)
	beq.s ouverte
	
	move (a0),d0
	move 2(a0),d1
	move 4(a0),d2
	mulu #32*4,d2
	lsl.w #2,d1
	add.w d1,d2
	move.l 8(a0),a3
	move.l 0(a3,d2.w),d3
	bset.l d0,d3
	move.l d3,0(a3,d2.w)

ouverte:	add.w #RECORD_A,a0
	bra.s anothe

********* recopie de la liste des projectiles
proj:
	lea projectile1,a0
	lea buff_objets,a1
	move #(fin_enr_pro-projectile1)/2-1,d0
set_pro:	move.w (a0)+,(a1)+
	dbf d0,set_pro
	move.w #-1,(a1)+

******* initialisation des serrures (or/iron)
	lea laby_or,a0
	jsr clear_l
	lea laby_iron,a0
	jsr clear_l
	lea serrures,a0
	clr.l d0
anothero:	tst (a0)
	bmi.s finis

	move (a0),d0
	move 2(a0),d1
	move 4(a0),d2
	mulu #32*4,d2
	lsl.w #2,d1
	add.w d1,d2
	move.l 8(a0),a3
	move.l 0(a3,d2.w),d3
	bset.l d0,d3
	move.l d3,0(a3,d2.w)

	add.w #RECORD_S,a0
	bra.s anothero
finis:
	rts
*******
 BSS
buff_joueurs:	ds.b 150*RECORD_J
fin_buff_joueurs:	ds.w 1
buff_objets:	ds.b 80*RECORD_P
fin_buff_objets:	ds.w 1

laby_transp:ds.l 32*NB_LVL	; pour afficher les transport. visibles
laby_dalles:ds.l 32*NB_LVL	; pour afficher les dalles visibles
laby_bouton:ds.l 32*NB_LVL	; pour afficher les boutons
laby_tous_t:ds.l 32*NB_LVL	; pous tester depl. monstres

laby_esca_m:ds.l 32*NB_LVL	; escaliers montants
laby_esca_d:ds.l 32*NB_LVL

laby_arches:ds.l 32*NB_LVL	; les supports de portes
laby_bois:	ds.l 32*NB_LVL	; porte en bois
laby_fer:	ds.l 32*NB_LVL	; grilles en fer
laby_iron:	ds.l 32*NB_LVL	; serrures iron
laby_or:	ds.l 32*NB_LVL	; serrures or
 TEXT	
*******************************************
*   Le mode de dmo automatique
WAIT_DEMO=5
WAIT_SCR=8
WAIT_TXT=17

the_mega_demo:
	jsr fade_out
*	move.l #zik1,musique		; ASS

recom_demo:	move.l ecran2,a6
	jsr clr_scr

	lea chaos_m,a0
	move.l ecran1,a1
	move #fin_chaos_m-chaos_m,d0
aff_logo2:	move.b (a0)+,(a1)+
	dbf d0,aff_logo2
	move.l ecran1,a0
	jsr ice_unpack

	movem.l 2(a0),d0-d7
	movem.l d0-d7,pilette
	add #34,a0
	move.l ecran2,a1
	add.l offset_ovr,a1	; deja over
	move #32000/4-1,d0
move_ecr2:	move.l (a0)+,(a1)+
	dbf d0,move_ecr2
	jsr fade_in

	clr.w cpt
presentation2:
	jsr get_clav
	cmp.b #$39,d0
	beq cont_present1
	cmp.b #$1c,d0
	beq.s present2
	move.w cpt,d1
	cmp.w #WAIT_SCR*50,d1
	bne.s presentation2

present2:	jsr fade_out


	jsr set_laby_trans	; + players + projectiles

	move maitre_esclave,d0
	lea buff_joueurs,a0
	lea ad_j1,a1
	mulu #RECORD_J*2,d0
	add d0,a0
	move.l a0,(a1)+
	add #RECORD_J,a0
	move.l a0,(a1)+ 

	lea scenes,a6
	lea explic,a5

cont_demo:	cmp.l #fin_demo,a5
	beq recom_demo
	lea buff_joueurs,a0
	lea RECORD_J(a0),a1
	move.l (a6)+,(a0)+	; x,y
	move.l (a6)+,(a0)+	; dx,dy	
	move.w (a6)+,(a0)+	; level
	move.l (a6)+,(a1)+
	move.l (a6)+,(a1)+
	move.w (a6)+,(a1)+
	save a5/a6

	move.l ecran1,a0
	move.l ecran2,ecran1
	move.l a0,ecran2

	jsr affiche_sols_plaf
	jsr affiche_icones
	jsr affiche_murs

	movem.l colors1,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in

	move.l ecran1,a0
	move.l ecran2,ecran1
	move.l a0,ecran2

	load a5/a6
	clr.w cpt
presentation3:
	jsr get_clav
	cmp.b #$39,d0
	beq cont_present1
	cmp.b #$1c,d0
	beq.s present3
	move.w cpt,d1
	cmp.w #WAIT_SCR*50,d1
	bne.s presentation3

present3:	save a5/a6
	jsr fade_out

	move.l ecran2,a6
	jsr clr_scr
	load a5/a6
	move.l a5,a0
	save a6
	jsr write_txt(pc)
	load a6
	move.l a0,a5

	save a5/a6
	movem.l fnt_codee,d0-d7
	movem.l d0-d7,pilette
	jsr fade_in
	load a5/a6

	clr.w cpt
presentation4:
	jsr get_clav
	cmp.b #$39,d0
	beq cont_present1
	cmp.b #$1c,d0
	beq.s present4
	move.w cpt,d1
	cmp.w #WAIT_TXT*50,d1
	bne.s presentation4

present4:	save a5/a6
	jsr fade_out
	load a5/a6
	bra cont_demo
cont_present1:rts

 DATA
scenes:	dc.w 3,21,0,-1,3,10,8,1,0,6	; pour slide show
	dc.w 17,18,-1,0,3,13,3,0,1,3
	dc.w 22,21,-1,0,3,28,6,-1,0,1
	dc.w 29,19,-1,0,1,5,27,-1,0,1
	dc.w 8,8,-1,0,2,16,6,0,1,3
	dc.w 11,14,1,0,6,5,2,-1,0,4
	dc.w 24,9,0,-1,4,11,14,-1,0,6
	dc.w 11,16,-1,0,4,2,18,1,0,4
	dc.w 4,6,-1,0,6,15,10,0,1,3
	dc.w 17,23,0,-1,0,28,14,0,1,5
	dc.w 10,21,0,1,5,27,30,-1,0,5
	dc.w 17,5,-1,0,6,17,6,0,1,6
	dc.w 12,21,1,0,4,25,22,1,0,4
 TEXT
*************************************************************************
*	Unpacking source for Pack-Ice Version 2.1		*
*	a0: Pointer on packed Data and Finally on decrunched Data	*
*************************************************************************
ice_unpack:	movem.l d0-a6,-(sp)		; save registers
	cmpi.l	#'Ice!',(a0)+	; Data packed?
	bne.s	ice2_07		; no!
	move.l	(a0)+,d0
	lea	-8(a0,d0.l),a5
	move.l	(a0)+,(sp)
	lea	108(a0),a4
	movea.l a4,a6
	adda.l	(sp),a6
	movea.l a6,a3
	movea.l a6,a1		; save 120 bytes
	lea	ice2_21+120,a2	; at the end of the
	moveq	#$77,d0		; unpacked data
ice2_00:	move.b	-(a1),-(a2)
	dbra	d0,ice2_00
	bsr	ice2_0c
	bsr.s	ice2_08
	bsr	ice2_10		;; Picture decrunch!
	bcc.s	ice2_04		;; These marked lines are only
	movea.l a3,a1		;; necessary, if you selected the
	move.w	#$0f9f,d7		;; additional picture packer
ice2_01:	moveq	#3,d6		;; in Pack-Ice.
ice2_02:	move.w	-(a1),d4		;;
	moveq	#3,d5		;; If you never use the picture
ice2_03:	add.w	d4,d4		;; pack option, you may delete
	addx.w	d0,d0		;; all the lines marked with ";;"
	add.w	d4,d4		;;
	addx.w	d1,d1		;;
	add.w	d4,d4		;;
	addx.w	d2,d2		;;
	add.w	d4,d4		;;
	addx.w	d3,d3		;;
	dbra	d5,ice2_03		;;
	dbra	d6,ice2_02		;;
	movem.w d0-d3,(a1)	 	;;
	dbra	d7,ice2_01		;;
ice2_04:	move.l	(sp),d0		; move all data to
	lea	-120(a4),a1		; 120 bytes lower
ice2_05:	move.b	(a4)+,(a1)+
	dbra	d0,ice2_05
	subi.l	#$010000,d0
	bpl.s	ice2_05
	moveq	#$77,d0		; restore saved data
	lea	ice2_21+120,a2
ice2_06:	move.b	-(a2),-(a3)
	dbra	d0,ice2_06
ice2_07:	movem.l (sp)+,d0-a6		; restore registers
	rts
ice2_08:	bsr.s	ice2_10
	bcc.s	ice2_0b
	moveq	#0,d1
	bsr.s	ice2_10
	bcc.s	ice2_0a
	lea	ice2_1e(pc),a1
	moveq	#4,d3
ice2_09:	move.l	-(a1),d0
	bsr.s	ice2_13
	swap	d0
	cmp.w	d0,d1
	dbne	d3,ice2_09
	add.l	20(a1),d1
ice2_0a:	move.b	-(a5),-(a6)
	dbra	d1,ice2_0a
ice2_0b:	cmpa.l	a4,a6
	bgt.s	ice2_16
	rts
ice2_0c:	moveq	#3,d0
ice2_0d:	move.b	-(a5),d7
	ror.l	#8,d7
	dbra	d0,ice2_0d
	rts
ice2_0e:	move.w	a5,d7
	btst	#0,d7
	bne.s	ice2_0f
	move.l	-(a5),d7
	addx.l	d7,d7
	bra.s	ice2_15
ice2_0f:	move.l	-5(a5),d7
	lsl.l	#8,d7
	move.b	-(a5),d7
	subq.l	#3,a5
	add.l	d7,d7
	bset	#0,d7
	bra.s	ice2_15
ice2_10:	add.l	d7,d7
	beq.s	ice2_11
	rts
ice2_11:	move.w	a5,d7
	btst	#0,d7
	bne.s	ice2_12
	move.l	-(a5),d7
	addx.l	d7,d7
	rts
ice2_12:	move.l	-5(a5),d7
	lsl.l	#8,d7
	move.b	-(a5),d7
	subq.l	#3,a5
	add.l	d7,d7
	bset	#0,d7
	rts
ice2_13:	moveq	#0,d1
ice2_14:	add.l	d7,d7
	beq.s	ice2_0e
ice2_15:	addx.w	d1,d1
	dbra	d0,ice2_14
	rts
ice2_16:	lea	ice2_1f(pc),a1
	moveq	#3,d2
ice2_17:	bsr.s	ice2_10
	dbcc	d2,ice2_17
	moveq	#0,d4
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bmi.s	ice2_18
	bsr.s	ice2_13
ice2_18:	move.b	6(a1,d2.w),d4
	add.w	d1,d4
	beq.s	ice2_1a
	lea	ice2_20(pc),a1
	moveq	#1,d2
ice2_19:	bsr.s	ice2_10
	dbcc	d2,ice2_19
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bsr.s	ice2_13
	add.w	d2,d2
	add.w	6(a1,d2.w),d1
	bra.s	ice2_1c
ice2_1a:	moveq	#0,d1
	moveq	#5,d0
	moveq	#0,d2
	bsr.s	ice2_10
	bcc.s	ice2_1b
	moveq	#8,d0
	moveq	#$40,d2
ice2_1b:	bsr.s	ice2_13
	add.w	d2,d1
ice2_1c:	lea	2(a6,d4.w),a1
	adda.w	d1,a1
	move.b	-(a1),-(a6)
ice2_1d:	move.b	-(a1),-(a6)
	dbra	d4,ice2_1d
	bra	ice2_08
	dc.b $7f,$ff,$00,$0e,$00,$ff,$00,$07
	dc.b $00,$07,$00,$02,$00,$03,$00,$01
	dc.b $00,$03,$00,$01
ice2_1e:	dc.b $00,$00,$01,$0d,$00,$00,$00,$0e
	dc.b $00,$00,$00,$07,$00,$00,$00,$04
	dc.b $00,$00,$00,$01
ice2_1f:	dc.b $09,$01,$00,$ff,$ff,$08,$04,$02
	dc.b $01,$00
ice2_20:	dc.b $0b,$04,$07,$00,$01,$20,$00,$00
	dc.b $00,$20
 BSS
ice2_21:	ds.b 120		; free space (can be put in BSS)
 TEXT
*************************************************************************
* Affiche un texte avec une Font ; compatible Gem-Dos * (c) Wax 12/9/91 *
*************************************************************************
lf=13
db_cd=32		; debut du codage space au A
hauteur=16
long=1	; nb maps

write_txt:	moveq #0,d1		; dx
	moveq #0,d2		; dy

next_one:	move.b (a0)+,d0
	beq.s fini
	cmp.b #esc,d0
	beq.s special
	cmp.b #lf,d0
	bne.s pas_lf
	add.l #160*hauteur,d2
	bra.s next_one
pas_lf:	jsr write_char(pc)
	add.l #long*8,d1
	cmp.l #160,d1
	bne.s pas_fin_l
	add.l #hauteur*160,d2
	moveq #0,d1
pas_fin_l:	bra.s next_one

special:	move.b (a0)+,d0
	cmp.b #'Y',d0
	beq.s posi_x_y
	bra.s next_one		; Autre Procedure ESC
posi_x_y:	move.b (a0)+,d2	; Y
	move.b (a0)+,d1	; X
	sub.b #32,d1
	sub.b #32,d2
	and.w #$ff,d1
	and.w #$ff,d2
	mulu #160*hauteur,d2
	mulu #8*long,d1
	bra.s next_one
fini:	rts

********** Write One Char ************
write_char:	move.l ecran2,a1
	add.l d1,a1
	add.l d2,a1
	lea fnt_codee+32,a2
	sub.b #db_cd,d0
	and.w #$ff,d0
	mulu #8*long*hauteur,d0
	add.l d0,a2
	move.l #hauteur-1,d7
	move.l a1,a3
affiche:	move.l a3,a1
	rept long*8/4
	move.l (a2)+,(a1)+
	endr
	add.l #160,a3
	dbf d7,affiche
	rts
 DATA
 even
texte_tt:	dc.b esc,'Y',34,32,'- MASTERS OF CHAOS -'
	dc.b '--------------------',lf,lf
	dc.b 'DO YOU HAVE :       ',lf
	dc.b '1) A T-T (LUCKY BOY)'
	dc.b '2) A ST  (LOW SCAN) '
	dc.b '3) A ST  (FULL-SCAN)'
	dc.b '4) A FALCON (VGA/TV)',0


texte_c:	dc.b esc,'Y',34,32,'- MASTERS OF CHAOS -'
	dc.b '--------------------',lf,lf
	dc.b 'DO YOU WANT TO PLAY '
	dc.b 'WITH TWO COMPUTERS  '
	dc.b 'CONNECTED USING MIDI',lf,lf
	dc.b 'PRESS C TO CONNECT .',lf
	dc.b 'PRESS SPACE IF NOT',0
 even
texte:	dc.b esc,'Y',32,32,'- MASTERS OF CHAOS -'
	dc.b '--------------------'
	dc.b 'TOP DELAY    : $'
ovr_1:	dc.b '18. '
	dc.b '       PRESS : F1,F2',lf
	dc.b 'BOTTOM DELAY : $'
ovr_2:	dc.b '13. '
	dc.b '       PRESS : F3,F4',lf
	dc.b 'BOTTOM LINE  : $'
ovr_3:	dc.b 'E4. '
	dc.b '       PRESS : F5,F6',lf

	dc.b 'LEFT-DELAY   : $'
ovr_4:	dc.b '04. '
	dc.b '       PRESS : F7,F8',lf

 even
nbplayrs:	dc.b 'TWO  PLAYERS. '
m_e:	dc.b '      ',lf
	dc.b 'RETURN : STARTS.    '
	dc.b 0
	dc.b '--------------------',0

 even
explic:	dc.b esc,'Y',32,32,' WELCOME  TO  M.O.C ',lf
	dc.b ' THIS GAME IS THE   '
	dc.b ' RESULT OF 4 MONTHS '
	dc.b 'OF CODING AND GRAPH '
	dc.b 'RIPPING ...         '
	dc.b 'WE ARE :            '
	dc.b 'W.A.X.         (MOI)'
	dc.b 'G.E.N.         (LUI)'
	dc.b 'WE ARE ALSO FRENCH  '
	dc.b 'AND FROM NANTES ... '
	dc.b ' COCK-A-DOODLE-DO ',0

	dc.b esc,'Y',32,32,'LESS IMPORTANT POINT',lf
	dc.b 'WE WOULD LIKE TO    '
	dc.b 'DEDICATE THIS GAME  '
	dc.b 'AND ALL THE PASSION '
	dc.b 'IT REPRESENTS TO THE'
	dc.b 'ONES THAT SPEND MANY'
	dc.b 'HOURS PLAYING  D.M. '
	dc.b 'AND  C.S.B  , AS WE '
	dc.b 'USED TO,WHEN WE WERE'
	dc.b 'YOUNGER ...         '
	dc.b '         SO LONG ...',0

	dc.b esc,'Y',32,32,' - ABOUT THE GAME - ',lf
	dc.b 'YOU SHOULD KNOW THAT'
	dc.b 'YOU MUST BE THREE TO'
	dc.b 'BYPASS TRICKY PARTS.'
	dc.b 'WE DID IT ON PURPOSE',LF
	dc.b 'BUT TWO ARRIVING AT '
	dc.b 'THE END (THE PRISON)'
	dc.b 'WILL MAKE THE DEAD  '
	dc.b 'RISE FROM THEIR     '
	dc.b '    G R A V E S     ',0

	dc.b esc,'Y',32,32,lf
	dc.b "THE MAZE THAT YOU'RE"
	dc.b 'GOING TO PACE , AND '
	dc.b 'SOON CURSE ,CAME OUT'
	dc.b 'OF THE TORTURED     '
	dc.b 'MINDS OF :          ',lf
	dc.b '- WAX               '
	dc.b '- RAPHA             '
	dc.b '- FABRICE           '
	dc.b '- DAVID             '
	dc.b '- GEN',0

	dc.b esc,'Y',32,32,' - PRECIOUS HINTS - ',lf
	dc.b 'IF YOU WANT TO REACH'
	dc.b 'THE END OF THIS CHA-'
	dc.b 'LLENGING GAME, CALL '
	dc.b 'OTHER ST-(WO)MEN AND'
	dc.b 'CONNECT YOUR TWO ST '
	dc.b 'USING MIDI-IN-OUT.  ',lf
	dc.b 'BUT YOU CAN FIND IT '
	dc.b 'MORE ENJOYABLE TO   '
	dc.b 'HUNT YOUR FRIENDS...',0

	dc.b esc,'Y',32,32,lf,lf,'      - KEYS -      ',lf,lf
	dc.b 'TOP LEFT  BOT. RIGHT'
	dc.b '--------  ----------',lf
	dc.b ' 1 2 3 4    ( ) / X '
	dc.b ' A Z E R    7 8 9 - '
	dc.b ' Q S D F    4 5 6 + '
	dc.b '   X   C      2  ENT',0

	dc.b esc,'Y',32,32,'    - FUNCTIONS -   ',lf,lf
	dc.b '1,(  : SWAP OBJECTS '
	dc.b '2,)  : TAKE OBJECT  '
	dc.b '3,/  : DROP OBJECT  '
	dc.b '4,X  : PUSH BUTTON  '
	dc.b 'R,-  : THROW R. OBJ.'
	dc.b 'F,+  : PUNCH USG OBJ'
	dc.b 'C,ENT: INSERT KEY   '
	dc.b 'S,5  : FIREBALLS',0

	dc.b esc,'Y',32,32,'  -  SOME  MORE  -  ',lf
	dc.b 'ALL ACTIONS NEEDING '
	dc.b 'AN OBJECT ARE DONE  '
	dc.b 'USING THE LEFT ONE. ',lf
	dc.b 'PLUG YOUR COMPUTERS '
	dc.b 'INTO THE SAME POWER-'
	dc.b 'POINT TO PREVENT ANY'
	dc.b 'TRANSMISSION PROBLEM'
	dc.b 'DUE TO DIFFERENT    '
	dc.b 'GROUND POTENTIALS.',0

	dc.b esc,'Y',32,32,' -   OVER  SCAN   - ',LF
	dc.b 'TT-MODE : NO 50 HZ  '
	dc.b ' AND LESS TRANSMISS.'
	dc.b 'PROBLEMS (NO TIMERS)',LF
	dc.b 'LOW-SCAN : FOR      '
	dc.b 'MONITORS WITH FEWER '
	dc.b 'THAN 272 LINES ...  ',LF
	dc.b 'FULL-SCAN : FOR     '
	dc.b 'THE LUCKIER ONES ...',0

	dc.b esc,'Y',32,32,' -   OVER  SCAN   - ',LF
	dc.b 'FOR THE ONES WITH   '
	dc.b 'TOS 1.0 ,YOU MUST   '
	dc.b 'CHANGE BOTTOM LINE. ',LF
	dc.b 'ALL OTHER DELAYS MAY'
	dc.b 'BE MODIF. TO IMPROVE'
	dc.b 'STABILITY,ACCORDING '
	dc.b 'TO THE SHIFTER YOU  '
	dc.b 'HAVE. MOVE THE MOUSE'
	dc.b 'TO HAVE AN IDEA ... ',0

	dc.b esc,'Y',32,32,' -    B U G S    -  ',LF
	dc.b 'IF ANY UNUSUAL COLOR'
	dc.b 'WERE TO APPEAR, YOU '
	dc.b 'SHALL KNOW THAT :   '
	dc.b 'BLUE,GREEN,WHITE ALL'
	dc.b 'MEAN THAT A TRANSMIS'
	dc.b 'SION PB HAS OCCURRED',LF
	dc.b 'F8  - BACK TO BLACK '
	dc.b 'F9  - CUT CONNECTION'
	dc.b 'F10 - RESTART',0

	dc.b esc,'Y',32,32
	dc.b 'WE ARE AWARE THAT   '
	dc.b 'THIS PROGRAM SUFFERS'
	dc.b 'LIMITS, YET WE WOULD'
	dc.b 'LIKE YOU TO KNOW    '
	dc.b 'THAT WE HAD SET THEM'
	dc.b 'RIGHT FROM THE      '
	dc.b 'BEGINNING ...       '
	dc.b 'ANYWAY,THE TIME WILL'
	dc.b 'BE LONG BEFORE ANY- '
	dc.b 'ONE DARES DO BETTER '
	dc.b 'OR SIMPLY THE SAME :'
	dc.b 'OVER/MIDI/4 PLAYERS.',0

	dc.b esc,'Y',32,32
	dc.b '- ANDY JAROS        '
	dc.b '- DAVID SIMON       '
	dc.b '            GRAPHICS'
	dc.b '- MARC COLEMAN      '
	dc.b '                FONT'
	dc.b '- S.P.A.Z.          '
	dc.b '              LOADER'
	dc.b '- ERIK SIMON        '
	dc.b '                LOGO'
	dc.b '- AXE               '
	dc.b '          PI1-PACKER'
	dc.b '- MAD MAX        ...',0

fin_demo:
texte_avertissement:
	dc.b "NOUS NOUS DEGAGEONS "
	dc.b "DE TOUTE RESPONSABI-"
	dc.b "-LITE CONCERNANT L' "
	DC.B "UTILISATION FRAUDU- "
	DC.B "LEUSE DE CE JEU ,   "
	DC.B "ET EN PARTICULIER DE"
	DC.B "SA REVENTE, QUI NE  "
	DC.B "SAURAIT AVOIR LIEU  "
	DC.B "PUISQUE CE LOGICIEL "
	DC.B "APPARTIENT AU  D.P. ",LF
	DC.B "         LES AUTEURS",0
 even
fnt_codee:	incbin moc\graphics\gods.f16
 TEXT

**********************************************************************
**  Fading sur la palette  (No rasters Please.) ** (c) Wax 17-07-91 **
**********************************************************************
tempo:	move cpt,d0
	addq #3,d0
attdr_sync:	cmp cpt,d0
	bne.s attdr_sync
	rts

fade_in:	jsr calcul_pal(pc)
	lea pilette+16*2*6,a6
in:	jsr tempo(pc)
	movem.l (a6),d0-d7
	movem.l d0-d7,palette
	sub.l #16*2,a6
	cmp.l #pilette-16*2,a6
	bne.s in
	rts

fade_out:	movem.l palette,d0-d7
	movem.l d0-d7,pilette
	jsr calcul_pal
	lea pilette,a6
out:	jsr tempo(pc)
	movem.l (a6),d0-d7
	movem.l d0-d7,palette
	add.l #16*2,a6
	cmp.l #pilette+16*2*8,a6
	bne.s out
	rts

CALCUL_PAL:	move #16-1,d7
	lea pilette,a0	; met composantes 0-7 (Pour Deluxe)
ordino_st:	and #%0000011101110111,(a0)+
	dbf d7,ordino_st

	move #7-1,d7	; nb fades
	lea pilette+16*2,a6

un_ton:	move d7,-(sp)
	movem.l -16*2(a6),d0-d7
	movem.l d0-d7,(a6)
	move (sp)+,d7

	moveq #16-1,d6	; nb coul
	move.l a6,a0
next_coul:	move #$0f00,d0	; masque
	moveq #3-1,d5	; nb composantes : R V B
	moveq #8,d4		; nb decalages
next_compo:	move.w (a0),d1
	and d0,d1
	beq.s deja_nul
	lsr.w d4,d1
	subq #1,d1
	lsl.w d4,d1
	not d0
	and d0,(a0)		; efface compo
	not d0
	or d1,(a0)		; nouvelle
deja_nul:	lsr.w #4,d0		; dcale motif de travail
	subq #4,d4
	dbf d5,next_compo
	addq #2,a0
	dbf d6,next_coul

	add.l #16*2,a6
	dbf d7,un_ton
	rts
 BSS
 even
pilette:	ds.w 16*8
 TEXT

***************************************************************************
* OVER-SCAN : POSITIONNEMENT PAR TIMER B ET SYNCHRO HBL * (C) GEN 24/05/91*
***************************************************************************
init_all1:	
OVR=296			; nb lignes de haut (ASS)
	move.l #phys1,d0	; multiple de 256
	and.l #$ffffff00,d0
	add.l #$100,d0
	move.l d0,ecran1
	add.l #160*ovr,d0
	move.l d0,ecran2

	movem.l zero,d0-d7	; existe deja
	movem.l d0-d7,palette
	move #$2300,sr
	stop #$2300
	move.l ecran,oldscreen	; sauve ancien
			; on n'efface les nouveaux
	move #-1,-(sp)
	appel xbios,88,4
	move d0,save_mode

	appel xbios,4,2
	move d0,save_st_rez

*	move.w #$1b2,-(sp)
	resolut #0,#-1,#-1	; ASS

*	move #$1b2,-(sp)
*	appel xbios,88,4

	move.w #$2700,sr
	
	move.l $118,oldclav
  	move.l #midi_clavier,$118
	move.l $70.w,oldvbl
	move.l #newvbl2,$70.w
	move.l $fffa06,fa07_09
	move.l $fffa12,fa13_15
	move.b $fffa17,fa17
	move.l timerb,oldb	; sauvegarde timer-b
	move.l $68.w,oldhbl

 	clr.l $fffa06
	bclr #3,$fffa17	; 'Automatic End of Interrupt' 
	bset #6,$fffa09	; Int-clavier
	move.w #$2300,sr
	clr.w zappos_acia
	rts

init_all2:	move.w #$2700,sr	; pour l'overscan
	move.l #newvbl,$70.w

	move.b #1,$fffa07	; pour autoriser le timer-b
	move.b #1,$fffa13

	move.l #hbl_sync,$68.w
pas_over:	move.w #$2300,sr
	rts

int_off:	jsr fade_out		; ASS
	move.w #$2700,sr

	clr.b ctrlb
	move.l oldhbl,$68.w
	move.l oldvbl,$70.w
	move.l oldb,timerb

	move.b clavier,d0
	move.b clavier+4,d0
	move.l oldclav,$118
	move.b fa17,$fffa17
	move.l fa13_15,$fffa12
	move.l fa07_09,$fffa06

	move.w #$ffff,d0
wait_mfp:	nop
	dbra d0,wait_mfp
	move.w #$2300,sr

	resolut save_st_rez,oldscreen

	tst is_falcon
	beq no_no_no
	lea save_REGS,A0
	MOVE.W	(A0)+,$FFFF82A4.W
	MOVE.W	(A0)+,$FFFF82A6.W
	MOVE.W	(A0)+,$FFFF82A8.W
	MOVE.W	(A0)+,$FFFF82AA.W
	
	move save_mode,-(sp)
	appel xbios,88,4

no_no_no	move #$777,palette
	clr palette+6
bidon:	rts

************* V B L ****************
tos1 equ 212
newvbl:	clr.b (ctrlb).w	; on branche le timer b
	move.b #$63,(datab).w
	move.l #over_h,timerb
	move.b #4,(ctrlb).w	
	move.w #1,zappos_acia

newvbl2:	save d0-a6
	move.l musique,a6
	jsr (a6)

	add #1,cpt

	move.b clavier,d0
	cmp.b #$42,d0
	bne.s no_key0
	clr palette
no_key0:	cmp.b #$43,d0
	bne.s no_key3
	clr.w connecte
no_key3:	cmp.b #$0e,d0
	bne.s no_key1
	move.w #$4e71,auto_modif
no_key1:	cmp.b #$44,d0
	bne.s no_key2
	load d0-a6
	move.l #restart,2(sp)
	rte
no_key2:	load d0-a6
	rte

******** H B L *********
hbl_sync:	rte

******** TIMER B *************

over_h:	move.b #%00000000,$fffffa15.w
	move.w #$2100,sr
	stop #$2100		; pour la syncrho avec la hbl

	move.w #$2700,sr
	clr.b (ctrlb).w	; arrete le timer B
	move.b #%01000000,$fffffa15.w
	move.w d1,-(sp)
	clr.w d1
	move.b over_1,d1	; 25 nop -> 28
att_hbl:	dbf d1,att_hbl
	move.b #0,$ffff820a.w	; 60hz
	rept 8
	nop
	endr
	move.b #2,$ffff820a.w	; 50hz

	move.b over_3,(datab).w	; pour les TOS 1.00 ?
	move.l #scanbas1,timerb
	move.b #8,(ctrlb).w
	move.w (sp)+,d1
	clr.w zappos_acia
	rte

**** Changement de freqence ***

scanbas1:	clr.b ctrlb

	move.w #$2700,sr
	move.w d0,-(sp)

	clr.w d0
	move.b over_4,d0	; A VOIR
att2c:	dbf d0,att2c

	move.b $ffff8209.w,d0	; avec l'affichage
	neg.w d0
	lsl.w d0,d0

	clr.w d0
	move.b over_2,d0	; mini d0=15 + 2 nop
att2b:	dbf d0,att2b	; maxi d0=17

	move.b #0,$ffff820a.w	; 60hz
	rept 8
	nop
	endr
	move.b #2,$ffff820a.w	; 50hz
	move.w (sp)+,d0
	rte
 BSS
musique:	ds.l 1
 DATA
over_1:	dc.b 24		; pour nous =24
over_2:	dc.b 19		; 19
over_3:	dc.b 228		; 228
over_4:	dc.b 4		; (4:wax) (5:gen)
 even
 TEXT
**********************************************************************	
** Routine d'mission / rception Midi       * (c) GEN-WAX 21-XII-91 *
**********************************************************************	
midi_clavier:		; Intruption clavier
	move #$2500,sr	; !!!!!!!!!!!!!!!!
	save d0/a0-a2
encore_un_present:
	lea $fffc04,a0
	lea buffer_midi,a1
	lea nb_midi,a2
	jsr test_acia(pc)

	lea $fffc00,a0
	lea buffer_clav,a1
	lea nb_clav,a2
	jsr test_acia(pc)
	btst #4,$fffa01	; lire jusqu'a plus faim
	beq.s encore_un_present
	load d0/a0-a2
	rte
test_acia:	move.b (a0),d0
	btst #7,d0		; interuption ou fausse alerte ?
	beq.s pas_int
	btst #0,d0		; caractere valide ?
	beq.s pas_caract	; meme si pas lire quand meme
	** Rception **
MAXIM=20

*	tst.w zappos_acia	; pour pas enfiler si en cours de lect.
*	bne.s pas_caract
			; Enfile le caractre midi-clavier
	move (a2),d0	; pointe nb carac ds buffer
	cmp #MAXIM,d0
	beq.s pas_caract
	add.w d0,a1		; a1=ad buffer
	move.b 2(a0),(a1)
	add #1,(a2)
	rts

pas_caract:	move.b 2(a0),d0
pas_int:	rts

**** Emission *************************
put_midi:	save d1		; Emet un caractre => extrieur
pas_libre:	move.b $fffc04,d1
	btst #1,d1		; buffer d'emission plein ?
	beq.s pas_libre
	move.b d0,$fffc06
	load d1
	rts

get_midi:	lea buffer_midi,a0	; appel rout
	lea nb_midi,a1
	move #127,d0
	tst (a1)
	bne.s defile
	rts

get_clav:	lea buffer_clav,a0
	lea nb_clav,a1
	move.b #127,d0	; si rien : retourne 127
	tst (a1)
	bne.s defile
	rts

defile:	tst.w zappos_acia
	bne.s defile
	move sr,save_sr
 	move #$2700,sr
*	move.w #1,zappos_acia
	move (a1),d1	; nb. carac
	beq.s rien
	move.b (a0),d0
	subq #1,d1		; -1 puis stoke
	move d1,(a1)
defiler:	move.b 1(a0),(a0)+
	dbf d1,defiler
rien:	move save_sr,sr
*	clr.w zappos_acia
	rts

prepare_buffers:
	clr.l flag_jrs

label0:	jsr get_clav
	cmp.b #127,d0
	beq.s finito
	lea buffer_j1,a1
	lea nb_j1,a2
	lea flag_jrs,a3
	lea touches1,a4
	jsr list_t
	lea buffer_j2,a1
	lea nb_j2,a2
	lea flag_jrs+2,a3
	lea touches2,a4
	jsr list_t
	move.l flag_jrs,d0
	cmp.l #$00010001,d0
	bne.s label0	; on revient si au moins une touche
finito:	rts		; pour chaque joueur ou plus rien dans
			; le buffer !!!
list_t:	move.w #NBTOUCHES-1,d7
tst_tj:	cmp.b (a4)+,d0
	beq.s good_touche
	dbf d7,tst_tj
	rts
good_touche:move (a2),d1
	cmp #MAXIM,d1
	beq.s buff_full
	add.w d1,a1		; a1=ad buffer
	move.b d0,(a1)
	add #1,(a2)
	move.w #1,(a3)	; ce joueur a au moins une touche
buff_full:	rts

 BSS
save_sr:	ds.w 1
buffer_clav:ds.b MAXIM		; pour pas bloquer les joueurs
buffer_midi:ds.b MAXIM
buffer_j1:	ds.b MAXIM
buffer_j2:	ds.b MAXIM
flag_jrs:	ds.l 1
zappos_acia:ds.w 1		; pour bloquer les acias pendant la
			; lecture des buffers
nb_clav:	ds.w 1
nb_midi:	ds.w 1
nb_j1:	ds.w 1
nb_j2:	ds.w 1

fa07_09:	ds.l 1
fa13_15:	ds.l 1
fa17:	ds.b 1

pile:	ds.l 1
oldclav:	ds.l 1
oldvbl:	ds.l 1
oldhbl:	ds.l 1
oldb:	ds.l 1
cpt:	ds.w 1		; compteur pour syncro
cpt2:	ds.w 1		; compteur pour mvt monstres

oldscreen:	ds.l 1
ecran1:	ds.l 1
ecran2:	ds.l 1
phys1:	ds.b 160*OVR*2+256	; 2 crans
*phys1=$80000-160*OVR*2+256 
 TEXT

**************   SECTION DATA   ***************
 section DATA
 even
colors1:	dc.w 0,$333,$444,$310,$066,$420,$040,$060
	dc.w $700,$400,$300,$770,$222,$555,$007,$777

colors2:	dc.w 0,$222,$333,$200,$055,$310,$030,$050
	dc.w $600,$300,$200,$660,$111,$444,$006,$666

colors3:	dc.w 0,$000,$111,$000,$033,$100,$010,$030
	dc.w $400,$100,$000,$440,$000,$222,$004,$444

colors4:	dc.w 0,$111,$222,$100,$044,$200,$020,$040
	dc.w $500,$200,$100,$550,$000,$333,$005,$555

logo:	incbin moc\graphics\logo_guw.pi1
fin_logo:
chaos_m:	incbin moc\graphics\chaos_m.pi1
fin_chaos_m:

*J*************************************************************************
posi_j1:	dc.w 30,30		; position (30,30)
	dc.w -1,0		; regard
	dc.w 1		; level
	dc.w 2		; type monstre
	dc.w 1		; monstre / gentil
	dc.w -1		; pour monstre -1=immobile sinon No j
	dc.w PTS100		; pts vie
	dc.w PTS100		; pts stamina
	dc.w PTS100		; pts mana
	dc.w -1		; objet 1
	dc.w -1		; objet 2

	dc.w 1,12 		; (1,12)
	dc.w 1,0
	dc.w 1
	dc.w 3
	dc.w 1
	dc.w 0
	dc.w PTS100
	dc.w PTS100
	dc.w PTS100
	dc.w -1
	dc.w -1

posi_j3:	dc.w 1,1 		; (1,1)
	dc.w 1,0
	dc.w 1
	dc.w 0
	dc.w 1
	dc.w 0
	dc.w PTS100
	dc.w PTS100
	dc.w PTS100
	dc.w -1
	dc.w -1

posi_j4:	dc.w 30,1 		; (30,1)
	dc.w -1,0
	dc.w 1
	dc.w 1
	dc.w 1
	dc.w 0
	dc.w PTS100
	dc.w PTS100
	dc.w PTS100
	dc.w -1
	dc.w -1
************
	; demon,dragon,cheva,scorp
; monstre  lvl 0
	dc 18,7		; pos x,y
	dc 1,0 		; direction
	dc 0		; level
	dc 2		; type monstre
	dc 0		; monstre / gentil
	dc -1		; pour monstre -1=immobile sinon No j
	dc PTS200		; pts vie
	dc PTSDOM		; pts domage
	dc PTS100		; pts mana
	dc -1,-1		; objets

	dc 6,8
	dc 1,0
	dc 0
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 10,15
	dc 1,0
	dc 0
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 17,22
	dc 0,1
	dc 0
	dc 3
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 12,22
	dc 0,1
	dc 0
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 22,26
	dc 0,1
	dc 0
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 18,1		; lvl 1
	dc 1,0
	dc 1
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM*2
	dc PTS200
	dc -1,-1

	dc 4,6
	dc -1,0
	dc 1
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 23,10
	dc 0,-1
	dc 1
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 28,12
	dc -1,0
	dc 1
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 30,20
	dc 1,0
	dc 1
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 18,24
	dc 0,-1
	dc 1
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM*2
	dc PTS200
	dc -1,-1

	dc 4,27
	dc -1,0
	dc 1
	dc 3
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM
	dc PTS200
	dc -1,-1

	dc 24,29
	dc 0,1
	dc 1
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM*2
	dc PTS200
	dc -1,-1

	dc 14,1		; level 2
	dc -1,0
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 3,5
	dc 1,0
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 28,5
	dc 0,1
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100		
	dc -1,-1		

	dc 22,6
	dc -1,0
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 20,6
	dc 0,1
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 18,6
	dc 1,0
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 15,6
	dc 0,1
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 22,8
	dc -1,0
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 18,8
	dc 1,0
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 22,14
	dc 0,1
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 20,13
	dc 0,1
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 18,12
	dc 0,1
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 16,12
	dc 0,1
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 3,14
	dc 0,1
	dc 2
	dc 0
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 13,17
	dc 0,1
	dc 2
	dc 1
	dc 0
	dc -1
	dc PTS200*8
	dc PTSDOM*3
	dc PTS100
	dc 41,-1		;mettre cle dans la main niv sup

	dc 30,18
	dc 0,1
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 30,23
	dc 1,0
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 14,22
	dc 0,1
	dc 2
	dc 3
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 9,23
	dc 0,-1
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 26,11
	dc 0,-1
	dc 2
	dc 1
	dc 0
	dc -1
	dc PTS200*6
	dc PTSDOM*3
	dc PTS100
	dc 16,-1		; maxi arme 

	dc 11,28
	dc 1,0
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 5,29
	dc 1,0
	dc 2
	dc 1
	dc 0
	dc -1
	dc PTS200*8	; garde cle d'or
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 18,30
	dc 1,0
	dc 2
	dc 2
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM
	dc PTS100
	dc -1,-1

	dc 22,12		; level 3
	dc 1,0
	dc 3		; level
	dc 2		; type monstre
	dc 0
	dc -1		; pour monstre -1=immobile sinon No j
	dc PTS200*3	; pts vie
	dc PTSDOM*2	; pts domage
	dc PTS100		; pts mana
	dc -1,-1		; objets

	dc 10,1
	dc -1,0
	dc 3
	dc 3
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 1,22,-1,0,3
	dc 2
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 1,24,-1,0,3
	dc 3
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 6,27,-1,0,3
	dc 1
	dc 0
	dc -1
	dc PTS200*1
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 16,17,-1,0,3
	dc 0
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 14,17,-1,0,3
	dc 2
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 13,17,0,1,3
	dc 2
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc 32,-1

	dc 21,17,0,-1,3
	dc 1
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc 33,-1

	dc 20,17,-1,0,3
	dc 3
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 18,16,-1,0,3
	dc 3
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 30,3,0,1,4	; lvl 4
	dc 2
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*6
	dc PTS100
	dc -1,-1

	dc 30,4,0,1,4
	dc 3
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 3,1,1,0,4
	dc 3
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 3,2,1,0,4
	dc 0
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 3,3,1,0,4
	dc 2
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 1,3,1,0,4
	dc 1
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*5
	dc PTS100
	dc -1,-1

	dc 14,9,0,-1,4
	dc 0
	dc 0
	dc -1
	dc PTS200*7
	dc PTSDOM*2
	dc PTS100
	dc -1,-1


	dc 14,10,0,-1,4
	dc 0
	dc 0
	dc -1
	dc PTS200*7
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 15,10,0,-1,4
	dc 3
	dc 0
	dc -1
	dc PTS200*7
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 26,22,-1,0,4
	dc 1
	dc 0
	dc -1
	dc PTS200*7
	dc PTSDOM*7
	dc PTS100
	dc -1,-1

	dc 5,19,-1,0,4
	dc 2
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 4,19,-1,0,4
	dc 2
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 4,20,0,1,4
	dc 2
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 17,30,1,0,4
	dc 3
	dc 0
	dc -1
	dc PTS200*3
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 16,30,-1,0,4
	dc 0
	dc 0
	dc -1
	dc PTS200*6
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 24,28,0,1,4
	dc 0
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*3
	dc PTS100
	dc -1,-1

	dc 22,29,0,-1,4
	dc 3
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 22,15,0,1,5	; lvl 5
	dc 0
	dc 0
	dc -1
	dc PTS200*6
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 9,23,0,-1,5
	dc 0
	dc 0
	dc -1
	dc PTS200*6
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 20,3,0,-1,6	; level 6
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 21,3,0,-1,6
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 29,5,-1,0,6
	dc 2
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 26,5,0,1,6
	dc 3
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 13,7,0,1,6
	dc 1
	dc 0
	dc -1
	dc PTS200*5
	dc PTSDOM*4
	dc PTS100
	dc -1,-1

	dc 8,11,1,0,6
	dc 1
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*6
	dc PTS100
	dc -1,-1

	dc 13,19,1,0,6
	dc 3
	dc 0
	dc -1
	dc PTS200*4
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 26,26,0,-1,6
	dc 3
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

	dc 24,27,1,0,6
	dc 0
	dc 0
	dc -1
	dc PTS200*2
	dc PTSDOM*2
	dc PTS100
	dc -1,-1

fin_enr_jrs:		; fin

**************************************************************************
projectile1:dc.w 16,22		; x
	dc.w 0,0		; dx
	dc.w 0		; lvl
	dc.w 2		; type  0:feu,1:clef,2:arme
	dc.w PTSARM*2	; domages
	dc.w 12		; numero de l'objet

	dc.w 29,14
	dc.w 0,0
	dc.w 1
	dc.w 2
	dc.w PTSARM*2
	dc.w 17

	dc.w 5,27
	dc.w 0,0
	dc.w 1
	dc.w 2
	dc.w PTSARM
	dc.w 23
	
	dc.w 3,7		; lvl 2
	dc.w 0,0
	dc.w 2
	dc.w 1		; clefs
	dc.w PTSARM
	dc.w 41		; 1/4

	dc.w 5,30
	dc.w 0,0
	dc.w 2
	dc.w 1
	dc.w PTSARM
	dc.w 35		; pour niv sup

	dc.w 255,255
	dc.w 0,0
	dc.w 2
	dc.w 1
	dc.w PTSARM
	dc.w 39		; pour niv sup : supra-arme

	dc.w 255,255	; maxi-arme
	dc.w 0,0
	dc.w 2
	dc.w 2
	dc.w PTSARM*3
	dc.w 16

	dc.w 30,3		; level3
	dc.w 0,0
	dc.w 3
	dc.w 2
	dc.w PTSARM*2	; arme donne dbut
	dc.w 24

	dc.w 3,1
	dc.w 0,0
	dc.w 3
	dc.w 1
	dc.w PTSARM
	dc.w 40		; 4/4

	dc.w 19,23
	dc.w 0,0
	dc.w 3
	dc.w 1
	dc.w PTSARM
	dc.w 42		; 2/4

	dc.w 25,28
	dc.w 0,0
	dc.w 3
	dc.w 1
	dc.w PTSARM
	dc.w 43		; 3/4

	dc.w 255,255
	dc.w 0,0
	dc.w 3
	dc.w 1
	dc.w PTSARM		; clef intermdiaire
	dc.w 32

	dc.w 255,255
	dc.w 0,0
	dc.w 3
	dc.w 1
	dc.w PTSARM		; clef intermdiaire
	dc.w 33

	dc.w 30,30		; level 4
	dc.w 0,0
	dc.w 4
	dc.w 1		; type  0:feu,1:clef,2:arme
	dc.w PTSARM
	dc.w 44		; 5/8

	dc.w 30,1
	dc.w 0,0
	dc.w 4
	dc.w 1
	dc.w PTSARM
	dc.w 45		; 6/8

	dc.w 1,1
	dc.w 0,0
	dc.w 4
	dc.w 1
	dc.w PTSARM
	dc.w 46		; 7/8

	dc.w 1,30
	dc.w 0,0
	dc.w 4
	dc.w 1
	dc.w PTSARM
	dc.w 47		; 8/8

	dc.w 11,25
	dc.w 0,0
	dc.w 4
	dc.w 1
	dc.w PTSARM
	dc.w 34		; intermdiaire

	dc.w 24,30,0,0,5	; level 5
	dc.w 2
	dc.w PTSARM*6
	dc.w 9		; fire staff

	dc.w 10,23,0,0,5
	dc.w 2
	dc.w PTSARM*4
	dc.w 15

	dc.w 20,15,0,0,5
	dc.w 2
	dc.w PTSARM*4
	dc.w 18

	dc.w 28,1,0,0,6	; level 6
	dc.w 2
	dc.w PTSARM*3
	dc.w 13		; epee de feu

	dc.w 11,9,0,0,6
	dc.w 2
	dc.w PTSARM*3
	dc.w 11		; masse d'arme

	dc.w 4,28,0,0,6
	dc.w 1
	dc.w PTSARM
	dc.w 36		; cle intermediaire

	dc.w 25,19,0,0,6
	dc.w 1
	dc.w PTSARM
	dc.w 37		; cle intermediaire
fin_enr_pro:	
*L*************************************************************************

laby_murs:	dc.l %11111111111111111111111111111111 	; level 0
	dc.l %10101101000000000101000000100101
	dc.l %11100000000011110111111011100101
	dc.l %10001111110110000000001000000101
	dc.l %10100011111010000000001111110101
	dc.l %10111011000000000000001000010111
	dc.l %10101010000000000000000000010111
	dc.l %10100010000000100000001110110111
	dc.l %10111111000001010000001000000101
	dc.l %10000001000000100000001010000111
	dc.l %11011111110000000000001111000111
	dc.l %10010000010000000000001010000111
	dc.l %10110111011000000101001000100101
	dc.l %10010001010001111101111010000111
	dc.l %11011000010101111101010110000101
	dc.l %10001011011101000000000000110101
	dc.l %11101001000101111111111111110101
	dc.l %11001101101100000000111110000011
	dc.l %11010000000001111010111111111011
	dc.l %10000110101101000110100000000011
	dc.l %11110110101111111000110111110011	;20
	dc.l %11000000101001111010100000001011
	dc.l %10001111101001001010110111101011
	dc.l %10101000101001001010000000000001
	dc.l %10101010101111111010100000101101
	dc.l %10100010101100110011101110101101	;25
	dc.l %10011010101101010100000000100011
	dc.l %11110010101101010101110100111011
	dc.l %10000010100101110101000100001011
	dc.l %10111010111100000101000001101011
	dc.l %10100010000001111100011100100011
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 1
	dc.l %10000000011000000001000100001001	;1
	dc.l %11010111010101011101100000100001
	dc.l %10000000010010100000101000001111
	dc.l %10101010100001100100000110000001	;4
	dc.l %10101000101001010011100100010101
	dc.l %10000010101011001001000001100001
	dc.l %11010000100001000000000100000111	;7
	dc.l %10000111001001001010111010001001
	dc.l %10010100000000000000000000111111	; 9
	dc.l %11010001010101010100100011000001
	dc.l %10101100000000010000000100011111
	dc.l %10000010101010000000101001110001	; 12
	dc.l %11011000000000111101011010000111
	dc.l %11011011010110000001000000110001	; 14
	dc.l %11111111111100011011010110100101
	dc.l %10000001001101000000111110001001	; 16
	dc.l %10000101010001000000110110101011
	dc.l %10000100000100000000000000100011	; 18
	dc.l %10000101000101000000110110100101
	dc.l %10000110111111000000000010101011	; 20
	dc.l %10000000000001000000100010100111
	dc.l %11110001001101101011110100010001	; 22
	dc.l %10010000000000101110100001011001
	dc.l %11111010111110100100110110110001
	dc.l %10001011100100101001010000000101	; 25
	dc.l %10101010101110100100010001111101
	dc.l %10000011100110110101111101000001
	dc.l %10111010000010100010010101111011	; 28
	dc.l %10001000010000101000101101101011
	dc.l %10000010000010100010101000000001	; 30
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111 	; level 2
	dc.l %10000000000000001000000000010001
	dc.l %10011000010001101000000000011101
	dc.l %10111000010001101000100100000101
	dc.l %10001000000000001000100010000111
	dc.l %10001111111111111100100001000001
	dc.l %10000000100000100100000111111001
	dc.l %10001000100000100111111000100101
	dc.l %11111110100000101101000000011101
	dc.l %10000000111011100101000011111001
	dc.l %10000000100000000001011100000111
	dc.l %10001011111111111001010011010001
	dc.l %11110100100000001101010100011101
	dc.l %10010101101010101001010101111001
	dc.l %10010000101010101101010100100111
	dc.l %10010000100000000001010110100001
	dc.l %10000000101110111011000010100001
	dc.l %10000000100010110001111010100001
	dc.l %10111011101000110111000000100001
	dc.l %10001000101111111001111111100001
	dc.l %10101010110000001001000000100001
	dc.l %10000011100011101111000000101111
	dc.l %11011111100010100000010000101001
	dc.l %10010100101010010000010000101001
	dc.l %11110000011011010010010000101001
	dc.l %10000100101000011010010000100101
	dc.l %10101111101000010010010010101001
	dc.l %10101001001110011110010011100111
	dc.l %10001000010000000000010000101001
	dc.l %10111010111010000000010100010101
	dc.l %10000010000010001001010000010001
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	;level 3
	dc.l %10000101010101010001001010010101
	dc.l %10000101010101010100010000010101
	dc.l %10000101010101000101001001110101
	dc.l %11110101010101010000010100010101
	dc.l %10000111111111010001001001010101
	dc.l %10000001010101001111010100010101
	dc.l %10000110000101000000111010011001
	dc.l %10000110110100000000000111110011
	dc.l %10000111100101110100000000000001
	dc.l %10000100000001110100000000000111
	dc.l %10000111010111010100000000000001
	dc.l %11111000000100010111000000000111
	dc.l %10000111111100010100111000000001
	dc.l %10001101011000110000000111110111
	dc.l %11110101000000110110000101000001
	dc.l %10000111110000110110000011000001
	dc.l %10001101010001000001000111000001
	dc.l %10110111101101000001000101000001
	dc.l %10000010101100111110000101000001
	dc.l %11010110100010000000000011000001
	dc.l %10000010100100000000001110100011
	dc.l %10101010100010000000010100010101
	dc.l %10000001101111111111100010100001
	dc.l %11010110000100010010100010010101
	dc.l %10000001111010010010011100100011
	dc.l %10101010000000011000000101000001
	dc.l %10100011110111110010110010010111
	dc.l %10010110010001001010000100100001
	dc.l %10100010010001001010010100100011
	dc.l %10001011001100000001100001100011
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	: level 4
	dc.l %10100000000001000001000100000001
	dc.l %10101111011111011101010101000001
	dc.l %10100001000010010111010101000001
	dc.l %10111101110010110101010101000001
	dc.l %10100000011110010111010101111111
	dc.l %10001111000100000111010101010101
	dc.l %11111111110111110001010001010001
	dc.l %10000000110000010011011111011101
	dc.l %10110000011111010011010001000101
	dc.l %10111111000001010011010001110101
	dc.l %10101111010101010000010001000101
	dc.l %10101111110001011111111111011101
	dc.l %10111000010111010000000001000101
	dc.l %10101000010000010000000001110101
	dc.l %10110000011111110100000001000101
	dc.l %10101000000000000100000001111101
	dc.l %10101111011111111100000001000001
	dc.l %10101000000000000100000001110001
	dc.l %10110011111000100100000001000001
	dc.l %10100000110000100111111111001111
	dc.l %10101111111110100000010001000001
	dc.l %10100000110000100100010101111101
	dc.l %10101111111100101111010100000101
	dc.l %10100000100000100100010100000101
	dc.l %10100010111100100100010101110101
	dc.l %10010010000100111111110101100101
	dc.l %11010011100100000000000101000101
	dc.l %10010010100100011100110111010101
	dc.l %11010110100111110000110111110101
	dc.l %10010000000100000000000000100101
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 5
	dc.l %10000001001000000000000000000001
	dc.l %10000001001011101110100100000001
	dc.l %10111001001010001000110100000001
	dc.l %10100100001010101100101101111001
	dc.l %10111111010011101000100100000001
	dc.l %10100101001000001110000000000001
	dc.l %10110001010000000000000000000001
	dc.l %10110001010010001011101010000001
	dc.l %10100001010010101010100100000001
	dc.l %10111111110001010011101010000001
	dc.l %10101000010000000010100000000001
	dc.l %10101001101111111011110011111111
	dc.l %10101100000100000100001100110001
	dc.l %10101100011010110100000010101101
	dc.l %10101100100010010010000100100001
	dc.l %10101000100101010100000010100101
	dc.l %10101001100101010100001100100001
	dc.l %10111010000000010011110011110001
	dc.l %10100000101111111000000000001011
	dc.l %10100000010000001001010010100001
	dc.l %10110000100000000100100010100111
	dc.l %10111101100000001011000100111001
	dc.l %10111011000000000001000100101011
	dc.l %10000010000000000001111000100111
	dc.l %10000010000000000001000001010101
	dc.l %11111010000000000001111111101011
	dc.l %10000010000000000001000000110101
	dc.l %10111010000000000001011100101011
	dc.l %10010011100000001010001000011101
	dc.l %10000000100000000100000000000011
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 6
	dc.l %11101110000111111010000000000001
	dc.l %10111101110000000000111111101011
	dc.l %10001001111001110011100011101111
	dc.l %10000000001111011111110100000011
	dc.l %10000000000000000000011100000011
	dc.l %10000000111001011111000000000011
	dc.l %10111111100000001101111100000011
	dc.l %10100000000001011100000100000011
	dc.l %11101111000001010101010100000011
	dc.l %10101111110001110101110111011011
	dc.l %10100000000001010000000001011011
	dc.l %10100111111001010111111001011011
	dc.l %10100000001111011100001111011011
	dc.l %10111111000010001100000001011001
	dc.l %10000001011000010000000100011101
	dc.l %10110111011110001100000001110101
	dc.l %10010101010111011100001111000101
	dc.l %11010111011111111111111000010101
	dc.l %10010101010111111000101001000101
	dc.l %10010111011111111010010001110101
	dc.l %11010011011011100001101000000101
	dc.l %11011110001000001010001111100001
	dc.l %10000011111011101001101001100001
	dc.l %10000000011010001100101000100101
	dc.l %11011111111010111101011100111101
	dc.l %10010000000010000100010100000101
	dc.l %11010000011110110111110101110101
	dc.l %11010000000000110000000100000101
	dc.l %10011111111110111111111111111101
	dc.l %10000000010000000000000100000001
	dc.l %11111111111111111111111111111111

laby_fmurs:	; faux murs
	dc.l %11111111111111111111111111111111 	; level 0
	dc.l %10001101000000000000000000000001
	dc.l %11100000000011110111111011100101
	dc.l %10001111110110000000001000000101
	dc.l %10100011111010000000001111110101
	dc.l %10111011000000000000001000010101
	dc.l %10101010000000000000000000010101
	dc.l %10100010000000100000001110110101
	dc.l %10111111000001010000001000000101
	dc.l %10000001000000100000001010000101
	dc.l %11011111110000000000001111000101
	dc.l %10010000010000000000001010000101
	dc.l %10010111011000000101001000100001
	dc.l %10010001010001111101111010000111
	dc.l %11011000010101111101010110000101
	dc.l %10001011011101000000000000110101
	dc.l %11001001000101111111111111110101
	dc.l %11001101101100000000111110000001
	dc.l %11010000000001111010111111111011
	dc.l %10000110101100000110100000000011
	dc.l %11110110101111111000110111110011	;20
	dc.l %11000000101001111010100000001011
	dc.l %10001111100000001010110111101011
	dc.l %10101000101001001010000000000001
	dc.l %10101010101111111010100000101101
	dc.l %10100010101100110011101110101101	;25
	dc.l %10011010101101010100000000100011
	dc.l %11110010101100010101110100111011
	dc.l %10000010100001110101000100001011
	dc.l %10111010111100000101000001101011
	dc.l %10100000000001111100011100100011
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 1
	dc.l %10000000011000000000000100001001	;1
	dc.l %11010111010101011101100000100001
	dc.l %10000000010000100000101000001101
	dc.l %10101010100001100100000110000001	;4
	dc.l %10101000101001010011100100010101
	dc.l %10000010101011001001000001100001
	dc.l %11010000100001000000000100000111	;7
	dc.l %10000111001001001010111010001001
	dc.l %10010100000000000000000000111101	;9
	dc.l %11010001010101010100100011000001
	dc.l %10101100000000010000000100011011
	dc.l %10000010101010000000101001110001	; 12
	dc.l %11011000000000111101011010000111
	dc.l %11011011010110000001000000110001	; 14
	dc.l %11111111111100011011010110100101
	dc.l %10000001001101000000111110001001	; 16
	dc.l %10000101010001000000110110101011
	dc.l %10000100000100000000000000100001	; 18
	dc.l %10000101000101000000110110100101
	dc.l %10000110111111000000000010101001	; 20
	dc.l %10000000000001000000100010100111
	dc.l %11110001001101101011110100010001	; 22
	dc.l %10000000000000101110100001011001
	dc.l %11111010111110100100110110110001
	dc.l %10001011100100101001010000000101	; 25
	dc.l %10101000001110100100000001111101
	dc.l %10000011100110110101101101000001
	dc.l %10111010000010100010000001111011	; 28
	dc.l %10001000010000101000101101101011
	dc.l %10000010000010100010101000000001	; 30
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111 	; level 2
	dc.l %10000000000000001000000000000001
	dc.l %10011000000001101000000000011101
	dc.l %10011000000001101000100100000101
	dc.l %10001000000000001000100010000101
	dc.l %10001111111111111100100001000001
	dc.l %10000000100000100100000111111001
	dc.l %10001000100000100111111000100101
	dc.l %11111110100000101101000000011101
	dc.l %10000000111011100101000011111001
	dc.l %10000000100000000001010100000111
	dc.l %10001011111111111001010011010001
	dc.l %11010100100000001101010100011101
	dc.l %10010101101010101001010101111001
	dc.l %10010000101010101101010100100111
	dc.l %10010000100000000001010100100001
	dc.l %10000000101110111011000010100001
	dc.l %10000000100010110001111000100001
	dc.l %10111011101000110111000000100001
	dc.l %10001000101111111001111111100001
	dc.l %10101010110000001001000000100001
	dc.l %10000011100011101111000000101011
	dc.l %11011111100010100000010000101001
	dc.l %10010000101010010000010000101001
	dc.l %11110000011011010010010000101001
	dc.l %10000100101000011010010000100101
	dc.l %10101111101000010010010000101001
	dc.l %10101001001010011110010011100101
	dc.l %10001000010000000000010000101001
	dc.l %10111010111010000000010100010101
	dc.l %10000010000010001001010000010001
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	;level3
	dc.l %10000101010101010001000010010101
	dc.l %10000101010101010100010000010101
	dc.l %10000101010101000101000001010101
	dc.l %11110101010101010000010100010101
	dc.l %10000111111111010001000001010101
	dc.l %10000001010101001111010000000101
	dc.l %10000110000101000000111000011001
	dc.l %10000110110100000000000111110011
	dc.l %10000111100101110100000000000001
	dc.l %10000000000001110100000000000111
	dc.l %10000111010111010100000000000001
	dc.l %11111000000100010111000000000111
	dc.l %10000111111100010100111000000001
	dc.l %10001101011000110000000111110111
	dc.l %11110101000000110110000001000001
	dc.l %10000101010000110110000011000001
	dc.l %10001101010001000001000111000001
	dc.l %10110111101101000001000101000001
	dc.l %10000010101100111110000100000001
	dc.l %11010110100010000000000011000001	;20
	dc.l %10000010000100000000000000100011
	dc.l %10101010100010000000010100010101
	dc.l %10000001101101111111100010100001
	dc.l %11010110000101000100100010010101
	dc.l %10000001111001000100011100100011
	dc.l %10101010010000010101000101000001
	dc.l %10100010000110000001010010010111
	dc.l %10010100100011110100000100100001
	dc.l %10100010101000010000101100100011
	dc.l %10001010000001000010000001100011
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	: level 4
	dc.l %10100000000001000001000100000001
	dc.l %10101111011111011101010101000001
	dc.l %10100001000010010101010101000001
	dc.l %10111101110010110101010101000001
	dc.l %10100000011110010111010101111111
	dc.l %10001111000100000111010101010101
	dc.l %11111111110111110001010001010001
	dc.l %10000000110000010011011111011101
	dc.l %10110000011111010011010001000101
	dc.l %10111111000001010011010001110101
	dc.l %10101111010101010000010001000101
	dc.l %10101111110001011111111111011101
	dc.l %10111000010101010000000001000101
	dc.l %10101000010000010000000001110001
	dc.l %10110000011111110100000001000101
	dc.l %10101000000000000100000001111101
	dc.l %10101111011111111100000001000001
	dc.l %10101000000000000100000001110001
	dc.l %10110011111000100100000001000001
	dc.l %10100000110000100111111111001111
	dc.l %10001111111110100000010001000001
	dc.l %10100000110000100100010101111101
	dc.l %10101111111100101111010100000101
	dc.l %10100000100000100100010100000101
	dc.l %10100010111100100100010101110101
	dc.l %10010010000100111111110101100101
	dc.l %11010011100100000000000101000101
	dc.l %10010010100000011100110111010101
	dc.l %11010110100111110000110111110101
	dc.l %10010000000100000000000000100101
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 5
	dc.l %10000000001000000000000000000001
	dc.l %10000001001011101110100100000001
	dc.l %10101001001010001000110100000001
	dc.l %10100000001010101100101101111001
	dc.l %10111101010011101000100100000001
	dc.l %10100101001000001110000000000001
	dc.l %10110001010000000000000000000001
	dc.l %10110000010010001011101010000001
	dc.l %10100001010010101000100100000001
	dc.l %10111011010001010011101010000001
	dc.l %10101000010000000010000000000001
	dc.l %10101001101111111011110011111111
	dc.l %10100100000100000100001100110001
	dc.l %10100100011010110100000010101101
	dc.l %10100100100010010010000100100001
	dc.l %10101000100101010100000010000101
	dc.l %10101001100101010100001100100001
	dc.l %10111010000000010011110011110001
	dc.l %10100000101111111000000000001011
	dc.l %10100000010000001001010010100001
	dc.l %10110000100000000100100010100111
	dc.l %10111101100000001011000100111001
	dc.l %10111011000000000001000100101011
	dc.l %10000010000000000001111000100101
	dc.l %10000010000000000001000001000101
	dc.l %11111010000000000001111111100001
	dc.l %10000010000000000001000000100101
	dc.l %11111010000000000001011100100001
	dc.l %10010011100000001010001000011101
	dc.l %10000000100000000100000000000001
	dc.l %11111111111111111111111111111111

	dc.l %11111111111111111111111111111111	; level 6
	dc.l %11101110000111111010000000000001
	dc.l %10101100110000000000111011101011
	dc.l %10001001111001110001100011101111
	dc.l %10000000001111011111110100000011
	dc.l %10000000000000000000011100000011
	dc.l %10000000111001011111000000000011
	dc.l %10111111100000001101111100000011
	dc.l %10100000000001011100000100000011
	dc.l %11101111000000010101010100000011
	dc.l %10101111100001010101110111011011
	dc.l %10100000000001010000000001011011
	dc.l %10100111111001010111111001011011
	dc.l %10100000001111011100001111011011
	dc.l %10111111000010001100000001011001
	dc.l %10000000011000010000000000011101
	dc.l %10110111011110001100000001110101
	dc.l %10010100000111011100001111000101
	dc.l %11010111011111011111111000010101
	dc.l %10010100000110001000101001000101
	dc.l %10010111011110101010000001110101
	dc.l %11010011011011100000100000000101
	dc.l %11011110001000001010001111100001
	dc.l %10000011111011101000100001100001
	dc.l %10000000011010001100001000100101
	dc.l %11010000011010111101011100111101
	dc.l %10000000000010000100010100000101
	dc.l %11000000011110110111110101110101
	dc.l %11000000000000110000000100000101
	dc.l %10010000011110111111110111111101
	dc.l %10000000010000000000000000000001
	dc.l %11111111111111111111111111111111

laby_trappes:
	dcb.l 32,%00000000000000000000000000000000	; level 0

	dc.l %00000000000000000000000000000000	; level 1
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000010000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000010001000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000100000000000000000	;11
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000010	;14
	dc.l %00000000000000000000000001000010
	dc.l %00000000000000000000000000000010
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000010000000000000	;20
	dc.l %00101000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %01000000000000000000001000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000100000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000

	dc.l %00000000000000000000000000000000	; level 2
	dc.l %00001000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %01000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00001000000000000000000000000000
	dc.l %00000000000000000000000010000000	;7
	dc.l %00000000000000010000000000000000
	dc.l %00000000000100001000000000000000
	dc.l %00000000000000000000000000010000
	dc.l %00000000000000000000000000000100
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000100010000000
	dc.l %00000000000000000000001000000000
	dc.l %00000000010000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000010000000	;18
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000010000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000100000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000001100000000
	dc.l %00000000000000000000001100000000
	dc.l %01010000000000000000000000000000
	dc.l %00000000000100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000001000000000000000000000
	dc.l %00000000000000000000000000000000

	dc.l %00000000000000000000000000000000	; level 3
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000001000100000000
	dc.l %00000000000000000000010000000000
	dc.l %00000000000000000100000000000000
	dc.l %00000000000000000010010000100000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000010100	;15
	dc.l %00000000000000000000000000010100
	dc.l %00000000000000000000000000010100
	dc.l %00000000000000000000000000010100
	dc.l %00000000000000000000000000010100
	dc.l %00000000000000000000000000010100
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000001000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000001000
	dc.l %00000000000000000000000000000000

	dcb.l 14,0				; level 4
	dc.l %00010000000000000000000000000000
	dc.l %00000100000000000000010000000000
	dc.l %00000000000000000000101000000000
	dc.l %00000000000000000000010000000000
	dcb.l 4,0
	dc.l %00000000000000000010000000000000
	dcb.l 9,0

	dcb.l 13,0				; level 5
	dc.l %00000000000010000000000000000000
	dc.l %00010000000000000000000000000000
	dcb.l 6,0
	dc.l %00000000000000000001000000000000
	dcb.l 10,0

	dc.l %00000000000000000000000000000000	; level 6
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000010000100	; 4
	dc.l %00000000001000000000000001111000
	dc.l %00000000000000000000000001001000
	dc.l %00000000001000000000000001001000
	dc.l %00000000001000000000000001111000
	dc.l %00000000001000000000000010001000
	dc.l %00000000001000000000000000000000
	dc.l %00000000001000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000011110000000000
	dc.l %00000000000000000000011100000000
	dc.l %00000000000000000001010000000000	;15
	dc.l %00000000000000000011000100000000
	dc.l %00000000000000000011110000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000100
	dc.l %00000000000000000000000000000100
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;25
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;31

	dcb.l 32,0				; level 7


laby_tr_inv:dcb.l 32,%00000000000000000000000000000000	; level 0

	dc.l %00000000000000000000000000000000	; level 1
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000010000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000010000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000010000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000001000000000000	; 12
	dc.l %00000000000000000000000000000000
	dc.l %00000000000100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00010000000000000000000000000000
	dc.l %00100000000000000000000000000000
	dc.l %00001000000000000101000000000000
	dc.l %01010000000000001000000000000000	; 19
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	; 25
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000001000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;30
	dc.l %00000000000000000000000000000000

	dc.l %00000000000000000000000000000000	; level 2
	dc.l %00000000100100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000100100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000100000000000000	;11
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000001000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00010000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000100000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000001000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000001000000
	dc.l %00000000000000000100000000000000
	dc.l %00000000000001000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000010000000000000000
	dc.l %00000000000000000000000000000000

	dc.l %00000000000000000000000000000000	; level 3
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000010000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000100000000
	dc.l %00000000000000000000100000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000100000000	;20
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000

	dcb.l 16,0				; level 4
	dc.l %01000000000000000000000000000000
	dcb.l 15,0

	dcb.l 32,0				; level 5

	dcb.l 32,0				; level 6

laby_autels:dcb.l 21,0
	dc.l %00000000000000100000000000000000
	dcb.l 10,0

	dcb.l 6,0				; level 1
	dc.l %00000000000001000000000000000000	;6
	dcb.l 3,0
	dc.l %00000000000000000100000000000000
	dcb.l 3,0
	dc.l %00010000000000000000000000000000	;14
	dc.l %00000000010000000000000000000000
	dcb.l 12,0
	dc.l %00000000000000000000000000100000	;28
	dcb.l 3,0

	dc.l %00000010000000000000000000000000	; level 2
	dcb.l 8,0
	dc.l %00000000000000000001000000000000
	dc.l %10000000000000000000000000000000
	dcb.l 2,0
	dc.l %00000000000000000000000000100000
	dcb.l 5,0
	dc.l %00000000000001000000000000000000
	dcb.l 8,0
	dc.l %00000000000000000000010000000000
	dcb.l 3,0

	dcb.l 3,%00000000000000000000000000000000	; level 3
	dc.l %10000000000000000000000000000000
	dcb.l 2,0
	dc.l %00000000000000000100000000000000
	dcb.l 5,0
	dc.l %00000000000000010000000000000000
	dcb.l 17,0
	dc.l %10000000000000000000000000000010
	dc.l 0

	dc.l %01000000000000000000000000000000	; level 4
	dc.l %00000000000000000000000000000001
	dcb.l 7,0
	dc.l %00000000001000000010000000000000
	dcb.l 3,0
	dc.l %00000000010000000000000000000000
	dcb.l 10,0
	dc.l %00000000000000100000000000000001
	dcb.l 3,0
	dc.l %00010000000000000000000100000000
	dcb.l 3,0

	dc.l %00001000000000000000000000100000	; level 5
	dcb.l 14,0
	dc.l %00000000000010010000000000000000
	dcb.l 8,0
	dc.l %00000000000000000000010000000000
	dc.l 0
	dc.l %01000000000000000000000000000000
	dcb.l 4,0
	dc.l %00000000000000000000000010000000

	dc.l %00000000000000000000000000010000	; level 6
	dcb.l 4,0
	dc.l %00000000000000000000001000000000
	dc.l 0
	dc.l %00000000000000000000100000000000
	dcb.l 5,0
	dc.l %00000000000010000000000000000000
	dcb.l 9,0
	dc.l %10000000100000000000000000000000
	dcb.l 7,0
	dc.l %00000000000001000000000000000000

laby_chaines:
	dcb.l 5,0 				; level 0
	dc.l %00100000000000000000000000000000	;5
	dcb.l 8,0
	dc.l %00000000000000010000000000000000
	dcb.l 7,0
	dc.l %00000000100000000000000000000000
	dcb.l 5,0
	dc.l %00000000000000000000000000000010
	dcb.l 2,0
	dc.l %00000000010000000000000000000000


	dc.l %00000000000000001000000000000000	; level 1
	dcb.l 26,0
	dc.l %00000000000000100000000000000000
	dcb.l 4,0

	dcb.l 3,0				; level 2
	dc.l %00000000000000000000000000000001
	dcb.l 9,0
	dc.l %00000000000000000000010000000000
	dcb.l 15,0
	dc.l %00000000010000000000000000000000
	dc.l 0
	dc.l %00010000000000000000000000000000

	dcb.l 5,0				; level 3
	dc.l %00000000000000000000000000000001
	dcb.l 21,0
	dc.l %10000000000000000000000000000000
	dcb.l 4,0

	dc.l %00000100000000001000000000000000	; level 4
	dcb.l 4,0
	dc.l %00000000000000000000000001000000
	dcb.l 6,0
	dc.l %10000000000000010000000000000001
	dcb.l 11,0
	dc.l %10000000000000000000000000000000
	dcb.l 7,0

	dc.l %00000000010000000100000000000000	; level 5
	dcb.l 3,0
	dc.l %10000000000000000000000000000000
	dcb.l 7,0
	dc.l %00000000000000000000000000001000
	dcb.l 9,0
	dc.l %00100000000000000000000000000000
	dcb.l 8,0
	dc.l %00000000000000000000000000001000

	dc.l %00000000000000000000000001000000	; level 6
	dcb.l 8,0
	dc.l %10000000000000000000000000000000
	dcb.l 2,0
	dc.l %00000000000000000000000000000010
	dc.l %00000000000000000000000001000000
	dcb.l 4,0
	dc.l %00000100000000000000000000000000
	dcb.l 6,0
	dc.l %00000000000000000000000000000100
	dcb.l 6,0

laby_anneaux:
	dcb.l 2,0				; level 0
	dc.l %00000000000000000010000000000000
	dcb.l 3,0
	dc.l %00000000000000000000000000010000
	dc.l %00000010000000000000000000000000
	dcb.l 10,0
	dc.l %00010000000000000000000000000000
	dcb.l 3,0
	dc.l %00001000000000000000000000000000
	dcb.l 2,0
	dc.l %00000000000000000000000100000000	;25
	dcb.l 6,0

	dc.l %00000000000000000000000001000000	; level 1
	dcb.l 7,0
	dc.l %00000000000000000000010000000000
	dcb.l 8,0
	dc.l %00000000000000000000100000000000
	dcb.l 2,0
	dc.l %00000000010000000000000000000000
	dcb.l 3,0
	dc.l %00000000000000000000000000000001
	dcb.l 6,0
	dc.l %00000000000000010000000000000000

	dc.l %00000000000000000000001000000000	; level 2
	dc.l %10000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000010000000000000000000	;5
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000010000000001
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;10
	dc.l %00000010000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000001
	dc.l %00000000000000000000000000000000
	dc.l %10000000000000000000000000000000	;15
	dc.l %00000000000000000000000000000000
	dc.l %00000000100000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000100000000
	dc.l %00000000000000000000000000000000	;20
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000100000
	dc.l %00100000000000000000000000000000
	dc.l %00000000000000000000000000000000	;25
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000100000000

	dc.l %00000000000000100000100000000000	; level 3
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;5
	dc.l %00000000000000000000000000000000
	dc.l %10000000000100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;10
	dc.l %00000000000000000000000000000000
	dc.l %00000000000100000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00100000000000000000000000000000	;15
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000100000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;20
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;25
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000100000
	dc.l %00000000000000000000000000000000
	dc.l %00000100000000000000000000000000

	dc.l %00000000000000000000000000000000	; level 4
	dc.l %00000000000001000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000001000000000000000000100	;5
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000001000000	;10
	dc.l %00000000000000000000000000000000
	dc.l %00000000100000001000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;15
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000100000000000000000	;20
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000100000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;25
	dc.l %00010000000000000010000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000100000000000000000000001000

	dc.l %00000000000000000000000000000000	; level 5
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000001000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00001000000000000000000000000000	;5
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000010000000000000000000000000	;10
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000010
	dc.l %00000000000000000100000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;15
	dc.l %00000000100000000000000000000000
	dc.l %00000000000000000000001000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;20
	dc.l %00000000000000000000000000000100
	dc.l %00000000000000000000000000000000
	dc.l %00010000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;25
	dc.l %00000000000000000000000010000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000100000000000

	dc.l %00000000000000000000000000000000	; level 6
	dc.l %00000000000000000000000000000000
	dc.l %00000000010000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000010000000000000000000
	dc.l %00000000000000000000000000000000	;5
	dc.l %00000000000000000000000000000000
	dc.l %00000001000000000000001000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;10
	dc.l %00000000000000000000000000000000
	dc.l %00000010000000000000000000000000
	dc.l %00000000000000000000000010000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;15
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000010000000
	dc.l %01000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000	;20
	dc.l %00000000000000000000000000000000
	dc.l %00000000001000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000001000001000	;25
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000000000000000000000000000
	dc.l %00000000100000000000001000000000

*****************************************************************
transporteurs:		; x,y,lvl dpart => arrive

debut_escal:dc 19,25,1,19,25,0	; escalier lvl 0-1
	dc 18,25,0,18,25,1
	dc 12,23,1,12,23,0
	dc 12,24,0,12,24,1
	dc 11,15,1,11,15,0
	dc 11,14,0,11,14,1
	dc 8,8,1,8,8,0
	dc 8,9,0,8,9,1
	dc 21,2,1,21,2,0
	dc 21,3,0,21,3,1

	dc 2,9,2,2,9,3	;level 2-3
	dc 1,9,3,1,9,2
	dc 2,13,2,2,13,3
	dc 1,13,3,1,13,2
	dc 2,26,2,2,26,3
	dc 1,26,3,1,26,2
	dc 23,24,2,23,24,3
	dc 24,24,3,24,24,2
	dc 22,19,2,22,19,3
	dc 22,18,3,22,18,2
	dc 24,20,2,24,20,3
	dc 24,19,3,24,19,2

	dc 20,20,3,20,20,4	; level 3-4
	dc 21,20,4,21,20,3
	dc 20,22,3,20,22,4
	dc 21,22,4,21,22,3
	dc 21,24,3,21,24,4
	dc 22,24,4,22,24,3
	dc 29,28,3,29,28,4
	dc 30,28,4,30,28,3

	dc 28,12,4,28,12,5	; level 4-5
	dc 28,11,5,28,11,4
	dc 28,17,5,28,17,4
	dc 28,16,4,28,16,5

	dc 15,15,6,15,15,5	; level 5-6
	dc 14,15,5,14,15,6

fin_escal:

	dc 21,25,1,1,10,1	; t =>gen
	dc 2,8,1,29,23,1	; t =>wax
	dc 10,20,1,11,20,1	; level 1 (piege)
	dc 11,20,1,12,20,1
	dc 12,20,1,13,20,1
	dc 22,11,1,21,9,1

	dc 3,26,3,3,27,3	; level 3
	dc 24,29,3,15,24,3
	dc 17,25,3,16,29,3
	dc 5,15,3,30,30,3	; shortcut (ASS2)
	dc 5,20,3,15,15,5	; shortcut

trans_decla:dc 25,13,0,19,19,1	; level 0
	dc 1,8,0,20,8,1
	dc 30,1,0,14,22,1
	dc 30,30,0,25,1,0

	dc 29,1,1,28,4,1	; lvl 1
	dc 27,1,1,27,8,1
	dc 29,3,1,24,7,1
	dc 27,3,1,26,5,1
	dc 24,5,1,28,6,1
	dc 29,6,1,29,9,1
	dc 26,6,1,30,3,1
	dc 27,7,1,28,5,1
	dc 29,8,1,26,7,1

	dc 2,20,1,19,6,3

	dc 18,14,1,25,1,3	; carre magique
	dc 17,14,1,23,1,3
	dc 18,15,1,21,1,3
	dc 17,15,1,19,1,3

	dc 22,1,2,19,4,2	; level 2
	dc 22,4,2,19,1,2
	dc 24,10,2,24,19,2
	dc 11,8,2,11,16,2
	dc 4,7,2,14,19,2
	dc 5,8,2,3,7,2
	dc 7,10,2,7,7,2
	dc 9,14,2,8,11,2
	dc 13,20,2,7,8,2
	dc 29,17,2,16,1,2

	dc 29,7,3,30,13,3		; level 3
	dc 6,7,3,5,2,3

	dc 20,4,4,27,15,4		; level 4
	dc 19,11,4,19,6,4
	dc 15,3,4,20,10,4
	dc 10,16,4,9,9,4
	dc 7,11,4,5,15,4
	dc 5,17,4,20,10,4
	dc 28,18,4,17,15,6

	dc 12,11,5,17,15,6		; level 5
	dc 11,15,5,5,7,6
	dc 1,22,5,17,15,6

	dc 18,7,6,17,7,6		; level 6
	dc 16,7,6,17,7,6
	dc 15,9,6,3,17,6
	dc 3,16,6,27,21,6
	dc 26,21,6,15,10,6

	dc.w -1
*********************
boutons:	*dc.w 5,14,3		; ASS2
	*dc.w 2
	*dc.w 0
	*dc.w %0000000000010000
	*dc.l laby_trappes+(16+32*3)*4
	*dc.w 0

boutons_dec:dc.w 3,9,1			; x,y,lvl
	dc.w 2			; 0/1/2 clr,set,change
	dc.w 0			; WORD
	dc.w %0000000001000000		; 0+ WORD=long
	dc.l laby_trappes+(15+32)*4	; adresse
	dc.w 0			; quel graphisme ?

	dc.w 0,14,1
	dc.w 2
	dc.w 0
	dc.w %0000000000000010
	dc.l laby_trappes+(15+32)*4
	dc.w 0

	dc.w 4,23,1
	dc.w 2
	dc.w 0
	dc.w %0000000000000010
	dc.l laby_trappes+(16+32)*4
	dc.w 0

	dc.w 8,31,1
	dc.w 2
	dc.w 0
	dc.w %0000001000000000
	dc.l laby_trappes+(23+32)*4
	dc.w 0

	dc.w 12,5,1
	dc.w 2
	dc.w %0000000000000001
	dc.w 0
	dc.l laby_tr_inv+(7+32)*4
	dc.w 0

	dc.w 20,20,1
	dc.w 2
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_trappes+(21+32)*4
	dc.w 0

	dc.w 7,16,1	; ouvre porte
	dc.w 2
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_fer+(18+32)*4
	dc.w 0

	dc.w 30,15,1	; op
	dc.w 2
	dc.w %0000010000000000
	dc.w 0
	dc.l laby_bois+(16+32)*4
	dc.w 0

	dc.w 31,9,1		; op
	dc.w 2
	dc.w %0000001000000000
	dc.w 0
	dc.l laby_fer+(13+32)*4
	dc.w 0
 
	dc.w 16,26,2		; level 2
	dc.w 0
	dc.w 0
	dc.w 0
	dc.l laby_trappes+(0+64)*4
	dc.w 0
 
	dc.w 14,8,2
	dc.w 0
	dc.w 0
	dc.w 0
	dc.l laby_trappes+(0+64)*4
	dc.w 0
 
	dc.w 16,18,2
	dc.w 0
	dc.w 0
	dc.w 0
	dc.l laby_trappes+(0+64)*4
	dc.w 0
 
	dc.w 24,26,2
	dc.w 2
	dc.w %0101000000000000
	dc.w 0
	dc.l laby_trappes+(27+64)*4
	dc.w 0
 
	dc.w 17,31,2
	dc.w 2
	dc.w 00000000000000010
	dc.w 0
	dc.l laby_trappes+(23+64)*4
	dc.w 0


	dc.w 13,31,2
	dc.w 2
	dc.w 0
	dc.w %0000010000000000
	dc.l laby_trappes+(21+64)*4
	dc.w 0
 
	dc.w 11,31,2
	dc.w 2
	dc.w 0
	dc.w %0000001000000000
	dc.l laby_trappes+(25+64)*4
	dc.w 0

	dc.w 23,22,2
	dc.w 2
	dc.w 0
	dc.w %0000001000000000
	dc.l laby_trappes+(26+64)*4
	dc.w 0

	dc.w 27,3,2
	dc.w 2
	dc.w %0100000000000000
	dc.w 0
	dc.l laby_trappes+(3+64)*4
	dc.w 0

	dc.w 25,8,3			; level 3
	dc.w 2
	dc.w %0000000000010000
	dc.w 0
	dc.l laby_fer+(10+32*3)*4
	dc.w 0

	dc.w 31,6,3
	dc.w 0
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_fmurs+(12+32*3)*4
	dc.w 0

	dc.w 6,16,3
	dc.w 2
	dc.w 0
	dc.w %0000000000010000
	dc.l laby_trappes+(16+32*3)*4
	dc.w 0

	dc.w 17,10,3
	dc.w 0
	dc.w %0000000000001000
	dc.w 0
	dc.l laby_fer+(18+32*3)*4
	dc.w 0

	dc.w 23,18,3
	dc.w 0
	dc.w %0000000100000000
	dc.w 0
	dc.l laby_fmurs+(14+32*3)*4
	dc.w 0

	dc.w 25,18,3
	dc.w 0
	dc.w %0000010000000000
	dc.w 0
	dc.l laby_fmurs+(15+32*3)*4
	dc.w 0

	dc.w 31,16,3
	dc.w 0
	dc.w %0000001010000000
	dc.w 0
	dc.l laby_fmurs+(16+32*3)*4
	dc.w 0

	dc.w 7,17,3
	dc.w 2
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_fmurs+(20+32*3)*4
	dc.w 0

	dc.w 5,30,3
	dc.w 2
	dc.w 0
	dc.w %0000000100000000
	dc.l laby_fer+(30+32*3)*4
	dc.w 0

	dc.w 0,4,4			; level 4
	dc.w 2
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_bois+(1+32*4)*4
	dc.w 0

	dc.w 13,5,4
	dc.w 0
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_bois+(1+32*4)*4
	dc.w 0

	dc.w 29,15,4
	dc.w 2			; 0/1/2 clr,set,change
	dc.w %0010000000000000
	dc.w 0
	dc.l laby_fer+(29+32*4)*4
	dc.w 0

	dc.w 29,19,4
	dc.w 0
	dc.w %0100000000000000
	dc.w 0
	dc.l laby_tr_inv+(16+32*4)*4
	dc.w 0

	dc.w 10,12,4
	dc.w 0
	dc.w %0000000000000001
	dc.w 0
	dc.l laby_bois+(23+32*4)*4
	dc.w 0

	dc.w 10,20,4
	dc.w 0
	dc.w 0
	dc.w %0000100000000000
	dc.l laby_fer+(23+32*4)*4
	dc.w 0

	dc.w 14,17,4
	dc.w 0
	dc.w 0
	dc.w %0100000000000000
	dc.l laby_fer+(21+32*4)*4
	dc.w 0

	dc.w 6,16,4
	dc.w 0
	dc.w 0
	dc.w %0000100000000000
	dc.l laby_trappes+(16+32*4)*4
	dc.w 0

	dc.w 6,26,4
	dc.w 0
	dc.w 0
	dc.w %0000000100000000
	dc.l laby_fer+(30+32*4)*4
	dc.w 0

	dc.w 7,29,4
	dc.w 0
	dc.w %0000000001000000
	dc.w 0
	dc.l laby_fer+(16+32*4)*4
	dc.w 0

	dc.w 6,29,4
	dc.w 0
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_trappes+(25+32*4)*4
	dc.w 0

	dc.w 21,31,4
	dc.w 0
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_fer+(27+32*4)*4
	dc.w 0

	dc.w 5,13,5			; level 5
	dc.w 0
	dc.w 0
	dc.w %0000000000010000
	dc.l laby_fmurs+(22+32*5)*4
	dc.w 0

	dc.w 20,19,6		; level 6
	dc.w 0			; 0/1/2 clr,set,change
	dc.w %0000010000000000
	dc.w 0
	dc.l laby_fmurs+(7+32*6)*4
	dc.w 0

	dc.w 0,17,6
	dc.w 2
	dc.w 0
	dc.w %0000000000000100
	dc.l laby_fer+(13+32*6)*4
	dc.w 0

	dc.w 8,4,6
	dc.w 2
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_trappes+(4+32*6)*4
	dc.w 0

	dc.w -1
***************
dalles:	dc.w 26,28,1		; x,y,lvl
	dc.w 2			; 0/1/2 clr,set,change
	dc.w %0000010000000000		; WORD
	dc.w 0			; + WORD=long
	dc.l laby_trappes+(29+32)*4	; adresse
	dc.l 0			; ad du j

	dc.w 11,13,1
	dc.w 2
	dc.w 0
	dc.w %0000000000000010
	dc.l laby_trappes+(14+32)*4	
	dc.l 0

	dc.w 18,1,2			; level 2
	dc.w 2
	dc.w %0001000000000000
	dc.w 0
	dc.l laby_trappes+(1+64)*4
	dc.l 0

	dc.w 17,1,2
	dc.w 2
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_trappes+(1+64)*4
	dc.l 0

	dc.w 18,4,2
	dc.w 2
	dc.w %0001000000000000
	dc.w 0
	dc.l laby_trappes+(1+64)*4
	dc.l 0

	dc.w 17,4,2
	dc.w 2
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_trappes+(1+64)*4
	dc.l 0

	dc.w 24,6,2
	dc.w 2
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_trappes+(6+64)*4
	dc.l 0

	dc.w 22,6,2
	dc.w 0
	dc.w %0000000001000000
	dc.w 0
	dc.l laby_trappes+(18+64)*4
	dc.l 0

	dc.w 21,6,2
	dc.w 0
	dc.w %0000000001000000
	dc.w 0
	dc.l laby_trappes+(16+64)*4
	dc.l 0

	dc.w 15,7,2
	dc.w 2
	dc.w %0000000000010000
	dc.w 0
	dc.l laby_trappes+(9+64)*4
	dc.l 0

	dc.w 8,7,2
	dc.w 2
	dc.w 0
	dc.w %0000000000010000
	dc.l laby_trappes+(10+64)*4
	dc.l 0

	dc.w 22,10,2
	dc.w 2
	dc.w %0000000000000001
	dc.w 0
	dc.l laby_trappes+(8+64)*4
	dc.l 0

	dc.w 8,11,2
	dc.w 2
	dc.w 0
	dc.w %0000100000000000
	dc.l laby_trappes+(14+64)*4
	dc.l 0

	dc.w 11,12,2
	dc.w 2
	dc.w 0
	dc.w %0000001000000000
	dc.l laby_trappes+(15+64)*4
	dc.l 0

	dc.w 3,11,2
	dc.w 2
	dc.w 0
	dc.w %0000000000000100
	dc.l laby_trappes+(11+64)*4
	dc.l 0

	dc.w 7,15,2
	dc.w 2
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_trappes+(14+64)*4
	dc.l 0

	dc.w 20,18,2
	dc.w 1
	dc.w %0000000001000000
	dc.w 0
	dc.l laby_trappes+(18+64)*4
	dc.l 0

	dc.w 13,19,2
	dc.w 1
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_trappes+(8+64)*4
	dc.l 0

	dc.w 14,20,2
	dc.w 1
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_trappes+(8+64)*4
	dc.l 0

	dc.w 18,22,2
	dc.w 2
	dc.w 0
	dc.w %0000000100000000
	dc.l laby_trappes+(26+64)*4
	dc.l 0

	dc.w 22,23,2
	dc.w 2
	dc.w 0
	dc.w %0000000100000000
	dc.l laby_trappes+(25+64)*4
	dc.l 0

	dc.w 22,25,2
	dc.w 2
	dc.w %0000000000100000
	dc.w 0
	dc.l laby_trappes+(30+64)*4
	dc.l 0

	dc.w 15,26,2
	dc.w 2
	dc.w 0
	dc.w %0000000000000000
	dc.l laby_trappes+(0+64)*4
	dc.l 0

	dc.w 26,27,2
	dc.w 2
	dc.w %0000000000010000
	dc.w 0
	dc.l laby_trappes+(28+64)*4
	dc.l 0

	dc.w 26,28,2
	dc.w 2
	dc.w 0
	dc.w %0000000000000000
	dc.l laby_trappes+(0+64)*4
	dc.l 0

	dc.w 15,26,2
	dc.w 2
	dc.w 0
	dc.w %0000000000000000
	dc.l laby_trappes+(0+64)*4
	dc.l 0

	dc.w 25,2,3			; level 3
	dc.w 0
	dc.w %0000000001010000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+3)
	dc.l 0

	dc.w 23,2,3
	dc.w 0
	dc.w %0000010000010000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+3)
	dc.l 0

	dc.w 21,2,3
	dc.w 0
	dc.w %0000010100000000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+3)
	dc.l 0

	dc.w 19,2,3
	dc.w 0
	dc.w %0000010001000000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+3)
	dc.l 0

	dc.w 11,4,3
	dc.w 1
	dc.w 0
	dc.w %0001000000000000
	dc.l laby_trappes+4*(3*32+4)
	dc.l 0

	dc.w 3,3,3
	dc.w 0
	dc.w 0
	dc.w %0000000000000100
	dc.l laby_fmurs+4*(3*32+3)
	dc.l 0

	dc.w 1,1,3
	dc.w 0
	dc.w 0
	dc.w %0001000000000000
	dc.l laby_trappes+4*(3*32+4)
	dc.l 0

	dc.w 15,7,3
	dc.w 0
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_trappes+4*(3*32+9)
	dc.l 0

	dc.w 7,15,3
	dc.w 0
	dc.w %0000000000001000
	dc.w 0
	dc.l laby_fer+4*(3*32+18)
	dc.l 0

	dc.w 15,16,3
	dc.w 1
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_trappes+4*(3*32+9)
	dc.l 0

	dc.w 21,15,3
	dc.w 1
	dc.w %0000000000001000
	dc.w 0
	dc.l laby_fer+4*(3*32+18)
	dc.l 0

	dc.w 23,17,3
	dc.w 1
	dc.w %0000000010000000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+16)
	dc.l 0

	dc.w 25,17,3
	dc.w 1
	dc.w %0000001000000000
	dc.w 0
	dc.l laby_fmurs+4*(3*32+16)
	dc.l 0
			; level 4
	dc.w 5,1,4
	dc.w 1			; 0/1/2 clr,set,change
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_bois+(1+4*32)*4
	dc.l 0

	dc.w 19,13,4
	dc.w 0
	dc.w %0000000100000000
	dc.w 0
	dc.l laby_fer+(5+4*32)*4
	dc.l 0

	dc.w 23,15,4
	dc.w 2
	dc.w %0000010000000000
	dc.w 0
	dc.l laby_trappes+(15+4*32)*4
	dc.l 0

	dc.w 7,26,4
	dc.w 1
	dc.w 0
	dc.w %0000000010000000
	dc.l laby_trappes+(25+4*32)*4
	dc.l 0

	dc.w 29,30,4
	dc.w 1
	dc.w %0010000000000000
	dc.w 0
	dc.l laby_fer+(29+4*32)*4
	dc.l 0

	dc.w 27,20,4
	dc.w 0
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_fer+(22+4*32)*4
	dc.l 0

	dc.w 28,15,5			; level 5
	dc.w 0
	dc.w %0000000000000001
	dc.w 0
	dc.l laby_fer+(13+32*5)*4
	dc.l 0

	dc.w 28,16,5
	dc.w 0
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_fer+(17+32*5)*4
	dc.l 0

	dc.w 18,13,5
	dc.w 1
	dc.w %0000000000000001
	dc.w 0
	dc.l laby_fer+(13+32*5)*4
	dc.l 0

	dc.w 16,18,5
	dc.w 1
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_fer+(17+32*5)*4
	dc.l 0

	dc.w 17,18,5
	dc.w 2
	dc.w %0000010010010100
	dc.w 0
	dc.l laby_fer+(18+32*5)*4
	dc.l 0

	dc.w 25,15,5
	dc.w 2
	dc.w %0000010010010100
	dc.w 0
	dc.l laby_fer+(18+32*5)*4
	dc.l 0

	dc.w 14,18,5
	dc.w 1
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_fer+(17+32*5)*4
	dc.l 0

	dc.w 13,19,5
	dc.w 2
	dc.w 0
	dc.w %0001010010100100
	dc.l laby_fer+(19+32*5)*4
	dc.l 0

	dc.w 3,20,5
	dc.w 2
	dc.w 0
	dc.w %0001010010100100
	dc.l laby_fer+(19+32*5)*4
	dc.l 0

	dc.w 28,27,5
	dc.w 1
	dc.w %0000100000000000
	dc.w 0
	dc.l laby_fer+(27+32*5)*4
	dc.l 0

	dc.w 29,30,5
	dc.w 1
	dc.w %0001000000000000
	dc.w 0
	dc.l laby_fer+(30+32*5)*4
	dc.l 0

	dc.w 9,27,5
	dc.w 1
	dc.w 0
	dc.w %0000000100000000
	dc.l laby_fer+(27+32*5)*4
	dc.l 0

	dc.w 10,30,5
	dc.w 1
	dc.w 0
	dc.w %0000001000000000
	dc.l laby_fer+(30+32*5)*4
	dc.l 0

	dc.w 29,27,5	;fine
	dc.w 1
	dc.w 0
	dc.w %0000000000000001
	dc.l final
	dc.l 0

	dc.w 30,30,5	;fine
	dc.w 1
	dc.w 0
	dc.w %0000000000000010
	dc.l final
	dc.l 0

	dc.w 10,27,5	;fine
	dc.w 1
	dc.w 0
	dc.w %0000000000000100
	dc.l final
	dc.l 0

	dc.w 12,30,5	;fine
	dc.w 1
	dc.w 0
	dc.w %0000000000001000
	dc.l final
	dc.l 0



	dc.w 13,3,6			; level 6
	dc.w 2
	dc.w 0
	dc.w %0000010000000000
	dc.l laby_fer+(1+32*6)*4
	dc.l 0

	dc.w 4,4,6
	dc.w 0
	dc.w 0
	dc.w %0000000000010000
	dc.l laby_trappes+(5+32*6)*4
	dc.l 0

	dc.w 16,5,6
	dc.w 0
	dc.w 0
	dc.w %1000000000000000
	dc.l laby_bois+(5+32*6)*4
	dc.l 0

	dc.w 7,6,6
	dc.w 0
	dc.w 0
	dc.w %0000000001000000
	dc.l laby_trappes+(6+32*6)*4
	dc.l 0

	dc.w 2,7,6
	dc.w 0
	dc.w 0
	dc.w %0000000000001000
	dc.l laby_trappes+(7+32*6)*4
	dc.l 0

	dc.w 17,12,6
	dc.w 1
	dc.w %0000000000000010
	dc.w 0
	dc.l laby_fer+(13+32*6)*4
	dc.l 0

	dc.w 20,15,6
	dc.w 1
	dc.w %0000000000001000
	dc.w 0
	dc.l laby_fer+(15+32*6)*4
	dc.l 0

	dc.w -1

****** dalles creatrices de monstres
dalles_cree:dc.w 14,14,1	; x_dalle,y_dalle,lvl
	dc.w 15,18,1	; x_monstre...
	dc.w 2		; type
	dc.w PTS200		; pts vie
	dc.w PTSDOM		; pts domage
	dc.l 0		: quel perso

	dc.w 14,9,1
	dc.w 12,12,1
	dc.w 2
	dc.w PTS200
	dc.w PTSDOM
	dc.l 0

	dc.w 11,2,2		; lvl 2
	dc.w 1,10,2
	dc.w 2
	dc.w PTS200
	dc.w PTSDOM
	dc.l 0

	dc.w 7,2,2
	dc.w 1,10,2
	dc.w 2
	dc.w PTS200
	dc.w PTSDOM
	dc.l 0

	dc.w 19,1,2
	dc.w 21,4,2
	dc.w 3
	dc.w PTS200
	dc.w PTSDOM*2
	dc.l 0

	dc.w 19,4,2
	dc.w 21,4,2
	dc.w 3
	dc.w PTS200
	dc.w PTSDOM*2
	dc.l 0

	dc.w 24,8,2
	dc.w 27,10,2
	dc.w 0
	dc.w PTS200
	dc.w PTSDOM*2
	dc.l 0

	dc.w 29,12,2
	dc.w 27,10,2
	dc.w 0
	dc.w PTS200
	dc.w PTSDOM*2
	dc.l 0

	dc.w 25,24,2
	dc.w 6,29,2
	dc.w 1
	dc.w PTS200
	dc.w PTSDOM*4
	dc.l 0

	dc.w 12,29,2
	dc.w 21,20,2
	dc.w 0
	dc.w PTS200
	dc.w PTSDOM
	dc.l 0

	dc.w 24,30,2
	dc.w 21,20,2
	dc.w 0
	dc.w PTS200
	dc.w PTSDOM
	dc.l 0

	dc.w 2,20,2
	dc.w 4,21,2
	dc.w 1
	dc.w PTS200*2
	dc.w PTSDOM*2
	dc.l 0

	dc.w 28,2,3		; level 3
	dc.w 25,6,3
	dc.w 0
	dc.w PTS200*2
	dc.w PTSDOM
	dc.l 0

	dc.w 29,3,3
	dc.w 25,6,3
	dc.w 0
	dc.w PTS200*2
	dc.w PTSDOM
	dc.l 0

	dc.w 27,3,3
	dc.w 25,6,3
	dc.w 3
	dc.w PTS200*3
	dc.w PTSDOM
	dc.l 0

	dc.w 16,8,3
	dc.w 13,9,3
	dc.w 2
	dc.w PTS200*2
	dc.w PTSDOM*2
	dc.l 0

	dc.w 7,6,3
	dc.w 1,11,3
	dc.w 2
	dc.w PTS200*4
	dc.w PTSDOM*1
	dc.l 0
		
	dc.w 6,12,3
	dc.w 8,13,3
	dc.w 0
	dc.w PTS200*1
	dc.w PTSDOM*3
	dc.l 0

	dc.w 15,27,3
	dc.w 15,25,3
	dc.w 0
	dc.w PTS200*1
	dc.w PTSDOM*3
	dc.l 0

	dc.w 20,29,3
	dc.w 17,29,3
	dc.w 0
	dc.w PTS200*1
	dc.w PTSDOM*3
	dc.l 0

	dc.w 18,19,3
	dc.w 17,13,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*3
	dc.l 0

	dc.w 29,20,3
	dc.w 27,18,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 27,20,3
	dc.w 26,19,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 30,22,3
	dc.w 30,25,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 28,22,3
	dc.w 28,21,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 26,22,3
	dc.w 25,23,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 27,24,3
	dc.w 28,25,3
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*1
	dc.l 0

	dc.w 13,2,4		; level 4
	dc.w 11,3,4
	dc.w 2
	dc.w PTS200*3
	dc.w PTSDOM*3
	dc.l 0

	dc.w 21,12,4
	dc.w 17,11,4
	dc.w 3
	dc.w PTS200*6
	dc.w PTSDOM*1
	dc.l 0

	dc.w 14,14,4
	dc.w 10,14,4
	dc.w 0
	dc.w PTS200*7
	dc.w PTSDOM*2
	dc.l 0

	dc.w 13,16,4
	dc.w 10,18,4
	dc.w 2
	dc.w PTS200*7
	dc.w PTSDOM*2
	dc.l 0

	dc.w 8,16,4
	dc.w 11,17,4
	dc.w 3
	dc.w PTS200*7
	dc.w PTSDOM*2
	dc.l 0

	dc.w 25,1,5		; level 5
	dc.w 28,6,5
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*3
	dc.l 0

	dc.w 25,5,5
	dc.w 28,6,5
	dc.w 2
	dc.w PTS200*3
	dc.w PTSDOM*3
	dc.l 0

	dc.w 30,2,5
	dc.w 30,7,5
	dc.w 1
	dc.w PTS200*3
	dc.w PTSDOM*3
	dc.l 0

	dc.w 24,15,5
	dc.w 24,11,5
	dc.w 3
	dc.w PTS200*5
	dc.w PTSDOM*2
	dc.l 0

	dc.w 30,24,5
	dc.w 26,26,5
	dc.w 0
	dc.w PTS200*2
	dc.w PTSDOM*5
	dc.l 0

	dc.w 2,17,5
	dc.w 1,20,5
	dc.w 2
	dc.w PTS200*2
	dc.w PTSDOM*2
	dc.l 0

	dc.w 3,21,5
	dc.w 4,17,5
	dc.w 3
	dc.w PTS200*3
	dc.w PTSDOM*2
	dc.l 0

	dc.w 1,28,5
	dc.w 6,29,5
	dc.w 1
	dc.w PTS200*5
	dc.w PTSDOM*2
	dc.l 0

	dc.w 17,5,6		; level 6
	dc.w 20,12,6
	dc.w 0
	dc.w PTS200*2
	dc.w PTSDOM*3
	dc.l 0

	dc.w 15,10,6
	dc.w 13,9,6
	dc.w 2
	dc.w PTS200*2
	dc.w PTSDOM*3
	dc.l 0

	dc.w 23,14,6
	dc.w 21,17,6
	dc.w 3
	dc.w PTS200*4
	dc.w PTSDOM
	dc.l 0

	dc.w 23,17,6
	dc.w 25,17,6
	dc.w 3
	dc.w PTS200*4
	dc.w PTSDOM
	dc.l 0

	dc.w 3,17,6
	dc.w 5,19,6
	dc.w 0
	dc.w PTS200*2
	dc.w PTSDOM*4
	dc.l 0

	dc.w 27,20,6
	dc.w 30,19,6
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*2
	dc.l 0

	dc.w 27,21,6
	dc.w 28,23,6
	dc.w 0
	dc.w PTS200*3
	dc.w PTSDOM*2
	dc.l 0

	dc.w 14,21,6
	dc.w 7,23,6
	dc.w 1
	dc.w PTS200*4
	dc.w PTSDOM*6
	dc.l 0

	dc.w -1

****** dalles creatrices de boules de feu
dalles_cbf:	dc.w 26,21,1	; x_dalle,y_dalle,lvl
	dc.w 29,21		; x,y_boule_feu
	dc.w -1,0		; dx,dy
	dc.w 1		; lvl
	dc.l 0		; add du joueur

	dc.w 16,21,1
	dc.w 16,15
	dc.w 0,1
	dc.w 1
	dc.l 0

	dc.w 17,18,1
	dc.w 12,18
	dc.w 1,0
	dc.w 1
	dc.l 0

	dc.w 14,16,1
	dc.w 14,23
	dc.w 0,-1
	dc.w 1
	dc.l 0

	dc.w 29,5,2			; lvl 2
	dc.w 29,8
	dc.w 0,-1
	dc.w 2
	dc.l 0

	dc.w 21,10,2
	dc.w 20,5
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 16,10,2
	dc.w 16,5
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 14,15,2
	dc.w 13,7
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 30,19,2
	dc.w 30,12
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 27,17,2
	dc.w 27,11
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 26,19,2
	dc.w 26,13
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 25,17,2
	dc.w 25,11
	dc.w 0,1
	dc.w 2
	dc.l 0

	dc.w 14,20,3	; level 3
	dc.w 19,20
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 14,21,3
	dc.w 20,21
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 14,22,3
	dc.w 19,22
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 15,20,3
	dc.w 19,20
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 15,21,3
	dc.w 20,21
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 16,22,3
	dc.w 19,22
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 22,30,3
	dc.w 26,22
	dc.w 0,1
	dc.w 3
	dc.l 0

	dc.w 26,18,3
	dc.w 22,18
	dc.w -1,0
	dc.w 3
	dc.l 0

	dc.w 17,30,3
	dc.w 13,30
	dc.w 1,0
	dc.w 3
	dc.l 0

	dc.w 15,24,3
	dc.w 15,31
	dc.w 0,-1
	dc.w 3
	dc.l 0

	dc.w 13,28,3
	dc.w 13,23
	dc.w 0,1
	dc.w 3
	dc.l 0

	dc.w 10,30,3
	dc.w 13,30
	dc.w -1,0
	dc.w 3
	dc.l 0
			; level 4
	dc.w 21,10,4
	dc.w 21,15
	dc.w 0,-1
	dc.w 4
	dc.l 0

	dc.w 11,11,4
	dc.w 11,0
	dc.w 0,1
	dc.w 4
	dc.l 0

	dc.w 18,22,4
	dc.w 18,17
	dc.w 0,1
	dc.w 4
	dc.l 0

	dc.w 23,1,5		; level 5
	dc.w 23,12
	dc.w 0,-1
	dc.w 5
	dc.l 0

	dc.w 25,6,5
	dc.w 25,0
	dc.w 0,1
	dc.w 5
	dc.l 0

	dc.w 24,18,5
	dc.w 24,22
	dc.w 0,-1
	dc.w 5
	dc.l 0

	dc.w 25,19,5
	dc.w 25,23
	dc.w 0,-1
	dc.w 5
	dc.l 0

	dc.w 26,19,5
	dc.w 26,22
	dc.w 0,-1
	dc.w 5
	dc.l 0

	dc.w 24,20,5
	dc.w 29,20
	dc.w -1,0
	dc.w 5
	dc.l 0

	dc.w 3,18,5
	dc.w 3,14
	dc.w 0,1
	dc.w 5
	dc.l 0

	dc.w 6,19,5
	dc.w 6,25
	dc.w 0,1
	dc.w 5
	dc.l 0

	dc.w 8,25,5
	dc.w 12,25
	dc.w -1,0
	dc.w 5
	dc.l 0

	dc.w 14,2,6		; level 6
	dc.w 22,2
	dc.w -1,0
	dc.w 6
	dc.l 0

	dc.w 17,7,6
	dc.w 17,3
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 17,9,6
	dc.w 17,3
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 13,14,6
	dc.w 13,12
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 12,14,6
	dc.w 12,12
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 11,14,6
	dc.w 11,12
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 11,15,6
	dc.w 11,12
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 10,16,6
	dc.w 10,12
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 9,16,6
	dc.w 9,13
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 9,15,6
	dc.w 9,13
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 1,19,6
	dc.w 1,13
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 20,25,6
	dc.w 20,21
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 20,26,6
	dc.w 20,21
	dc.w 0,1
	dc.w 6
	dc.l 0

	dc.w 17,30,6
	dc.w 22,30
	dc.w -1,0
	dc.w 6
	dc.l 0

	dc.w -1

****** dalles quart de tour
dalles_quart:
	dc.w 26,23,1	; x_dalle,y_dalle,lvl
	dc.l 0		; ad. du joueur dessus

	dc.w 6,9,3		; level 3
	dc.l 0
	dc.w 6,10,3
	dc.l 0
	dc.w 6,11,3
	dc.l 0
	dc.w 6,13,3
	dc.l 0
	dc.w 3,17,3
	dc.l 0
	dc.w 3,20,3
	dc.l 0
	dc.w 15,20,3
	dc.l 0
	dc.w 15,21,3
	dc.l 0
	dc.w 15,22,3
	dc.l 0
	dc.w 15,22,3
	dc.l 0
	
	dc.w 4,11,4		; level 4
	dc.l 0
	dc.w 4,11,4
	dc.l 0
	dc.w 11,15,4
	dc.l 0

	dc 23,2,5		; level 5
	dc.l 0
	dc 25,15,5
	dc.l 0
	dc 30,11,5
	dc.l 0
	dc 30,11,5
	dc.l 0
	dc 30,16,5
	dc.l 0
	dc 30,16,5
	dc.l 0
	dc 3,17,5
	dc.l 0
	dc 1,27,5
	dc.l 0
	dc 2,28,5
	dc.l 0

	dc.w 5,8,6		; level 6
	dc.l 0
	dc.w 25,11,6
	dc.l 0
	dc.w 13,14,6
	dc.l 0
	dc.w 11,14,6
	dc.l 0
	dc.w 11,16,6
	dc.l 0
	dc.w 1,16,6
	dc.l 0
	dc.w 1,18,6
	dc.l 0
	dc.w 1,18,6
	dc.l 0
	dc.w 1,23,6
	dc.l 0

	dc.w -1

********
portes:	dc.w 25,29,1	; x,y,lvl
	dc.w 1		; 0:ouvert,1:ferme
	dc.l laby_fer	; porte bois ou grille

	dc.w 5,16,1
	dc.w 1
	dc.l laby_bois

	dc.w 4,17,1
	dc.w 1
	dc.l laby_bois

	dc.w 7,18,1
	dc.w 1
	dc.l laby_fer

	dc.w 26,16,1
	dc.w 1
	dc.l laby_bois

	dc.w 25,13,1
	dc.w 1
	dc.l laby_fer

	dc.w 3,2,1
	dc.w 1
	dc.l laby_bois

	dc.w 20,10,3	; level 3
	dc.w 1
	dc.l laby_fer

	dc.w 15,9,3		;clef
	dc.w 1
	dc.l laby_bois

	dc.w 15,11,3	;clef
	dc.w 1
	dc.l laby_fer

	dc.w 15,13,3	;clef
	dc.w 1
	dc.l laby_bois

	dc.w 15,16,3	;clef
	dc.w 1
	dc.l laby_bois

	dc.w 14,14,3	;clef
	dc.w 1
	dc.l laby_fer

	dc.w 8,30,3
	dc.w 1
	dc.l laby_fer

	dc.w 19,18,3
	dc.w 1
	dc.l laby_fer

	dc.w 22,15,3
	dc.w 1
	dc.l laby_fer
			; level 4
	dc.w 6,1,4
	dc.w 1
	dc.l laby_bois

	dc.w 24,5,4
	dc.w 1
	dc.l laby_fer

	dc.w 22,16,4
	dc.w 1
	dc.l laby_fer

	dc.w 27,22,4
	dc.w 1
	dc.l laby_fer

	dc.w 29,29,4
	dc.w 0
	dc.l laby_fer

	dc.w 15,27,4
	dc.w 1
	dc.l laby_fer

	dc.w 14,21,4
	dc.w 1
	dc.l laby_fer

	dc.w 11,23,4
	dc.w 1
	dc.l laby_fer

	dc.w 16,23,4
	dc.w 1
	dc.l laby_bois

	dc.w 8,30,4
	dc.w 1
	dc.l laby_fer

	dc.w 1,27,4
	dc.w 1
	dc.l laby_fer

	dc.w 24,4,5		; level 5
	dc.w 1
	dc.l laby_bois

	dc.w 2,15,5
	dc.w 1
	dc.l laby_bois

	dc.w 16,13,5
	dc.w 0
	dc.l laby_fer

	dc.w 18,18,5
	dc.w 0
	dc.l laby_fer

	dc.w 20,18,5
	dc.w 1
	dc.l laby_fer

	dc.w 23,18,5
	dc.w 0
	dc.l laby_fer

	dc.w 26,18,5
	dc.w 1
	dc.l laby_fer

	dc.w 27,27,5
	dc.w 0
	dc.l laby_fer

	dc.w 28,30,5
	dc.w 0
	dc.l laby_fer

	dc.w 25,30,5
	dc.w 1
	dc.l laby_fer

	dc.w 15,17,5
	dc.w 0
	dc.l laby_fer

	dc.w 12,19,5
	dc.w 0
	dc.l laby_fer

	dc.w 10,19,5
	dc.w 1
	dc.l laby_fer

	dc.w 7,19,5
	dc.w 0
	dc.l laby_fer

	dc.w 5,19,5
	dc.w 1
	dc.l laby_fer

	dc.w 2,19,5
	dc.w 0
	dc.l laby_fer

	dc.w 8,27,5
	dc.w 0
	dc.l laby_fer

	dc.w 9,30,5
	dc.w 0
	dc.l laby_fer

	dc.w 11,28,5
	dc.w 1
	dc.l laby_fer

	dc.w 10,1,6		; level 6
	dc.w 1
	dc.l laby_fer

	dc.w 15,5,6
	dc.w 1
	dc.l laby_bois

	dc.w 17,13,6
	dc.w 0
	dc.l laby_fer

	dc.w 2,13,6
	dc.w 1
	dc.l laby_fer

	dc.w 19,15,6
	dc.w 0
	dc.l laby_fer

	dc.w 17,17,6
	dc.w 0
	dc.l laby_bois

	dc.w 17,22,6
	dc.w 1
	dc.l laby_fer

	dc.w 16,23,6
	dc.w 1
	dc.l laby_bois

	dc.w -1	
********
serrures:	dc.w 17,9,3			; x,y,z
	dc.w 40			; numero de l'objet qui l'ouvre
	dc.l laby_or		; clef en fer ou en or
	dc.w %1000000000000000		; bit a changer
	dc.l laby_bois+4*(32*3+9)+2	; dans quel laby?

	dc.w 16,10,3
	dc.w 41
	dc.l laby_or
	dc.w %1000000000000000
	dc.l laby_fer+4*(32*3+11)+2

	dc.w 14,12,3
	dc.w 42
	dc.l laby_or
	dc.w %1000000000000000
	dc.l laby_bois+4*(32*3+13)+2

	dc.w 16,14,3
	dc.w 43
	dc.l laby_or
	dc.w %1000000000000000
	dc.l laby_bois+4*(32*3+16)+2

	dc.w 16,15,3
	dc.w 32
	dc.l laby_iron
	dc.w %0100000000000000
	dc.l laby_fer+4*(32*3+14)+2

	dc.w 17,15,3
	dc.w 33
	dc.l laby_iron
	dc.w %0000000001000000
	dc.l laby_fer+4*(32*3+15)

	dc.w 24,7,4			; lvl 4
	dc.w 44
	dc.l laby_or
	dc.w %0000000100000000
	dc.l laby_fmurs+4*(32*4+11)

	dc.w 25,7,4
	dc.w 45
	dc.l laby_or
	dc.w %0000001000000000
	dc.l laby_fmurs+4*(32*4+11)

	dc.w 26,7,4
	dc.w 46
	dc.l laby_or
	dc.w %0000010000000000
	dc.l laby_fmurs+4*(32*4+11)

	dc.w 27,7,4
	dc.w 47
	dc.l laby_or
	dc.w %0000100000000000
	dc.l laby_fmurs+4*(32*4+11)

	dc.w 0,26,4
	dc.w 34
	dc.l laby_iron
	dc.w %0000000000000010
	dc.l laby_fer+4*(32*4+27)+2

	dc.w 26,31,5		; level 5
	dc.w 39
	dc.l laby_iron
	dc.w %0000001000000000
	dc.l laby_fer+4*(32*5+30)

	dc.w 1,6,6			; level 6
	dc.w 35
	dc.l laby_iron
	dc.w %0000000000100000
	dc.l laby_trappes+4*(32*6+8)+2

	dc.w 5,23,6
	dc.w 36
	dc.l laby_iron
	dc.w %0000000000000001
	dc.l laby_bois+4*(32*6+23)

	dc.w 16,8,6
	dc.w 37
	dc.l laby_iron
	dc.w %0000000000100000
	dc.l laby_trappes+4*(32*6+8)


	dc.w -1
***************************************************************************

*zik1:	incbin m:\musics\transbea.mus
*zik2:	incbin m:\musics\electra.mus


END
