#!/util/bin/perl -- # -*-Perl-*-

require 'sys/socket.ph';

package ircclient;

# the basics for making CLIENT connections to an irc socket
# *NOT* a parser, just the sending code.  Parsers are easy.

sub bindsocket {		# bind a socket
    local($sockname,$target,$port) = @_;
    local($sockaddr,$name,$aliases,$proto,$type,$len,
	  $thisaddr,$thataddr,$this,$that,$savfh,$hostname);
        
    $sockaddr = 'S n a4 x8';
    chop($hostname = `hostname`);
    $sockname =~ s/^([^']+)$/(caller)[$[]."'".$1/e;
    
    ($name, $aliases, $proto) = getprotobyname('tcp');
    ($name, $aliases, $port) = getservbyname($port, 'tcp')
	unless $port =~ /^\d+$/;;
    ($name, $aliases, $type, $len, $thisaddr) = gethostbyname($hostname);
    ($name, $aliases, $type, $len, $thataddr) = gethostbyname($target);
    
    $this = pack($sockaddr, &main'AF_INET, 0, $thisaddr);
    $that = pack($sockaddr, &main'AF_INET, $port, $thataddr);
    
    socket($sockname, &main'PF_INET, &main'SOCK_STREAM, $proto) ||
	die "socket $sockname: $!";
    bind($sockname, $this) || die "bind $sockname: $!";
    connect($sockname, $that) || die "connect $sockname: $!";
    $savfh = select($sockname); $| = 1; select($savfh);
    $socket = $sockname;
}

sub admin {
    local($target) = @_;

    send($socket,"ADMIN $target\n",0);
}

sub away {
    local($message) = @_;
    $message = " :$message" if $message;
    send($socket,"AWAY$message\n",0);
}

sub channel {
    local($channel) = @_;

    send($socket,"CHANNEL $channel\n",0);
}

sub connect {
    local($toserver, $port, $fromserver) = @_;

    send($socket, "CONNECT $toserver $port $fromserver\n",0);
}


sub deoper {
    send($socket, "DEOPER\n",0);
}

sub die {
    send($socket, "DIE\n",0);
}

sub info {
    local($target) = @_;

    send($socket,"INFO $target\n",0);
}

sub invite {
    local($target,$channel) = @_;
    send($socket, "INVITE $target $channel\n",0);
}

sub join {
    local($channel) = @_;
    send($socket, "JOIN $channel\n",0);
}

sub kick {
    local($channel,$target) = @_;
    send($socket, "KICK $channel $target\n",0);
}

sub kill {
    local($target,$comment) = @_;
    send($socket, "KILL $target $comment\n",0);
}

sub links {
    local($mask) = @_;
    send($socket, "LINKS $mask\n",0);
}

sub list {
    local($channel) = @_;
    send($socket, "LIST $channel\n",0);
}

sub lusers {
    send($socket, "LUSERS\n",0);
}

sub mode {
    local($channel,$mode) = @_;
    send($socket, "MODE $channel $mode\n",0);
}

sub motd {
    local($target) = @_;

    send($socket, "MOTD $target\n",0);
}

sub msg {
    local(@strings)=@_;
    foreach(@strings){
	send($socket,"MSG :$_\n",0);
    }
}

sub names {
    local($channel) = @_;
    send($socket, "NAMES $channel\n",0);
}

sub nick {
    local($target)=@_;
    send($socket, "${srcstring}NICK $target\n",0);
}

sub notice {
    local($target,@strings)=@_;
    foreach(@strings){
	send($socket,"NOTICE $target :$_\n",0);
    }
}

sub oper {
    local($name,$passwd) = @_;

    send($socket,"OPER $name $passwd\n",0);
}

sub part {
    local($channel)=@_;
    send($socket, "PART $channel\n",0);
}

sub pong {
    local($target)=@_;
    send($socket, "PONG $target\n",0);
}

sub privmsg {
    local($target,@strings)=@_;
    foreach(@strings){
	send($socket,"PRIVMSG $target :$_\n",0);
    }
}

sub quit {
    send($socket, "QUIT\n",0);
}

sub quote {
    send($socket,"@_\n", 0);
}

sub squit {
    local($target)=@_;
    send($socket, "SQUIT $target\n",0);
}

sub stats {
    local($target,$flags)=@_;
    send($socket, "STATS $flags $target\n",0);
}

sub summon {
    local($target) = @_;

    send($socket, "SUMMON $target\n",0);
}

sub time {
    local($target) = @_;

    send($socket, "TIME $target\n",0);
}

sub topic {
    local($string)=@_;
    send($socket, "TOPIC $string\n",0);
}

sub trace {
    local($target)=@_;
    send($socket, "TRACE $target\n",0);
}

sub user {
    local($username,$machine,$server,$fullname)=@_;
    send($socket, "USER $username $machine $server $fullname\n",0);
}

sub users {
    local($target)=@_;
    send($socket, "USERS $target\n",0);
}
sub version {
    local($target)=@_;
    send($socket, "VERSION $target\n",0);
}

sub voice {
    local($target,$string)=@_;
    send($socket,"VOICE $target :$string\n",0);
}

sub wall {
    local($string)=@_;
    send($socket,"WALL $string\n",0);
}

sub wallops {
    local($string)=@_;
    send($socket,"WALLOPS $string\n",0);
}

sub who {
    local($mask) = @_;
    send($socket,"WHO $mask\n",0);
}

sub whois {
    local($mask) = @_;
    send($socket,"WHOIS $mask\n",0);
}

sub whowas {
    local($mask) = @_;
    send($socket,"WHOWAS $mask\n",0);
}

1;				# so require works right.
//E*O*F ircclient.pl//
