#!/bin/sh

# Installation script for sirc, will try to find your perl interpreter,
# C compiler, check your perl installation and setup sirc.

# (bits stolen from ircII's "easyinst" and from various configure
# scripts)

cat << '_EOF_'

This script will compile, configure and install sirc for your system.
You can exit at any time by pressing ^C (Control-C) and start over if
you wish to change your settings.

Whenever asked for something, the default answer is shown between
[brackets]. Pressing Enter at that point will take the default answer.

_EOF_

if test "`echo -n a`" = "a"
then
  n='-n'
  c=''
else
  n=''
  c='\c'
fi

echo $n "Continue with the installation? ([y]/n) " $c
read A
case "$A" in
  n*|N*) echo "Aborting."
  	 exit 1
esac

echo
if test -r dsirc -a -r ssfe.c
then
  echo "Checking where dsirc and ssfe.c are - OK"
else
  echo "I can't find the files dsirc or ssfe.c, from the sirc distribution."
  echo "Please run this script in the directory where these files are."
  echo
  exit 1
fi

rm -f ssfe sircsock.ph crfkbtsk.c crfkbtsk
IFS="${IFS= 	}"; save_ifs=$IFS; IFS="${IFS}:"; CC=""; PERL=""
for dir in $PATH
do
  test -z "$dir" && dir="."
  test -f $dir/gcc && CC="$dir/gcc"
  test -f $dir/cc -a -z "$CC" && CC="$dir/cc"
  test -f $dir/perl5 && PERL="$dir/perl5"
  test -f $dir/perl -a -z "$PERL" && PERL="$dir/perl"
done

IFS="$save_ifs"
echo

if test -z "$CC"
then
  echo "I can't find a C compiler, either cc or gcc."
  echo
  CC=none
fi

echo "Enter the name of the C compiler you want to use, or \"none\" if you"
echo "don't have access to one. In that case you can only use this IRC"
echo "client in dumb (not full-screen) mode."
echo
echo "If you don't know what this is all about, just press Enter :)"
echo
echo $n "Compiler? [$CC] " $c
read compiler
test -z "$compiler" || CC="$compiler"
test "$CC" = none && CC=""

if test "$CC"
then
  echo
  echo "ssfe.c needs the termcap library, or something compatible with it,"
  echo "such as ncurses.  Also, on some systems the termcap library is"
  echo "included in the curses library, so \"curses\" might work."
  echo 
  echo $n "Which library to use? [termcap] " $c
  read library
  test -z "$library" && library="termcap"
  case "$library" in
    -l*)
      lib="$library"
      ;;
    *)
      lib="-l$library"
  esac
  echo $n "Use the old BSD sgtty interface instead of the POSIX one? (y/[n])" $c
  read sgtty
  case "$sgtty" in
    y*|Y*)
      opt="-DUSE_SGTTY"
      ;;
    *)
      opt=""
  esac
  echo $n "Any other flags (-O, -L, -I ...) for the compiler? [none]" $c
  read flags
  echo
  echo $n "Attempting to compile ssfe.c with $CC ... press Enter " $c
  read blah
  echo "$CC $opt $flags ssfe.c -o ssfe $lib"
  eval "$CC $opt $flags ssfe.c -o ssfe $lib"
  if test -x ssfe
  then
    echo
    echo "It seems to have worked :)"
  else
    echo
    echo "I can't compile ssfe, for whatever reason. Press ^C and try again"
    echo "with a different compiler or different compile options, or press"
    echo $n "Enter to go on and install sirc in dumb mode... " $c
    read blah
    echo "Going on."
    echo
  fi
fi
test -f ssfe && strip ssfe

echo
if test -z "$PERL"
then
  echo "I can't find your perl interpreter anywhere."
  echo "There is no way sirc can run without perl; please check your"
  echo "PATH and/or ask your sysadmin about it."
  echo
  echo "Enter the full pathname to the perl interpreter, or press ^C"
  echo "to abort the installation."
else
  echo "Enter the name of the perl interpreter you want to use, or"
  echo "press Enter to use $PERL"
fi
echo $n "Perl interpreter? [$PERL] " $c
read perl
test -z "$perl" || PERL="$perl"
echo
echo $n "Checking your perl interpreter... " $c
perlmsg=`eval "$PERL -v" 2>&1`

case "$perlmsg" in 
  *Wall*) echo "OK"
  	  ;;
   *)     echo "Doesn't seem to work ... aborting."
	  exit 1
esac

if $PERL -e 'eval "use Socket; &AF_INET;" || exit 1'
then
  echo You have perl 5.  Congratulations.
else
  echo
  echo "Trying to setup the perl include files sirc needs..."
  sockfile="sircsock.ph"
  hosttype=`uname -a`
  test -z "$hosttype" && hosttype=unknown

  case "$hosttype" in
    AIX*|HP-UX*|Linux*|NEXT*|OSF1*|SunOS*4.1*|ULTRIX*|FreeBSD*|NetBSD*|OpenBSD*)
      echo "... using the defaults I have for your type of system."
      cat > $sockfile << '_EOF_'
eval 'sub SOCK_STREAM {0x1;}';
eval 'sub AF_INET {0x2;}';
eval 'sub PF_INET {0x2;}';
_EOF_
      ;;
    SunOS*5.*|IRIX*5.*)
      echo "... using the defaults I have for your type of system."
      cat > $sockfile << '_EOF_'
eval 'sub SOCK_STREAM {0x2;}';
eval 'sub AF_INET {0x2;}';
eval 'sub PF_INET {0x2;}';
_EOF_
      ;;
    *)
      echo "I don't have any specific defaults for your type of system."
      if test -z "$CC"
      then
	echo "Since we can't use a C compiler, we're stuck with the general"
	echo "default values... I hope they work :>"
	cat > $sockfile << '_EOF_'
eval 'sub SOCK_STREAM {0x1;}';
eval 'sub AF_INET {0x2;}';
eval 'sub PF_INET {0x2;}';
_EOF_
      else
	echo
	echo "Do you want to use the general default values? If you answer \"no\","
	echo "I will try to find out the right values for your system."
	echo $n "Use general defaults? (y/[n]) " $c
	read use
	case "$use" in
	  y*|Y*)
	    echo "Going on with the global defaults... I hope they work for you"
	    cat > $sockfile << '_EOF_'
eval 'sub SOCK_STREAM {0x1;}';
eval 'sub AF_INET {0x2;}';
eval 'sub PF_INET {0x2;}';
_EOF_
	    ;;
	  *)
	    cat > crfkbtsk.c << '_EOF_'
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>

main() {
  printf("eval 'sub SOCK_STREAM {0x%x;}';\n", SOCK_STREAM);
  printf("eval 'sub AF_INET {0x%x;}';\n", AF_INET);
  printf("eval 'sub PF_INET {0x%x;}';\n", PF_INET);
}

_EOF_

	    echo 
	    echo "Compiling intermediary program..."
	    echo 
	    eval "$CC crfkbtsk.c -o crfkbtsk"
	    if test -f crfkbtsk
	    then
	      echo "The intermediary C program seems to have compiled OK."
	    else
	      echo
	      echo "The intermediary C program seems NOT to compile OK."
	      echo "Try again with the global defaults or another compiler..."
	      echo "Aborting."
	      exit
	    fi
	    ./crfkbtsk > $sockfile
	    rm -f crfkbtsk crfkbtsk.c
	    echo "We're done installing your perl include files for sirc"
	esac
      fi
  esac
fi

if $PERL -e 'if (eval "require \"getopts.pl\";") { exit 1 } else { exit 0 }'
then
  echo
  echo "Your perl installation is really messed up, you don't even have the"
  echo "getopts.pl library... creating it in sirc's directory"
  # this code comes from the perl distribution
  cat > getopts.pl << '_EOF_'
;# getopts.pl - a better getopt.pl

;# Usage:
;#      do Getopts('a:bc');  # -a takes arg. -b & -c not. Sets opt_* as a
;#                           #  side effect.

sub Getopts {
    local($argumentative) = @_;
    local(@args,$_,$first,$rest);
    local($errs) = 0;
    local($[) = 0;

    @args = split( / */, $argumentative );
    while(@ARGV && ($_ = $ARGV[0]) =~ /^-(.)(.*)/) {
	($first,$rest) = ($1,$2);
	$pos = index($argumentative,$first);
	if($pos >= $[) {
	    if($args[$pos+1] eq ':') {
		shift(@ARGV);
		if($rest eq '') {
		    ++$errs unless @ARGV;
		    $rest = shift(@ARGV);
		}
		eval "\$opt_$first = \$rest;";
	    }
	    else {
		eval "\$opt_$first = 1";
		if($rest eq '') {
		    shift(@ARGV);
		}
		else {
		    $ARGV[0] = "-$rest";
		}
	    }
	}
	else {
	    print STDERR "Unknown option: $first\n";
	    ++$errs;
	    if($rest ne '') {
		$ARGV[0] = "-$rest";
	    }
	    else {
		shift(@ARGV);
	    }
	}
    }
    $errs == 0;
}

1;
_EOF_
else
  echo "Your perl's getopts.pl library seems to be OK"
fi

curdir=`pwd`
if test -w /bin
then
  bindir="/usr/local/bin"
  plibdir="/usr/local/lib/sirc"
else
  bindir="$HOME/bin"
  if test -d "$HOME/lib"
  then
    plibdir="$HOME/lib/sirc"
  else
    plibdir="$HOME/sirc"
  fi
fi

echo
echo "Where do you want to install the sirc binaries?"
echo $n "Binaries directory? [$bindir] " $c
read bin
test -z "$bin" || bindir="$bin"

if test -d "$bindir"
then
  true
else
  echo "The bin directory $bindir doesn't exist."
  echo $n "Create it? ([y]/n) " $c
  read creat
  echo
  case "$creat" in
    n*|N*)
      echo "I can't put your files there, then!"
      echo "Aborting."
      exit 1
      ;;
    *)
      if mkdir "$bindir"
      then
        echo "Created!"
      else
        echo "Can't create directory... aborting"
	exit 1
      fi
  esac
fi
if test -w "$bindir"
then
  true
else
  echo "I can't write in the $bindir directory."
  echo "Aborting."
  exit 1
fi

echo "Ok"
echo
echo "Other than the executable files in the bin directory, sirc needs to"
echo "keep a small number of files in a directory of its own. You can either"
echo "leave them here in $curdir,"
echo "or specify another directory."
echo
echo $n "Pick another directory for sirc's files? (y/[n]) " $c
read another
filesmoved=""
case "$another" in
  y*|Y*)
    echo $n "sirc directory? [$plibdir] " $c
    read libdir
    test -z "$libdir" && libdir="$plibdir"
    if test -d "$libdir"
    then
      true
    else
      echo "The directory $libdir doesn't exist."
      echo $n "Create it? ([y]/n) " $c
      read creat
      echo
      case "$creat" in
	n*|N*)
	  echo "OK, up to you to move the files there later, then"
	  ;;
	*)
	  if mkdir "$libdir"
	  then
	    echo "Created!"
	  else
	    echo "Can't create directory... aborting"
	    exit 1
	  fi
      esac
    fi
    echo $n "Copy all the files sirc needs in that directory? ([y]/n) " $c
    read copyfiles
    case "$copyfiles" in
      n*|N*)
	echo "Ok, I'll leave that to you..."
        ;;
      *)
	echo "Copying files from $curdir to $libdir..."
	cp ChangeLog PROGRAMMING README dsirc sirc.help.gz ssfe.c n0thing.pl socks.pl $libdir
	chmod 755 $libdir $libdir/dsirc
	chmod 644 $libdir/ChangeLog $libdir/PROGRAMMING $libdir/README $libdir/sirc.help.gz $libdir/ssfe.c $libdir/n0thing.pl
	if test -f getopts.pl
	then
	  cp getopts.pl $libdir
	  chmod 644 $libdir/getopts.pl
	fi
	if test -f sircsock.ph
	then
	  cp sircsock.ph $libdir
	  chmod 644 $libdir/sircsock.ph
	fi
	filesmoved="1"
	if test -f "$libdir/dsirc"
	then
	  echo "done copying."
	else
	  echo
	  echo "Something seems to have gone wrong... aborting."
	  exit 1
	fi
    esac
    ;;
  *)
    libdir="$curdir"
    echo OK
esac

cat << '_EOF_'

sirc now includes experimental support for SOCKS proxies.  If you are
behind a firewall (i.e your host can't directly connect to outside) and
the firewall is running a SOCKS proxy, answer "yes" to this question.
Otherwise answer "no".

_EOF_

echo $n "Support SOCKS proxies? (y/[n]) " $c
read socks
soxtra1=""
soxtra2=""
soxtra3=""
case "$socks" in
  y*|Y*)
    echo $n "Enter the hostname of your SOCKS proxy: " $c
    read socksserver
    if test -z "$socksserver"
    then
      echo "Uhm, I guess you don't really want SOCKS then"
    else
      soxtra1="SOCKS_SERVER=$socksserver; export SOCKS_SERVER
"
      echo $n "What port does your SOCKS proxy use? [1080] " $c
      read socksport
      if test "$socksport"
      then
        soxtra2="SOCKS_PORT=$socksport; export SOCKS_PORT
"
      fi
      test -z "$proxyport" && proxyport=1080
      cat << '_EOF_'

sirc also supports the SOCKS4A extension to the SOCKS protocol, allowing
clients to ask the SOCKS host to resolve hostnames if they can't
themselves.  If your machine has access to a working nameserver, you
don't want this.

_EOF_
      echo $n "Use SOCKS4A DNS extension? (y/[n]) " $c
      read socks4a
      case "$socks4a" in
	y*|Y*)
	  soxtra3="SOCKS_DNS=1; export SOCKS_DNS
"
      esac
    fi
esac

server="irc.primenet.com"
cat << '_EOF_'

One thing left to setup now: the name of your default IRC server.
You should pick the closest server to you in the net you wish to use.

If you don't know which server to use, you can pick one of the following,
or look at http://www.irchelp.org for information:

     irc.primenet.com -  EFnet server in America
     irc.ec-lille.fr  -  EFnet server in Europe
     us.undernet.org  -  Undernet server in America
     eu.undernet.org  -  Undernet server in Europe
     irc.stealth.net  -  IRCnet server in America
     irc.funet.fi     -  IRCnet server in Europe
     irc.dal.net      -  DALnet server in America
     fi.dal.net       -  DALnet server in Europe

_EOF_
echo $n "Default server? [$server] " $c
read serv
test -z "$serv" || server="$serv"

echo
echo "OK, time to put the binaries in the bin directory, and to create the"
echo "startup script."
echo $n "Press Enter to go on, or ^C to interrupt... " $c
read blah
echo

rm -f $bindir/sirc
if test -f ssfe
then
  chmod 755 ssfe
  rm -f $bindir/ssfe
  cp -f ssfe $bindir
  echo "#!/bin/sh

SIRCLIB=$libdir ; export SIRCLIB
${soxtra1}${soxtra2}${soxtra3}
if test -z \"\$SIRCSERVER\" && test -z \"\$IRCSERVER\"
then
  SIRCSERVER=\"$server\"
  export SIRCSERVER
fi

case \"\$1\" in
  -d) shift
      exec $PERL $libdir/dsirc \"\$@\"
      ;;
  *)  eval exec $bindir/ssfe \$SSFE $PERL $libdir/dsirc \\\"\\\$@\\\"
esac" > $bindir/sirc
else
  echo "#!/bin/sh

SIRCLIB=$libdir ; export SIRCLIB
${soxtra1}${soxtra2}${soxtra3}
if test -z \"\$SIRCSERVER\" && test -z \"\$IRCSERVER\"
then
  SIRCSERVER=\"$server\"
  export SIRCSERVER
fi

case \"\$1\" in
  -d) shift
esac
exec $PERL $libdir/dsirc \"\$@\"" > $bindir/sirc

fi
chmod 755 $bindir/sirc

if test -n "$soxtra1"
then
  echo '&load("socks.pl");' > $libdir/sircrc.pl
fi

if test "$filesmoved"
then
  echo
  echo "Since you have copied the files in $libdir,"
  echo "you probably don't need them here... you can delete them if you want."
fi

echo
echo "We're done. You can start sirc at any time by typing \"sirc\" at the Unix"
echo "prompt. If that doesn't work, check your PATH, or you can always start sirc"
echo "by typing $bindir/sirc" | sed "s|$HOME|~|"
echo


if test -f $bindir/ssfe
then
  echo "Keep in mind that you can always exit sirc by pressing Control-X C"
else
  echo "Keep in mind that you can always exit sirc by pressing Control-C"
fi

echo
echo "Happy IRCing..."
echo "... and don't forget to read $libdir/README sometime :)" | sed "s|$HOME|~|"

