/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * proto.h   prototypes
 */

#ifndef PROTO_H
#define PROTO_H

#include <sys/socket.h>
#include <sys/un.h>
#include <types.h>
#include "filesys.h"
#include "nfs.h"
#include "message.h"
#include "netfs.h"


/* netfs.c */
long get_handle(NFS_INDEX *ni);
long nfs_root (_wORD drv, fcookie *fc);
long nfs_lookup (fcookie *dir, char *name, fcookie *fc);
long nfs_creat (fcookie *dir, char *name,
                          unsigned _wORD mode, _wORD attrib, fcookie *fc);
DEVDRV * nfs_getdev (fcookie *fc, long *devsp);
long nfs_getxattr (fcookie *fc, XATTR *xattr);
long do_sattr(fcookie *fc, sattr *attr);
long nfs_chattr (fcookie *fc, _wORD attrib);
long nfs_chown (fcookie *fc, _wORD uid, _wORD gid);
long nfs_chmode (fcookie *fc, unsigned _wORD mode);
long nfs_mkdir (fcookie *dir, char *name, unsigned _wORD mode);
long nfs_rmdir (fcookie *dir, char *name);
long nfs_remove (fcookie *dir, char *name);
long nfs_getname (fcookie *root, fcookie *dir,
                                 char *pathname, _wORD size);
long nfs_rename (fcookie *olddir, char *oldname,
                                 fcookie *newdir, char *newname);
long nfs_pathconf (fcookie *dir, _wORD which);
long nfs_dfree (fcookie *dir, long *buf);
long nfs_writelabel (fcookie *dir, char *name);
long nfs_readlabel (fcookie *dir, char *name, _wORD namelen);
long nfs_symlink (fcookie *dir, char *name, char *to);
long nfs_readlink (fcookie *dir, char *buf, _wORD len);
long nfs_hardlink (fcookie *fromdir, char *fromname,
                                   fcookie *todir, char *toname);
long nfs_fscntl (fcookie *dir, char *name, _wORD cmd, long arg);
long nfs_dskchng (_wORD drv);
long nfs_release (fcookie *fc);
long nfs_dupcookie (fcookie *dst, fcookie *src);


/* netdir.c */
long nfs_opendir (DIR *dirh, _wORD flags);
long nfs_readdir (DIR *dirh, char *nm, _wORD nmlen, fcookie *);
long nfs_rewinddir (DIR *dirh);
long nfs_closedir (DIR *dirh);


/* netdev.c */
long nfs_open (FILEPTR *f);
long nfs_write (FILEPTR *f, char *buf, long bytes);
long nfs_read (FILEPTR *f, char *buf, long bytes);
long nfs_lseek (FILEPTR *f, long where, _wORD whence);
long nfs_ioctl (FILEPTR *f, _wORD mode, void *buf);
long nfs_datime (FILEPTR *f, _wORD *time, _wORD rwflag);
long nfs_close (FILEPTR *f, _wORD pid);
long nfs_select (FILEPTR *f, long proc, _wORD mode);
void nfs_unselect (FILEPTR *f, long proc, _wORD mode);


/* index.c */
void init_mount_attr(XATTR *ap);
NFS_INDEX *get_mount_slot(char *name, NFS_MOUNT_INFO *info);
int release_mount_slot(NFS_INDEX *ni);
NFS_INDEX *get_slot(NFS_INDEX *dir, char *name, int dom);
void free_slot(NFS_INDEX *ni);
long remove_slot_by_name(NFS_INDEX *dir, char *name);
void init_cluster(INDEX_CLUSTER *icp, int number);
void free_cluster(INDEX_CLUSTER *icp);
void init_mount_data();
void init_root();
void init_index();


/* nfsutil.c */
int after(u_long u, u_long v);
long get_timestamp();
int nfs_mode(int mode, int attrib);
int mint_mode(int mode, int type);
void fattr2xattr(fattr *fa, XATTR *xa);
void xattr2fattr(XATTR *xa, fattr *fa);

/* sock_ipc.c */
long rpc_request(SERVER_OPT *opt, MESSAGE *mreq,
                                  u_long proc, MESSAGE **mrep);
void free_message(MESSAGE *m);
MESSAGE *alloc_message(MESSAGE *m, char *buf, long buf_len, long data_size);
int init_ipc(u_long prog, u_long version);


/* cache.c */
NFS_INDEX *nfs_cache_lookup(NFS_INDEX *dir, char *name, int dom);
void nfs_cache_expire();
int nfs_cache_add(NFS_INDEX *dir, NFS_INDEX *index);
int nfs_cache_remove(NFS_INDEX *ni);
int nfs_cache_removebyname(NFS_INDEX *parent, char *name);

#endif
