/****************************************************************************
*	$Id: bm.h 1.3 93/07/16 11:43:01 ROOT_DOS Exp $
*	08 May 93	1.2		GT	Fix warnings.									*
*
*	ATARI Version by David Nash - dnash@chaos.demon.co.uk
*
*  hide definition of struct mbx
*
****************************************************************************/
#ifndef _BM_H
#define _BM_H

/* bm.h -- definitions for bmutil.c that aren't included elsewhere */

#ifdef ATARI
struct mbx;			/* hide definition of strut mbx - defined in mailbox.h */
#endif
 
#ifndef _SMTP_H
#include "smtp.h"
#endif

/* Header types */
#define	NOHEADER 	-1
#define APPROVED	0
#define	FROM		1
#define	TO		2
#define	DATE		3
#define	MSGID		4
#define	SUBJECT		5
#define	RECEIVED	6
#define	SENDER		7
#define	REPLYTO		8
#define STATUS		9
#define BBSTYPE		10
#define XFORWARD	11
#define CC		12
#define RRECEIPT	13
#define APPARTO		14
#define ERRORSTO	15
#define ORGANIZATION	17
#define	UNKNOWN		18

/* number of columns and lines on a standard display, e.g. vt100 */
#define	MAXCOL		80
#define MAXLIN		24

/* message status */
#define	BM_DELETE	1
#define	BM_READ		2
#define	BM_FORWARDED	4

#define BM_NLET		200	/* default size of letter array */

#define SLINELEN	64
#define LINELEN		256

extern unsigned Maxlet;		/* max messages */
extern char *fgets();
extern char *Hdrs[];

void scanmail __ARGS((struct mbx *m));
int msgtofile __ARGS((struct mbx *m,int msg,FILE *tfile,int noheader));
int closenotes __ARGS((struct mbx *m));
int mbx_reply __ARGS((int argc,char *argv[],struct mbx *m,struct list **cclist,char **rhdr));
long isnewprivmail __ARGS((struct mbx *m));
int dolistnotes __ARGS((int argc,char *argv[],void *p));
int isarea __ARGS((char *name));
int dodelmsg __ARGS((int argc,char *argv[],void *p));
int doreadmsg __ARGS((int argc,char *argv[],void *p));
int doreadnext __ARGS((int argc,char *argv[],void *p));
int htype __ARGS((char *s));
char *getaddress __ARGS((char *string,int cont));

#endif  /* _BM_H */
