/****************************************************************************
*	$Id: filter.h 1.2 93/07/16 11:44:39 ROOT_DOS Exp $
*	14 Jun 93	1.2		GT	Enable ip_filter () prototype.					*
*
*  ATARI Version by David Nash - dnash@chaos.demon.co.uk
*
*  hide definition of struct ip with  incomplete definition
*
****************************************************************************/
#ifndef _FILTER_H
#define _FILTER_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#define FILTER_ACTION_DENY 1
#define FILTER_ACTION_PERMIT 2

#ifdef ATARI
struct ip;		/* hide definition of struct ip - defined in ip.h */
#endif

/*
 *   Filter entry structure.
 */
struct filter {
	struct filter	*next;		/* Link to next filter element	*/
	short		action;		/* Filter entry match action	*/
	int		(*type) __ARGS((struct mbuf *bp, struct ip *ip, struct filter *fp));	/* Packet type comparison f(x)	*/
	struct filtersd {
	  	unsigned long addr;	/* Address used for comparisons	*/
		unsigned long mask;	/* Address comparison mask	*/
		unsigned char bits;	/* One bits in high part of mask*/
		unsigned char exclude;	/* Exclude matching addresses	*/
		unsigned short port;	/* TCP/UDP port (low of range)	*/
		unsigned short hiport;	/* High port of range		*/
	} src, dest;
	unsigned long	matches;	/* Number of matching packets	*/
};

int doipfilter __ARGS(( int argc, char *argv[], void *p ));
int ip_filter __ARGS(( struct mbuf *bp, struct ip *ip, struct filter *fp ));

#endif /* _FILTER_H */
