/****************************************************************************
*	$Id: ftpcli.h 1.4 94/02/02 14:38:00 ROOT_DOS Exp $
*	22 Dec 93	1.3		iain@nomed.demon.co.uk	Batch stuff.
*	01 Feb 94	1.4		GT	Wrap column.
*
*  Atari version by David Nash - dnash@chaos.demon.co.uk
*
*  Add V_BYTE verbosity level
*
****************************************************************************/

#ifndef	_FTPCLI_H
#define	_FTPCLI_H

#include <stdio.h>

#ifndef	_FTP_H
#include "ftp.h"
#endif

#ifndef _SESSION_H
#include "session.h"
#endif

#define	LINELEN	256		/* Length of user command buffer */

#define CTLZ	26		/* EOF for CP/M systems */

/* Per-session FTP client control block */
struct ftpcli {
	int control;		/* Control socket */
	int data;		/* Data socket */

	char state;
#define	COMMAND_STATE	0	/* Awaiting user command */
#define	SENDING_STATE	1	/* Sending data to user */
#define	RECEIVING_STATE	2	/* Storing data from user */

	int16 verbose;			/* Transfer verbosity level 						*/
#define	V_QUIET		0	/* Error messages only 								*/
#define	V_SHORT		1	/* Final message only 								*/
#define	V_NORMAL		2	/* display control messages 						*/
#define	V_HASH		3	/* control messages, hash marks 					*/
#define	V_BYTE		4	/* control messages, byte count (ATARI) 		*/

	int batch;				/* Command batching flag */
	int abort;				/* Aborted transfer flag */
	char type;				/* Transfer type */
	char typesent;			/* Last type command sent to server */
	int logbsize;			/* Logical byte size for logical type */
	int16 wrap;				/* hash wrap column						*/
	FILE *fp;				/* File descriptor being transferred */
	int sourcefileon;  		/* 1 readinf lines from surce file */
	FILE *source; 			/* file to source commands from */

	struct session *session;
	void *fsocket; 			/* helps with doopen */
};
#define	NULLFTP	(struct ftpcli *)0

#endif	/* _FTPCLI_H */
