/* Help.c written by paul@wolf.demon.co.uk for ka9qnos */
/* Generic help routine, using a single help file with multiple topics */
#include <stdio.h>
#include "global.h"
#include "ftp.h"
#include "proc.h"
#include "cmdparse.h"
#include "help.h"

/* Call help routine with the helpfile name in 'helpfile'
 *  the current command list structure array in 'cmdlist',
 *  and the help arguments in argc and argv
 */
/* The helpfile lives in the Helpdir directory (as specified
 * in files.h
 * For the format of an example help file, look at FTP.HLP
 */
int
helproutine(argc,argv,cmdlist,helpfile)
int argc;
char *argv[];
struct cmds *cmdlist;
char *helpfile;
{
    char helpcmd[255],
         buf[85];
	int i;
	FILE *fp;
    int found=0;

    strcpy(helpcmd,"help"); /* if command isn't found use 'help' as topic */
	if(argc > 1)
        for(i=0; cmdlist[i].name != NULLCHAR; ++i)
            if(!strncmp(cmdlist[i].name,argv[1],strlen(argv[1]))) {
                strcpy(helpcmd,cmdlist[i].name);
				break;
			}
    strcat(helpcmd,"}");

    /* Scan helpfile looking for topic */
    if((fp = fopen(helpfile,READ_TEXT)) != NULLFILE) {
        while (fgets(buf,84,fp)!=NULL)
        {
            if (buf[0]=='{') {
                if (found)
                    break;
                else
                if (strnicmp(buf+1,helpcmd,strlen(helpcmd))==0)
                    found=1;
             continue;
            }
            if (found)
                tprintf(buf);
        }
        if (!found)
        {
            helpcmd[strlen(helpcmd)-1]=0;
            tprintf("No help available. (topic %s not found)\n",helpcmd);
        }
		fclose(fp);
	}
	else
        tprintf("No help available. (file %s not found)\n",helpfile);
	return 0;
}

