/* RIP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 *
 * Atari version by David Nash - dnash@chaos.demon.co.uk
 *
 * 29.08.94 DFN - pullentry moved from rip.c for use when RIP is not defined
 *                in config.h
 *
 */

#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "timer.h"
#include "rip.h"
#include "trace.h"

void rip_dump(FILE *fp, struct mbuf **bpp)
{
	struct rip_route entry;
	int i;
	int cmd,version;
	int16 len;
	
	fprintf(fp,"RIP: ");
	cmd = PULLCHAR(bpp);
	version = PULLCHAR(bpp);
	switch(cmd){
	case RIPCMD_REQUEST:
		fprintf(fp,"REQUEST");
		break;
	case RIPCMD_RESPONSE:
		fprintf(fp,"RESPONSE");
		break;
	default:
		fprintf(fp," cmd %u",cmd);
		break;
	}

	pull16(bpp);	/* remove one word of padding */

	len = len_p(*bpp);
	fprintf(fp," vers %u entries %u:\n",version,len / RIPROUTE);

	i = 0;
	while(len >= RIPROUTE){
		/* Pull an entry off the packet */
		pullentry(&entry,bpp);
		len -= RIPROUTE;

		if(entry.addr_fam != RIP_IPFAM) {
			/* Skip non-IP addresses */
			continue;
		}
		fprintf(fp,"%-16s%-3u ",inet_ntoa(entry.target),entry.metric);
		if((++i % 3) == 0){
			putc('\n',fp);
		}
	}
	if((i % 3) != 0)
		putc('\n',fp);
}


void pullentry(struct rip_route *ep, struct mbuf **bpp)
{
	ep->addr_fam = pull16(bpp);
	(void)pull16(bpp);
	ep->target = pull32(bpp);
	(void)pull32(bpp);
	(void)pull32(bpp);
	ep->metric = pull32(bpp);
}

