/*
	st_asy.h - header for Atari ST async driver
*/

#ifndef _DOS_H                            /* required for IOREC defn			*/ 
#include <dos.h>
#endif

#define FOUND_DOWN	0x00
#define FOUND_UP		0x01
#define MOVED_DOWN	0x02
#define MOVED_UP		0x03
#define IGNORED 		0x04

struct asy {
	unsigned char  *input_buffer;				/* point to input buffer 			*/
	unsigned int	buflen;						/* length of recv buffer 			*/
	unsigned char  *input_p;					/* pointer to current byte			*/
	unsigned int	input_len;					/* bytes left 							*/
	unsigned int	speed;						/* line speed 							*/
	char	       	*device_name;				/* device name 						*/
	int				unit;							/* unit number 						*/
	unsigned int	rxchar;						/* received char count				*/	
	unsigned int	txchar;						/* transmitted char count			*/
	unsigned int   rxover;                 /* receiver overrun count        */
	unsigned int   txover;                 /* transmit overrun count        */
	struct iface	*iface;						/* back pointer to interface 		*/
	struct mbuf		*sndq;						/* transmit queue 					*/
	struct MsgPort	*serinp;						/* input message port 				*/
	struct MsgPort	*seroutp;					/* output message port 				*/
	char				input_active;				/* input request pending 			*/
	char				output_active;				/* output request pending 			*/
	char				serial_open;				/* open and ready to go 			*/
	char				mode;							/* mode (SLIP, AX25, NRS) 			*/
	IOREC 			*in;							/* ptr to current i/p iorec		*/
	IOREC				*out;							/* ptr to current o/p iorec 		*/
	IOREC 			oldin;						/* saved i/p iorec					*/
	IOREC				oldout; 						/* saved o/p iorec					*/
	unsigned 		addr;							/* Base I/O address, 1 or 3  		*/
	unsigned 		vec;							/* I vector =  route thru flag 	*/
	char dtr_usage;
	char rts_usage;
	char cts_flow_control;
	char rlsd_line_control;			/* RLSD indicates physical layer up/down */

	unsigned char user_flags;		/* user specified flags					*/
	
#define	ASY_UFLAG_1  1				/* Define user flag values here, add code */
#define	ASY_UFLAG_2  2				/* to asy.c and st_asy.c to handle them	*/

};

extern struct asy Asy[];

/*
void check_serin(struct asy *asy), check_serout(struct asy *asy);
*/
