/*
	-----------------------------------------------------
	ATARI Version by David Nash - dnash@chaos.demon.co.uk

	Added __stdargs to tel_output and ttylhandle
	-----------------------------------------------------
*/

#ifndef	_TELNET_H
#define	_TELNET_H

#ifndef _SESSION_H
#include "session.h"
#endif

#define	LINESIZE	256	/* Length of local editing buffer */

/* Telnet command characters */
#define	IAC		255	/* Interpret as command */
#define	WILL		251
#define	WONT		252
#define	DO		253
#define	DONT		254

/* Telnet options */
#define	TN_TRANSMIT_BINARY	0
#define	TN_ECHO			1
#define	TN_SUPPRESS_GA		3
#define	TN_STATUS		5
#define	TN_TIMING_MARK		6
#define	NOPTIONS		6

/* Telnet protocol control block */
struct telnet {
	char local[NOPTIONS];	/* Local option settings */
	char remote[NOPTIONS];	/* Remote option settings */
	struct session *session;	/* Pointer to session structure */
	char eolmode;		/* Control translation of enter key */
};
#define	NULLTN	(struct telnet *)0

extern int Refuse_echo;
extern int Tn_cr_mode;

/* In telnet.c: */
int tel_connect __ARGS((struct session *sp,char *fsocket,int len));

#ifndef ATARI
void tel_output __ARGS((int unused,void *p1,void *p2));
#else
void __stdargs tel_output (int unused, void *p1, void *p2);
#endif

void tnrecv __ARGS((struct telnet *tn));
void doopt __ARGS((struct telnet *tn,int opt));
void dontopt __ARGS((struct telnet *tn,int opt));
void willopt __ARGS((struct telnet *tn,int opt));
void wontopt __ARGS((struct telnet *tn,int opt));
void answer __ARGS((struct telnet *tn,int r1,int r2));

/* In ttylink.c: */

#ifndef ATARI
void ttylhandle __ARGS((int s,void *unused,void *p));
#else
void __stdargs ttylhandle(int s, void *unused, void *p);
#endif

#endif	/* _TELNET_H */
