******************************************************
* PLAYBACK ROUTINES FOR THE STEREO PLAYBACK CARTRIDGE*
* DESIGNED FOR USE WITH MOST BASICS.		     *
* THESE ROUTINES ALLOW OTHER TASKS TO BE PERFORMED   *
* WHILE PLAYING THE SAMPLES.THE ROUTINES ARE DESIGNED*
* TO RUN FROM BASIC BUT COUND EASLY BE MODIFIED TO   *
* RUN FROM C OR YOUR OWN MACHINE CODE PROGRAMS       *
****************************************************** 
* (C) AUDIO VISUAL RESEARCH 1991 
*
* VERSION	1.0	16.1.91 
*		1.1	 8.7.91 fix signed play bug
* OUTPUT ADDRESSES
*
OUTPUTR	EQU $FA0000 (BOTTOM CONNECTOR)
OUTPUTL EQU $FA0200 (TOP CONNECTOR)
*
*
XBTIMER	EQU	31
DOSOUND	EQU	32
*
*
* COMMAND JUMP TABLE
*
	BRA	PLAY		PLAY SAMPLE FORWARDS
	BRA	BACK		PLAY SAMPLE BACKWARDS
	BRA	HALT		STOP SAMPLE PLAYING
	BRA	WAIT		WAIT FOR SAMPLE TO FINISH
	BRA	DUMMY		DOES NOTHING
* 	
* PARAMETER DATA BLOCK 
* BASIC POKES IN VALUES BEFORE CALLING ROUTINE
*
SAMSTART	DS.L	1	START OF SAMPLE DATA
SAMLENGTH	DS.L	1
FREQ		DS.W	1	SAMPLE PLAYBACK FREQ
LOOPZ		DS.W	1	LOOP 0 - OFF, ANY OTHER NUMBER - ON 
MODEZ		DS.W	1	0- LEFT (UNSIGNED)
*				1 -RIGHT(UNSIGNED)
*				2 -BOTH (MONO,UNSIGNED)
*				3 -INTERLACED STEREO (UNSIGNED)		
*				4- LEFT(SIGNED)
*				5- RIGHT(SIGNED)
*				6- BOTH (MONO,SIGNED)
*				7- INTERLACED STEREO (SIGNED)
****************
*     WAIT     *
****************

wait	MOVEM.L	D0/A0,-(A7)
	LEA.L	VARS(PC),A0
	TST.B	GOING(A0)	SAMPLE RUNNING ?
	BEQ.S	WAITX		LEAVE IF NOT
	ST.B	WAITF(A0)	FORCE FLAG
WAITL	TST.B	WAITF(A0)	& WAIT FOR LOW
	BNE.S	WAITL
WAITX	MOVEM.L	(A7)+,D0/A0
DUMMY	RTS

****************
*     HALT     *
****************

halt	MOVEM.L	D0-D7/A0-A6,-(A7)
	CLR.L	-(A7)			SET SUPERVISOR MODE
	MOVE.W	#$20,-(A7)
	TRAP	#1
	ADDQ.L	#6,A7

	LEA	VARS(PC),A0		RESTORE VARIABLE POINTER
	MOVE.L	D0,STACK(A0)		& SAVE OLD STACK POINTER
	MOVE.W	SR,D0			SAVE STATUS
	ORI.W	#$0700,SR		STOP INTS

	BCLR.B	#5,$FFFFFA07.W		CLR IERA (TIMER A)
	BCLR.B	#5,$FFFFFA0B.W		CLR IPRA (TIMER A)
	BCLR.B	#5,$FFFFFA0F.W		CLR ISRA (TIMER A)
	BCLR.B	#5,$FFFFFA13.W		CLR IMRA (TIMER A)
	MOVE.W	D0,SR			RE-ENABLE INTS
	SF.B	GOING(A0)		RESET FLAG
	SF.B	WAITF(A0)		(TO BE SURE)

	MOVE.L	STACK(A0),-(A7)		REPLACE 'OLD' STACK POINTER
	MOVE.W	#$20,-(A7)		REMOVE SUPERVISOR MODE
	TRAP	#1
	ADDQ.L	#6,A7
	MOVEM.L	(A7)+,D0-D7/A0-A6
	RTS

****************
*    REPLAY    *
****************
*
play	
	MOVEM.L	D0-D7/A0-A6,-(SP)
	LEA	VARS(PC),A0		BASE ADDRESS OF DATA STORE
	LEA	LOOPZ(PC),A1	
	MOVE.W	(A1),LOOP(A0)		COPY LOOP
	LEA	SAMSTART(PC),A1	
	MOVE.L	(A1),SSTART(A0)		COPY START OF SAMPLE
	MOVE.L	(A1),COPYS(A0)
	MOVE.L	(A1),LENGTH(A0)		COPY START OF SAMPLE
	MOVE.L	(A1),COPYL(A0)
	LEA	SAMLENGTH(PC),A1	
	MOVE.L	(A1),D0			GET LENGTH
	ADD.L	D0,LENGTH(A0)		ADD TO START TO MAKE END
	ADD.L	D0,COPYL(A0)
	LEA	MODEZ(PC),A1
	MOVE.W	(A1),D0
	MOVE.W	D0,MODE(A0)		COPY MODE
	
	CLR.L	-(A7)			SET SUPERVISOR MODE
	MOVE.W	#$20,-(A7)
	TRAP	#1
	ADDQ.L	#6,A7

	LEA	VARS(PC),A0		RESTORE VARIABLE POINTER
	MOVE.L	D0,STACK(A0)		& SAVE OLD STACK POINTER

	MOVE.W	SR,SREG(A0)		PRESERVE CURRENT INT. STATUS
	ORI.W	#$0700,SR		AND SWITCH OF ALL INTS.
*
*  SET UP AND INSTALL INTERRUPT
*
	LEA.L	FREQTAB(PC),A1		GET TABLE OF MFP VALUES
	LEA	FREQ(PC),A0
	MOVE.W	(A0),D0			GET SAMPLE FREQUENCY
	ANDI.W	#15,D0
	LSL.W	#2,D0			LONG WORD OFFSET
	MOVE.L	0(A1,D0.W),D0		GET MFP VALUES
	LEA	VARS(PC),A0
	TST.W	MODE(A0)
	BNE	TM1
	PEA.L	IPLAYL(PC)		INSTALL PLAY LEFT ROUTINE
	BRA.S	CONT1
TM1	CMP.W	#1,MODE(A0)		
	BNE	TM2
	PEA.L	IPLAYR(PC)		INSTALL PLAY RIGHT ROUTINE
	BRA	CONT1
TM2	CMP.W	#2,MODE(A0)		
	BNE	TM3
	PEA.L	IPLAYB(PC)		INSTALL PLAY BOTH (MONO)
	BRA	CONT1
TM3	CMP.W	#3,MODE(A0)		
	BNE	TM4
	PEA.L	IPLAYS(PC)		PLAY STEREO INTERLEAVED
	BRA	CONT1
TM4	CMP.W	#4,MODE(A0)		
	BNE	TM5
	PEA.L	ISPLAYL(PC)		PLAY LEFT (SIGNED)
	BRA	CONT1
TM5	CMP.W	#5,MODE(A0)
	BNE	TM6
	PEA.L	ISPLAYR(PC)		PLAY RIGHT (SIGNED)
	BRA	CONT1
TM6	CMP.W	#6,MODE(A0)
	BNE	TM7
	PEA.L	ISPLAYB(PC)		PLAY BOTH (SIGNED)
	BRA	CONT1
TM7	PEA.L	ISPLAYS(PC)		PLAY STEREO (SIGNED)
CONT1	MOVE.W	D0,-(A7)		DATA REGISTER BYTE
	SWAP	D0
	MOVE.W	D0,-(A7)		CONTROL REGISTER BYTE
	MOVE.W	#0,-(A7)		TIMER A
	MOVE.W	#XBTIMER,-(A7)
	TRAP	#14
	ADDA.L	#12,SP
	LEA	VARS(PC),A0		REPAIR POINTER

	ST.B	GOING(A0)		THE "WE'RE RUNNING" FLAG
	SF.B	WAITF(A0)
	MOVE.W	SREG(A0),SR		START PLAY
	MOVE.L	STACK(A0),-(A7)		REPLACE 'OLD' STACK POINTER
	MOVE.W	#$20,-(A7)		REMOVE SUPERVISOR MODE
	TRAP	#1
	ADDQ.L	#6,A7
	MOVEM.L	(SP)+,D0-D7/A0-A6
	RTS				BACK TO CALLER

********************
*  PLAY BACKWARDS  *
********************

back
	MOVEM.L	D0-D7/A0-A6,-(SP)
	LEA	VARS(PC),A0		BASE ADDRESS OF DATA STORE
	LEA	LOOPZ(PC),A1	
	MOVE.W	(A1),LOOP(A0)		COPY LOOP
	LEA	SAMSTART(PC),A1	
	MOVE.L	(A1),SSTART(A0)		COPY START OF SAMPLE
	MOVE.L	(A1),COPYS(A0)
	MOVE.L	(A1),LENGTH(A0)		COPY START OF SAMPLE
	MOVE.L	(A1),COPYL(A0)
	LEA	SAMLENGTH(PC),A1	
	MOVE.L	(A1),D0			GET LENGTH
	ADD.L	D0,LENGTH(A0)		ADD TO START TO MAKE END
	ADD.L	D0,COPYL(A0)
	LEA	MODEZ(PC),A1
	MOVE.W	(A1),D0
	MOVE.W	D0,MODE(A0)		COPY MODE
	

	CLR.L	-(A7)			SET SUPERVISOR MODE
	MOVE.W	#$20,-(A7)
	TRAP	#1
	ADDQ.L	#6,A7

	LEA	VARS(PC),A0		RESTORE VARIABLE POINTER
	MOVE.L	D0,STACK(A0)		& SAVE OLD STACK POINTER

	MOVE.W	SR,SREG(A0)		PRESERVE CURRENT INT. STATUS
	ORI.W	#$0700,SR		AND SWITCH OF ALL INTS.
*
*  SET UP AND INSTALL INTERRUPT
*
	LEA.L	FREQTAB(PC),A1		GET TABLE OF MFP VALUES
	LEA	FREQ(PC),A0
	MOVE.W	(A0),D0			GET SAMPLE FREQUENCY
	ANDI.W	#15,D0
	LSL.W	#2,D0			LONG WORD OFFSET
	MOVE.L	0(A1,D0.W),D0		GET MFP VALUES
	LEA	VARS(PC),A0

	TST.W	MODE(A0)
	BNE	TMB4
	PEA.L	IBACKL(PC)		INSTALL PLAY LEFT ROUTINE
	BRA.S	CONT2
TMB4	CMP.W	#1,MODE(A0)		
	BNE	TMB5
	PEA.L	IBACKR(PC)		INSTALL PLAY LEFT ROUTINE
	BRA	CONT2
TMB5	CMP.W	#2,MODE(A0)		
	BNE	TMB6
	PEA.L	IBACKB(PC)		INSTALL PLAY LEFT ROUTINE
	BRA	CONT2
TMB6	CMP.W	#3,MODE(A0)
	BNE	TMB7
	PEA.L	ISBACKS(PC)		PLAY STEREO (INTERLEAVED) 
	BRA.S	CONT2
TMB7	CMP.W	#4,MODE(A0)		
	BNE	TMB8
	PEA.L	ISBACKL(PC)		PLAY LEFT (SIGNED)
	BRA	CONT2
TMB8	CMP.W	#5,MODE(A0)		
	BNE	TMB9
	PEA.L	ISBACKR(PC)		PLAY RIGHT (SIGNED)
	BRA	CONT2
TMB9	CMP.W	#6,MODE(A0)		
	BNE	TM10
	PEA.L	ISBACKB(PC)		PLAY BOTH (SIGNED)
	BRA	CONT2
TM10	PEA.L	ISBACKS(PC)		PLAY STEREO (INTERLEAVED)
CONT2	MOVE.W	D0,-(A7)		DATA REGISTER BYTE
	SWAP	D0
	MOVE.W	D0,-(A7)		CONTROL REGISTER BYTE
	MOVE.W	#0,-(A7)		TIMER A
	MOVE.W	#XBTIMER,-(A7)
	TRAP	#14
	ADDA.L	#12,SP
	LEA	VARS(PC),A0		REPAIR POINTER

	ST.B	GOING(A0)		THE "WE'RE RUNNING" FLAG
	SF.B	WAITF(A0)
	MOVE.W	SREG(A0),SR		START PLAY
	MOVE.L	STACK(A0),-(A7)		REPLACE 'OLD' STACK POINTER
	MOVE.W	#$20,-(A7)		REMOVE SUPERVISOR MODE
	TRAP	#1
	ADDQ.L	#6,A7
	MOVEM.L	(SP)+,D0-D7/A0-A6
	RTS				BACK TO CALLER

**************************************
*   THE INTERRUPT SERVICE ROUTINES   *
**************************************
*
*	A6 = SAMPLE START / OUTPUT ADDRESS
*	A5 = VARIABLES OFFSET
*	A4 = UNUSED
*	A3 = UNUSED
*	A2 = UNUSED
*	A1 = UNUSED
*	A0 = UNUSED
*
*	D7 = AUDIO DATA
*	D6 = UNUSED
*	D5 = UNUSED
*	D4 = UNUSED
*	D3 = UNUSED
*	D2 = UNUSED
*	D1 = UNUSED
*	D0 = UNUSED 
*
* EACH OPTION HAS ITS OWN INTERUPT ROUTINE
****************************************
*       REPLAY SAMPLE FORWARDS         *
****************************************
* UNSIGNED
IPLAYL	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

IPLAYR	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTR,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

IPLAYB	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	ADD.W	#$200,D7		ADD OFFSET FOR RIGHT
	TST.B	(A6,D7.W)		PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

IPLAYS	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	MOVEQ.L	#0,D7
	MOVE.B	(A6)+,D7		READ RIGHT CHANNEL FROM RAM
	SWAP	D7
	MOVE.B	(A6)+,D7		READ LEFT CHANNEL FROM RAM
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT.S	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	SWAP	D7
	ADD.W	D7,D7			WORD OFFSET
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)		PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE
************************************
*    STOP TIMER 'A' INTERRUPTS     *
************************************

STOP	MOVE.W	SR,D7		SAVE STATUS
	ORI.W	#$0700,SR	STOP INTS

	BCLR.B	#5,$FFFFFA07.W	CLR IERA (TIMER A)
	BCLR.B	#5,$FFFFFA0B.W	CLR IPRA (TIMER A)
	BCLR.B	#5,$FFFFFA0F.W	CLR ISRA (TIMER A)
	BCLR.B	#5,$FFFFFA13.W	CLR IMRA (TIMER A)

	SF.B	GOING(A5)
	SF.B	WAITF(A5)
	MOVE.W	D7,SR		RESTORE STATUS
	MOVEM.L	(A7)+,D7/A5-A6
	RTE

**********************
*   CHECK LOOP MODE  *
**********************

LOOPS	SF.B	WAITF(A5)		INFORM END OF LOOP
	TST.W	LOOP(A5)		LOOPING SET?
	BEQ.S	STOP			BR. IF NOT
	MOVE.L	COPYS(A5),SSTART(A5)
	MOVE.L	COPYL(A5),LENGTH(A5)
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

****************************************
*       REPLAY SAMPLE BACKWARDS        *
****************************************

IBACKL	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ.S	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

IBACKR	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ.S	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTR,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

IBACKB	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

IBACKS	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BLS	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ RIGHT FROM RAM
	SWAP	D7
	MOVE.B	-(A6),D7	READ LEFT FROM RAM
	
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	SWAP	D7
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

* SIGNED INTERUPT ROUTINES
ISPLAYL	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

ISPLAYR	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTR,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

ISPLAYB	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	CLR.W	D7
	MOVE.B	(A6)+,D7		READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	ADD.W	#$200,D7		ADD OFFSET FOR RIGHT
	TST.B	(A6,D7.W)		PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

ISPLAYS	MOVEM.L	D7/A5-A6,-(SP)

	LEA.L	VARS(PC),A5		GET DATA BLOCK
	MOVE.L	SSTART(A5),A6		RESTORE POINTERS
	MOVEQ.L	#0,D7
	MOVE.B	(A6)+,D7		READ RIGHT CHANNEL FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	SWAP	D7
	MOVE.B	(A6)+,D7		READ LEFT CHANNEL FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	CMP.L	LENGTH(A5),A6		EXCEDED END STOP?
	BGT	LOOPS
	MOVE.L	A6,SSTART(A5)		UPDATE POINTER

	ADD.W	D7,D7			WORD OFFSET
	MOVE.L	#OUTPUTL,A6		OUTPUT ADDRESS
	TST.B	(A6,D7.W)		PLAY LEFT SOUND
	SWAP	D7
	ADD.W	D7,D7			WORD OFFSET
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)		PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W		END OF INTERRUPT (TIMER A)
	RTE

****************************************
*       REPLAY SAMPLE BACKWARDS        *
****************************************
* SIGNED ROUTINES

ISBACKL	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

ISBACKR	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTR,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

ISBACKB	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BEQ	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE

ISBACKS	MOVEM.L	D7/A5-A6,-(SP)
	LEA.L	VARS(PC),A5	GET DATA BLOCK
	MOVE.L	LENGTH(A5),A6	RESTORE POINTERS
	MOVEQ.L	#0,D7
	CMP.L	SSTART(A5),A6	AT START?
	BLS	LOOPS		BRANCH IF SO
	MOVE.B	-(A6),D7	READ RIGHT FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	SWAP	D7
	MOVE.B	-(A6),D7	READ LEFT FROM RAM
	ADD.B	#$80,D7			UNSIGN DATA
	
	MOVE.L	A6,LENGTH(A5)	UPDATE POINTER

	ADD.W	D7,D7		WORD OFFSET
	MOVE.L	#OUTPUTL,A6	OUTPUT ADDRESS
	TST.B	(A6,D7.W)	PLAY LEFT SOUND
	SWAP	D7
	ADD.W	#$200,D7
	TST.B	(A6,D7.W)	PLAY RIGHT SOUND
	MOVEM.L	(SP)+,D7/A5-A6
	BCLR.B	#5,$FFFFFA0F.W	END OF INTERRUPT (TIMER A)
	RTE



FREQTAB	DC.L	$0003001F	 5 KHZ
	DC.L	$00010052	 7.5 KHZ
	DC.L	$0001004D	 8.0 KHZ
	DC.L	$00030011	9.0 KHZ
	DC.L	$0001003E	10 KHZ
	DC.L	$0003000E	11 KHZ
	DC.L	$00010033	12 KHZ
	DC.L	$00010029	15 KHZ
	DC.L	$00010026	16 KHZ
	DC.L	$00010022	18 KHZ
	DC.L	$0001001F	20 KHZ
	DC.L	$00030007	22 KHZ
	DC.L	$00060001	25 KHZ
	DC.L	$00060001	25 KHZ
	DC.L	$00060001	25 KHZ
	DC.L	$00060001	25 KHZ


**************************************
*       DEFINE PROGRAM STORAGE       *
**************************************
*
	EVEN
SSTART	RS.L	1	USED BY INTERRUPT
LENGTH	RS.L	1
COPYS	RS.L	1	COPY START FOR LOOP
COPYL	RS.L	1	COPY LENGTH FOR LOOP
FREQNCY	RS.L	1	PRESET FREQUENCY
STACK	RS.L	1	TEMP STACK
SREG	RS.W	1	STATUS REGISTER
LOOP	RS.W	1	LOOPING MODE SET
WAITF	RS.B	1	WAITING FLAG
GOING	RS.B	1	ALREADY ACTIVE
MODE	RS.W	1	COPY OF MODEZ FLAG
BLOCK	RS.W	0

**************************************
*      DECLARE PROGRAM STORAGE       *
**************************************
*
	EVEN
VARS	DS.B	BLOCK

	END
