Received: by maskin (mbox dlanor)
 (with Cubic Circle's cucipop (v1.31 1998/05/13) Mon May 10 13:33:59 1999)
X-From_: tos.pl.net!mb@tos.pl.net Mon May 10 06:04:18 1999
Received: (from uucp@localhost)
	by maskin.ettnet.se (8.9.1a/8.8.8) id GAA14065
	for <dlanor@oden.se>; Mon, 10 May 1999 06:04:12 +0200 (MET DST)
Received: from UNKNOWN(202.20.65.1), claiming to be "planet.ak.planet.gen.nz"
 via SMTP by maskin, id smtpdAAAa003Rf; Mon May 10 06:03:57 1999
Received: (from uucp@localhost)
	by planet.ak.planet.gen.nz (8.8.8/8.8.8) id PAA00559
	for oden.se!dlanor; Mon, 10 May 1999 15:59:47 +1200 (NZST)
>Received: from localhost by tos.pl.net with smtp
	(Smail3.1.29.5 #1) id m10ghCk-0001K9C; Mon, 10 May 99 15:58 NZST
Date: Mon, 10 May 1999 15:58:08 +1200
From: Mario Becroft <mb@tos.pl.net>
X-Sender: mb@tos
To: Ronald Andersson <dlanor@oden.se>
Subject: IP masquerading
In-Reply-To: <Pine.LNX.3.96.990509130643.23798A-100000@hal.fishpool.fi>
Message-ID: <Pine.MNT.4.05.9905101447110.652-100000@tos>
MIME-Version: 1.0
Received: from tos.pl.net by planet.ak.planet.gen.nz; Mon, 10 May 1999 15:59 NZS
Content-Type: TEXT/PLAIN; charset=US-ASCII

Mr Andersson,

I have taken it upon myself to implement IP masquerading functionality in
MiNTNet, and and it was suggested to me by Martin-Eric Racine that I
should contact you, as you were familiar with this subject.

Unfortunately I have only a passing familiarity with networking, but I am
reading various manuals and RFC's and I think I am learning quickly what
it is all about.

So far I have come up with some ideas about the requirements to implement
IP masquerading. As I am not familiar with the subject I imagine there are
many issues that I have not considered, however I will describe below my
current thoughts on the subject, which are based on a little bit of
reading on the subject and otherwise just common sense.

To describe the intended results:

A gateway machine should be able to join two networks, such that all data
transmitted to and from one of the networks appears to be directed to and
from the gateway machine only. The gateway machine will direct the data to
the actual intended recipients.

Thus the gateway machine must implement functionality similar to the
following:

Data from the machines that will benefit from IP masquerading (I will call
those machines the "masqueraded" machines) destined for a machine in the
rest of the world and travelling via the masquerading gateway will have
their source addresses modified to equal those of the gateway machine. At
the same time the gateway machine will maintain a record of all data
modified in this way, so that data transmitted by remote machines in reply
can be redirected in a similar manner to reach the masqueraded machine for
which they are really destined.

Unfortunately I have not entirely figured out the details of how this will
be implemented. I have some general ideas, but I have not yet been able to
reliably work out a coherent implementation which covers everything.

It seems clear that the IP masquerading process must have some concept of
port numbers, since these would be used to identify which masqueraded
machine a datagram is destined for. This implies that the IP masquerading
functionality cannot work only at the IP level, but must also work on the
TCP and UDP level to handle the port values. ICMP seems more complicated.
Is the TCP or UDP header always within the first fragment, or might it be
necessary to reconstruct a fragmented IP datagram before all the required
information can be obtained?

I hope it is not necessary to deal with TCP except so far as to use the
port value in the TCP header.

Since the address and port values must be modified to utilise a port on
the gateway machine, there must some coherent method of relating a certain
port on the gateway machine to a certain port on a masqueraded machine.
Perhaps the first time a datagram is received from a certain port on a
masqueraded machine, the gateway will add an entry in a database to
connect that port with a certain port on the gateway. When subsequent
datagrams arrive, that same port will always be substituted. However there
would need to be some mechanism for determining when a port is no longer
needed.

Conversely when an IP datagram arrives at the gateway machine from the
outside world, and is found to be destined for a port that is in said
database, the datagram gets redirected to the address and port of the
masqueraded machine as listed in the database.

The above describes approximately the current state of my thinking on the
subject of IP masquerading. I would be most interested in your comments.

Thank you very much.

-- 
+-----------------------------------------------------------------------+
| Mario Becroft                * Tariland, New Zealand Atari User Group |
| mb@tos.pl.net                * Atari Hardware Developments            |
| http://www.ak.planet.gen.nz/~mario/ * Atari Serial Mouse Interface    |
+-----------------------------------------------------------------------+




