Received: by maskin (mbox dlanor)
 (with Cubic Circle's cucipop (v1.31 1998/05/13) Wed May 12 19:13:43 1999)
X-From_: tos.pl.net!mb@tos.pl.net Wed May 12 07:23:19 1999
Received: (from uucp@localhost)
	by maskin.ettnet.se (8.9.1a/8.8.8) id HAA02818
	for <dlanor@oden.se>; Wed, 12 May 1999 07:23:19 +0200 (MET DST)
Received: from UNKNOWN(202.20.65.15), claiming to be "planet.ak.planet.gen.nz"
 via SMTP by maskin, id smtpdAAAa000g0; Wed May 12 07:23:16 1999
Received: (from uucp@localhost)
	by planet.ak.planet.gen.nz (8.8.8/8.8.8) id RAA23322
	for oden.se!dlanor; Wed, 12 May 1999 17:19:06 +1200 (NZST)
>Received: from localhost by tos.pl.net with smtp
	(Smail3.1.29.5 #1) id m10hRP4-0001TlC; Wed, 12 May 99 17:17 NZST
Date: Wed, 12 May 1999 17:17:57 +1200
From: Mario Becroft <mb@tos.pl.net>
X-Sender: mb@tos
To: Ronald Andersson <dlanor@oden.se>
Subject: Re: IP masquerading
In-Reply-To: <199905120050.CAA25760@maskin.ettnet.se>
Message-ID: <Pine.MNT.4.05.9905121605270.771-100000@tos>
MIME-Version: 1.0
Received: from tos.pl.net by planet.ak.planet.gen.nz; Wed, 12 May 1999 17:19 NZS
Content-Type: TEXT/PLAIN; charset=US-ASCII

On Wed, 12 May 1999, Ronald Andersson wrote:

> >A gateway machine should be able to join two networks, such that all data
> >transmitted to and from one of the networks appears to be directed to and
> >from the gateway machine only. The gateway machine will direct the data to
> >the actual intended recipients.
> 
> Yes, that is the basic idea.  This is also the basis for other methods than
> masquerading of course, since it describes a rather wide-reaching concept.

Could you describe what some of those other methods are? I suppose it
might be worthwhile to consider them, in case they are more suitable for
my intended purpose than the IP masquerading which I currently have in
mind.

> It is not legal to fragment TCP/UDP headers.  That is implied in the rule
> that MSS nay never be larger than MTU-40.  For UDP there is no equivalent
> to MSS, or let us rather say that it is fixed to 512.  Other rules define
> mandatory datagram handling capability of all IP implementations such that
> it is never relevant to fragment UDP packets at all. That is also implied
> by the fact that UDP is essentially a single datagram exchange protocol.
> It can be used for other things too, but for such things TCP is better.

Since writing my previous email I have thought of some other issues.  
Because the port number is only contained in the first fragment, i.e. the
one containing the TCP or UDP header, subsequent fragments do not contain
all the required information to enable them to be redirected correctly.
Since a subsequent fragment might arrive before the first fragment, it is
possible that a fragment would arrive before the necessary information
could be obtained. In such cases the fragment would need to be retained
until the first fragment arrived. However I suspect that this is a
complicated approach to the problem, and it would be easier to re-assemble
all datagrams that are subject to IP masquerading, before processing them.
What do you think?

[Regarding expiring unused database records]
> True, but there is no way to know this with absolute certainty, especially
> as UDP exchanges do not have any generic message stating that the exchange
> is over.  There is not even any guarantee that datagrams will ever arrive
> as UDP is a 'lossy' protocol, without delivery control (like TCP has).
> So we can never know if more incoming datagrams are expected or not.

I have since given this some consideration and arrived at similar
conclusions to those which you put forward. I had decided to do it like
this:

Each database record will include a creation time and a destruction time.
When a database entry is created, the creation time will be set to the
current time, while the destruction time will be set to a value that is
appropriate for the protocol in question. For UDP this would be an
estimated period of time such as 1 minute, which should accomodate most
cases. For TCP, the destruction time would by default be a long period of
time, but since it is possible to determine when a TCP connection is
closed, the destruction time would be set to a short time when the
connection is seen to have been closed.

However even if a record is marked for destruction because the destruction
time has passed, it will not actually be destroyed until a new record is
needed, in which case the first available record which is marked for
destruction will be used.

Additionally, I determined that it would be necessary to implement
never-to-be-destroyed records. Such records would be indicated by a
destruction time that is equal to the creation time. These records would
be used for permanently redirecting certain ports to a masqueraded
machine. For example HTTP connections to the gateway machine may always be
redirected to a masqueraded machine running the actual HTTP server.

What I am calling the "creation time," should in fact be referred to as
the "last used time" and would be updated each time the database record is
used to redirect a datagram. This would ensure that the timeout for
destruction is based on the last time the record was used instead of the
time when it was created.

> NB: These checksum operations need to be done for all packets, and that
>     means that they should be highly optimized, preferably by use of
>     assembly language, optimized by an experienced assembler programmer.

Fortunately MiNTNet includes highly optimised routines for calculating
checksums, which I believe I can use for IP masquerading.

Regarding ICMP, I had not given this a lot of consideration as I wanted to
clearly understand the simpler issues first. However I now have a clearer
understanding of those issues, and so your comments on handling ICMP
datagrams were very helpful. I had reached much the same conclusions as
the ones that you put forward, but your explanation clarified a couple of
points.

> Well, I think that this mail now actually contains all the vital info
> needed to be able to construct a functional masquerade implementation,
> except of course for the low level details (header structs etc).
> For those you should turn to the RFCs (as always for such things).
> 
> I wish you the best of luck for your implementation, and if you feel
> a need for further advice or consultation, I remain at your disposal.

Fortunately your explanations generally confirm the ideas that I already
had. Even so your advice is very beneficial for me, since it represents a
proven approach, while I am only thinking about untested theories. Your
advice is much appreciated, and with the aid of your considered
explanations I am confident that I will be able to finish this project.

-- 
+-----------------------------------------------------------------------+
| Mario Becroft                * Tariland, New Zealand Atari User Group |
| mb@tos.pl.net                * Atari Hardware Developments            |
| http://www.ak.planet.gen.nz/~mario/ * Atari Serial Mouse Interface    |
+-----------------------------------------------------------------------+




