Received: by maskin (mbox dlanor)
 (with Cubic Circle's cucipop (v1.31 1998/05/13) Wed May 26 10:35:47 1999)
X-From_: tos.pl.net!mb@tos.pl.net Tue May 18 09:25:40 1999
Received: (from uucp@localhost)
	by maskin.ettnet.se (8.9.1a/8.8.8) id JAA24344
	for <dlanor@oden.se>; Tue, 18 May 1999 09:25:34 +0200 (MET DST)
Received: from UNKNOWN(202.20.65.1), claiming to be "planet.ak.planet.gen.nz"
 via SMTP by maskin, id smtpdAAAa005wL; Tue May 18 09:25:31 1999
Received: (from uucp@localhost)
	by planet.ak.planet.gen.nz (8.8.8/8.8.8) id TAA21517
	for oden.se!dlanor; Tue, 18 May 1999 19:21:29 +1200 (NZST)
>Received: from localhost by tos.pl.net with smtp
	(Smail3.1.29.5 #1) id m10jeCE-0000xzC; Tue, 18 May 99 19:21 NZST
Date: Tue, 18 May 1999 19:21:50 +1200
From: Mario Becroft <mb@tos.pl.net>
X-Sender: mb@tos
To: Ronald Andersson <dlanor@oden.se>
Subject: Re: IP masquerading
In-Reply-To: <199905120050.CAA25760@maskin.ettnet.se>
Message-ID: <Pine.MNT.4.05.9905181857420.823-100000@tos>
MIME-Version: 1.0
Received: from tos.pl.net by planet.ak.planet.gen.nz; Tue, 18 May 1999 19:21 NZS
Content-Type: TEXT/PLAIN; charset=US-ASCII

Seeing as I contacted you previously regarding IP masquerading I thought I
would inform you about the progress I have made.

Since I wrote my last email to you, I have implemented fully functional IP
masquerading in MiNTNet, and it seems to be working very well, at least on
my small network of 3 computers.

There were no major problems, and considering my lack of knowledge, the
whole thing came off very smoothly. It probably still has bugs that will
be found after it is used by more people, but all the basic functionality
is there and is working well.

Although it turns out that I could have done it equally well without your
help, it was invaluable to compare my ideas with an existing
proven implementation, and some of your suggestions saved some time that
it would otherwise have taken for me to figure out what approach to use.
So all together, your assistance has been of great benefit and I thank you
very much for it.

In case you are interested, following are some of the ways in which I
solved the various issues which I mentioned in my two previous emails to
you.

To keep track of masqueraded connections I have a database with one record
for each connection. The record has information describing the connection
in terms of its source address and port number and protocol, its port on
the gateway machine, and it also includes a last used time field as well
as a timeout field.

When a datagram arrives from a masqueraded machine, the database is
searched to find an entry with matching source and port, and if none is
found, a new entry is created referencing an unused port on the gateway
machine. The last used time is always updated any time that a record is
accessed. For a newly created record, the timeout is set to a
user-specified value depending upon the protocol, TCP, UDP or ICMP.

TCP has special additional handling, in that when a datagram with the SYN
flag set is received from the remote end of the connection, indicating
that the remote host has responded and the connection will be established,
a new tcp-connected timeout is written in the corresponding database
record, and when a FIN or RST datagram is transmitted in either direction,
a tcp-finished timeout is used instead. This ensures that an established
TCP connection can get a long timeout, while one that has been closed, or
one which has not opened properly, will timeout quickly. After testing it
for the past couple of days this approach seems to be successful.

When the current time is alter than a record's last accessed time plus its
timeout, the record is condemned, although it is not deleted. Condemned
records will, however, be over-written when ever a new record needs to be
allocated, or when the operator purges them via a user command. Otherwise
they remain indefinitely, although the operator could have them purged
regularly via cron if he wanted to.

There is a single array which contains pointers to each record in the
database, and to look up the destination of an incoming masqueraded
datagram is as simple as accessing an index in the array that is the same
as the port that received the datagram minus the base port number. I
thought of using a linked list, but I decided that this would be faster.
However I might still use a linked list instead, as it would require less
memory, especially when the database empty or only has a small number of
records.

I also have a separate database consisting of the same kind of records,
but as a linked list, for redirected ports. These entries are created and
destroyed by the user, and are never destroyed or "condemned" in any other
way. This is necessary because the normal database referred to above
cannot redirect ports other than those in a specific range used for
masquerading, which is not useful if, for example, a user wants to
permanently redirect port 80 for HTTP transfers to a different masqueraded
machine.

To handle fragmented datagrams, I simply re-assemble every datagram that
is received before processing it, whether or not it needs masquerading. I
see no other way of handling this, and in any case it does not appear to
create any problems, although it is true that I have not had much of an
opportunity to test this thoroughly.

ICMP error messages are forwarded to the masqueraded machine which
generated the original datagram and this seems to be successful. Echo,
info and other ICMP messages have the identification field used in the
same way as the port is used for TCP and UDP, as you suggested, and this
also seems to be successful.

Anyway, I hope the above is of some interest, and thanks again for your
advice.

-- 
+-----------------------------------------------------------------------+
| Mario Becroft                * Tariland, New Zealand Atari User Group |
| mb@tos.pl.net                * Atari Hardware Developments            |
| http://www.ak.planet.gen.nz/~mario/ * Atari Serial Mouse Interface    |
+-----------------------------------------------------------------------+



