;----------------------------------------------------------------------------
;File name:	NETD_APP.S			Revision date:	1999.04.01
;Creator:	Ulf Ronald Andersson		Creation date:	1998.11.20
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 25	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;----------------------------------------------------------------------------
MAX_VA_ARGLEN	equ	512
;----------------------------------------------------------------------------
	include	RA_JAR.I
	include	RA_XB.I
	include	RA_SIM.I
	include	RA_AV.I
	include	RA_ARG.I
	include	RA_APP.I
;
	include	sting\NETD.I
;----------------------------------------------------------------------------
	output	.APP
;----------------------------------------------------------------------------
M_YEAR	=	1999
M_MONTH	=	4
M_DAY	=	1
;
M_TITLE		MACRO
		dc.b	'GEM NetDemon'
		ENDM
M_VERSION	MACRO
		dc.b	'01.04'
		ENDM
M_AUTHOR	MACRO
		dc.b	'Ronald Andersson'
		ENDM
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
text_start:
basepage	=	(text_start-$100)
my_APP		=	basepage	;ND_APP_base
;----------------------------------------------------------------------------
my_LongJump:
start:
	jmp	(start_1).l		;ND_APP_jump
;----------------------------------------------------------------------------
my_magic:
	dc.l	ND_XB_ID	;ND_magic	;Must equal ND_XB_ID
	dc.l	'_APP'		;ND_xmagic	;Must equal '_APP'
	dc.l	REF_IF_VER	;ND_if_ver	;NetD interface version
	dc.w	((M_YEAR-1980)<<9)|(M_MONTH<<5)|M_DAY	;uint16 ND_APP_date
	dc.l	my_APP_version_s	;ND_APP_version	;NetD APP version string in "xx.yy" format
	dc.l	my_APP_author_s	;ND_APP_author	;-> name of author of NetD APP
;-------
	dc.l	global		;ND_APP_global
;----------------------------------------------------------------------------
my_APP_version_s:
	M_VERSION
	dc.b	NUL
my_APP_author_s:
	M_AUTHOR
	dc.b	NUL
	EVEN
;----------------------------------------------------------------------------
start_1:
	start_app
;----------------------------------------------------------------------------
	ifeq	huge_program
	SECTION	DATA
	endc
;----------------------------------------------------------------------------
acc_name:	dc.b	'  NetDemon '
		M_VERSION
		dc.b	NUL	;for ACC menu registration
;--------
id_app_name_s:	dc.b	'NETD    ',NUL
		EVEN
;----------------------------------------------------------------------------
	ifeq	huge_program
	SECTION	BSS
	endc
;----------------------------------------------------------------------------
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	1024		;subroutine stack >= 1024 longs
mystack:	ds.l	1		;top of subroutine stack
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
init_app:
	start_arg
	lea	VA_arg_s,a0
	clr.b	(a0)
	move.l	a0,VA_arg_p
;-------
	clr	inited_f		;invalidate 'initialized' flag
	st	NetD_STX_p		;invalidate NetD cookie pointer
	bsr	try_ND_init_APP	;try to initialize via cookie
	rts
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
exec_app:
	clr	d0			;preclear low word of d0
	tst.w	d7			;MI/PL == TOS/GEM
	bmi.s	.TOS_checked		;go keep d0 bit_3 cleared for TOS/TTP program
	bset	#3,d0			;set d0 bit_3 for GEM program
.TOS_checked:
	cmp	#1,global+2		;EQ/NE == Single/Multi-tasking AES
	beq.s	.MULTI_checked		;go keep d0 bit_2 cleared for singletasking
	bset	#2,d0			;set d0 bit_2 for multitasking
.MULTI_checked:
	tst.l	d7			;MI/PL == ACC/nonACC
	bpl.s	.ACC_checked		;go keep d0 bit_1 cleared for nonACC
	bset	#1,d0			;set d0 bit_1 for ACC
.ACC_checked:
	move	exec_ref(pc,d0),d0	;fetch a word offset to selected exec code
	jmp	exec_ref(pc,d0)	;jump to selected exec code
;-------------------------------------
exec_ref:
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_single_APP-exec_ref,exec_single_ACC-exec_ref
	dc.w	exec_multi_APP-exec_ref,exec_multi_ACC-exec_ref
;-------------------------------------
exec_TOS:
	lea	must_be_GEM_al_s,a3
	bra	exit_app_alarm
;-------------------------------------
exec_single_APP:
	lea	must_be_multi_al_s,a3
	bra	exit_app_alarm
;-------------------------------------
exec_multi_APP:
	btst	#7,revise_type_f	;been here before ?
	bne.s	repeat_multi_APP	;then behave like an ACC this time
initial_multi_APP:
	bset	#7,revise_type_f	;tell main loop to behave like ACC
	bra	exit_app_ok		;exit to main event loop
;-------------------------------------
repeat_multi_APP:
exec_single_ACC:
exec_multi_ACC:
	bsr	try_ND_init_APP	;try to initialize via cookie
	move	inited_f(pc),d0		;test for success
	bne.s	.cookie_ok		;skip error message if cookie present
.cookie_bad:
	lea	must_have_STX_al_s,a3	;prep message about "absent cookie"
	sim_aes	form_alert,#1,(a3)	;show error message
	bra	exit_app_ok		;and exit when user closes alert
;-------
.cookie_ok:
.first_server_loop:
	clr.l	current_server_p
	clr	server_count
	clr	server_number
	lea	none_s(pc),a0
	move.l	a0,server_name_p
	move.l	a0,server_author_p
	lea	no_ver_s(pc),a0
	move.l	a0,server_version_p
;-------
	move.l	NetD_STX_p(pc),a4	;a4 -> NetD_STX struct
	move.l	ND_server_q(a4),d0	;d0 -> NetD server queue
	ble.s	.have_server_info
	move.l	d0,current_server_p
.cnt_srv_loop:
	addq	#1,server_count		;increment server count
	Move.l	d0,a3			;a3 -> current server
	move.l	ND_SRV_next(a3),d0	;d0 -> next server or is NULL
	bgt.s	.cnt_srv_loop		;loop back until at end of queue
.next_server_loop:
	addq	#1,server_number
	move.l	current_server_p(pc),a3	;a3 -> current server
	move.l	ND_SRV_name(a3),server_name_p
	move.l	ND_SRV_version(a3),server_version_p
	move.l	ND_SRV_author(a3),server_author_p
.have_server_info:
	bsr	prep_main_alert		;prepare alert text
	lea	main_al_s(pc),a2	;a2 -> alert text
	sim_aes	form_alert,#1,(a2)	;show message
	cmp	#1,d0			;[ Ok ] button ?
	beq.s	exit_app_ok		;if so, exit
	move.l	ND_SRV_next(a3),d0	;d0 -> next server or is NULL
	ble	.first_server_loop	;loop to show first server at end of queue
	move.l	d0,current_server_p	;set next server as current
	bra.s	.next_server_loop	;loop back to show next server
;-------------------------------------
exit_app_alarm:
	sim_aes		form_alert,#1,(a3)
exit_app_err:		;jump here to exit with error code -1
	moveq	#-1,d0
exit_terminate:		;jump here to exit with error code in d0
	bclr	#7,revise_type_f
	bra.s	exit_app_app
;-------------------------------------
exit_app_ok:
	clr.l	d0
exit_app_app:
	rts
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
	ifd	exec_timeout	;cond:	ifd exec_timeout
exec_timer:
	move.l	NetD_STX_p(pc),d0
	ble.s	exit_timer
	move.l	d0,a5			;a5 -> NetD cookie
	pea	my_APP(pc)
	move.l	ND_exec_APP(a5),a0
	jsr	(a0)
	addq	#4,sp
exit_timer:
	rts
	endc			;ends:	ifd exec_timeout
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
	ifd	exec_message	;cond:	ifd exec_message
exec_mesag:
	cmp	#AC_CLOSE,message
	bne.s	.not_AC_CLOSE
	sf	keep_wind_f
	bra	exit_mesag
;
.not_AC_CLOSE:
	cmp	#AP_TERM,message
	bne.s	.not_AP_TERM
	tst.l	d7
	bmi	exit_mesag		;AP_TERM is not for ACCs
	clr.l	d0			;flag no error
	bra	exit_terminate
;
.not_AP_TERM:
	cmp	#VA_START,message
	bne	.not_VA_START
	st	VA_START_f
	move	message+2,AV_partner_id
	move.l	message+6,VA_START_cmd_p
;
	AV_send	PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
	clr.b	VA_arg_s		;prep empty local string
	lea	VA_arg_s(pc),a2		;a2 -> local argument area
	move.l	a2,VA_arg_p		;prep a pointer for future
	move.l	VA_START_cmd_p(pc),a0	;a0 -> argument on Venus
	move.l	a0,d0			;test -> argument on Venus
	ble.s	.send_AV_STARTED	;if NULL, go send reply now
	move.l	a0,a1			;a1 -> argument on Venus
	strpass	a1			;a1 -> argument end on Venus
	sub.l	VA_START_cmd_p(pc),a1	;a1 = argument length
	move.l	a1,d1			;d1 = length of argument
	move	#MAX_VA_ARGLEN,d0
	cmp.l	d0,d1			;argument too long ?
	blo.s	.length_ok
	move.l	d0,d1			;limit argument length
.length_ok:
	move.b	-1(a0,d1.w),d0		;save byte at termination point
	clr.b	-1(a0,d1.w)		;enforce limited termination
	move.l	a0,a1			;a1 -> argument on Venus
	lea	VA_arg_s(pc),a2		;a2 -> local argument area
	move.l	a2,VA_arg_p		;prep a pointer for future
	strcpy	a1,a2			;make a local copy of argument
	move.b	d0,-1(a0,d1.w)		;repair original copy
.send_AV_STARTED:
	AV_send	STARTED|_ind,VA_START_cmd_p(pc)
	bra	exec_app
;
.not_VA_START:
	cmp	#VA_PROTOSTATUS,message
	bne.s	.not_VA_PROTOSTATUS
	move	message+8,VA_protostatus
	move	message+6,VA_protostatus+2
	bra	exit_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
exit_mesag:
	rts
	endc			;ends:	ifd exec_message
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
try_ND_init_APP:
	tst.l	NetD_STX_p
	bgt.s	.exit
	gemdos	Super,!
	move.l	d0,-(sp)
	eval_cookie	#ND_XB_ID
	move.l	d0,d3
	gemdos	Super,()
	move.l	d3,NetD_STX_p
	bmi.s	.exit
	st	inited_f
	move.l	NetD_STX_p(pc),a5
	pea	my_APP(pc)
	move.l	ND_init_APP(a5),a0
	jsr	(a0)
	addq	#4,sp
.exit:
	rts
;----------------------------------------------------------------------------
prep_main_alert:
	lea	main_al_l3(pc),a2	;a2 -> base of line 3
	lea	main_al_srvcnt(pc),a1	;a1 -> server count in line 3
	move	server_count(pc),d0	;d0 = server count
	bsr.s	word2ascii		;conv d0 to (a1)+
	bsr	pad_to_next		;pad spaces to (a1)+ through 28(a2)
	move.b	#'|',(a1)+		;pad line separator to (a1)+
	move.l	a1,a2			;a2 -> base of line 4
	move.b	#'#',(a1)+		;pad '#' to (a1)+
	move	server_number(pc),d0	;d0 = server number
	bsr.s	word2ascii		;conv d0 to (a1)+
	move.b	#'=',(a1)+		;add '=' after number
	move.l	server_name_p(pc),a0	;a0 -> server name string
	moveq	#26,d2			;d2 = 26 char extra limit
	bsr.s	strcpy_to_al		;copy string into alert line at (a1)+
	bsr.s	pad_to_next		;pad spaces to (a1)+ through 28(a2)
	move.b	#'|',(a1)+		;pad line separator to (a1)+
	move.l	a1,a2			;a2 -> base of line 5
	move.l	server_version_p(pc),a0	;a0 -> server version string
	moveq	#5,d2			;d2 = 5 char extra limit
	bsr.s	strcpy_to_al		;copy string into alert line at (a1)+
	move.b	#' ',(a1)+		;add ' ' after number
	move.b	#'b',(a1)+		;add 'b' after number
	move.b	#'y',(a1)+		;add 'y' after number
	move.b	#' ',(a1)+		;add ' ' after number
	move.l	server_author_p(pc),a0	;a0 -> server name string
	moveq	#20,d2			;d2 = 20 char extra limit
	bsr.s	strcpy_to_al		;copy string into alert line at (a1)+
	bsr.s	pad_to_next		;pad spaces to (a1)+ through 28(a2)
	rts
;----------------------------------------------------------------------------
word2ascii:
	lea	dig_buff_end(pc),a0	;a0 -> end of digit buffer
	clr.b	-(a0)			;back pad buffer terminator
	and.l	#$FFFF,d0		;d0 = 16 bit dividend
.loop_1:
	divu	#10,d0			;d0 = remainder.quotient
	swap	d0			;d0 = quotient.remainder
	add	#'0',d0			;d0 = quotient.remainder_digit
	move.b	d0,-(a0)		;back pad digit into dig_buff
	clr	d0			;d0 = quotient.0
	swap	d0			;d0 = 0.quotient, as new dividend
	bne.s	.loop_1			;loop back until dividend zero
.loop_2:
	tst.b	(a0)			;a0 -> digit string terminator ?
	beq.s	.exit			;if so, exit
	move.b	(a0)+,(a1)+		;copy one digit char to dest string
	bne.s	.loop_2			;loop back for all digits (max 5)
.exit:
	rts
;----------------------------------------------------------------------------
strcpy_to_al:
	subq	#1,d2			;adjust extra char limit for dbra
	bmi.s	.exit			;if no chars allowed, exit
	pea	29(a2)			;push -> alert line limit
	move.l	(sp)+,d0		;pull d0 -> alert line limit
	cmp.l	d0,a1			;is a1 below the limit
	bhs.s	.exit			;if not, exit
.loop:
	tst.b	(a0)			;string terminator ?
	beq.s	.exit			;exit on terminator
	move.b	(a0)+,(a1)+		;copy one char
	cmp.l	d0,a1			;is a1 still below the limit ?
	dbhs	d2,.loop		;loop until either limit met
.exit:
	rts
;----------------------------------------------------------------------------
pad_to_next:
	moveq	#' ',d0			;d0 = space
	lea	29(a2),a0		;a0 -> alert line limit
	cmp.l	a0,a1			;is a1 below the limit ?
	bhs.s	.exit			;if not, exit
.loop:
	move.b	d0,(a1)+		;pad a space
	cmp.l	a0,a1			;is a1 still below the limit ?
	blo.s	.loop			;if so, loop back
.exit:
	rts
;----------------------------------------------------------------------------
	make	AV_links
	make	SIM_links
	make	JAR_links
;----------------------------------------------------------------------------
	SECTION	DATA
;----------------------------------------------------------------------------
must_be_GEM_al_s:
	dc.b	"[3]["
	dc.b	" STinG NetD master APP "
					M_VERSION
	dc.b				    " |"
	dc.b	"-----------------------------|"
	dc.b	"The NetD APP/ACC needs to use|"
	dc.b	"GEM. It won't work as TOS/TTP]"
	dc.b	"[ Abort ]",NUL
;
must_be_multi_al_s:
	dc.b	"[3]["
	dc.b	" STinG NetD master APP "
					M_VERSION
	dc.b				    " |"
	dc.b	"-----------------------------|"
	dc.b	"In singletasking TOS the NetD|"
	dc.b	"APP/ACC must run as ACCessory]"
	dc.b	"[ Abort ]",NUL
;
must_have_STX_al_s:
	dc.b	"[1]["
	dc.b	" STinG NetD master APP "
					M_VERSION
	dc.b				    " |"
	dc.b	"-----------------------------|"
	dc.b	"NetD cookie is absent meaning|"
	dc.b	"the NetD STX is not installed|"
	dc.b	"so NetD servers won't work...]"
	dc.b	"[ Ok ]",NUL
;
main_al_s:
	dc.b	"[0]["
	dc.b	" STinG NetD master APP "
					M_VERSION
	dc.b				    " |"
	dc.b	"-----------------------------|"
main_al_l3:
	dc.b	"NetD servers handled = "
main_al_srvcnt:
	dc.b			       "xxxxx |"
main_al_l4:
	dc.b	"#xxxxx=nnnnnnnnnnnnnnnnnnnnnn|"
main_al_l5:
	dc.b	"xx.yy by aaaaaaaaaaaaaaaaaaaa]"
	dc.b	"[ Ok | Next ]",NUL
;
none_s:
	dc.b	"none",NUL
no_ver_s:
	dc.b	"00.00",NUL
;-------
	EVEN
;----------------------------------------------------------------------------
	SECTION	BSS
;----------------------------------------------------------------------------
VA_START_f:		ds.w	1
VA_START_cmd_p:		ds.l	1
VA_protostatus:		ds.l	1
VA_arg_p:		ds.l	1
VA_arg_s:		ds.b	MAX_VA_ARGLEN
			EVEN
;-------
inited_f:		ds.w	1
NetD_STX_p:		ds.l	1
;-------
current_server_p:	ds.l	1
;-------
server_count:		ds.w	1
server_number:		ds.w	1
server_name_p:		ds.l	1
server_version_p:	ds.l	1
server_author_p:	ds.l	1
dig_buff_start:		ds.b	6
dig_buff_end:
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	NETD_APP.S
;----------------------------------------------------------------------------
