;----------------------------------------------------------------------------
;File name:	T_BATCLK.S			Revision date:	1998.03.09
;Creator:	Ulf Ronald Andersson		Creation date:	1997.08.01
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;Required header declarations:
;
	.include	"uran\STRUCT.SH"	;PASM adapted structures
	.include	"uran\URAn_SYS.SH"	;Main system definitions
	.include	"uran\URAn_LA.SH"	;Line A variables etc
	.include	"uran\URAn_DOS.SH"	;GEMDOS, BIOS, XBIOS
	.include	"uran\URAn_GEM.SH"	;VDI & AES
	.include	"uran\URAn_SIM.SH"	;some AES funcs for TOS/TTP
	.include	"uran\URAn_APP.SH"	;General application support
	.include	"uran\URAn_JAR.SH"	;Cookie jar handling
	.include	"uran\URAn_AV.SH"	;AV/VA protocol + MP protocol
;
	.include	"sting\LAYER.SH"	;only used by servers
	.include	"sting\TRANSPRT.SH"	;used by servers/clients
	.include	"sting\NET_TCON.SH"	;handles network time conv.
	.include	"sting\DOMAIN.SH"	;handles domain name/ip conv.
;
;----------------------------------------------------------------------------
;
DAY_TIME_PORT	equ	13
NET_TIME_PORT	equ	37
TOS_NORMAL	equ	0
BUF_SIZE	equ	500
;
;----------------------------------------------------------------------------
;
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
;;;exec_timeout		= 1000	;uncomment to enable timer in main eventloop
;;;exec_message		= 1	;uncomment for messages in main eventloop
;
;----------------------------------------------------------------------------
;
	.text
;
	start_app
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.data
	.endif
;
acc_name:
	dc.b	'  T_BatClk',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'T_BATCLK',NUL
	even
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.bss
	.endif
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	.text
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
;
	include		"uran\URAn_ARG.S"		;load ARGV handler
;
; Here URAn_ARG.S defines two variables
;
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;
;NB:	Both of the above include a dummy program name (first string==NUL).
;-------
	clr.l		VA_arg_p
	cmp		#2,arg_cnt
	blo		.done_arg
	move.l		arg_ptr,a0
	str_pass	a0
	move.l		a0,VA_arg_p
.done_arg:
;
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble		.error
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne		.error
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble		.error
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble		.error
	clr.l		initerr_mess_p
	rts
;
.error:
	lea		some_error_s(pc),a0
	move.l		a0,initerr_mess_p
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	move.l		initerr_mess_p,d3
	bne		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bsr		find_time_server
	bmi		exit_exec_err
	bsr		resolve_time_server
	bmi		exit_exec_err
	TCP_open	time_server_ip,#NET_TIME_PORT,#TOS_NORMAL,#BUF_SIZE
	move		d0,handle
	bmi		exit_exec_err
	move.l		#5000,d0	
	bsr		await_time_service
	move.l		d0,d3
	TCP_close	handle,#0
	move.l		d3,d0
	bgt		exit_exec_ok
exit_exec_err:		;jump here to exit with error code -1
	moveq		#-1,d0
	bra		exit_exec_app
;
;-------------------------------------
;
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
;
find_time_server:
	lea		tcon_data(pc),a0
	tcon_rd_zone
	tcon_rd_summer
;
	clr.l		time_server_ip
	move.l		VA_arg_p(pc),d0
	bsr		test_time_server
	bne		.exit
.try_TIME_SERVER_var:
	getvstr		TIME_SERVER_vn_s(pc)
	bsr		test_time_server
	bne		.exit
	moveq		#-1,d0
.exit:
	rts
;
;----------------------------------------------------------------------------
;
test_time_server:
	is_unblank.i	d0
	move.l		a0,time_server_s_p
	beq		.exit
	is_dip		(a0)
	move.l		a0,d0
	beq		.exit
	diptobip	(a0)
	move.l		d0,time_server_ip
.exit:
	move.l		time_server_s_p(pc),d0
	rts
;
;----------------------------------------------------------------------------
;
resolve_time_server:
	clr.l		d0
	tst.l		time_server_ip
	bne		.exit
	resolve.i	time_server_s_p(pc),#0,#time_server_ip,#1
.exit:
	tst.l		d0
	rts		
;
;----------------------------------------------------------------------------
;
await_time_service:
	move.l		d0,max_delay
	TIMER_now
	move.l		d0,start_time
;
.wait_loop:
	_appl_yield
	TIMER_elapsed	start_time
	cmp.l		max_delay(pc),d0
	bhs		.timed_out
	CNbyte_count(handle)
	cmp		#E_NODATA,d0
	beq		.wait_loop	;loop for E_NODATA
	tst		d0
	blt		.error		;break on errors
	cmp		#4,d0
	blt		.wait_loop	;loop if reception incomplete
;
	lea		tcon_data(pc),a3
	CNget_block	handle,tcon_net_time(a3),#4
	cmp		#4,d0
	blt		.error
	move.l		a3,a0
	tcon_net2man
	tcon_man2tos
	tcon_tos2real		;clock is set
	move		#4,d0	;flag full time received
	rts
;
.timed_out:
	clr.l		d0	;flag no time received
	rts
;
.error:
	moveq		#-1,d0	;flag error received
	rts
;
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
;
	make	SIM_links
	make	JAR_links
	make	TCON_links
	make	DOMAIN_links
	make	AV_links
;
;----------------------------------------------------------------------------
;
text_limit:	.data
;
;----------------------------------------------------------------------------
;
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
some_error_s:
	dc.b	' Error ! ',NUL
;
TIME_SERVER_vn_s:
	dc.b	'TIME_SERVER',NUL
;
;----------------------------------------------------------------------------
;
data_limit:	.bss
;
;----------------------------------------------------------------------------
;
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
VA_arg_p:	ds.l	1
		even
;
tcon_data:		ds.b	sizeof_tcon
time_server_s_p:	ds.l	1
time_server_ip:		ds.l	1
handle:			ds.w	1
send_time:		ds.l	1
start_time:		ds.l	1
max_delay:		ds.l	1
buffer:			ds.b	BUF_SIZE
;
;----------------------------------------------------------------------------
bss_limit:	.end
;----------------------------------------------------------------------------
;End of file:	T_BATCLK.S
;----------------------------------------------------------------------------
