;----------------------------------------------------------------------------
;File name:	T_SERVER.S			Revision date:	1998.03.09
;Creator:	Ulf Ronald Andersson		Creation date:	1997.07.31
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;Version:	1.04
;----------------------------------------------------------------------------
;Required header declarations:
;
	.include	"uran\STRUCT.SH"	;PASM adapted structures
	.include	"uran\URAn_SYS.SH"	;Main system definitions
	.include	"uran\URAn_LA.SH"	;Line A variables etc
	.include	"uran\URAn_DOS.SH"	;GEMDOS, BIOS, XBIOS
	.include	"uran\URAn_GEM.SH"	;VDI & AES
	.include	"uran\URAn_SIM.SH"	;some AES funcs for TOS/TTP
	.include	"uran\URAn_APP.SH"	;General application support
	.include	"uran\URAn_JAR.SH"	;Cookie jar handling
	.include	"uran\URAn_AV.SH"	;AV/VA protocol + MP protocol
;
	.include	"sting\LAYER.SH"	;only used by servers
	.include	"sting\TRANSPRT.SH"	;used by servers/clients
	.include	"sting\NET_TCON.SH"	;handles network time conv.
	.include	"sting\DOMAIN.SH"	;handles domain name/ip conv.
;
;----------------------------------------------------------------------------
;
ZERO_IP		equ	0
DAY_TIME_PORT	equ	13
NET_TIME_PORT	equ	37
TOS_NORMAL	equ	0
BUF_SIZE	equ	500
;
;----------------------------------------------------------------------------
;
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 100	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;
;----------------------------------------------------------------------------
;
	.text
;
	start_app
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.data
	.endif
;
acc_name:
	dc.b	'  Time server',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'T_SERVER',NUL
	even
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.bss
	.endif
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	.text
;
;----------------------------------------------------------------------------
;	Constants, Variables, and Usage of the URAn_APP.S library
;
;rz		'relative zero' for internal references
;basepage_p	-> program's base page
;tsr_size	.L size of BASEPAGE+TEXT+DATA+BSS  (only TOS/TTP may TSR)
;progtype	.L indicates program type:
;  ...			$0000.$FFFF == TOS/TTP/boot_PRG
;  ...			$0000.ap_id == APP/GTP/non_boot_PRG
;  ...			$FFFF.ap_id == ACC
;acc_flag	is the high word of 'progtype'
;tos_flag	is the low word of 'progtype'
;bootflag	.W $FFFF == PRG booted from AUTO (also sets 'tos_flag')
;menu_id	.W menu id for an ACC, otherwise null
;g_handle	.W workstation handle for ACC/APP/GTP/non_boot_PRG
;vwk_handle	.W virtual workstation handle
;contrl		12 words for AES/VDI control data
;
;wk_x_rez \
;wk_y_rez  \/ from
;wk_pix_w  /\ opnvwk
;wk_pix_h /
;
;MiNT_p		.L NULL or -> MiNT structure
;MagX_p		.L NULL or -> MagX structure
;nAES_p		.L NULL or -> nAES structure
;Gnva_p		.L NULL or -> Gnva structure
;
;line_a_base_p	.L -> line_a variable base
;kbshift_p	.L -> kbshift byte of OS
;currbp_p_p	.L -> OS var -> current basepage
;
;NB: if symbol 'huge_program' is defined, above data is in TEXT section (else in BSS)
;NB: defining 'huge_program' also makes function calls use 'jsr' (instead of bsr)
;
;Required user routines:
;
;init_app	called for ACC/APP/GTP/non_boot_PRG to init application,
;		but doesn't need appl_init, graf_handle, or v_opnvwk,
;		nor does an ACC need menu_register.
;		Suitable use is for initialization of object trees.
;NB:  for ACC	menu_register is called between init_app and exec_app
;
;exec_app	called to execute the main application regardless of type,
;		but doesn't need v_clsvwk, or appl_exit, or ACC appl_mesag.
;		This call will be repeated for a reactivated ACC.
;		Non_acc programs should have exit code in d0 at RTS.
;		(See details at 'Exit codes:' below)
;
;	At entry to either of these two routines:
;
;		d6.W	== bootflag	\
;		d7.L	== progtype	 > See descriptions above.
;		a6.L	== rz		/
;
;Optional user routines:
;
;exec_timer	Called for ACC that has a defined constant 'exec_timeout',
;		whenever evnt_multi produces such a timer event.
;		The constant is placed as long at 'main_timeout', and may
;		there be dynamically adjusted by the program.
;
;exec_mesag	Called for ACC that has a defined constant 'exec_message',
;		whenever evnt_multi/evnt_mesag produces messages that are
;		not AC_OPEN  (such as VA_START).
;
;		If the constant 'keep_windows' is also set, the workstation
;		will not be closed at each return (you must obey AC_CLOSE).
;		This places a word == $FF00 at 'keep_wind_f', and if the top
;		byte is cleared the workstation closure is enabled again.
;
;NB:	Top bit of the word 'revise_type_f' is used for 3 purposes:
;   1:	Let ACC start 'exec_app' directly without awaiting event.
;   2:	Let APP delay 'exec_app' until an event occurs.
;   3:	Let APP loop back for more events after 'exec_app'
;The flag must be set by 'init_app' in the first two cases, and in case 3
;should be set/cleared in 'exec_app' to decide whether to exit program.
;
;Exit codes:	At exit from exec_app, d0 has the following effects
;		when the program was not started as accessory.
;
; negative	=> Pterm(d0)			=> error code exit
; 0		=> Pterm(d0)			=> error free exit
; 0x0000ADD0	=> Ptermres(tsr_size,0)		=> error free resident exit
; 0x0000ADD1	=> Ptermres(d1,0)		=> error free resident exit
; 0x0000ADD2	=> Ptermres(d1,d2)		=> error code resident exit
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
;
	include		"uran\URAn_ARG.S"		;load ARGV handler
;
; Here URAn_ARG.S defines two variables
;
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;
;NB:	Both of the above include a dummy program name (first string==NUL).
;-------
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3				;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers		;sting_drivers -> DRV_LIST structure
	ble		.STiK_not_found
	move.l		d3,a3				;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'stx'
	ble		.layer_not_valid
	clr		fatal_f
;
	bsr		update_ports
	move		daytime_tcp_h,d3
	and		daytime_udp_h,d3
	and		nettime_tcp_h,d3
	and		nettime_udp_h,d3
	bmi		.no_ports_open
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s,a0
	bra		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s,a0
	bra		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s,a0
	bra		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
	bra		.init_error
;
.no_ports_open:
	lea		no_ports_open_al_s,a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	move.l		initerr_mess_p,d3
	beq		no_init_err
	move.l		d3,a3
	sim_aes		form_alert,#1,(a3)
	tst		fatal_f
	bne		exit_exec_err
no_init_err:
	tst.w		d7			;GEM/TOS program ?
	bmi		exec_TOS		;go show error message and exit for TOS program
exec_GEM:
	tst.l		d7			;APP/ACC program ?
	bmi		exec_multi_GEM
	cmp		#1,global+2		;Singletasking APP ?
	beq		exec_single_GEM		;then go show error message and exit program
exec_multi_APP:
	btst		#7,revise_type_f	;been here before ?
	bne		exec_multi_GEM		;then behave like an ACC this time
	tst.l		d3			;init_error ?
	bne		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bset		#7,revise_type_f	;tell main loop to behave like ACC
	bra		exit_exec_ok		;exit to main event loop
;
;-------------------------------------
;
exec_TOS:
	lea		must_be_GEM_al_s,a3
	bra		exec_APP_error
;
;-------------------------------------
;
exec_single_GEM:
	lea		must_be_multi_al_s,a3
exec_APP_error:
	sim_aes		form_alert,#1,(a3)
exit_exec_err:
	moveq		#-1,d0
exit_terminate:
	move.l		d0,d3
	bclr		#7,revise_type_f
	lea		daytime_tcp_h(pc),a3
	bsr		close_tcp_port
	lea		daytime_udp_h(pc),a3
	bsr		close_udp_port
	lea		nettime_tcp_h(pc),a3
	bsr		close_tcp_port
	lea		nettime_udp_h(pc),a3
	bsr		close_udp_port
	move.l		d3,d0
	bra		exit_exec_app
;
;-------------------------------------
;
exec_multi_GEM:
	bsr		update_ports
	gem_aes 	form_alert,#1,hello_there_al_s
	cmp		#1,d0	;OK button ?
	beq		exit_exec_ok
	cmp		#2,d0	;Time button
	bne		exit_exec_ok
	bsr		time_display_alert
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
;
	.ifne	exec_timeout	;cond:	ifne exec_timeout
exec_timer:
	lea	nettime_tcp_h(pc),a3
	tst	(a3)
	bmi	.done_net_TCP
	CNgetinfo	(a3)
	move.l	d0,a0
	tst.l	CIB_rhost(a0)
	beq	.done_net_TCP
	bsr	service_nettime_TCP
.done_net_TCP:
	lea	nettime_udp_h(pc),a3
	tst	(a3)
	bmi	.done_net_UDP
	CNgetinfo	(a3)
	move.l	d0,a0
	tst.l	CIB_rhost(a0)
	beq	.done_net_UDP
	bsr	service_nettime_UDP
.done_net_UDP:
	lea	daytime_tcp_h(pc),a3
	tst	(a3)
	bmi	.done_day_TCP
	CNgetinfo	(a3)
	move.l	d0,a0
	tst.l	CIB_rhost(a0)
	beq	.done_day_TCP
	bsr	service_daytime_TCP
.done_day_TCP:
	lea	daytime_udp_h(pc),a3
	tst	(a3)
	bmi	.done_day_UDP
	CNgetinfo	(a3)
	move.l	d0,a0
	tst.l	CIB_rhost(a0)
	beq	.done_day_UDP
	bsr	service_daytime_UDP
.done_day_UDP:
exit_exec_timer:
	rts
	.endif			;ends:	ifne exec_timeout
;
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
;
	.if	exec_message
exec_mesag:
	cmp		#AC_CLOSE,message
	bne		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
;Add ALL handling of the passed command line here, if you need to do some later
;you must copy it here, because the original may disappear after AV_STARTED.
;
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne		.not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
;
;Add client/server dependent message event work here
;
exit_exec_mesag:
	rts
	.endif
;
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
;
time_display_alert:
	lea		tcon_data(pc),a0	;a0 -> our tcon structure
.alert_loop:
	move.l		tcon_zoneseconds(a0),-(sp)
	move.l		tcon_summer(a0),-(sp)
	tcon_real2tos				;get realtime in TOS form
	tcon_tos2man				;convert to human form
	tcon_man2net
	tst		GMT_f			;GMT or Local time ?
	beq		.keep_zone
	clr.l		tcon_zoneseconds(a0)	;enforce GMT
	clr.l		tcon_summer(a0)		;suppress daylight savings
.keep_zone:
	tcon_net2man
	lea		buffer(pc),a1		;prep for date string conv
	bsr		man2alert		;convert to alert  d0 = len
	gem_aes		form_alert,#1,(a1)
	lea		tcon_data(pc),a0
	move.l		(sp)+,tcon_summer(a0)
	move.l		(sp)+,tcon_zoneseconds(a0)
	cmp		#2,d0			;GMT/LOCAL button ?
	bne		.exit
	eor		#$FF,GMT_f
	bra		.alert_loop
;	
.exit:
	clr		GMT_f
	rts
;
;----------------------------------------------------------------------------
;
update_ports:
	movem.l		d0/d3/a0/a3-a4,-(sp)
	lea		tcon_data(pc),a0
	tcon_rd_zone
	tcon_rd_summer
;
	moveq		#DAY_TIME_PORT,d3
	lea		daytime_tcp_h(pc),a3
	lea		day_tcp_s(pc),a4
	bsr		update_tcp_port
	lea		daytime_udp_h(pc),a3
	lea		day_udp_s(pc),a4
	bsr		update_udp_port
	moveq		#NET_TIME_PORT,d3
	lea		nettime_tcp_h(pc),a3
	lea		net_tcp_s(pc),a4
	bsr		update_tcp_port
	lea		nettime_udp_h(pc),a3
	lea		net_udp_s(pc),a4
	bsr		update_udp_port
	movem.l		(sp)+,d0/d3/a0/a3-a4
	rts
;
;----------------------------------------------------------------------------
;
update_tcp_port:
	movem.l		d0-d2/a0-a2/a5,-(sp)
	lea		three2upper(pc),a5
	tst		(a3)
	bpl		.port_ok
	TCP_open	#ZERO_IP,d3,#TOS_NORMAL,#BUF_SIZE
	move		d0,(a3)
	bpl		.port_ok
	lea		three2lower(pc),a5
.port_ok:
	jsr		(a5)
	movem.l		(sp)+,d0-d2/a0-a2/a5
	rts
;
;----------------------------------------------------------------------------
;
update_udp_port:
	movem.l		d0-d2/a0-a2/a5,-(sp)
	lea		three2upper(pc),a5
	tst		(a3)
	bpl		.port_ok
	UDP_open	#ZERO_IP,d3
	move		d0,(a3)
	bpl		.port_ok
	lea		three2lower(pc),a5
.port_ok:
	jsr		(a5)
	movem.l		(sp)+,d0-d2/a0-a2/a5
	rts
;
;----------------------------------------------------------------------------
;
close_tcp_port:
	tst		(a3)
	bmi		.done_port
	TCP_close	(a3),#1
	st		(a3)
.done_port:
	rts
;
;----------------------------------------------------------------------------
;
close_udp_port:
	tst		(a3)
	bmi		.done_port
	UDP_close	(a3)
	st		(a3)
.done_port:
	rts
;
;----------------------------------------------------------------------------
;
three2lower:
	or.b	#$20,(a4)+
	or.b	#$20,(a4)+
	or.b	#$20,(a4)+
	rts
;
;----------------------------------------------------------------------------
;
three2upper:
	and.b	#$5F,(a4)+
	and.b	#$5F,(a4)+
	and.b	#$5F,(a4)+
	rts
;
;----------------------------------------------------------------------------
;
service_nettime_TCP:				;(a3) = TCP_handle
	lea		tcon_data(pc),a0	;a0 -> our tcon structure
	tcon_real2tos				;get realtime in TOS form
	tcon_tos2man				;convert to human form
	tcon_man2net				;convert to network form
	TCP_send	(a3),tcon_net_time(a0),#4
	TCP_ack_wait	(a3),#3000
	bsr		close_tcp_port
	bsr		update_ports
	rts	
;
;----------------------------------------------------------------------------
;
service_daytime_TCP:				;(a3) = TCP_handle
	lea		tcon_data(pc),a0	;a0 -> our tcon structure
	bsr		real2daytime
	lea		buffer(pc),a1		;prep for date string conv
	bsr		man2ascii		;convert to string  d0 = len
	TCP_send	(a3),(a1),d0
	TCP_ack_wait	(a3),#3000
	bsr		close_tcp_port
	bsr		update_ports
	rts	
;
;----------------------------------------------------------------------------
;
real2daytime:
	tcon_real2tos			;get realtime in TOS form
	tcon_tos2man			;convert to human form
	tcon_man2net			;\/ Dummy conversion is needed
	tcon_net2man			;/\ to get the weekday correct
	rts
;
;----------------------------------------------------------------------------
;
service_daytime_UDP:				;(a3) = UDP_handle
	lea		tcon_data(pc),a0	;a0 -> our tcon structure
	bsr		real2daytime
	lea		buffer(pc),a1		;prep for date string conv
	bsr		man2ascii		;convert to string  d0 = len
	UDP_send	(a3),(a1),d0
	bsr		close_udp_port
	bsr		update_ports
	rts	
;
;----------------------------------------------------------------------------
;
service_nettime_UDP:				;(a3) = UDP_handle
	lea		tcon_data(pc),a0	;a0 -> our tcon structure
	tcon_real2tos				;get realtime in TOS form
	tcon_tos2man				;convert to human form
	tcon_man2net				;convert to network form
	UDP_send	(a3),tcon_net_time(a0),#4
	bsr		close_udp_port
	bsr		update_ports
	rts	
;
;End of service_nettime_UDP
;----------------------------------------------------------------------------
;
man2ascii:
	movem.l		d1/a1-a2,-(sp)
	move		tcon_man_weekday(a0),d0	;d0 = weekday index (0==Sunday)
	and		#7,d0			;limit index
	asl		#2,d0			;scale to index pointer table
	lea		weekday_spt(pc),a2	;a2 -> table of string pointers
	move.l		(a2,d0.w),a2		;a2 -> weekday string
	str_copy	a2,a1
	move.b		#' ',-1(a1)
	move.b		#' ',(a1)+
	move		tcon_man_year(a0),d0
	bsr		word2ascii4
	move.b		#'.',(a1)+
	move		tcon_man_month(a0),d0
	bsr		word2ascii2
	move.b		#'.',(a1)+
	move		tcon_man_date(a0),d0
	bsr		word2ascii2
	move.b		#' ',(a1)+
	move.b		#' ',(a1)+
	move		tcon_man_hour(a0),d0
	bsr		word2ascii2
	move.b		#':',(a1)+
	move		tcon_man_minute(a0),d0
	bsr		word2ascii2
	move.b		#':',(a1)+
	move		tcon_man_second(a0),d0
	bsr		word2ascii2
	lea		GMT_tail_s(pc),a2
	str_copy	a2,a1
	subq		#1,a1
	move.b		#'+',(a1)+
	tcon_is_summer
	and.l		#3600,d0
	add.l		tcon_zoneseconds(a0),d0
	bpl		.keep_sign
	move.b		#'-',-1(a0)
	neg.l		d0
.keep_sign:
	divu		#3600,d0
	move.l		d0,d1
	bsr		word2ascii2
	move.b		#':',(a1)+
	swap		d1
	clr.l		d0
	move		d1,d0
	divu		#60,d0
	bsr		word2ascii2
	move.b		#CR,(a1)+
	move.b		#LF,(a1)+
	clr.b		(a1)+
	move.l		a1,d0
	movem.l		(sp)+,d1/a1-a2
	sub.l		a1,d0	;d0 = resulting string length, incl terminator
	rts
;
;End of man2ascii
;----------------------------------------------------------------------------
;
man2alert:
	movem.l		a1-a2,-(sp)
	move.b		#'[',(a1)+
	move.b		#'0',(a1)+
	move.b		#']',(a1)+
	move.b		#'[',(a1)+
	move.b		#'|',(a1)+
	move.b		#' ',(a1)+
	move		tcon_man_weekday(a0),d0	;d0 = weekday index (0==Sunday)
	and		#7,d0			;limit index
	asl		#2,d0			;scale to index pointer table
	lea		weekday_spt(pc),a2	;a2 -> table of string pointers
	move.l		(a2,d0.w),a2		;a2 -> weekday string
	str_copy	a2,a1
	subq		#1,a1
	move.b		#'|',(a1)+
	move.b		#' ',(a1)+
	move		tcon_man_year(a0),d0
	bsr		word2ascii4
	move.b		#'.',(a1)+
	move		tcon_man_month(a0),d0
	bsr		word2ascii2
	move.b		#'.',(a1)+
	move		tcon_man_date(a0),d0
	bsr		word2ascii2
	move.b		#' ',(a1)+
	move.b		#'|',(a1)+
	move.b		#' ',(a1)+
	move		tcon_man_hour(a0),d0
	bsr		word2ascii2
	move.b		#':',(a1)+
	move		tcon_man_minute(a0),d0
	bsr		word2ascii2
	move.b		#':',(a1)+
	move		tcon_man_second(a0),d0
	bsr		word2ascii2
	lea		Local_s(pc),a2
	tst		GMT_f
	beq		.keep_type_1
	lea		GMT_s(pc),a2
.keep_type_1:
	str_copy	a2,a1
	subq		#1,a1
	move.b		#'|',(a1)+
	move.b		#']',(a1)+
	move.b		#'[',(a1)+
	move.b		#' ',(a1)+
	move.b		#'O',(a1)+
	move.b		#'k',(a1)+
	move.b		#' ',(a1)+
	move.b		#'|',(a1)+
	lea		Local_s(pc),a2
	tst		GMT_f
	bne		.keep_type_2
	lea		GMT_s(pc),a2
.keep_type_2:
	str_copy	a2,a1
	subq		#1,a1
	move.b		#']',(a1)+
	move.b		#NUL,(a1)+
	move.l		a1,d0
	movem.l		(sp)+,a1-a2
	sub.l		a1,d0	;d0 = resulting string length, incl terminator
	rts
;
;End of man2alert
;----------------------------------------------------------------------------
;
word2ascii4:
	and.l	#1<<16-1,d0
	divu	#1000,d0
	add	#'0',d0
	move.b	d0,(a1)+
	clr	d0
	swap	d0
	divu	#100,d0
	add	#'0',d0
	move.b	d0,(a1)+
	clr	d0
	swap	d0
word2ascii2:
	and.l	#1<<7-1,d0
	divu	#10,d0
	add	#'0',d0
	move.b	d0,(a1)+
	swap	d0
	add	#'0',d0
	move.b	d0,(a1)+
	rts
;
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
;
	make	SIM_links
	make	JAR_links
	make	TCON_links
	make	DOMAIN_links
	make	AV_links
;
;----------------------------------------------------------------------------
;
text_limit:	.data
;
;----------------------------------------------------------------------------
;
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
	even
;
;
;Enter program constant definitions below:
;
daytime_tcp_h:	dc.w	-1
daytime_udp_h:	dc.w	-1
nettime_tcp_h:	dc.w	-1
nettime_udp_h:	dc.w	-1
GMT_f:		dc.w	0
;
weekday_spt:
	dc.l	sunday_s,monday_s,tuesday_s,wednesday_s
	dc.l	thursday_s,friday_s,saturday_s,sunday_s
;
sunday_s:	dc.b	'Sunday',NUL
monday_s:	dc.b	'Monday',NUL
tuesday_s:	dc.b	'Tuesday',NUL
wednesday_s:	dc.b	'Wednesday',NUL
thursday_s:	dc.b	'Thursday',NUL
friday_s:	dc.b	'Friday',NUL
saturday_s:	dc.b	'Saturday',NUL
;
GMT_s:		dc.b	'  GMT  ',NUL
Local_s:	dc.b	' Local ',NUL
GMT_tail_s:	dc.b	'  GMT',NUL
;
hello_there_al_s:
	dc.b	'[0]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'Active ports in upper case:  |'
	dc.b	'Day time port 13:  '
day_udp_s:
	dc.b	                   'UDP  '
day_tcp_s:
	dc.b	                        'TCP  |'
	dc.b	'Net time port 37:  '
net_udp_s:
	dc.b	                   'UDP  '
net_tcp_s:
	dc.b	                        'TCP  ]'
	dc.b	'[ Ok | Time ]',NUL
;
no_ports_open_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'Attempts to open port failed,|'
	dc.b	'both for UDP and TCP !]'
	dc.b	'[ Abort ]',NUL
;
must_be_GEM_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'T_SERVER needs to use GEM, so|'
	dc.b	'TOS/TTP use does not work.]'
	dc.b	'[ Abort ]',NUL
;
must_be_multi_al_s:
	dc.b	'[3]['
	dc.b	'STinG Timeserver Version 1.04|'
	dc.b	'-----------------------------|'
	dc.b	'In singletasking TOS T_SERVER|'
	dc.b	'can only run as an ACCessory!]'
	dc.b	'[ Abort ]',NUL
;
	even
;
;----------------------------------------------------------------------------
;
data_limit:	.bss
;
;----------------------------------------------------------------------------
;Enter program variable definitions below:
;
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
;
tcon_data:	ds.b	sizeof_tcon
buffer:		ds.l	BUF_SIZE
;
;----------------------------------------------------------------------------
bss_limit:	.end
;----------------------------------------------------------------------------
;End of file:	T_SERVER.S
;----------------------------------------------------------------------------
