;----------------------------------------------------------------------------
;File name:	T_SETCLK.S			Revision date:	1998.03.09
;Creator:	Ulf Ronald Andersson		Creation date:	1997.08.01
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;Required header declarations:
;
	.include	"uran\STRUCT.SH"	;PASM adapted structures
	.include	"uran\URAn_SYS.SH"	;Main system definitions
	.include	"uran\URAn_LA.SH"	;Line A variables etc
	.include	"uran\URAn_DOS.SH"	;GEMDOS, BIOS, XBIOS
	.include	"uran\URAn_GEM.SH"	;VDI & AES
	.include	"uran\URAn_SIM.SH"	;some AES funcs for TOS/TTP
	.include	"uran\URAn_APP.SH"	;General application support
	.include	"uran\URAn_JAR.SH"	;Cookie jar handling
	.include	"uran\URAn_AV.SH"	;AV/VA protocol + MP protocol
;
	.include	"sting\LAYER.SH"	;only used by servers
	.include	"sting\TRANSPRT.SH"	;used by servers/clients
	.include	"sting\NET_TCON.SH"	;handles network time conv.
	.include	"sting\DOMAIN.SH"	;handles domain name/ip conv.
;
;----------------------------------------------------------------------------
;
DAY_TIME_PORT	equ	13
NET_TIME_PORT	equ	37
TOS_NORMAL	equ	0
BUF_SIZE	equ	500
MAX_VA_ARGLEN	equ	512
;
;----------------------------------------------------------------------------
;
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 1000	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;
;----------------------------------------------------------------------------
;
	.text
;
	start_app
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.data
	.endif
;
acc_name:
	dc.b	'  T_SetClk',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'T_SETCLK',NUL
	even
;
;----------------------------------------------------------------------------
;
	.ifeq	huge_program
	.bss
	.endif
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	.text
;
;----------------------------------------------------------------------------
;	Constants, Variables, and Usage of the URAn_APP.S library
;
;rz		'relative zero' for internal references
;basepage_p	-> program's base page
;tsr_size	.L size of BASEPAGE+TEXT+DATA+BSS  (only TOS/TTP may TSR)
;progtype	.L indicates program type:
;  ...			$0000.$FFFF == TOS/TTP/boot_PRG
;  ...			$0000.ap_id == APP/GTP/non_boot_PRG
;  ...			$FFFF.ap_id == ACC
;acc_flag	is the high word of 'progtype'
;tos_flag	is the low word of 'progtype'
;bootflag	.W $FFFF == PRG booted from AUTO (also sets 'tos_flag')
;menu_id	.W menu id for an ACC, otherwise null
;g_handle	.W workstation handle for ACC/APP/GTP/non_boot_PRG
;vwk_handle	.W virtual workstation handle
;contrl		12 words for AES/VDI control data
;
;wk_x_rez \
;wk_y_rez  \/ from
;wk_pix_w  /\ opnvwk
;wk_pix_h /
;
;MiNT_p		.L NULL or -> MiNT structure
;MagX_p		.L NULL or -> MagX structure
;nAES_p		.L NULL or -> nAES structure
;Gnva_p		.L NULL or -> Gnva structure
;
;line_a_base_p	.L -> line_a variable base
;kbshift_p	.L -> kbshift byte of OS
;currbp_p_p	.L -> OS var -> current basepage
;
;NB: if symbol 'huge_program' is defined, above data is in TEXT section (else in BSS)
;NB: defining 'huge_program' also makes function calls use 'jsr' (instead of bsr)
;
;Required user routines:
;
;init_app	called for ACC/APP/GTP/non_boot_PRG to init application,
;		but doesn't need appl_init, graf_handle, or v_opnvwk,
;		nor does an ACC need menu_register.
;		Suitable use is for initialization of object trees.
;NB:  for ACC	menu_register is called between init_app and exec_app
;
;exec_app	called to execute the main application regardless of type,
;		but doesn't need v_clsvwk, or appl_exit, or ACC appl_mesag.
;		This call will be repeated for a reactivated ACC.
;		Non_acc programs should have exit code in d0 at RTS.
;		(See details at 'Exit codes:' below)
;
;	At entry to either of these two routines:
;
;		d6.W	== bootflag	\
;		d7.L	== progtype	 > See descriptions above.
;		a6.L	== rz		/
;
;Optional user routines:
;
;exec_timer	Called for ACC that has a defined constant 'exec_timeout',
;		whenever evnt_multi produces such a timer event.
;		The constant is placed as long at 'main_timeout', and may
;		there be dynamically adjusted by the program.
;
;exec_mesag	Called for ACC that has a defined constant 'exec_message',
;		whenever evnt_multi/evnt_mesag produces messages that are
;		not AC_OPEN  (such as VA_START).
;
;		If the constant 'keep_windows' is also set, the workstation
;		will not be closed at each return (you must obey AC_CLOSE).
;		This places a word == $FF00 at 'keep_wind_f', and if the top
;		byte is cleared the workstation closure is enabled again.
;
;NB:	Top bit of the word 'revise_type_f' is used for 3 purposes:
;   1:	Let ACC start 'exec_app' directly without awaiting event.
;   2:	Let APP delay 'exec_app' until an event occurs.
;   3:	Let APP loop back for more events after 'exec_app'
;The flag must be set by 'init_app' in the first two cases, and in case 3
;should be set/cleared in 'exec_app' to decide whether to exit program.
;
;Exit codes:	At exit from exec_app, d0 has the following effects
;		when the program was not started as accessory.
;
; negative	=> Pterm(d0)			=> error code exit
; 0		=> Pterm(d0)			=> error free exit
; 0x0000ADD0	=> Ptermres(tsr_size,0)		=> error free resident exit
; 0x0000ADD1	=> Ptermres(d1,0)		=> error free resident exit
; 0x0000ADD2	=> Ptermres(d1,d2)		=> error code resident exit
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
;
	include		"uran\URAn_ARG.S"		;load ARGV handler
;
; Here URAn_ARG.S defines two variables
;
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;
;NB:	Both of the above include a dummy program name (first string==NUL).
;-------
	clr.l		VA_arg_p
	cmp		#2,arg_cnt
	blo		.done_arg
	move.l		arg_ptr,a0
	str_pass	a0
	move.l		a0,VA_arg_p
.done_arg:
;
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble		.STiK_not_found
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble		.layer_not_valid
	clr		fatal_f
;
;Add client/server dependent init here
;
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s(pc),a0
	bra		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s(pc),a0
	bra		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s(pc),a0
	bra		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	move.l		initerr_mess_p,d3
	beq		no_init_err
	move.l		d3,a3
	sim_aes		form_alert,#1,(a3)
	tst		fatal_f
	bne		exit_exec_err
no_init_err:
	tst.w		d7			;GEM/TOS program ?
	bmi		exec_TOS		;go run TOS/TTP routines
exec_GEM:
	tst.l		d7			;APP/ACC program ?
	bmi		exec_multi_GEM		;go run ACC routines
	cmp		#1,global+2		;Singletasking APP ?
	beq		exec_single_GEM		;go run singletasking GEM code
exec_multi_APP:
	btst		#7,revise_type_f	;been here before ?
	bne		exec_multi_GEM		;then behave like an ACC this time
	tst.l		d3			;init_error ?
	bne		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bset		#7,revise_type_f	;tell main loop to behave like ACC
	cmp		#1,arg_cnt		;any arguments for this APP
	bgt		exec_multi_GEM		;then start directly
	bra		exit_exec_ok		;exit to main event loop
;
;-------------------------------------
;
exec_TOS:
exec_single_GEM:
	bsr		close_channel
	bsr		find_time_server
	bmi		exit_exec_ok
	bsr		ask_protocol
	bmi		exit_exec_ok
	bsr		resolve_time_server
	bmi		resolve_error
	bsr		send_request
	bmi		send_error
	move.l		#5000,d0	
	bsr		await_time_service
	move.l		d0,d3
	bsr		close_channel
	move.l		d3,d0
	bmi		wait_error
	beq		timeout_error
	bra		exit_exec_ok
;
exec_multi_GEM:
	bsr		close_channel
	bsr		find_time_server
	bmi		exit_exec_ok
	bsr		ask_protocol
	bmi		exit_exec_ok
	move.l		#10000,main_timeout
new_request:
	bsr		resolve_time_server
	bpl		have_server_ip
resolve_error:
	sim_aes		form_alert,#1,unresolved_al_s(pc)
	bra		exit_exec_ok
;
have_server_ip:
	bsr		send_request
	bpl		request_sent
send_error:
	bsr		close_channel
	sim_aes		form_alert,#1,send_error_al_s(pc)
	bra		exit_exec_ok
;
request_sent:
	TIMER_now
	move.l		d0,send_time
	move.l		#100,main_timeout
	bra		exit_exec_ok
;
;-------------------------------------
;
;
exec_APP_error:		;jump here to display alert (a3) and then exit
	sim_aes		form_alert,#1,(a3)	;NB: has simulation for TOS/TTP
exit_exec_err:		;jump here to exit with error code -1
	moveq		#-1,d0
exit_terminate:		;jump here to exit with error code in d0
	move.l		d0,d3
	bclr		#7,revise_type_f
;
;Add client/server dependent termination code here
;
	move.l		d3,d0
	bra		exit_exec_app
;
;-------------------------------------
;
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
;
	.ifne	exec_timeout	;cond:	ifne exec_timeout
exec_timer:
	tst	handle
	ble	exit_exec_timer
	TIMER_elapsed	send_time
	cmp.l		#10000,d0
	blo		not_timed_out
	bsr		close_channel
	move.l		#10000,main_timeout
timeout_error:
	sim_aes		form_alert,#1,timeout_al_s(pc)
	cmp		#1,d0	;[ Ok ] button
	beq		exec_app
	bra		exit_exec_timer
;
not_timed_out:
	move.l		#10,d0	
	bsr		await_time_service
	beq		exit_exec_timer		;continue waiting
	move		d0,d3
	move.l		#10000,main_timeout
	tst		d3
	bpl		exit_exec_timer
wait_error:
	sim_aes		form_alert,#1,wait_error_al_s(pc)
exit_exec_timer:
	clr.l		d0
	rts
	.endif			;ends:	ifne exec_timeout
;
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
;
	.ifne		exec_message
exec_mesag:
	cmp		#AC_CLOSE,message
	bne		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
	move.l		VA_START_cmd_p(pc),a0	;a0 -> argument on Venus
	move.l		a0,a1			;a1 -> argument on Venus
	str_pass	a1
	sub.l		VA_START_cmd_p(pc),a1
	move.l		a1,d1			;d1 = length of argument
	move		#MAX_VA_ARGLEN,d0
	cmp.l		d0,d1			;argument too long ?
	blo		.length_ok
	move.l		d0,d1			;limit argument length
.length_ok:
	move.b		-1(a0,d1.w),d0		;save byte at termination point
	clr.b		-1(a0,d1.w)		;enforce limited termination
	move.l		a0,a1			;a1 -> argument on Venus
	lea		VA_arg_s(pc),a2		;a2 -> local argument area
	move.l		a2,VA_arg_p		;prep a pointer for future
	str_copy	a1,a2			;make a local copy of argument
	move.b		d0,-1(a0,d1.w)		;repair original copy
;
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne		.not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
;
;Add client/server dependent message event work here
;
exit_exec_mesag:
	rts
	.endif		exec_message
;
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
;
ask_protocol:
	sim_aes		form_alert,#1,ask_protocol_al_s(pc)
	cmp		#2,d0		;UDP button ?
	slo		TCP_f
	bhi		.cancel
	clr.l		d0		;flag zero for TCP/UDP buttons
	rts
;
.cancel:
	moveq		#-1,d0		;flac -1 for Cancel button
	rts
;
;----------------------------------------------------------------------------
;
find_time_server:
	lea		tcon_data(pc),a0
	tcon_rd_zone
	tcon_rd_summer
;
	clr.l		time_server_ip
	move.l		VA_arg_p(pc),d0
	bsr		test_time_server
	bne		.exit
.try_TIME_SERVER_var:
	getvstr		TIME_SERVER_vn_s(pc)
	bsr		test_time_server
	bne		.exit
	sim_aes		form_alert,#1,time_server_not_valid_al_s(pc)
	clr.l		d0
.exit:
	rts
;
;----------------------------------------------------------------------------
;
test_time_server:
	is_unblank.i	d0
	move.l		a0,time_server_s_p
	beq		.exit
	is_dip		(a0)
	move.l		a0,d0
	beq		.exit
	diptobip	(a0)
	move.l		d0,time_server_ip
.exit:
	move.l		time_server_s_p(pc),d0
	rts
;
;----------------------------------------------------------------------------
;
resolve_time_server:
	clr.l		d0
	tst.l		time_server_ip
	bne		.exit
	resolve.i	time_server_s_p(pc),#0,#time_server_ip,#1
.exit:
	tst.l		d0
	rts		
;
;----------------------------------------------------------------------------
;
close_channel:
	tst		handle
	ble		.exit
	tst		TCP_f
	beq		.close_udp
.close_tcp:
	TCP_close	handle,#1
	bra		.exit
;
.close_udp:
	UDP_close	handle
.exit:
	clr.l		handle
	rts
;
;----------------------------------------------------------------------------
;
send_request:
	tst		TCP_f
	beq		.send_UDP
	TCP_open	time_server_ip,#NET_TIME_PORT,#TOS_NORMAL,#BUF_SIZE
	move		d0,handle
	bra		.exit
;
.send_UDP:
	UDP_open	time_server_ip,#NET_TIME_PORT
	move		d0,handle
	bmi		.exit
	clr.l		buffer
	UDP_send	d0,buffer(pc),#0	;send empty datagram
	clr.l		d0
.exit:
	rts
;
;----------------------------------------------------------------------------
;
await_time_service:
	move.l		d0,max_delay
	TIMER_now
	move.l		d0,start_time
;
.wait_loop:
	_appl_yield
	TIMER_elapsed	start_time
	cmp.l		max_delay(pc),d0
	bhs		.timed_out
	CNbyte_count(handle)
	cmp		#E_NODATA,d0
	beq		.wait_loop	;loop on E_NODATA
	tst		d0
	bmi		.error		;break on errors
	cmp		#4,d0
	blt		.wait_loop	;loop on incomplete reception
;
	lea		tcon_data(pc),a3
	CNget_block	handle,tcon_net_time(a3),#4
	cmp		#4,d0
	blt		.error
	move.l		a3,a0
	tcon_net2man
	tcon_man2tos
	tcon_tos2real		;clock is set
	bsr		close_channel
	move		#4,d0	;flag full time received
	rts
;
.timed_out:
	clr.l		d0	;flag no time received
	rts
;
.error:
	bsr		close_channel
	moveq		#-1,d0	;flag error received
	rts
;
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
;
	make	SIM_links
	make	JAR_links
	make	TCON_links
	make	DOMAIN_links
	make	AV_links
;
;----------------------------------------------------------------------------
;
text_limit:	.data
;
;----------------------------------------------------------------------------
;
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
	even
;
;
TIME_SERVER_vn_s:
	dc.b	'TIME_SERVER',NUL
;
time_server_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TIME_SERVER must be specified|'
	dc.b	'in argument or STinG variable|'
	dc.b	'(use domain or dotted IP num)]'
	dc.b	'[ Abort ]',NUL
;
unresolved_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TIME_SERVER address could not|'
	dc.b	'be resolved at this time. It |'
	dc.b	'may be error in DEFAULT.CFG !]'
	dc.b	'[ Abort ]',NUL
;
send_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred attempting |'
	dc.b	'to send a request to the time|'
	dc.b	'server !]'
	dc.b	'[ Abort ]',NUL
;
wait_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred in awaiting|'
	dc.b	'a reply from the time server.]'
	dc.b	'[ Abort ]',NUL
;
ask_protocol_al_s:
	dc.b	'[2]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'Which protocol do you want to|'
	dc.b	'use on this server request ? ]'
	dc.b	'[ TCP | UDP | Cancel ]',NUL
;
timeout_al_s:
	dc.b	'[2]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'Time server does not answer !|'
	dc.b	'Click  Ok to make yet another|'
	dc.b	'attempt to contact it.]'
	dc.b	'[ Ok | Cancel ]',NUL
;
;----------------------------------------------------------------------------
;
data_limit:	.bss
;
;----------------------------------------------------------------------------
;
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
VA_arg_p:	ds.l	1
VA_arg_s:	ds.b	MAX_VA_ARGLEN
		even
;
tcon_data:		ds.b	sizeof_tcon
time_server_s_p:	ds.l	1
time_server_ip:		ds.l	1
TCP_f:			ds.w	1
handle:			ds.w	1
send_time:		ds.l	1
start_time:		ds.l	1
max_delay:		ds.l	1
buffer:			ds.b	BUF_SIZE
;
;----------------------------------------------------------------------------
bss_limit:	.end
;----------------------------------------------------------------------------
;End of file:	T_SETCLK.S
;----------------------------------------------------------------------------
