/*------------------------------------------------
//
// Module: daycli.c
//
// Objet : Dmonstration de client Daytime/TCP avec la librairie inet.lib
//
// ToDo  : 
//
//
//
// Maintenance :
//
//		 Auteur  : Olivier Booklage
//		 Version : V1.0
//		 Date 	 : 12/05/1999
//		 Remarq. : tab 2
//
//
//
//-----------------------------------------------*/

#define USE_INTERNAL_SERVER

/* ---			 Includes externes			 -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<tos.h>
#include	<time.h>
#include	<portab.h>
#include	<string.h>
#include	<sting\inet.h>

/* ---			 Includes internes			 -- */

/* --- Constantes globales internes --- */

#define CLIENT_BUFSIZE			127
#define TCP_DAYTIME_PORT		13
#define	TIMEOUT							30

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

LOCAL	UBYTE server_name[51];
LOCAL UBYTE buffer[CLIENT_BUFSIZE];
LOCAL BOOLEAN wait_server = FALSE;

/* ---		 Prototypage interne			--- */

WORD	main(VOID);
VOID	OpenConnection( UBYTE *host );
INT		reponse( INT handle, INT action );

/* ---				 Fonctions						--- */

WORD main(VOID)
{
INT ret;
WORD key = 0;
UBYTE *ptr;
clock_t	call_time = 0;

	ret = Inet_Init( INET_SYSTEM_TOS );
	
	if ( (ret != NETWORK_OK) && (ret != NETWORK_STIK_OK) )
	{
		printf("\a%s\n",Inet_Err(ret));
		return(-1);
	}

	printf("Welcome to TCP DayTime client\n\n");

#ifdef USE_INTERNAL_SERVER 

	ptr = "127.0.0.1";
	
#else

	ptr=getvstr("TIME_SERVER");
	if ( ptr[1] == '\0' && (ptr[0] == '0' || ptr[0] == '1') )
	{
		printf("No TIME_SERVER defined in DEFAULT.CFG !\n");
		return(-1);
	}

#endif

	*server_name='\0';
	strncpy( server_name, ptr, 50);

	while ( Cconis() !=0 )	Crawcin();

	do
	{
		if ( clock() > call_time )
		{
			OpenConnection(server_name);
			call_time = clock()+660*CLK_TCK;	/* 10 sec */
		}
		Inet_Loop();
		if ( Cconis() !=0 )	key=(int)Crawcin()&0xFF;
	}
	while ( key != 27 );

	while ( Cconis() !=0 )	Crawcin();

	Inet_Terminate();

return(0);
}


VOID OpenConnection( UBYTE *host )
{
INT ret;

	if ( wait_server == TRUE )	return;
	ret =  Inet_Open( host , INET_TCP, TCP_DAYTIME_PORT, CLIENT_BUFSIZE, reponse, TIMEOUT );
	if ( ret < 0 )
		printf("Error   : %s %s\n", host, Inet_Err(ret) );
	else
	{
		printf("<%04d>  : Request %s\n", ret, host);
		wait_server = TRUE;
	}
}


INT reponse( INT handle, INT action )
{
INT len;
UBYTE *c;

	switch( action )
	{
		case INET_DATA :
			len = Inet_ReadData( handle, (VOID *)buffer , CLIENT_BUFSIZE);
			if ( len > 0 )
			{
				buffer[len]='\0';

				/* limine les autres \r\n */

				c = strchr( buffer, '\r');
				if ( c != NULL )	*c = '\0';

				c = strchr( buffer, '\n');
				if ( c != NULL )	*c = '\0';

				fprintf( stdout,"<%04d>  : <%s>\n", handle, buffer);
				wait_server = FALSE;
				return(INET_STATUS_CONTINUE);	/* Le serveur va refermer */
			}
		break;

		default :
			if( action != INET_TIMER )
			{
				if ( action < 0 )
				{
					fprintf( stdout,"<%04d> ?: %s datas <%d>\n", handle, Inet_Err(action), Inet_CountData(handle) );
					wait_server = FALSE;
				}
				else
					fprintf( stdout,"<%04d>  : %s datas <%d>\n", handle, Inet_Err(action) , Inet_CountData(handle));
			}
			break;
	}
	
return(INET_STATUS_CONTINUE);
}

/* ---					EOF 								--- */
