/*------------------------------------------------
//
// Module: main2.c
//
// Objet : Dmonstration de serveur DayTime/Nettime pour STinG
//					avec la librairie 'INET.LIB'.
//
// ToDo  : 
//
//
//
// Maintenance :
//
//		 Auteur  : Olivier Booklage (res1@vcf-com.fr)
//		 Version : V1.1
//		 Date 	 : 23/05/1999
//		 Remarq. : tab 2
//
//
//-----------------------------------------------*/


/* ---			 Includes externes			 -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<tos.h>
#include	<time.h>
#include	<portab.h>
#include	<string.h>
#include	<sting\inet.h>

/* ---			 Includes internes			 -- */

/* --- Constantes globales internes --- */

#define CLIENT_BUFSIZE	50
#define DAYTIME_PORT		13
#define	NETTIME_PORT		37 
#define	TIMEOUT					30
#define CON	2					/* con: (Console) */

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

LOCAL UBYTE buffer[CLIENT_BUFSIZE];

/* ---		 Prototypage interne			--- */

WORD	main(VOID);
INT daytime_reponse( INT handle, INT action );
INT nettime_reponse( INT handle, INT action );

/* ---				 Fonctions						--- */

WORD	main(VOID)
{
INT ret;
WORD key = 0;

	fprintf( stdout,"Welcome to DayTime server (C) Olivier Booklage %s %s\n\n", __DATE__, __TIME__);

	ret = Inet_Init( INET_SYSTEM_TOS );
	
	if ( (ret != NETWORK_OK) && (ret != NETWORK_STIK_OK) )
	{
		fprintf( stdout,"\aInet_System()=%s\n",Inet_Err(ret));
		return(-1);
	}

	ret =	Inet_Listen( INET_TYP_PASSIVE_MULTI, INET_TCP, DAYTIME_PORT, CLIENT_BUFSIZE, daytime_reponse, TIMEOUT);
	if ( ret < 0 )
	{
		fprintf( stdout,"\aInet_Listen=()%s\n",Inet_Err(ret));
		Inet_Terminate();
		return(-1);
	}

	ret =	Inet_Listen( INET_TYP_PASSIVE_MULTI, INET_UDP, DAYTIME_PORT, CLIENT_BUFSIZE, daytime_reponse, TIMEOUT);
	if ( ret < 0 )
	{
		fprintf( stdout,"\aInet_Listen()=%s\n",Inet_Err(ret));
		Inet_Terminate();
		return(-1);
	}

	ret =	Inet_Listen( INET_TYP_PASSIVE_MULTI, INET_TCP, NETTIME_PORT, CLIENT_BUFSIZE, nettime_reponse, TIMEOUT);
	if ( ret < 0 )
	{
		fprintf( stdout,"\aInet_Listen()=%s\n",Inet_Err(ret));
		Inet_Terminate();
		return(-1);
	}

	ret =	Inet_Listen( INET_TYP_PASSIVE_MULTI, INET_UDP, NETTIME_PORT, CLIENT_BUFSIZE, nettime_reponse, TIMEOUT);
	if ( ret < 0 )
	{
		fprintf( stdout,"\aInet_Listen()=%s\n",Inet_Err(ret));
		Inet_Terminate();
		return(-1);
	}

	fprintf( stdout,"Press Esc key to quit..\n");

	while ( Cconis() !=0 )	Crawcin();
	
	do
	{

		Inet_Loop();

		if ( Cconis() !=0 )	key=(int)Crawcin()&0xFF;

	}
	while ( key != 27 );
	
	Inet_Terminate();

return(0);
}


INT daytime_reponse( INT handle, INT action )
{
long ul_today;
INT ret;

	switch( action )
	{
		case INET_CONTACTED :

			if ( Inet_Proto(handle) == INET_TCP )
				fprintf( stdout,"SERV:<%04d> %s :Request TCP DayTime service\n", handle, Inet_Name( handle ) );
			else
				fprintf( stdout,"SERV:<%04d> %s :Request UDP DayTime service\n", handle, Inet_Name( handle ) );

			time(&( (time_t)(ul_today) ));

			/* Wed Mar 11 02:08:30 1998 => sct.fr */
			/* Saturday  1998.04.18  11:35:46  GMT+02:00 => Ronald*/

/*		strftime(buffer,50,"%a %b %d %Y %X %Z",localtime(&((time_t)(ul_today)))); */
			strftime(buffer,50,"%d %b %Y %X %Z",gmtime(&((time_t)(ul_today))));
			ret = Inet_Send_String( handle, buffer );
			if ( ret < 0 )
			{
				fprintf( stdout,"SERV:<%04d> %s : Warning, Inet_Send_String <%s>\n", handle, Inet_Name( handle ), Inet_Err(ret) );
				return(INET_STATUS_KILL);
			}
			
			return(INET_STATUS_FINISH);
		
		default :
			if( action != INET_TIMER )
			{
				if ( action < 0 )
					fprintf( stdout,"SERV:<%04d> %s ? %s\n", handle, Inet_Name( handle ), Inet_Err(action) );
				else
					fprintf( stdout,"SERV:<%04d> %s : %s\n", handle, Inet_Name( handle ), Inet_Err(action) );
			}
			break;
	}
	
return(INET_STATUS_CONTINUE);
}

INT nettime_reponse( INT handle, INT action )
{
INT ret;

	switch( action )
	{
		case INET_CONTACTED :

			if ( Inet_Proto(handle) == INET_TCP )
				fprintf( stdout,"SERV:<%04d> %s : Request TCP NetTime service\n", handle, Inet_Name( handle ) );
			else
				fprintf( stdout,"SERV:<%04d> %s : Request UDP NetTime service\n", handle, Inet_Name( handle ) );
			*((LONG*)&buffer) = time(NULL);
			*((LONG*)&buffer) += 2208988800L;
			buffer[4]=0;
			ret = Inet_Send_Data( handle, buffer, 4 );
			if ( ret < 0 )
			{
				fprintf( stdout,"SERV:<%04d> %s : Warning, Inet_Send_Data <%s>\n", handle, Inet_Name( handle ), Inet_Err(ret));
				return(INET_STATUS_KILL);
			}
			return(INET_STATUS_FINISH);
		
		default :
			if( action != INET_TIMER )
			{
				if ( action < 0 )
					fprintf( stdout,"SERV:<%04d> ?: %s\n", handle, Inet_Err(action) );
				else
					fprintf( stdout,"SERV:<%04d> %s : %s\n", handle, Inet_Name( handle ), Inet_Err(action) );
			}
			break;
	}
	
return(INET_STATUS_CONTINUE);
}

/* ---					EOF 								--- */
