/*------------------------------------------------
//
// Module: download.c
//
// Objet : INET.LIB demo : http client.
//
// ToDo  :
//
//					Use Inet_SendString or Inet_SendData with length superior
//					as buffersize defined lock connection.
//
//					Some requests are not received by server, why ?
//
//
// Maintenance :
//
//		 Auteur  : Olivier Booklage (obooklage@free.fr)
//		 Version : V1.0
//		 Date 	 : 19/11/1999
//		 Remarq. : tab 2
//
//
//-----------------------------------------------*/


/* ---			 Includes externes			 -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<ext.h>
#include	<tos.h>
#include	<time.h>
#include	<atarierr.h>
#include	<screen.h>
#include	<portab.h>
#include	<string.h>
#include	<sting\inet.h>

/* ---			 Includes internes			 -- */

/* --- Constantes globales internes --- */

#define SERVER_BUFSIZE	1024
#define STRINGSIZE			1024
#define PATHSIZE				127
#define HTTP_PORT				80
#define	TIMEOUT					120
#define CON							2	/* con: (Console) */

/* --- Structures globales internes --- */

typedef struct Decompose
{

	UBYTE URI[STRINGSIZE];				/* uri, eg '/download/dumy.lzh'*/
	UBYTE protocol[STRINGSIZE];		/* must be http */
	UBYTE server[STRINGSIZE];			/* server eg 'obooklage.free.fr' */
	INT port;											/* port connection */

}DECOMPOSE;

typedef struct Request
{
	INT			handle;								/* connection handle */

	/* Network */

	UBYTE URI[STRINGSIZE];				/* uri, ex '/download/dumy.lzh'*/
	UBYTE server[STRINGSIZE];			/* server eg 'obooklage.free.fr' */

	/* Downloaded file */
	
	INT			file_handle;					/* file handle */
	UBYTE		filepath[STRINGSIZE];	/* complete filepath and filename */
	UBYTE		*filename;						/* filename */
	time_t	if_last_modified;			/* actual file date RFC 822 form, if file exist */
	LONG		data_counter;					/* number of bytes received */
	BOOLEAN complete;							/* Trasaction ok */

	/* Server Reponse */
	
	UBYTE	*proto;
	INT		code;
	UBYTE *message;
	time_t	last_modified;				/* file date on server, if file exist */
	ULONG		content_length;

	/* Screen position for informations */
	
	INT screen_pos;
	
}REQUEST;

/* --- Variables globales  internes --- */

LOCAL INT servers = 0;						/* number of running connections */
LOCAL INT screen_pos = 3;					/* current screen cursor position */

/* ---		 Prototypage interne			--- */

WORD		main(INT argc, UBYTE *argv[]);
LOCAL 	INT			Server_Handle( INT handle, INT action );
LOCAL		VOID ProcessRequest( UBYTE *url, UBYTE *file );
LOCAL		BOOLEAN Extract_Status_Line( REQUEST *request, UBYTE *status  );
VOID		split_URL(UBYTE *URL, DECOMPOSE *decompose);
LOCAL		time_t parse_date(char *date_string);

LOCAL		WORD	ProcessScript( UBYTE *filescript );
LOCAL		VOID ProcessLine( BYTE *line );

LOCAL		time_t TimeDate( UWORD gemdos_time, UWORD gemdos_date );
LOCAL		UBYTE *StringDate( UWORD gemdos_time, UWORD gemdos_date);
LOCAL		UBYTE *TimeString( time_t *t );

LOCAL		BYTE *trim (BYTE *str);
LOCAL		VOID xprintf ( INT handle, BYTE *fmt, ... );

/* ---				 Fonctions						--- */

WORD	main(INT argc, UBYTE *argv[])
{
INT ret;
WORD key = 0;
REQUEST	*request;
INT handle;

	fprintf( stdout,"\33EWelcome to Download HTTP Client (C) Olivier Booklage %s %s\n\n", __DATE__, __TIME__);
	
	if ( argc < 3 )
	{
		fprintf( stdout,"Download HTTP Client needs URL and Filepath as parameters !\n");
		return(-1);
	}

	ret = Inet_Init( INET_SYSTEM_TOS );
	
/*Inet_System(INET_USE_DEBUG);*/
	
	if ( (ret != NETWORK_OK) && (ret != NETWORK_STIK_OK) )
	{
		fprintf( stdout,"\aInet_System()=%s\n",Inet_Err(ret));
		return(-1);
	}

	if ( stricmp( argv[1], "-f" ) == SUCCESS )
	{
		ProcessScript( argv[2] );
	}
	else
	{
		ProcessRequest( argv[1], argv[2] );
	}

	while ( Cconis() !=0 )	Crawcin();	/* clear keyboard buffer */
	
	do
	{

		Inet_Loop();

		if ( Cconis() !=0 )	key=(int)Crawcin()&0xFF;

	}
	while ( (key != 27) && (servers != 0) );

	handle = Inet_First();
	while ( handle > 0 )
	{
		request = (REQUEST*)Inet_UserBlk(handle);
		if ( request != NULL )
		{
			if( request->file_handle > 0 )
			{
				Fclose( request->file_handle );
				Fdelete( request->filepath );
			}
		}

		handle = Inet_Next();
	}

	Inet_Terminate();

return(0);
}


LOCAL INT Server_Handle( INT handle, INT action )
{
INT ret;
UBYTE incom_buffer[SERVER_BUFSIZE];
UBYTE outcom_buffer[SERVER_BUFSIZE];
DOSTIME filetime;
struct tm *urltime;
REQUEST	*request;

	request = (REQUEST*)Inet_UserBlk(handle);

	switch( action )
	{

		/* A server is connected */
		
		case INET_CONNECTED :
		
			if ( request == NULL )	return(INET_STATUS_CONTINUE);

			sprintf( outcom_buffer, "GET %s HTTP/1.0\r\nHost: %s\r\nAccept: */*\r\nIf-Modified-Since: %s\r\n\r\n", request->URI, request->server, TimeString(&request->if_last_modified) );
			xprintf( handle, "Send Request..\r");
			ret = Inet_Send_String( handle, outcom_buffer);
			if ( ret < 0 )
			{
				xprintf( handle, "Inet_Send_String %s.\r", Inet_Err(ret) );
				return(INET_STATUS_KILL);
			}
			
		break;

		case INET_DATA :	/* Data present */

			if ( request == NULL )	return(INET_STATUS_CONTINUE);

			if ( request->file_handle > 0 )
			{
				ret = Inet_ReadData( handle, (VOID *)incom_buffer , SERVER_BUFSIZE);
				if( ret > 0) 
				{
					request->data_counter = request->data_counter + (LONG)ret;
					if ( request->content_length > 0L )
						xprintf( handle, "=>\33p%ld/%lu\33q\r", request->data_counter, request->content_length);
					else
						xprintf( handle, "=>\33p%ld\33q\r", request->data_counter);
					Fwrite( request->file_handle, (LONG)ret, (VOID*)incom_buffer);
				}
				return(INET_STATUS_CONTINUE);
			}
			
			/* HTTP header is termined by double line feed */
			
			if	( 
						( Inet_IsString( handle, "\n\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\r" ) == TRUE ) ||
						( Inet_IsString( handle, "\n\r" ) == TRUE )
					)
			{

				request->complete = TRUE;
				
				/* Get just the request (first) line as "GET /pub/file.htm HTTP/1.0\r\n" */
			
				ret = Inet_ReadString( handle, incom_buffer, SERVER_BUFSIZE);
			
				/* Problem with read data ? */
			
				if ( ret < 0 )
				{
					xprintf( handle, "Error occured on allocated memory.\r");
					return(INET_STATUS_KILL);
				}

				/* Extract Request Line */
				
				if ( Extract_Status_Line( request, incom_buffer ) != TRUE )
				{
					xprintf( handle, "Error occured on request line.\r");
					return(INET_STATUS_KILL);
				}

				if ( (request->code != 200) && (request->code != 201 ) )
				{
					xprintf( handle, "Error %s.\r", request->message);

					return(INET_STATUS_KILL);
				}

				/* Empty Header */

				while(
						( Inet_IsString( handle, "\n\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\r" ) == TRUE ) ||
						( Inet_IsString( handle, "\n\r" ) == TRUE )
				)
				{
					ret =  Inet_ReadString( handle, incom_buffer, SERVER_BUFSIZE);
					if (  (ret < 0) || ( *incom_buffer == '\0') )
						break;
					else
					{
						if( strnicmp( incom_buffer, "Last-Modified:", 14 ) == SUCCESS )
						{
							request->last_modified = parse_date( trim(&incom_buffer[15]) );

						}
						else if ( strnicmp( incom_buffer, "Content-Length:", 15 ) == SUCCESS )
						{
							request->content_length = atol( trim(&incom_buffer[16]) );
						}
					}
				}
								
				request->file_handle = (INT)Fcreate(request->filepath, 0);
							
				/* Check the request line : */
				
				return( INET_STATUS_CONTINUE );
			}

			/* Header not present, waiting.. */
			
			return( INET_STATUS_CONTINUE );
		
		case INET_LEAVED :
		case INET_LEAVE :

			if ( request == NULL )	return(INET_STATUS_CONTINUE);

			if ( request->file_handle > 0 )
			{
				if (request->last_modified > 0	)
				{
					urltime=localtime(&request->last_modified);/* gmtime corrige GMT (-1h) */

					/* Because GEMDOS is half seconde based, we must
					increment if tm_sec ( normally only if ODD ) */
					filetime.time=(urltime->tm_sec/2)+1;
					filetime.time+=(urltime->tm_min)<<5;
					filetime.time+=(urltime->tm_hour)<<11;
					filetime.date=(urltime->tm_mday);
					filetime.date+=((urltime->tm_mon)+1)<<5;
					filetime.date+=((urltime->tm_year)-80)<<9;

					Fdatime(&filetime, request->file_handle, 1);
				}
				Fclose( request->file_handle);
				request->file_handle = -1;
				xprintf( handle, "\r\33p%s\33q\r", request->filename);
			}

			if ( request->complete != TRUE )
				xprintf( handle, "%s.\r", Inet_Err(action));

		
			servers--;

			/* Kill connection */

			return( INET_STATUS_KILL );
							
		case INET_TIMER :
		
			/* Nothing to do... */
			
		break;
		
		default :
		
			if ( request == NULL )	return(INET_STATUS_CONTINUE);

			if ( action < 0 )	/* Any error */
			{

				xprintf( handle, " ? %s.\r", Inet_Err(action));

				/* Free private memory block */

				Inet_FreeUserBlk( handle ) ;
				
				servers--;

				/* Kill connection */

				return( INET_STATUS_KILL );

			}
			else							/* Any message */
			{
				xprintf( handle, "%s.\r", Inet_Err(action));
			}

		break;

	}
	
return(INET_STATUS_CONTINUE);
}

LOCAL VOID ProcessRequest( UBYTE *url, UBYTE *file )
{
INT handle;
DECOMPOSE decompose;
REQUEST	*request;
DTA dtabuffer;
XATTR xattr;
INT pos;
UBYTE	*ptr;

	servers++;

	printf(CUR_OFF);
	printf(CUR_HOME);
	for( pos = 0; pos < screen_pos; pos++)
		printf(CUR_DOWN);
	printf(CUR_ON);

	split_URL( url, &decompose);

	handle = Inet_Open( decompose.server, INET_TCP, decompose.port, SERVER_BUFSIZE, Server_Handle, TIMEOUT);

	if ( handle < 0 )
	{
		xprintf( handle, "Inet_Open(%s)=>%s\r", decompose.server, Inet_Err(handle));
		servers--;
		return;
	}

	request = (REQUEST*)Inet_NewUserBlk( handle, 1L, sizeof( struct Request ) );
	
	if ( request == NULL )
	{
		xprintf( handle, "Inet_NewUserBlk(%s) out of memory.\r", decompose.server);
		Inet_Close( handle );
		servers--;
		return;
	}
	
	request->file_handle	= -1;
	*request->URI = '\0';
	strncat( request->URI, decompose.URI, STRINGSIZE);
	*request->server = '\0';
	strncat( request->server, decompose.server, STRINGSIZE);
	*request->filepath = '\0';
	strncat( request->filepath, file, STRINGSIZE);
	ptr = strchr( request->filepath, '\\' );
	if ( ptr != NULL )
		request->filename = ptr+1;
	else
		request->filename = request->filepath;
	request->screen_pos = screen_pos++;
	request->data_counter = 0L;
	request->complete = FALSE;
	
	if ( Fxattr ( 0, request->filepath, &xattr ) == E_OK )
	{
		request->if_last_modified=mktime(ftimtotm((struct ftime*)&xattr.mtime));
	}
	else
	{
		Fsetdta (&dtabuffer);
		if ( Fsfirst (request->filepath, -1) >= 0 )
		{
			request->if_last_modified=TimeDate( *((UWORD*)(&dtabuffer.time)),*((UWORD*)(&dtabuffer.date) ));
		}
		else	/* not found */
		{
			request->if_last_modified = -1L;
		}
	}
}

LOCAL BOOLEAN Extract_Status_Line( REQUEST *request, UBYTE *status  )
{
UBYTE *token;
INT		arg = 0;

	token = strtok(status, " ");

	if ( token != NULL )
	{
		arg = 1;
		request->proto = token;
		token = strtok(NULL, " ");
		if ( token != NULL )
		{
			arg = 2;
			request->code = atoi(token);
			token = strtok(NULL, "\0");
			if ( token != NULL )
			{
				request->message = token;
				arg = 3;
			}
		}
	}
			
	/* Error , imcomplete request line */
			
	if ( arg != 3 )
	{
		return( FALSE );
	}

return(TRUE);
}

VOID split_URL(UBYTE *URL, DECOMPOSE *decompose)
{
size_t colon_index, slash_index;

	colon_index=strcspn(URL, ":");
	strncpy(decompose->protocol, URL, colon_index);

	decompose->protocol[colon_index]=0;
	strcpy(decompose->URI, &URL[colon_index+3]);

	slash_index=strcspn(decompose->URI, "/");
	strncpy(decompose->server, decompose->URI, slash_index);

	decompose->server[slash_index]=0;
	strcpy(decompose->URI, &URL[colon_index+slash_index+3]);

	colon_index=strcspn(decompose->server, ":");
	if (colon_index<strlen(decompose->server))
	{
		decompose->port=atoi(&(decompose->server[colon_index+1]));
		decompose->server[colon_index]=0;
	}
	else
	{
		decompose->port=80;
	}

	/* correction for URI non "/" termined eg 'http://my.server.com' */
	
	if ( ( *decompose->URI == '\0' ) || ( *decompose->URI == ' ' ) )
	{
		*decompose->URI = '\0';
		strncat( decompose->URI, "/", 2047 );
	}

}


/* -------------------------------------------------------------

												Script proccess

---------------------------------------------------------------- */

LOCAL WORD	ProcessScript( UBYTE *filescript )
{
FILE *file_ptr;
UBYTE line[PATHSIZE];

	file_ptr = fopen( filescript, "r" );
	
	if ( file_ptr == NULL )
	{
		fprintf( stdout,"SERV: script file <%s> open error.\n");
		return(-33);
	}

	while ( fgets(line, PATHSIZE, file_ptr) != NULL )
	{
		trim(line);
		if ( (*line != ';') && (*line != '#') && (*line != '\0') && (*line != 13))
		{
			ProcessLine(line);
		}
	}

	fclose(file_ptr);

return(0);
}


LOCAL VOID ProcessLine( BYTE *line )
{
UBYTE	*pos , *token, *url, *file;

	pos = strchr(line, ';');
	if (pos) *pos = EOS;

	pos = strchr(line, '#');
	if (pos) *pos = EOS;
	
	pos = strchr(line, '\n');
	if (pos) *pos = EOS;
	
	token = strtok(line, " ");
	
	if ( token != NULL )
	{
		url = token;
		token = strtok( NULL,"\0");
		if ( token != NULL )
		{
			file = trim(token);
			ProcessRequest( url, file);
			Inet_Loop();
		}
	}

}

/* -------------------------------------------------------------

												 Tools

---------------------------------------------------------------- */

/* Return time_t for a string content date */

LOCAL time_t parse_date(char *date_string)
{
size_t index;
char tmp[5]={0, 0, 0, 0, 0};
struct tm time;


	if (strchr(date_string, '-')!=NULL) {
		/* Sunday, 06-Nov-94 08:49:37 GMT	RFC 850, obsoleted by RFC 1036 */
		index=strcspn(date_string, ",");
		time.tm_sec=atoi(strncpy(tmp, &date_string[index+18], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[index+15], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[index+12], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[index+9], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[index+2], 2));
	} else if (strchr(date_string, ',')!=NULL) {
		/* Sun, 06 Nov 1994 08:49:37 GMT		RFC 822, updated by RFC 1123 */
		time.tm_sec=atoi(strncpy(tmp, &date_string[23], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[20], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[17], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[5], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[12], 4))-1900;
	} else {
		/* Sun Nov	6 08:49:37 1994			ANSI C's asctime() format */
		time.tm_sec=atoi(strncpy(tmp, &date_string[17], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[14], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[11], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[8], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[20], 4))-1900;
	}
	/* The month is generic... */
	if (strstr(date_string, "Jan")>0)
		time.tm_mon=0;
	else if (strstr(date_string, "Feb")>0)
		time.tm_mon=1;
	else if (strstr(date_string, "Mar")>0)
		time.tm_mon=2;
	else if (strstr(date_string, "Apr")>0)
		time.tm_mon=3;
	else if (strstr(date_string, "May")>0)
		time.tm_mon=4;
	else if (strstr(date_string, "Jun")>0)
		time.tm_mon=5;
	else if (strstr(date_string, "Jul")>0)
		time.tm_mon=6;
	else if (strstr(date_string, "Aug")>0)
		time.tm_mon=7;
	else if (strstr(date_string, "Sep")>0)
		time.tm_mon=8;
	else if (strstr(date_string, "Oct")>0)
		time.tm_mon=9;
	else if (strstr(date_string, "Nov")>0)
		time.tm_mon=10;
	else
		time.tm_mon=11;
	/* DOSTIME is in 2 second intervals... */
	time.tm_sec=(time.tm_sec & 0xFFFE);
	return(mktime(&time));
}

/* Return time_t for gemdos time and date */

LOCAL time_t TimeDate( UWORD gemdos_time, UWORD gemdos_date )
{
struct ftime ftime;

	ftime.ft_tsec	= ( gemdos_time & 0x01f);
	ftime.ft_min	= ( gemdos_time & 0x7e0)>>5;
	ftime.ft_hour	= ( gemdos_time & 0xf800)>>11;
	ftime.ft_year	= ( gemdos_date & 0xfe00)>> 9;
	ftime.ft_month= ( gemdos_date & 0x1e0)>> 5;
	ftime.ft_day	= ( gemdos_date & 0x01f);

	/* Sun, 06 Nov 1994 08:49:37 GMT    RFC 822, updated by RFC 1123 */

return(mktime(ftimtotm(&ftime)));
}

/* Return string-date for gemdos time/date form */

LOCAL UBYTE *StringDate( UWORD gemdos_time, UWORD gemdos_date)
{
LOCAL UBYTE filedate[50];
time_t gmt;


	/* Sun, 06 Nov 1994 08:49:37 GMT    RFC 822, updated by RFC 1123 */

	gmt = TimeDate( gemdos_time, gemdos_date );
	strftime(filedate,50,"%a, %d %b %Y %X GMT",localtime(&gmt));
	

return(filedate);
}

/* Return string-date for time_t variable */

LOCAL UBYTE *TimeString( time_t *t )
{
static UBYTE string[50];

	strftime(string,50,"%a, %d %b %Y %H:%M:%S GMT",localtime(t) );
	
return(string);
}

/* Clean-up a string */

LOCAL BYTE *trim (BYTE *str)
{
register char *s;
register int i = 0;
BYTE chaine[PATHSIZE+1];

  while ( (*(str + i) == ' ') || (*(str + i) == 0x09 ) )    i++;
  *chaine=0;
  strncat (chaine, (str + i),PATHSIZE);

  s = chaine + strlen (chaine) - 1;
  for( ; ((*s == ' ')||(*s == 0x09)) && (s >= chaine) ; *s-- = 0);
  *str=0;
  strncat (str, chaine,PATHSIZE);

return (str);
}


/* Print a string to screen at request current position */

LOCAL VOID xprintf ( INT handle, BYTE *fmt, ... )
{
UBYTE buffer[STRINGSIZE];
UBYTE prefix[STRINGSIZE];
REQUEST	*request;
va_list	args;
INT pos;

	request = (REQUEST*)Inet_UserBlk(handle);

	if ( request == NULL )	return;

	/* Set cursor position */

	printf(CUR_OFF);
	printf(CUR_HOME);
	for( pos = 0; pos < request->screen_pos; pos++)
		printf(CUR_DOWN);
	printf(CUR_ON);

	sprintf( prefix, "\33l%- 20s : ", request->filename, Inet_Name( handle ) );

	va_start(args,fmt);
	vsprintf(buffer,fmt,args);
	va_end(args);

	fprintf( stdout,"%s%s\n", prefix, buffer);

}

/* ---					EOF 								--- */
