/*------------------------------------------------
//
// Module: miniweb.c
//
// Objet : INET.LIB demo : simply http server.
//
// ToDo  : 
//
//
//
// Maintenance :
//
//		 Auteur  : Olivier Booklage (obooklage@free.fr)
//		 Version : V1.1
//		 Date 	 : 16/11/1999
//		 Remarq. : tab 2
//
//
//-----------------------------------------------*/


/* ---			 Includes externes			 -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<ext.h>
#include	<tos.h>
#include	<time.h>
#include	<portab.h>
#include	<string.h>
#include	<sting\inet.h>

/* ---			 Includes internes			 -- */

/* --- Constantes globales internes --- */

#define CLIENT_BUFSIZE	1024
#define PATHSIZE				127
#define HTTP_PORT				80
#define	TIMEOUT					60
#define CON							2	/* con: (Console) */

/* --- Structures globales internes --- */

typedef struct Client
{
	INT			handle;
	BOOLEAN header_received;
	UBYTE		*method;
	UBYTE		*uri;
	UBYTE		*protocol;
	time_t	modified_since;						/* file date */
	time_t	if_modified_since;				/* conditionnal */
	ULONG		filesize;
}CLIENT;

/* --- Variables globales  internes --- */

LOCAL UBYTE root[PATHSIZE];

/* ---		 Prototypage interne			--- */

WORD		main(INT argc, UBYTE *argv[]);

LOCAL 	INT			Server_Handle( INT handle, INT action );

LOCAL 	BOOLEAN Extract_Request_Line( CLIENT *client, UBYTE *request );
LOCAL		INT			Send_Request( CLIENT *client, UBYTE *filepath );
LOCAL 	VOID		Send_FileList( CLIENT *client, UBYTE *path );

LOCAL		UBYTE		*DatetoString( DTA *dta );
LOCAL		time_t parse_date(char *date_string);
LOCAL		BYTE *trim (BYTE *str);

/* ---				 Fonctions						--- */

WORD	main(INT argc, UBYTE *argv[])
{
INT ret;
WORD key = 0;

	fprintf( stdout,"Welcome to Mini-Web server (C) Olivier Booklage %s %s\n\n", __DATE__, __TIME__);
	
	if ( argc > 1 )
	{
		*root = '\0';
		strncat( root, argv[1], PATHSIZE);
		if ( root[strlen(root)-1] != '\\' )
			strncat( root, "\\", PATHSIZE);
	}

	ret = Inet_Init( INET_SYSTEM_TOS );
	
/*Inet_System(INET_USE_DEBUG); */
	
	if ( (ret != NETWORK_OK) && (ret != NETWORK_STIK_OK) )
	{
		fprintf( stdout,"\aInet_System()=%s\n",Inet_Err(ret));
		return(-1);
	}

	ret =	Inet_Listen( INET_TYP_PASSIVE_MULTI, INET_TCP, HTTP_PORT, CLIENT_BUFSIZE, Server_Handle, TIMEOUT);

	if ( ret < 0 )
	{
		fprintf( stdout,"\aInet_Listen=()%s\n",Inet_Err(ret));
		Inet_Terminate();
		return(-1);
	}


	fprintf( stdout,"Server ready on path <%s>, press Esc key to quit..\n", root);

	while ( Cconis() !=0 )	Crawcin();	/* clear keyboard buffer */
	
	do
	{

		Inet_Loop();

		if ( Cconis() !=0 )	key=(int)Crawcin()&0xFF;

	}
	while ( key != 27 );
	
	Inet_Terminate();

return(0);
}


LOCAL INT Server_Handle( INT handle, INT action )
{
INT ret;
INT index;
UBYTE file[CLIENT_BUFSIZE];
UBYTE incom_buffer[CLIENT_BUFSIZE];
CLIENT	*client;

	switch( action )
	{

		/* A new client is connected */
		
		case INET_CONTACTED :

			/* Create memory block for private use */
			
			client = (CLIENT*)Inet_NewUserBlk( handle, 1L, (LONG)sizeof(struct Client) );
			
			/* Memory problem ? */
			
			if ( client == NULL )
			{
				fprintf( stdout,"SERV:<%04d> %s : Error occured on allocated memory.\n", handle, Inet_Name( handle ));
				return(INET_STATUS_KILL);
			}

			/* Initialization of is structure */

			client->handle = handle;
			client->header_received = FALSE;

		break;

		case INET_DATA :	/* Data present */

			/* Get is private memory block */
			
			client = (CLIENT*)Inet_UserBlk(handle);

			/* Memory problem ? */

			if ( client == NULL )
			{
				fprintf( stdout,"SERV:<%04d> %s : Error occured on allocated memory.\n", handle, Inet_Name( handle ));
				return(INET_STATUS_KILL);
			}

			/* Do not care about other data than HTTP header */
			
			if ( client->header_received == TRUE )
			{
				return(INET_STATUS_CONTINUE);
			}

			if(
					( Inet_IsString( handle, "\n\n" ) == TRUE ) ||
					( Inet_IsString( handle, "\r\n" ) == TRUE ) ||
					( Inet_IsString( handle, "\r\r" ) == TRUE ) ||
					( Inet_IsString( handle, "\n\r" ) == TRUE )
			)
			{

				client->header_received = TRUE;
			
				/* Get just the request (first) line as "GET /pub/file.htm HTTP/1.0\r\n" */
			
				ret = Inet_ReadString( handle, incom_buffer, CLIENT_BUFSIZE);

/*			
				if	( ret > 0 )
				{

*/
			
				/* Problem with read data ? */
			
				if ( ret < 0 )
				{
					fprintf( stdout,"SERV:<%04d> %s : Error occured on allocated memory.\n", handle, Inet_Name( handle ));
					return(INET_STATUS_KILL);
				}
				
				/* Extract Request Line */
				
				if ( Extract_Request_Line( client, incom_buffer ) != TRUE )
				{
					fprintf( stdout,"SERV:<%04d> %s : Error occured on request line.\n", handle, Inet_Name( handle ));
					return(INET_STATUS_KILL);
				}
			
				/* Check the request line : */
				
				if ( strnicmp( client->method, "GET", 3 ) != SUCCESS ) /* Is not the request line or insuported method */
				{
					Inet_Send_String( handle, "HTTP/1.0 501 Not implemented.\r\n\r\n");
					Inet_Send_String( handle, "The server do not support your browser method.\r\n" );
					return( INET_STATUS_FINISH );
				}

				/* Transform uri to file */
				
				*file = '\0';
				/* Skip the first "/" */
				strncat(file, root, CLIENT_BUFSIZE);
				strncat(file,&client->uri[1],CLIENT_BUFSIZE);

				/* All unix '/' are changed to Atari '\' path style */
			
				for( index = 0; file[index] != '\0'; index++ )
					if ( file[index]== '/' )	file[index]='\\';
			
				/* Empty Header */

				while(
						( Inet_IsString( handle, "\n\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\n" ) == TRUE ) ||
						( Inet_IsString( handle, "\r\r" ) == TRUE ) ||
						( Inet_IsString( handle, "\n\r" ) == TRUE )
				)
				{
					ret =  Inet_ReadString( handle, incom_buffer, CLIENT_BUFSIZE);
					if (  (ret < 0) || ( *incom_buffer == '\0') )
						break;
					else
					{
						if( strnicmp( incom_buffer, "If-Modified-Since:", 18 ) == SUCCESS )
						{
							client->if_modified_since = parse_date( trim(&incom_buffer[19]) );
						}
					}
				}

				/* Send request to client */
				
				return( Send_Request( client, file ) );
			}

			/* Header not present, waiting.. */
			
			return( INET_STATUS_CONTINUE );
		
		case INET_LEAVE :
		case INET_LEAVED :

			fprintf( stdout,"SERV:<%04d> %s %s\n", handle, Inet_Name( handle ), Inet_Err(action) );

			/* Free private memory block */
			Inet_FreeUserBlk( handle ) ;

			/* Kill connection */
			return( INET_STATUS_KILL );
							
		case INET_TIMER :
		
			/* Nothing to do... */
			
		break;
		
		default :
		
			if ( action < 0 )	/* Any error */
			{

				fprintf( stdout,"SERV:<%04d> %s ? %s\n", handle, Inet_Name( handle ), Inet_Err(action) );

				/* Free private memory block */
				Inet_FreeUserBlk( handle ) ;

				/* Kill connection */
				return( INET_STATUS_KILL );

			}
			else							/* Any message */
			{
				fprintf( stdout,"SERV:<%04d> %s : %s\n", handle, Inet_Name( handle ), Inet_Err(action) );
			}

		break;

	}
	
return(INET_STATUS_CONTINUE);
}

LOCAL BOOLEAN Extract_Request_Line( CLIENT *client, UBYTE *request  )
{
UBYTE *token;
INT		arg = 0;

	token = strtok(request, " ");

	if ( token != NULL )
	{
		arg = 1;
		client->method = token;
		token = strtok(NULL, " ");
		if ( token != NULL )
		{
			arg = 2;
			client->uri = token;
			token = strtok(NULL, " ");
			if ( token != NULL )
			{
				client->protocol = token;
				arg = 3;
			}
		}
	}
			
	/* Error , imcomplete request line */
			
	if ( arg != 3 )
	{
		return( FALSE );
	}

return(TRUE);
}

LOCAL INT Send_Request( CLIENT *client, UBYTE *filepath )
{
INT ret;
UBYTE indexfile[PATHSIZE];
UBYTE outcom_buffer[CLIENT_BUFSIZE];
DTA dtabuffer;

	/* filepath exist ? */
			
	ret = Inet_Check_File( filepath );
			
	if ( ret > 0 )	/* yes */
	{
		fprintf( stdout,"SERV:<%04d> %s : Request file <%s>\n", client->handle, Inet_Name( client->handle ), filepath);
		Fsetdta (&dtabuffer);
		if ( Fsfirst (filepath, -1) >= 0 )
		{
		
			client->modified_since = mktime(ftimtotm((struct ftime*)&dtabuffer.time));
			client->filesize = dtabuffer.d_length;
			
			if ( client->modified_since <= client->if_modified_since )
			{
				sprintf( outcom_buffer, "HTTP/1.0 304 Document has not been modified (conditional GET).\r\n\r\n");
				Inet_Send_String( client->handle, outcom_buffer);
				return( INET_STATUS_FINISH );
			}

			sprintf( outcom_buffer, "HTTP/1.0 200 Ok\r\nContent-Length: %lu\r\nLast-Modified: %s\r\n\r\n", client->filesize, DatetoString( &dtabuffer ) );
			
		}
		else	/* not found */
			sprintf( outcom_buffer, "HTTP/1.0 200 Ok\r\n\r\n");
		Inet_Send_String( client->handle, outcom_buffer);
		ret = Inet_Send_File( client->handle, filepath );
		if( ret < 0 )
		{
			fprintf( stdout,"Inet_Send_File error <%d>\n", ret);
			sprintf( outcom_buffer, "The server can not send your file \"%s\" (%d)\r\n", filepath, ret);
			Inet_Send_String( client->handle, outcom_buffer);
		}
		return( INET_STATUS_FINISH );
	}

	else	/* no */

	{

	/* Check if index.htm exist in the path */

		if ( (filepath[strlen(filepath)-1] == '\\') || ( *filepath == '\0' ) )
		{
			*indexfile = '\0';
			strncat(indexfile,filepath,PATHSIZE);
			strncat(indexfile,"index.htm",PATHSIZE);
			ret = Inet_Check_File( indexfile ) ;
			if ( ret > 0 ) /* Yes */
			{
				fprintf( stdout,"SERV:<%04d> %s : Request default file <%s>\n", client->handle, Inet_Name( client->handle ), indexfile);
				Inet_Send_String( client->handle, "HTTP/1.0 200 Ok\r\n\r\n");
				Inet_Send_File( client->handle, indexfile);
				return(INET_STATUS_FINISH);
			}

			else	/* no, send file list */

			{
				if( strcmp( filepath, "\\") == SUCCESS )	*filepath = '\0';
				strncat( filepath, "*.*", CLIENT_BUFSIZE);
				Inet_Send_String( client->handle, "HTTP/1.0 200 Ok\r\n\r\n");
				Send_FileList( client, filepath);
				return(INET_STATUS_FINISH);
			}
		}
			
	}

	/* File not found */
				
	fprintf( stdout,"SERV:<%04d> %s : File %s error %d\n", client->handle, Inet_Name( client->handle ), filepath, ret);
	Inet_Send_String( client->handle, "HTTP/1.0 404 File Not Found\r\n\r\n");
	sprintf( outcom_buffer, "The server can not found your file \"%s\" (%d)\r\n", filepath, ret);
	Inet_Send_String( client->handle, outcom_buffer);

return(INET_STATUS_FINISH);
}

LOCAL 	VOID		Send_FileList( CLIENT *client, UBYTE *path )
{
DTA		dtabuffer;
INT		re;
UBYTE string[CLIENT_BUFSIZE];

	fprintf( stdout,"SERV:<%04d> %s : Send file list for path <%s>\n", client->handle, Inet_Name( client->handle ), path);

	sprintf( string, "<HTML>\r\n<HEAD>\r\n<TITLE>File Listing of %s</TITLE>\r\n</HEAD>\r\n<BODY>\r\n<TABLE>\r\n", path);
	Inet_Send_String( client->handle, string);

	Fsetdta (&dtabuffer);
	re=Fsfirst (path, -1);
	while(re >=0)
	{
		if ( (dtabuffer.d_attrib & FA_SUBDIR )!=0 ) /* Folder */
		{
			if ( strcmp( dtabuffer.d_fname, "." ) != SUCCESS )
			{
				sprintf( string, "<TR><TD><IMG SRC=\"/internal-gopher-menu\" ALT=\"[DIR] \"><TD><A HREF=\"%s/\">%s/</A><TD ALIGN=\"RIGHT\">%s<TD ALIGN=\"RIGHT\">%lu bytes</TR>\r\n",\
					 dtabuffer.d_fname, dtabuffer.d_fname, DatetoString( &dtabuffer ), dtabuffer.d_length);
				Inet_Send_String( client->handle, string);
			}
		}
		else									/* Other */
		{
			sprintf( string, "<TR><TD><IMG SRC=\"/internal-gopher-unknown\" ALT=\"[   ] \"><TD><A HREF=\"%s\">%s</A><TD ALIGN=\"RIGHT\">%s<TD ALIGN=\"RIGHT\">%lu bytes</TR>\r\n",\
			 dtabuffer.d_fname, dtabuffer.d_fname,\
			 DatetoString( &dtabuffer), dtabuffer.d_length);
			Inet_Send_String( client->handle, string);
		}
		
		re=Fsnext();
	}

	Inet_Send_String( client->handle, "</TABLE>\r\n</BODY>\r\n</HTML>");
}

LOCAL UBYTE *DatetoString( DTA *dta )
{
LOCAL UBYTE filedate[50];
time_t local;

	*filedate=0;

	/* RFC 822 : Sun, 06 Nov 1994 08:49:37 GMT */

	local = mktime(ftimtotm((struct ftime *)&dta->time));

	strftime(filedate,50,"%a, %d %b %Y %H:%M:%S GMT",localtime(&local));
	
return(filedate);

}

/* Return time_t for a string content date */

LOCAL time_t parse_date(char *date_string)
{
size_t index;
char tmp[5]={0, 0, 0, 0, 0};
struct tm time;


	if (strchr(date_string, '-')!=NULL) {
		/* Sunday, 06-Nov-94 08:49:37 GMT	RFC 850, obsoleted by RFC 1036 */
		index=strcspn(date_string, ",");
		time.tm_sec=atoi(strncpy(tmp, &date_string[index+18], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[index+15], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[index+12], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[index+9], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[index+2], 2));
	} else if (strchr(date_string, ',')!=NULL) {
		/* Sun, 06 Nov 1994 08:49:37 GMT		RFC 822, updated by RFC 1123 */
		time.tm_sec=atoi(strncpy(tmp, &date_string[23], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[20], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[17], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[5], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[12], 4))-1900;
	} else {
		/* Sun Nov	6 08:49:37 1994			ANSI C's asctime() format */
		time.tm_sec=atoi(strncpy(tmp, &date_string[17], 2));
		time.tm_min=atoi(strncpy(tmp, &date_string[14], 2));
		time.tm_hour=atoi(strncpy(tmp, &date_string[11], 2));
		time.tm_mday=atoi(strncpy(tmp, &date_string[8], 2));
		time.tm_year=atoi(strncpy(tmp, &date_string[20], 4))-1900;
	}
	/* The month is generic... */
	if (strstr(date_string, "Jan")>0)
		time.tm_mon=0;
	else if (strstr(date_string, "Feb")>0)
		time.tm_mon=1;
	else if (strstr(date_string, "Mar")>0)
		time.tm_mon=2;
	else if (strstr(date_string, "Apr")>0)
		time.tm_mon=3;
	else if (strstr(date_string, "May")>0)
		time.tm_mon=4;
	else if (strstr(date_string, "Jun")>0)
		time.tm_mon=5;
	else if (strstr(date_string, "Jul")>0)
		time.tm_mon=6;
	else if (strstr(date_string, "Aug")>0)
		time.tm_mon=7;
	else if (strstr(date_string, "Sep")>0)
		time.tm_mon=8;
	else if (strstr(date_string, "Oct")>0)
		time.tm_mon=9;
	else if (strstr(date_string, "Nov")>0)
		time.tm_mon=10;
	else
		time.tm_mon=11;
	/* DOSTIME is in 2 second intervals... */
	time.tm_sec=(time.tm_sec & 0xFFFE);
	return(mktime(&time));
}

/* Clean-up a string */

LOCAL BYTE *trim (BYTE *str)
{
register char *s;
register int i = 0;
BYTE chaine[PATHSIZE+1];

  while ( (*(str + i) == ' ') || (*(str + i) == 0x09 ) )    i++;
  *chaine=0;
  strncat (chaine, (str + i),PATHSIZE);

  s = chaine + strlen (chaine) - 1;
  for( ; ((*s == ' ')||(*s == 0x09)) && (s >= chaine) ; *s-- = 0);
  *str=0;
  strncat (str, chaine,PATHSIZE);

return (str);
}

/* ---					EOF 								--- */
