/*------------------------------------------------
//
// Module: inet.h
//
// Objet : Inet, PureC librarie for STiK/STinG
//
// ToDo  :
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0beta
//     Date    : 14/11/1999
//     Remarq. : Need pctoslib and pcextlib.lib
//
//
//
//-----------------------------------------------*/

#ifndef __INET__
#define __INET__

#ifndef __PORTAB__
	#include	<portab.h>
#endif

/* --- Export Constantes globales   --- */

/* Inet_Init() system parameter */

#define	INET_SYSTEM_TOS		0
#define	INET_SYSTEM_GEM		1
#define	INET_SYSTEM_ACC		2	/* or any GEM program without memory allocation, STinG memory is used.*/

/* Inet_Init(); returns values */

#define NETWORK_OK				 		 0				/* Initialisation correcte */
#define NETWORK_NOINIT				-100			/* Pas encore d'initialisation */
#define NETWORK_NOCOOKIE			-101			/* Pas de cookie */
#define NETWORK_NOMAGIC				-102			/* Le nombre magique n'est pas bon */
#define NETWORK_NOTRANSPORT		-103			/* Pas de transport valable pour STiK */
#define NETWORK_NODRIVER			-104			/* Pas de driver STinG prsent */
#define NETWORK_STIK_OK				-104			/* StiK present */
#define NETWORK_NOTACTIVE			-105			/* STinG n'est pas actif */
#define NETWORK_NOHANDLER			-106			/* Routine TIMER non installable */

/* Inet_System() parameter */

#define	INET_USE_DEBUG		TRUE		/* print messages from library */
#define	INET_NUSE_DEBUG		FALSE		/* do not print any message */


/*
   ------------------------------------------------------------------------

	 Inet_Open() and Inet_Listen() parameters

   ------------------------------------------------------------------------
*/


/* protocol , ICMP is not available for instance */

#define	INET_ICMP		1		/* IP assigned number for ICMP                  */
#define INET_TCP    6		/* IP assigned number for TCP                   */
#define INET_UDP    17	/* IP assigned number for UDP                   */

/* typ */

#define INET_TYP_ACTIVE		 			1			/* one connection active */
#define INET_TYP_PASSIVE_MONO		2			/* Passive, waiting only one connection */
#define INET_TYP_PASSIVE_MULTI	3			/* Passive, ready for multi-connections */

/* timeout , you can use any other value in seconds */

#define INET_NO_TIMEOUT			0			/* Do not care about timeout, connection is keeped alive */

/*
   ------------------------------------------------------------------------

	 Your private NPROC function receive as parameter action :

   ------------------------------------------------------------------------
*/

/* NPROC action */

#define INET_CONNECTING			1			/* connection running... */
#define INET_CONNECTED 			2			/* connected to host */
#define INET_CONTACTED 			3			/* contacted by a host computer ( listen ) */
#define INET_DATA			 			4			/* some data sended by a host are available */
#define INET_TIMER		 			5			/* nothing to do, is just if you need any time for your private use */
#define INET_LEAVE			 		6			/* the host have closed the connection */
#define INET_LEAVED		 			7			/* you have closed the connection to host */

/*
  ------------------------------------------------------------------------

	Your private NPROC function return a INT value :

  ------------------------------------------------------------------------
*/

/* NPROC must return : */

#define INET_STATUS_CONTINUE	   0		/* keep connection */
#define INET_STATUS_FINISH		  -200	/* send all data and close connection */
#define INET_STATUS_KILL				-201	/* close connection now */

/* --- Export Structures globales   --- */

typedef INT ( *NPROC )( INT handle, INT action );

/*
  ------------------------------------------------------------------------

	Some variables usefull for information

  ------------------------------------------------------------------------
*/

/* --- Export Variables globales    --- */

/* StiK/STinG librarie version string Format `00.00' */

EXTERN	UBYTE	*STR_STINGLIB_VERSION;

/* StiK/STinG version string Format `00.00' */

EXTERN	UBYTE	*STR_STIK_VERSION;

/*
   StiK/STinG version
   if >= 120, new DRIVER_120 struct available, new TCP_close implemented
   if >= 121 do not require SUPX under TOS ??
*/

EXTERN	INT		STIK_VERSION;

/*
   TCP.STX module version.
   If >= 114, no TCP_ack_wait() before TCP_close() need (old bug)
   If >= 125, TCP_info() function available
*/

EXTERN	INT		TCP_VERSION;

/*
   UDP.STX module version.
   If >= 144, UDP_info() function available and CNbyte_count() as for TCP use
*/

EXTERN	INT		UDP_VERSION;

/*
   MASQUE.STX module version.
   If >= 111, new struct is available
*/

EXTERN	INT		MASQUE_VERSION;

/* ---    Export Prototypage        --- */

/* ----- System Operations ----- */

INT		Inet_Init( INT system );					/* Required before any utilisation */
VOID	Inet_System( BOOLEAN debug_msg ); /* Optional, for expert debugpging */
VOID	Inet_Loop(VOID);									/* Required, you must call this function in a loop */
VOID	Inet_Terminate( VOID );						/* Required before quit your program */

/* ----- Inet Operations ----- */


/*

	Open a link with a host, return a handle if success or
	error code.

	use timeout = INET_NO_TIMEOUT for 'ever'

*/

/* Open an Active connection */
INT	Inet_Open( UBYTE *host , INT protocol, INT port, INT bufsize, NPROC proc, INT timeout);

/* Open an Passive (listen) */
INT	Inet_Listen( INT typ, INT protocol, INT port, INT bufsize, NPROC proc, INT timeout);

/* Write data to host */
INT	Inet_Send_String( INT handle, UBYTE *string );					/* Send a string */
INT	Inet_Send_Data( INT handle, VOID *buffer, INT len);			/* Send a data block */
INT Inet_Check_File( UBYTE *filename );											/* Return postive value if file exist, or negative TOS error code */
INT	Inet_Send_File( INT handle, UBYTE *filename );					/* Send a file to host */

/* Read data from host */
INT	Inet_CountData( INT handle );														/* Return number of bytes available to read */
INT	Inet_ReadData( INT handle, VOID *buffer , INT limit);		/* Read almost 'limit' data in buffer */
INT	Inet_ReadString( INT handle, UBYTE *string , INT limit);/* Read a string with 'limit' maximum bytes */
BOOLEAN	Inet_IsChar( INT handle , UBYTE c );								/* Return TRUE if the char 'c' is in data availables */
BOOLEAN	Inet_IsString( INT handle , UBYTE *string );				/* Return TRUE if string 'string' is in data availables */

/* Close the connection */
INT	Inet_Close( INT handle );

/* Return TRUE if all data are be sended to the host */
BOOLEAN Inet_OutIsEmpty( INT handle );

/* ----- utilities ----- */

/* Return a string message for any negative error code */
UBYTE		*Inet_Err( INT code );

/* Name of host if can be resolved or empty string if no connection exist */
UBYTE		*Inet_Name( INT handle );

/* My name for a host if can be resolved or empty string if no connection exist */
UBYTE		*Inet_MyName( INT handle );

/* Return the number of connection */
INT			Inet_Number( VOID );


/* Return my IP address for the IP remote , route depending, Masquerade compatible if version>=1.11 */
ULONG		Inet_Local( const ULONG	 remote );

/* Return host IP address for me , route depending, Masquerade compatible if version>=1.11 */
ULONG		Inet_IsIp( INT handle );

ULONG		Inet_MyIp( INT handle );


/* Return protocol used for a connection */
INT			Inet_Proto( INT handle );						/* Return INET_ICMP, INET_TCP, INET_UDP or 0 if unknown */

/* You can scan all handles (connections) by using this functions: */
INT			Inet_First( VOID );
INT			Inet_Next( VOID );

/* ----- Private memory for a connection ----- */

/* If you need private memory for your program, you can use this functions: */

VOID		*Inet_NewUserBlk( INT handle, LONG count, LONG size );	/* Create memory block if possible */
VOID		*Inet_UserBlk( INT handle );														/* Return memory block , NULL if do not exist */
VOID		Inet_FreeUserBlk( INT handle );													/* Free memory block */

/* ----- Tools ----- */

	/* Return STRING for IP address */

UBYTE *inetoa( const ULONG ip );

	/* Return IP address of a string, eg: "194.2.128.1" */

ULONG	atoinet( const UBYTE *string );

	/* Real IP address of masqued port or 0L if no port masqued */

ULONG	MasqueradeIP(VOID);

	/* Name of masqued port or "" if no port masqued */

UBYTE *MasqueradePort(VOID);

	/* IP address of port (masqued or not masqued) or 0L if not exist */

#ifdef STING_PORT_H
ULONG	IP_Address( const PORT *port );
#endif

#endif

/* ---          EOF                 --- */
