/*------------------------------------------------
//
// Module: main.c
//
// Objet : routines principales de la librairie
//
// ToDo  :	Inet_Send_Data() crash si buffer prevu est trop petit
//          pour la taille des donnes  envoyer.
//					IL FAUT PREVOIR SI BUFFER TROP PETIT POUR SEND_DATA !
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 23/03/1999
//     Remarq. :
//
//
//
//-----------------------------------------------*/


/* ---       Includes externes       -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"globals.h"
#include	"slot.h"
#include	"watching.h"

/* ---       Includes internes       -- */

#include "main.h"	

/* --- Constantes globales internes --- */

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

/* Dfinis dans transprt.h */

DRV_LIST	*drivers;
TPL 			*tpl;
STX				*stx;

LOCAL	PORT	*port;
LOCAL	VOID	*driver;			/* struct differente si 1.20 ! */
LOCAL	LAYER	*layer;
LOCAL	INT		versiona;
LOCAL	INT		versionb;

/* ---     Prototypage interne      --- */

LOCAL LONG get_sting_cookie(VOID);

/* ---         Fonctions            --- */

INT	Inet_Init( INT system )
{

	inet_system_used		= system;
	inet_debug_message	= INET_NUSE_DEBUG;
	
	drivers = (DRV_LIST *) Supexec(get_sting_cookie);

	if ( drivers == 0L )
	{
		sting_network_ready	= FALSE;
		stik_network_ready	= FALSE;
		return(NETWORK_NOCOOKIE);
	}

	if( strcmp (drivers->magic, MAGIC) != 0 )
	{
		sting_network_ready	= FALSE;
		stik_network_ready	= FALSE;
		return(NETWORK_NOMAGIC);
	}

	/* Plante ici si STICK.ACC pas present, je n'ai pas de solution : */
	/* normal car il est indispensable selon sa doc */
	
	tpl = (TPL *)get_dftab(TRANSPORT_DRIVER);

	if ( tpl == (TPL *)NULL )
	{
		sting_network_ready	= FALSE;
		stik_network_ready	= FALSE;
		return(NETWORK_NOTRANSPORT);
	}

	stik_network_ready = TRUE;

	STR_STIK_VERSION = tpl->version;
	sscanf(STR_STIK_VERSION,"%d.%d",&versiona,&versionb);
	STIK_VERSION = versiona*100+versionb;

	stx = (STX *)get_dftab(MODULE_DRIVER);
	if (stx == (STX *)NULL)
	{
		sting_network_ready	= FALSE;
		return(NETWORK_NODRIVER);
	}

	/*
	
	 Si la version est gale ou suprieure  1.20 alors certains modules
	 (ether.stx) n'ont peu tre pas une structure DRIVER mais de NEW_DRIVER
	
	*/
	
	if ( STIK_VERSION >= 120 )	/* version >= "01.20" */
		driver = ( DRIVER_120 *)driver;
	else
		driver = ( DRIVER *)driver;

	query_chains ((VOID**)&port,(VOID**)&driver,(VOID**)&layer);

	/* Version du layer TCP ( tester si < 114 alors ack ) */

	while ( layer != NULL )
	{
		if ( strcmp(layer->name,"TCP") == SUCCESS )
		{
			sscanf(layer->version,"%d.%d",&versiona,&versionb);
			TCP_VERSION = versiona*100+versionb;
		}
		else
		if ( strcmp(layer->name,"UDP") == SUCCESS )
		{
			sscanf(layer->version,"%d.%d",&versiona,&versionb);
			UDP_VERSION = versiona*100+versionb;
		}
		layer = layer->next;
	}		
	
	/* Version du driver masquerade ( tester si < 111 alors pas d'ip dispo ) */

	while ( port != NULL )
	{
		if ( port->type == L_MASQUE )
		{
			if ( STIK_VERSION >= 120 )
				sscanf( ( (DRIVER_120*)port->driver)->version,"%d.%d",&versiona,&versionb);
			else
				sscanf( ( (DRIVER*)port->driver)->version,"%d.%d",&versiona,&versionb);
			MASQUE_VERSION = versiona*100+versionb;
		}
		port = port->next;
	}		

	/* Test si STinG est activ */
	
	if ( (WORD)( set_sysvars(-1,-1)>>16 ) == 0 )
	{
/*	set_sysvars(TRUE,-1);	*//* on pourrai activer STinG */
		sting_network_ready	= FALSE;
		return(NETWORK_NOTACTIVE);
	}

#ifdef USE_TIMER_CALL

	if ( sting_network_ready == FALSE )
	{
	  if ( TIMER_call (	WatchingTimer, HNDLR_SET)  != 1 )	/* Erreure d'installation */
  	{
			return(NETWORK_NOHANDLER);
	  }
	}

#endif

	sting_network_ready = TRUE;
	
return( E_NORMAL );
}

LOCAL LONG get_sting_cookie(VOID)
{
LONG *work;

	for (work = * (long **) 0x5a0L; *work != 0L; work += 2)
		if (*work == 'STiK')
		{
			return (*++work);		
		}

return(0L);
}

/*

Rgle des paramtres internes, dans un but de debuggage.

*/

VOID	Inet_System( BOOLEAN debug_msg )
{

	inet_debug_message	= debug_msg;
	
}


VOID Inet_Loop( VOID )
{
static debug_call = 0;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant call on Inet_Loop\n");
		debug_call--;
		return;
	}
	Watching();
	debug_call--;
}


VOID Inet_Terminate( VOID )
{
#ifdef USE_TIMER_CALL
  TIMER_call (	WatchingTimer, HNDLR_REMOVE);
#endif
	WatchingClose();
	sting_network_ready = FALSE;
	Inet_memcheck();
}

INT Inet_Open( UBYTE *host , INT protocol, INT port, INT bufsize, NPROC proc, INT timeout)
{
INT			n;
INT			handle;
uint32	h;
UBYTE		*realname;
INET		*new = NULL;

	/* ----- Vrification paramtres ----- */
	
	if ( host <= 0 )
		return( E_PARAMETER );

	if ( port <= 0 )
		return( E_PARAMETER );

	if ( bufsize <= 0 )
		return( E_PARAMETER );

	if ( proc == NULL )
		return( E_PARAMETER );

	/* ----- Rsoudre son nom ----- */
	
	n = resolve( host, &realname, &h, 1);
	KRfree (realname);

 	if (n < 0)
 		return(n);
	
	/* ----- Mmoire ----- */
	
	/* crer en mmoire */
	
	new = InetNewMem( bufsize );
	
	if ( new == NULL )
	{
		return(E_NOMEM);
	}

	/* ----- Initialisation ---- */
	
	new->type				=	INET_TYP_ACTIVE;
	new->todo				=	INET_TODO_USER_CONNECTING;
	new->status			= INET_STATUS_CONTINUE;
	new->port				= port;
	new->remote_addr= h;
	new->user_proc	= proc;
	new->second			= timeout;
/*new->bufsize		= bufsize;	*//* dja fait */
	new->protocol		= protocol;
	new->is_sender	= FALSE;
	new->timeout		= clock()+60*CLK_TCK;	/* 60 secondes pour TCP_wait_state */
	new->fileout_handle = -1;

	/* ----- Connexion  ----- */
	
	handle = InetOpenNetwork( new );

	if ( handle < 0 )
	{
		InetFreeMem(new);
		return( handle );
	}

	new->handle = handle;

return(new->handle);
}

/* Si INET_PASSIVE_MULTI il faut essayer d'en crer 3  */

INT Inet_Listen( INT typ, INT protocol, INT port, INT bufsize, NPROC proc, INT timeout)
{

	if ( typ == INET_TYP_PASSIVE_MULTI )
	{
		return( Inet_MultiListen( 3, typ, protocol, port, bufsize, proc, timeout) );
	}

return( Inet_MultiListen( 1 , typ, protocol, port, bufsize, proc, timeout) );
}

INT Inet_MultiListen( INT nbre, INT typ, INT protocol, INT port, INT bufsize, NPROC proc, INT timeout)
{
INET		*new1 = NULL;
INET		*new2 = NULL;
INET		*new3 = NULL;
INT			handle;

	/* ----- Vrification paramtres ----- */
	
	if ( proc == NULL )
		return( E_PARAMETER );

	if ( nbre < 1 )
		return( E_PARAMETER );

	/* crer en mmoire 1 */
	
	new1 = InetNewMem( bufsize );
	
	if ( new1 == NULL )
	{
		return(E_NOMEM);
	}

	/* ----- Initialisation 1 ---- */
	
	new1->type 				= typ;
	new1->todo 				= INET_TODO_LISTEN;
	new1->status			= INET_STATUS_CONTINUE;
	new1->port				= port;
	new1->remote_addr	= INADDR_ANY;
	new1->user_proc		= proc;
	new1->second			= timeout;
/*new1->bufsize			= bufsize;	*//* dja fait */
	new1->protocol		= protocol;
	new1->timeout			= clock()+60*CLK_TCK;	/* 60 secondes pour TCP_wait_state */
	new1->is_sender		= FALSE;
	new1->fileout_handle	= -1;

	/* ----- Connexion 1 ----- */
	
	handle = InetOpenNetwork( new1 );

	if ( handle < 0 )
	{
		InetFreeMem(new1);
		return( handle );
	}

	new1->handle = handle;

	if ( nbre < 2 )	return( E_NORMAL );

	/* crer en mmoire 2 */
	
	new2 = InetNewMem( bufsize );
	
	if ( new2 == NULL )
	{
		InetUrgentCloseNetwork(new1);
		InetFreeMem( new1 );
		return(E_NOMEM);
	}

	/* ----- Initialisation 2 ---- */
	
	new2->type 				= typ;
	new2->todo				= INET_TODO_LISTEN;
	new2->status			= INET_STATUS_CONTINUE;
	new2->port				= port;
	new2->remote_addr	= INADDR_ANY;
	new2->user_proc		= proc;
	new2->second			= timeout;
/*new2->bufsize			= bufsize;	*//* dja fait */
	new2->protocol		= protocol;
	new2->timeout			= clock()+60*CLK_TCK;	/* 60 secondes pour TCP_wait_state */
	new2->is_sender		= FALSE;
	new2->fileout_handle = -1;

	/* ----- Connexion  2 ----- */
	
	handle = InetOpenNetwork( new2 );

	if ( handle < 0 )
	{
		InetUrgentCloseNetwork(new1);
		InetFreeMem(new1);
		InetFreeMem(new2);
		return( handle );
	}

	new2->handle = handle;
	
	if ( nbre < 3 )	return( E_NORMAL );

	/* crer en mmoire 3 */
	
	new3 = InetNewMem( bufsize );
	
	if ( new3 == NULL )
	{
		InetUrgentCloseNetwork(new1);
		InetFreeMem( new1 );
		InetUrgentCloseNetwork(new2);
		InetFreeMem( new2 );
		return(E_NOMEM);
	}

	/* ----- Initialisation 3 ---- */
	
	new3->type				= typ;
	new3->todo				= INET_TODO_LISTEN;
	new3->status			= INET_STATUS_CONTINUE;
	new3->port				= port;
	new3->remote_addr	= INADDR_ANY;
	new3->user_proc		= proc;
	new3->second			= timeout;
/*new3->bufsize			= bufsize;	*//* dja fait */
	new3->protocol		= protocol;
	new3->timeout			= clock()+60*CLK_TCK;	/* 60 secondes pour TCP_wait_state */
	new3->is_sender		= FALSE;
	new3->fileout_handle = -1;

	/* ----- Connexion  3 ----- */
	
	handle = InetOpenNetwork( new3 );

	if ( handle < 0 )
	{
		InetUrgentCloseNetwork(new1);
		InetFreeMem(new1);
		InetUrgentCloseNetwork(new2);
		InetFreeMem(new2);
		InetFreeMem(new3);
		return( handle );
	}

	new3->handle = handle;

return( E_NORMAL );
}

INT Inet_Send_String( INT handle, UBYTE *string )
{
	return( Inet_Send_Data( handle, (VOID*)string, (INT)strlen(string)) );
}

INT Inet_Send_Data( INT handle, VOID *buffer, INT len )
{
INET *inet;
INT maxi;
INT ret;

	while( do_loop == TRUE );
	do_loop = TRUE;
	
	inet = InetActive( handle );
	
	if ( inet == NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_Send_Data on NULL inet\n");
		do_loop = FALSE;
		return(E_BADHANDLE);
	}
	
	if (	inet->status != INET_STATUS_CONTINUE )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_Send_Data is not INET_STATUS_CONTINUE status.\n");
		do_loop = FALSE;
	 return(E_BADHANDLE);
	}

	maxi = (INT)( inet->outbuf.len - inet->outbuf.used );

	/* Vrification que la place totale soit suprieure */
	
	if ( inet->outbuf.len < len )
	{
		fprintf( stderr,"INET.LIB Your BUFSIZE is too small for your apllication.\n");
		ret = E_BIGBUF;
		return( ret);
	}

	/* On attend de liberer la place neccessaire */

	while( (len > maxi) && (clock() < inet->timeout) )
	{
		ret = WatchingSendActive(inet);
		if ( (ret < 0) && (ret != E_OBUFFULL) ) /* grave erreure */
		{
			if ( inet_debug_message == INET_USE_DEBUG )
				fprintf( stderr,"INET.LIB Inet_Send_Data buffer FULL, can not send data, error:<%s>\n", Inet_Err(ret) );
/*		inet->todo = INET_TODO_TOKILL; On ne deconnecte pas */
			inet->status = ret;
			do_loop = FALSE;
			if ( clock() < inet->timeout )
			{
				if ( inet_debug_message == INET_USE_DEBUG )
					fprintf( stderr,"INET.LIB Inet_Send_Data, error:<%s>\n", Inet_Err(E_USERTIMEOUT) );
				ret = E_USERTIMEOUT;
			}
			return( ret);
		}
		maxi = (INT)( inet->outbuf.len - inet->outbuf.used );
	}
		
	memcpy( (UBYTE*)inet->outbuf.beg+inet->outbuf.used, buffer, len );
	inet->outbuf.used = inet->outbuf.used + len;

	inet->is_sender		= TRUE;

	do_loop = FALSE;

return( E_NORMAL );	/* ?! */
}

INT Inet_CountData( INT handle )
{
 INET *inet;

	inet = InetActive( handle );
	
	if ( inet == NULL )														return(E_BADHANDLE);
/*if ( inet->status != INET_STATUS_CONTINUE )		return(E_BADHANDLE);*/
return( (INT)inet->inbuf.used );
}

INT Inet_ReadString( INT handle, UBYTE *string , INT limit)
{
INET *inet;
UBYTE *question;
UBYTE *ptr;
UBYTE *c;
UBYTE save;
INT len;

	while( do_loop == TRUE );
	do_loop = TRUE;

	inet = InetActive( handle );
	
	if ( inet == NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_ReadString no InetActive\n");
		do_loop = FALSE;
		return(E_BADHANDLE);
	}
	
	if ( inet->status != INET_STATUS_CONTINUE )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_Send_Data no INET_STATUS_CONTINUE\n");
		do_loop = FALSE;
		return(E_BADHANDLE);
	}

	question = (UBYTE*)inet->inbuf.beg;

/* ok pas de probleme, on crase rien, vrifi par : */
/* wprintf( 'xlog', "call.c caractre masqu = <%d>\n", ((UBYTE*)inet->inbuf.beg)[inet->inbuf.used] ); */

/*	dj fait pourtant ! mais il semble neccessaire, pourquoi? */

	((UBYTE*)inet->inbuf.beg)[inet->inbuf.used] = '\0';

	ptr = strchr( question, '\n');
	if ( ptr == NULL )	/* pas de \n, il faudrait faire \r\r, \r\n, \n\n */
	{
		do_loop = FALSE;
		return(E_NODATA);
	}

	save = *(ptr+1);
	*(ptr+1)	='\0';

	/* lire */
	
	len = (INT)strlen(question);
	if ( len > limit )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_ReadString your buffer is too small for received string.\n");
		do_loop = FALSE;
		return(-3);
	}

	*string = '\0';
	strncat( string, question, len);

	/* limine les autres \r\n */

	c = strchr( string, '\r');
	if ( c != NULL )	*c = '\0';

/*
	c = strchr( string, '\n');
	if ( c != NULL )	*c = '\0';
*/

	/* vide */
	
	inet->inbuf.used = inet->inbuf.used - len;
	*(ptr+1)	= save;
	memcpy( inet->inbuf.beg, (UBYTE*)inet->inbuf.beg+len ,inet->inbuf.used);

	do_loop = FALSE;
return(len);
}

INT Inet_ReadData( INT handle, VOID *buffer , INT limit)
{
INET *inet;
INT lire;

	while( do_loop == TRUE );
	do_loop = TRUE;

	inet = InetActive( handle );
	
	if ( inet == NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_ReadData no InetActive\n");
		do_loop = FALSE;
		return(E_BADHANDLE);
	}
	
	if ( inet->status != INET_STATUS_CONTINUE )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr,"\aINET.LIB Inet_ReadData no INET_STATUS_CONTINUE. (%d)\n", inet->status);
		do_loop = FALSE;
		return(E_BADHANDLE);
	}

	/* lire */
	
	lire = min( (INT)inet->inbuf.used, limit );
	
	memcpy( buffer, inet->inbuf.beg, lire );

	/* vide */
	
	inet->inbuf.used = inet->inbuf.used - lire;
	memcpy( inet->inbuf.beg, (UBYTE*)inet->inbuf.beg+lire ,inet->inbuf.used);

	do_loop = FALSE;

return(lire);
}

/* Rechercher un caractre dans le buffer d'entre */

BOOLEAN	Inet_IsChar( INT handle , UBYTE c )
{
INET *inet;
LONG index;

	inet = InetActive( handle );
	
	if ( inet == NULL )
		return(FALSE);
	
	for( index = 0L; index < inet->inbuf.used; index++)
	{
		if( ((UBYTE*)inet->inbuf.beg)[index] == c )
			return(TRUE);
	}

return(FALSE);
}

/* Rechercher une chaine dans le buffer d'entre */

BOOLEAN	Inet_IsString( INT handle , UBYTE *string )
{
INET *inet;

	inet = InetActive( handle );
	
	if ( inet == NULL )
		return(FALSE);
	
	if ( strstr( (UBYTE*)inet->inbuf.beg, string ) != NULL )
		return( TRUE );

return(FALSE);
}

INT Inet_Close( INT handle )
{
INET	*inet;

	inet = InetExist( handle );
	if ( inet != NULL )
	{
		if ( inet->status != INET_STATUS_CONTINUE )
		{
			if ( inet_debug_message == INET_USE_DEBUG )
				fprintf( stderr,"\aINET.LIB Inet_Close no INET_STATUS_CONTINUE.\n");
			return(E_BADHANDLE);
		}
		inet->todo = INET_TODO_SENDKILL;
		return(E_NORMAL);
	}

return(E_BADHANDLE);
}

BOOLEAN Inet_OutIsEmpty( INT handle )
{
INET *inet;

	inet = InetActive( handle );
	
	if ( inet == NULL )													return(TRUE);
	if ( inet->status < 0 )											return(TRUE);

	WatchingSendActive( inet );	/* Danger ? */
	
	if ( (inet->outbuf.used == 0L) && ( inet->fileout_handle <0 ) ) return(TRUE);

return(FALSE);
}

INT Inet_Check_File( UBYTE *filename )
{
INT handle;

	handle = (INT)Fopen( filename, FO_READ);
	
	if ( handle > 0 )
	{
		Fclose( handle );
	}

return( handle );
}

INT Inet_Send_File( INT handle, UBYTE *filename )
{
INET *inet;

	inet = InetActive( handle );
	
	if ( inet == NULL )													return(-33);
	if ( inet->fileout_handle > 0 )							return(-33);

	inet->fileout_handle = (INT)Fopen( filename, FO_READ);

return( inet->fileout_handle );
}

/* ----- utilitaires ----- */

INT Inet_Number( VOID )
{
INET *parcour;
INT count=0;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( parcour->todo	== INET_TODO_SENDRECV )
			count++;
		parcour=parcour->suiv;
	}

return(count);
}

UBYTE *Inet_Name( INT handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( handle == parcour->handle )
			return( parcour->remote_name );
		parcour=parcour->suiv;
	}

return("");
}

UBYTE *Inet_MyName( INT handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( handle == parcour->handle )
			return( parcour->local_name );
		parcour=parcour->suiv;
	}

return("");
}

ULONG		Inet_MyIp( INT handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( handle == parcour->handle )
			return( parcour->local_addr );
		parcour=parcour->suiv;
	}

return(0L);
}

static INT inet_position = -1;

INT Inet_First( VOID )
{
	inet_position = 0;
	return( Inet_Next() );
}

INT Inet_Proto( INT handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( handle == parcour->handle )
			return( parcour->protocol );
		parcour=parcour->suiv;
	}

return(0);
}

INT Inet_Next( VOID )
{
INET *parcour;
INT loop = 0;

	if ( inet_position < 0	) return (-1);
	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( loop == inet_position )
		{
			inet_position++;
			return( parcour->handle );
		}
		loop++;
		parcour = parcour->suiv;
	}

return(-1);
}

UBYTE *Inet_Err( INT code )
{
	switch ( code )
	{
	
	case NETWORK_OK:
		return("No error, STinG ready.");
	case NETWORK_NOINIT :
		return("Network not initialized.");
	case NETWORK_NOCOOKIE:
		return("No STiK/STinG cookie.");
	case NETWORK_NOMAGIC:
		return("Bad STiK/STinG magic number.");
	case NETWORK_NOTRANSPORT:
		return("No STiK/STinG transport driver.");
	case NETWORK_NODRIVER:
		return("No STinG driver,STiK present.");
	case NETWORK_NOTACTIVE:
		return("No STinG active.");
	case NETWORK_NOHANDLER:
		return("Can not install TIMER routine.");

	case 	INET_CONNECTING :
		return("Connecting to remote host.");
	case	INET_CONNECTED :
		return("Remote host connected.");
	case	INET_CONTACTED :
		return("Contacted by a remote host.");
	case	INET_DATA :
		return("Data presents.");
	case	INET_LEAVE :
		return("Remote host gone.");
	case	INET_LEAVED :
		return("Connection to remote host closed.");
	case	INET_TIMER :
		return("Timer");
	default :
		if ( stik_network_ready == TRUE )
		{
			if ( (code <= E_NORMAL) && (code >= -E_LASTERROR) )
				return( get_err_text( code ) );
		}
		return("Bad error number");
	}
}

/* ---          EOF                 --- */
