/*------------------------------------------------
//
// Module: memory.c
//
// Objet : Gestion de blocks memoire.
//
//
// ToDo  :
//
//
//
// Maintenance :
//
//		 Auteur  : Olivier Booklage
//		 Version : V1.0
//		 Date 	 : 02/05/1999
//		 Remarq. :
//
//
//
//-----------------------------------------------*/

/* ---			 Includes externes			 -- */

#include <ext.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <portab.h>
#include	<tos.h>
#include	<sting\transprt.h>

#include	"globals.h"
#include	<sting\inet.h>

/* ---			 Includes internes			 -- */

#include "memory.h"

/* --- Constantes globales internes --- */

/* --- Structures globales internes --- */

typedef struct _tagpmemblk
{
	struct _tagpmemblk *next;
	struct _tagpmemblk *prev;
	long 							 len;
}pmemblk;


/* --- Variables globales  internes --- */

static long 			 memory_used = 0L;
static pmemblk		*memory_list = NULL;

/* ---		 Prototypage interne			--- */

/* ---				 Fonctions						--- */

long Inet_memused ( void )
{
	return(memory_used);
}

/*--------------------------------------------------------------------------*/

void Inet_memcheck ( void )
{
	if ( memory_list )		/* allozierten Speicher freigeben */
	{

	  pmemblk *thisblk = memory_list;
	  pmemblk *nextblk;

	  do
	  {
	  	nextblk = thisblk->next;

	 		memory_used -= thisblk->len;

			if ( inet_system_used == INET_SYSTEM_ACC )
				KRfree ( thisblk );
			else
				free ( thisblk );

	  	thisblk = nextblk;

	  }while ( thisblk );
	}

	if ( memory_used > 0 )
		printf ( "\nmemory check: unfreed memory left!\n" );
	if ( memory_used < 0 )
		printf ( "\nmemory check: negative memory left!\n" );
}

/*--------------------------------------------------------------------------*/

/*
	fordert einen Speicherblock

	bergabe : memdb
	 					Anzahl der Elemente
	 					Gre eines Elementes
	 					Sourcefile
	 					Zeile im Sourcefile

	Rckgabe : TRUE, wenn ok
	
*/

int Inet_allocate ( memdb *mem, long count, long size, const char *fl , long ln )
{
char *start;

	/* ist der memdb unbenutzt ?	*/

	if ( mem->beg != NULL )
	{
		printf ( "fatal: double memory allocation!\n" \
						 "[%s,%ld][%s,%ld]\n", mem->fl, mem->ln, fl, ln );
		return(FALSE);
	}

	if ( count < 0 || size < 0 )
	{

		printf ( "error: negative memory allocation!\n"\
								 "[%s,%ld][%s,%ld]\n", mem->fl, mem->ln, fl, ln );
	 	return(FALSE);
	}

	/* minimal freilassen frs GEM 	*/

	if ( inet_system_used == INET_SYSTEM_ACC )
	{

		if ( ((long)( KRgetfree (TRUE)) - ( count * size )) <= 50L )	/* 50 bytes semble le minimum pour STinG */
			return FALSE;
	}
	else
	{
		if ( ((long)( coreleft ()) - ( count * size )) <= 32000L )
			return FALSE;
	}

	/*
		Speicher anfordern		  count Elemete * size Element
								+ 16 Bytes fr String-Check
								+ sizeof pmemblk
	*/

	if ( inet_system_used == INET_SYSTEM_ACC )
		start = KRmalloc ( count * size + 16 + sizeof ( pmemblk ));
	else
		start = malloc ( count * size + 16 + sizeof ( pmemblk ));

	if ( NULL == start )
		 return(FALSE);


	/* auf 0 initialisieren */

	memset ( start, 0, count * size + sizeof ( pmemblk ) + 16 );

	mem->len	= size * count;
	mem->used = 0L;

	mem->beg	= start + sizeof ( pmemblk ) + 8;
	mem->end	= (char *)( mem->beg ) + mem->len - 1;

	mem->fl = fl;
	mem->ln = ln;

	memory_used += mem->len;

	strncpy ( start + sizeof ( pmemblk ), "SBMEMBEG", 8 );
	strncpy ( mem->end + 1, "SBMEMEND", 8 );

	/* in die static Liste einfgen */

	{
		pmemblk *old = memory_list;
		pmemblk *new = (pmemblk*)start;

		new->next	 = memory_list;
		new->prev	 = NULL;

		if ( old )
		 old->prev = (pmemblk*)start;

		memory_list = (pmemblk*)start;

		((pmemblk*)start)->len = mem->len;
	}

return(TRUE);
}

/*--------------------------------------------------------------------------*/

/*
	Gibt einen memdb wieder frei

	bergabe : memdb
*/

void Inet_release ( memdb *mem, const char *fl, long ln )
{
char *start;

	if ( mem->beg != NULL )
	{
		start = (char *)mem->beg - sizeof ( pmemblk ) - 8;


		if ( strncmp ( start + sizeof ( pmemblk ), "SBMEMBEG", 8 )
													|| strncmp ( mem->end + 1, "SBMEMEND", 8 ))
		{

			printf ( "fatal: memory damaged!\n"\
							 "[%s,%ld][%s,%ld]\n", mem->fl, mem->ln, fl, ln );
		}


		memory_used -= mem->len;

		if ( memory_used < 0L )
		{
			printf ( "fatal: negative memory_used!\n"\
						 "[%s,%ld][%s,%ld]\n", mem->fl, mem->ln, fl, ln );
		}

		/* aus static Liste nehmen */

		{	pmemblk *prev = ((pmemblk*)start)->prev;
			pmemblk *next = ((pmemblk*)start)->next;

			if ( next )
			 	next->prev	= prev;

			if ( prev )
				prev->next	= next;
			else
				memory_list = next;

				((pmemblk*)start)->prev = NULL;
 			((pmemblk*)start)->next = NULL;
	  }

		if ( inet_system_used == INET_SYSTEM_ACC )
			KRfree ( start );
		else
			free ( start );

		mem->beg	 = NULL;
		mem->end	 = NULL;

		mem->len	 = 0L;
		mem->used  = 0L;

		mem->fl 	= "";
		mem->ln 	= 0L;
	}
}

/*--------------------------------------------------------------------------*/

/*
	fordert einen Speicherblock mit genderter Gre an

	bergabe : memdb
	 					Anzahl der Elemente
	 					Gre eines Elementes
	 					Sourcefile
	 					Zeile im Sourcefile

	Rckgabe : TRUE, wenn ok
*/

int Inet_reallocate ( memdb *mem, long count, long size, const char *fl , long ln )
{
char *start;

	if ( count < 0 || size < 0 )
	{
		printf ( "error: negative memory allocation!\n"\
						 "[%s,%ld][%s,%ld]\n", mem->fl, mem->ln, fl, ln );

		return(FALSE);
	}

	if ( mem->beg != NULL )
	{
		start = (char *)mem->beg - sizeof ( pmemblk ) - 8;

		if ( strncmp ( start + sizeof ( pmemblk ), "SBMEMBEG", 8 )
													|| strncmp ( mem->end + 1, "SBMEMEND", 8 ))
		{
			Inet_release ( mem, fl, ln );
	 		return(FALSE);
		}

		if (( count * size ) <= mem->len )
		{

			mem->fl = fl;
			mem->ln = ln;
			return(TRUE);
		}
	}

	/* Speicher freigeben */

	Inet_release( mem, fl, ln );

	/* Speicher neu fordern */

return( Inet_allocate( mem, count, size, fl, ln ) );
}

/* ---					EOF 								--- */
