/*------------------------------------------------
//
// Module: inet.c
//
// Objet : 
//
// ToDo  : 
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 22/03/1999
//     Remarq. :
//
//
//
//-----------------------------------------------*/


/* ---       Includes externes       -- */

#include	<stdio.h>
#include	<string.h>

#include	"globals.h"
#include	"main.h"

/* ---       Includes internes       -- */

#include "slot.h"	

/* --- Constantes globales internes --- */

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

INET *tete_inet = (INET *)NULL;

/* ---     Prototypage interne      --- */

LOCAL INET *InetCreer( VOID );
LOCAL INET *InetAjoute( VOID );
LOCAL INET *InetRetire(INET *noeud);

/* ---         Fonctions            --- */

/* ----- Routines de Mmoire Totale ----- */

INET	*InetNewMem( uint16	bufsize )
{
INET		*new = NULL;
memdb		inbuf			= _MEMDB;
memdb		outbuf		= _MEMDB;
memdb		user_blk	= _MEMDB;
	
	/* ----- Mmoire ----- */
	
	new = InetAjoute();
	
	if ( new == NULL )
	{
		return(NULL);
	}

	/* crer les buffers */
	
	new->bufsize = bufsize;

	if( !NewMemBlk(&inbuf,(LONG)new->bufsize+1,sizeof(UBYTE)) )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "! Error memory to small for inbuffer\n");
		InetRetire(new);
		return(NULL);
	}

	new->inbuf = inbuf;
	new->inbuf.used = 0L;

	/* Buffer de sortie */

	if( !NewMemBlk(&outbuf,(LONG)new->bufsize+1,sizeof(UBYTE)) )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "! Error memory to small for outbuffer\n");
		FreeMemBlk(&inbuf);
		InetRetire(new);
		return(NULL);
	}

	new->outbuf				= outbuf;
	new->outbuf.used	= 0L;
	
	new->user_blk = user_blk;

return(new);
}

INET	*InetFreeMem( INET *inet )
{

	if( inet == NULL )	return(NULL);
	FreeMemBlk( &inet->inbuf);
	FreeMemBlk( &inet->outbuf);
	FreeMemBlk( &inet->user_blk);

return( InetRetire(inet) );
}

/* ----- Routines Rseau ----- */

INT	InetOpenNetwork( INET *inet )
{
INT			n;
uint32	h;
UBYTE		*realname;
CIB			*cib;

	if( inet == NULL )	return(E_NOROUTINE);
	
	if ( inet->protocol == INET_TCP )
		inet->handle = TCP_open( inet->remote_addr, inet->port, TOS_ROUTINE, inet->bufsize+1);
	else if ( inet->protocol == INET_UDP )
		inet->handle = UDP_open( inet->remote_addr, inet->port );
	else
		inet->handle = E_FNAVAIL;
	
	/* Rsolver */
	
	*inet->remote_name = '\0';
	cib =	CNgetinfo( inet->handle );
	if ( cib != NULL )
	{
		if ( inet->remote_addr != INADDR_ANY )	/* j'avais des problemes ici */
		{
			inet->remote_addr = cib->address.rhost;
			strncat( inet->remote_name, inetoa(inet->remote_addr), MAX_STR);
		
			/* le resoudre */

			if( *inet->remote_name != 0 )
			{
				n = resolve(inet->remote_name, &realname, &h, 1); /* smtp.c */
			 	if (n > 0)
	  		{
					*inet->remote_name=0;
					strncat(inet->remote_name,realname,MAX_STR);
			  }
				KRfree (realname);
			}

			/* me resoudre */

			inet->local_addr = Inet_Local(inet->remote_addr);
			*inet->local_name=0;
			strncat( inet->local_name, inetoa(inet->local_addr), MAX_STR);

			if( *inet->local_name != 0 )
			{
				n = resolve( inet->local_name, &realname, &h, 1); /* smtp.c */
	 			if (n > 0)
			  {
					*inet->local_name=0;
					strncat(inet->local_name, realname, MAX_STR );
					inet->local_addr = h;
			  }
				KRfree (realname);
			}
		} /* inet->remote_addr != INADDR_ANY */
	}
	else
	{
		inet->remote_addr = 0L;
	}
	
return( inet->handle );	
}

INT	InetWaitCloseNetwork( INET *inet )
{
INT ret = E_BADHANDLE;

/*if( inet == NULL )	return(E_NOROUTINE); */
	if( inet == NULL )	return(TRUE);

	if ( inet->protocol == INET_TCP )
	{
		if( STIK_VERSION >= 120 )
		{
			TCP_close( inet->handle, TCP_HALFDUPLEX, (int16*)NULL);	/* Laisser STinG s'en occuper */
			ret = E_NORMAL;
		}
		else
		{
			ret = TCP_close( inet->handle, 1, (int16*)NULL);
		}
		if ( ( ret < 0 ) && (inet_debug_message == INET_USE_DEBUG ) )
			fprintf( stderr, "<%04d> SLOT.C InetWaitCloseNetwork TCP_close() <%d><%s>\n", inet->handle, ret, Inet_Err(ret));
	}
	else if ( inet->protocol == INET_UDP )
	{
		ret = UDP_close( inet->handle);
		if ( ( ret < 0 ) && (inet_debug_message == INET_USE_DEBUG ) )
			fprintf( stderr, "<%04d> SLOT.C InetWaitCloseNetwork UDP_close() <%d><%s>\n", inet->handle, ret, Inet_Err(ret));
	}

	if ( (ret == E_CNTIMEOUT) && ( clock() < inet->timeout ) )
		return(FALSE);
		
return(TRUE);
}

/* Urgent */

VOID	InetUrgentCloseNetwork( INET *inet )
{
INT ret = E_BADHANDLE;

	if( inet == NULL )	return;

	if ( inet->protocol == INET_TCP )
	{
		if( STIK_VERSION >= 120 )
		{
			TCP_close( inet->handle, TCP_IMMEDIATE, (int16*)NULL);
			ret = E_NORMAL;
		}
		else
		{
			ret = TCP_close( inet->handle, TCP_IMMEDIATE, (int16*)NULL);
		}

		if ( ( ret < 0 ) && (inet_debug_message == INET_USE_DEBUG ) )
			fprintf( stderr, "<%04d> SLOT.C TCP_close <%d><%s>\n", inet->handle, ret, Inet_Err(ret));
	}
	else if ( inet->protocol == INET_UDP )
	{
		ret = UDP_close( inet->handle);
		if ( ( ret < 0 ) && (inet_debug_message == INET_USE_DEBUG ) )
			fprintf( stderr, "<%04d> SLOT.C UDP_close <%d><%s>\n", inet->handle, ret, Inet_Err(ret));
	}
}

INET  *InetPassiveToActive( INET *inet )
{
INT			n;
uint32	h;
UBYTE		*realname;
CIB			*cib;

	if( inet == NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "! InetPassiveToActive: inet NULL.\n");
		return(NULL);
	}
	if( InetPassive( inet->handle ) == NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "! InetPassiveToActive: not passive inet.\n");
		return(NULL);
	}

	/* ----- Initialisation ---- */
	
	inet->type			= INET_TYP_ACTIVE;
	inet->todo			= INET_TODO_SENDRECV;
	inet->status		= INET_STATUS_CONTINUE;
	inet->timeout		= clock()+10*CLK_TCK;	/* 10 secondes pour TCP_wait_state */

	/* ----- Resoudre ----- */
	
	*inet->remote_name = '\0';
	cib =	CNgetinfo( inet->handle );
	if ( cib != NULL )
	{
		inet->remote_addr = cib->address.rhost;
		strncat( inet->remote_name, inetoa(inet->remote_addr), MAX_STR);
		
		/* le resoudre */

		if( *inet->remote_name != 0 )
		{
			n = resolve(inet->remote_name, &realname, &h, 1); /* smtp.c */
		 	if (n > 0)
  		{
				*inet->remote_name=0;
				strncat(inet->remote_name,realname,MAX_STR);
		  }
			KRfree (realname);
		}

		/* me resoudre */

		inet->local_addr = Inet_Local(inet->remote_addr);
		*inet->local_name=0;
		strncat( inet->local_name, inetoa(inet->local_addr), MAX_STR);

		if( *inet->local_name != 0 )
		{
			n = resolve( inet->local_name, &realname, &h, 1); /* smtp.c */
 			if (n > 0)
		  {
				*inet->local_name=0;
				strncat(inet->local_name, realname, MAX_STR );
				inet->local_addr = h;
		  }
			KRfree (realname);
		}
	}
	else
	{
		inet->remote_addr = 0L;
	}

return(inet);
}

/* ----- Routines Internes ----- */

LOCAL INET *InetCreer(VOID)
{
INET *nouveau;
memdb memptr=_MEMDB;

	if ( NewMemBlk(&memptr,SZ_INET,sizeof(UBYTE) ) )
	{
		nouveau = (INET *)memptr.beg;
		nouveau->memptr = memptr;
		nouveau->prec = NULL;	/* scurit */
		nouveau->suiv = NULL;	/* scurit */
	}

return(nouveau);
}

LOCAL INET *InetAjoute( VOID )
{
INET *nouveau;
INET *parcour;

	nouveau = InetCreer();

	if (nouveau == (INET*)NULL)	return((INET*)NULL);

	if ( tete_inet == (INET*)NULL )
	{
		nouveau->suiv = (INET*)NULL;
		nouveau->prec = (INET*)NULL;
		tete_inet = nouveau;
	}
	else
	{
		parcour = tete_inet;
		while (parcour->suiv != NULL)	parcour = parcour->suiv;
		nouveau->suiv = (INET*)NULL;
		nouveau->prec = parcour;
		parcour->suiv = nouveau;
	}

return (nouveau);
}

LOCAL INET *InetRetire(INET *noeud)
{
INET *retour=NULL;

	if ( tete_inet == (INET*)NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "\aERROR:ActiveRetire:tete = NULL !\n");
		return((INET *)NULL);
	}
	
	if ( noeud == (INET*)NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "\aERROR:ActiveRetire: inet NULL !\n");
		return((INET *)NULL);
	}

	if ( noeud == tete_inet )	/* premier */
		tete_inet = noeud->suiv;
	else
		noeud->prec->suiv = noeud->suiv;

	retour = noeud->suiv;

	if( noeud->suiv != NULL )
		noeud->suiv->prec = noeud->prec;

	/* Ds-initialisation */
	
	if ( noeud->fileout_handle > 0 )
		Fclose( noeud->fileout_handle );

	FreeMemBlk(&noeud->inbuf);
	FreeMemBlk(&noeud->outbuf);
	FreeMemBlk(&noeud->memptr);

	noeud = (INET *)NULL;			/* inutile car copie de pointeur :( */

return(retour);
}

/* ----- Outils ----- */

INET *InetSuivant(INET *noeud)
{
	if (noeud == NULL)
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "\ActiveSuivant:NULL parameter\n");
		return(NULL);
	}

	return (noeud->suiv);
}

VOID InetFree(VOID)
{
INET *parcours;

	parcours = tete_inet;
	while( parcours != NULL )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "\ActiveFree:Call ActiveRetire\n");
		parcours=InetRetire(parcours);
	}
}

INET	*InetExist( int16 handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( handle == parcour->handle )
			return(parcour);
		parcour=parcour->suiv;
	}

return(NULL);
}

INET	*InetActive( int16 handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if (	(handle == parcour->handle) &&
					(parcour->type == INET_TYP_ACTIVE) )
		{
			return(parcour);
		}
		parcour=parcour->suiv;
	}

return(NULL);
}

INET	*InetPassive( int16 handle )
{
INET *parcour;

	parcour = tete_inet;
	while( parcour != NULL )
	{
		if ( (handle == parcour->handle) &&
				 (parcour->todo == INET_TODO_LISTEN) &&
				 (parcour->status == INET_STATUS_CONTINUE) )
			return(parcour);
		parcour=parcour->suiv;
	}

return(NULL);
}

/* ---          EOF                 --- */
