/*------------------------------------------------
//
// Module: inet.h
//
// Objet : Exportation 
//
// ToDo  : 
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 22/03/1999
//     Remarq. :
//
//
//
//-----------------------------------------------*/


#include	<time.h>
#include	"memory.h"

/* --- Export Constantes globales   --- */

/* todo privs */

#define INET_TODO_LISTEN					-1			/* Passive  surveiller */
#define INET_TODO_USER_CONNECTING	-2			/* Envoyer connecting et passer en ESTABLISH (tcp) ou SENDRECV */
#define INET_TODO_WAIT_ESTABLISH	 3			/* Active, attendre le ESTABLISH (tcp) et passer en SENDRECV si pas de problme */
#define INET_TODO_USER_CONNECTED	 4		/* Envoyer connected et passer en SENDRECV */
#define INET_TODO_USER_CONTACTED	 5			/* Envoyer contacted et passer en SENDRECV */
#define INET_TODO_SENDRECV				 6			/* Active, envoyer et recevoir */
#define INET_TODO_SENDKILL				 7			/* Active, tout envoyer en fermer */
#define INET_TODO_TOKILL					-8			/* a refermer */
#define INET_TODO_WAIT_ACK				-9			/* attendre ack avant de refermer (tcp) ou une erreure != E_CNTIMEOUT */
#define INET_TODO_WAIT_CLOSE			-10			/* attendre E_NORMAL pour UDP/TCP_close ou une erreure != E_CNTIMEOUT */

/* status privs, y compris les erreures de STinG */

#define INET_STATUS_LEAVED			-3		/* il s'est dconnect */
#define INET_STATUS_DEAD			 	-4		/* Dconnexion en cours... */

/* --- Export Structures globales   --- */

typedef struct	Inet
{

/* systme */

	WORD		type;											/* listen, multilisten, active */
	WORD		todo;											/* action a effectuer */
	WORD		status;										/* tat de la connection, code d'erreur */
	INT			second;										/* deconnection si inactivit de 'second' */
	time_t	timeout;									/* time out, si clock()>timeout 30 secondes sont coules */
	memdb		memptr;										/* pointeur mmoire de la structure client */
	INT (*user_proc)( INT handle, INT action);	/* procedure  appeler */

/* rseau */	

	int16		handle;										/* handle de la connexion */
	uint16	protocol;									/* P_TCP, P_UDP, P_ICMP, ERROR */
	uint16	port;											/* Son port */
	uint32	remote_addr;							/* Son adresse IP */
	uint32	local_addr;								/* Mon adresse IP pour lui */
	UBYTE		remote_name[MAX_STR+1];		/* Son nom cannonique si resolu */
	UBYTE		local_name[MAX_STR+1];		/* Mon nom cannonique si resolu */

/* tampon rception/mission */

	uint16	bufsize;									/* mmoire demand  STinG */
	BOOLEAN	is_sender;								/* Il a enyoy des donns, TCP_ack_wait()  faire */
	memdb		inbuf;										/* buffer d'entre */
	memdb		outbuf;										/* buffer de sortie */

/* Gestion d'envoi - rception de fichiers (nouveau) */

	INT			fileout_handle;
	INT			filein_handle;

/* mmoire pour l'utilisateur */

	memdb		user_blk;

/* liste chaine */
	
	struct	Inet*	prec;
	struct	Inet*	suiv;
	
}INET;

#define SZ_INET	sizeof(struct	Inet)

/* --- Export Variables globales    --- */

EXTERN INET *tete_inet;

/* ---    Export Prototypage        --- */

/* Mmoire */
INET	*InetNewMem( uint16	bufsize );
INET	*InetFreeMem( INET	*inet );

/* Rseau */
INT		InetOpenNetwork( INET *inet );
INT		InetWaitCloseNetwork( INET *inet );
VOID	InetUrgentCloseNetwork( INET *inet );
INET  *InetPassiveToActive( INET *inet );

/* Utilitaires */
INET	*InetSuivant(INET *noeud);
INET	*InetExist( int16 handle );		/* prsent */
INET	*InetActive( int16 handle );	/* prsent et non listen */
INET	*InetPassive( int16 handle );	/* prsent et listen */

/* ---          EOF                 --- */
