/*------------------------------------------------
//
// Module: tools.c
//
// Objet : Fonctions utilitaires autour de STinG
//
// ToDo  :
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage	res1@vc-com.fr
//     Version : V1.0
//     Date    : 24/05/1999
//     Remarq. :
//
//
//
//-----------------------------------------------*/


/* ---       Includes externes       -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"globals.h"

/* ---       Includes internes       -- */

#include "tools.h"

/* --- Constantes globales internes --- */

/* Extract a short from a long */

#define	hiword(x)	((int16)((x) >> 16))
#define	loword(x)	((int16)(x))

/* Extract a byte from a short */

#define	hibyte(x)	((unsigned char)((x) >> 8))
#define	lobyte(x)	((unsigned char)(x))

/* Extract nibbles from a byte */

#define	hinibble(x)	(((x) >> 4) & 0xf)
#define	lonibble(x)	((x) & 0xf)

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

LOCAL	PORT	*port;
LOCAL	VOID	*dummy;

/* ---     Prototypage interne      --- */

/* ---         Fonctions            --- */

uint32	Inet_Local( const uint32 remote )
{
uint32 lcl_IP;

	if ( stik_network_ready != TRUE )	return(0L);

	if ( PRTCL_get_parameters (remote, &lcl_IP, NULL, NULL) != E_NORMAL )
		return(0L);


	/* Contrler si l'lcl_IP n'est pas celui de Masquerade */

	query_chains ((VOID**)&port,(VOID**)&dummy,(VOID**)&dummy);
	while ( port != NULL )
	{
		if ( ( port->ip_addr == lcl_IP ) && ( port->type == L_MASQUE ) )
		{
			if ( MASQUE_VERSION < 113 )
				return( lcl_IP );	/* SUR ??? */
			else
				return( ((MASQ_PORT_113*)(port))->masq_port_ISP_ip);
		}
		port = port->next;
	}

return(lcl_IP);
}

UBYTE *inetoa( const uint32 a)
{
static UBYTE buf[16];

		sprintf(buf,"%u.%u.%u.%u",
		hibyte(hiword(a)),
		lobyte(hiword(a)),
		hibyte(loword(a)),
		lobyte(loword(a)) );
	return buf;
}

uint32 atoinet( const UBYTE *string)
{
LONG len,i;
UBYTE *p,*last;
uint32 host=0;
WORD index=24;
static UBYTE buf[16];

	*buf=0;
	strncat( buf, string, 15);
	
	len = strlen( buf );
	
	p = last = buf;
	
	for ( i=0 ; i < len ; i++ )
	{
		p = &buf[i];

		if ( (( *p < '0')||( *p > '9')) && *p != '.' )	return(-1);

		if ( *p == '.' )
		{
			*p = 0;
			host = host | ( (uint32)atoi(last) << index );
			index -= 8;
			last = p+1;
		}
	}
	
	if ( (*last !=0)	&& ( last <= buf+len) )
	{
		host = host | ( (uint32)atoi(last) << index );
	}

return( host );
}

ULONG MasqueradeIP(VOID)
{

	if ( sting_network_ready != TRUE )			return( 0L );

	if ( MASQUE_VERSION < 113 )	return( 0L );
	
	query_chains ((VOID**)&port,(VOID**)&dummy,(VOID**)&dummy);
	while ( port != NULL )
	{
		if ( ( port->type == L_MASQUE) && ( port->active != 0 ) )
		{
			return( ((MASQ_PORT_113*)(port))->masq_port_ISP_ip);
		}
		port = port->next;
	}

return(0L);
}

UBYTE *MasqueradePort(VOID)
{
	if ( sting_network_ready != TRUE )	return("");
	query_chains ((VOID**)&port,(VOID**)&dummy,(VOID**)&dummy);
	while ( port != NULL )
	{
		if ( ( port->type == L_MASQUE) && ( port->active != 0 ) )
		{
			if ( MASQUE_VERSION < 113 )
				return( ((MASQ_PORT*)(port))->masq_port_ptr->name );
			else
				return( ((MASQ_PORT_113*)(port))->masq_port_ptr->name );
		}
		port = port->next;
	}

return("");
}

uint32	IP_Address( const PORT *p )
{
PORT *masqued;

	if ( sting_network_ready != TRUE )
		return(0L);

	if ( p == NULL )
		return(0L);

	if ( p->active == 0 )
		return(0L);

	if ( p->type == L_MASQUE )
		return(p->ip_addr);

	if ( MASQUE_VERSION < 113 )	/* ou 111 ?? Impossible d'obtenir l'adresse IP */
		return(p->ip_addr);

	query_chains ((VOID**)&port,(VOID**)&dummy,(VOID**)&dummy);
	while ( port != NULL )
	{
		if ( ( port->type == L_MASQUE) && ( port->active != 0 ) )
		{

			masqued = ((MASQ_PORT*)port)->masq_port_ptr;		/* PORT masqu */

			if ( strcmp( p->name, masqued->name) == SUCCESS )
				return( ((MASQ_PORT_113*)port)->masq_port_ISP_ip);
		}
	  port = port->next;
	}

return(p->ip_addr);
}

/* ---          EOF                 --- */
