/*------------------------------------------------
//
// Module: user_blk
//
// Objet : gestion d'un block mmoire user d'un inet
//
// ToDo  : 
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 18/04/1999
//     Remarq. :
//
//
//
//-----------------------------------------------*/


/* ---       Includes externes       -- */

#include	<stdio.h>

#include	"globals.h"
#include	"memory.h"
#include	"slot.h"

/* ---       Includes internes       -- */

#include "user_blk.h"	

/* --- Constantes globales internes --- */

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

/* ---     Prototypage interne      --- */

/* ---         Fonctions            --- */

VOID	*Inet_NewUserBlk( INT handle, LONG count, LONG size )
{
INET	*inet;
memdb	blk	= _MEMDB;

	while( do_loop == TRUE );
	do_loop = TRUE;

	inet = InetExist( handle );
	
	if ( inet == NULL )
	{
		do_loop = FALSE;
		return(NULL);
	}
	
	if ( inet->user_blk.beg	!= NULL )
	{
		do_loop = FALSE;
		return(NULL);
	}
	
	if ( !NewMemBlk( &blk, count, size ) )
	{
		return(NULL);
	}
	
	inet->user_blk = blk;
	inet->user_blk.used = 0;
	do_loop = FALSE;

return(	inet->user_blk.beg );
}


VOID	*Inet_UserBlk( INT handle )
{
INET	*inet;

	while( do_loop == TRUE );
	do_loop = TRUE;

	inet = InetExist( handle );
	
	if ( inet == NULL )
	{
		do_loop = FALSE;
		return(NULL);
	}
	
	do_loop = FALSE;
return(	inet->user_blk.beg );
}

VOID	Inet_FreeUserBlk( INT handle )
{
INET	*inet;
memdb	blk	= _MEMDB;

	while( do_loop == TRUE );
	do_loop = TRUE;

	inet = InetExist( handle );
	
	if ( inet == NULL )
	{
		do_loop = FALSE;
		return;
	}
	
	if ( inet->user_blk.beg	== NULL )
	{
		do_loop = FALSE;
		return;
	}
	
	FreeMemBlk( &inet->user_blk );
	
	inet->user_blk = blk;
	do_loop = FALSE;
}

/* ---          EOF                 --- */
