#define	FIX_TCP114_RRESET_BUG			/* E_RRESET is no more an error */
/* #define WAIT_TCP_TESTABLISH */ /* Attendre le TESTABLISH pour TCP */ 
#define	TIMEOUT_ACK		30
#define	TIMEOUT_CLOSE	30
/*------------------------------------------------
//
// Module:	watching.c
//
// Objet :	watching clients
//
// ToDo  :	
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 22/03/1999
//     Remarq. : TCP.STX V1.14 peut retourner E_RRESET pour :
//
//								-	TCP_wait_state ( cn, TESTABLISH, 1 );
//									=> on le considre comme E_RRESET=>E_NORMAL
//								- CNget_block();
//									=> on le considre comme E_RRESET=>E_NODATA
//
//-----------------------------------------------*/


/* ---       Includes externes       -- */

#include	<stdio.h>
#include	<string.h> /* memcpy */

#include	"globals.h"
#include	"slot.h"
#include	"main.h"
#include	"yield.h"

/* ---       Includes internes       -- */

#include "watching.h"

/* --- Constantes globales internes --- */

/* --- Structures globales internes --- */

/* --- Variables globales  internes --- */

/* ---     Prototypage interne      --- */

LOCAL INT			WatchingLogin( INET	*inet );
LOCAL BOOLEAN	WatchingLogoff( INET	*inet );

LOCAL INET		*WatchingProccessPassive( INET	*inet );
LOCAL INET		*WatchingGetActive( INET	*inet );
LOCAL INT			Watching_Read_File( INET *inet );

/* ---         Fonctions            --- */

VOID Watching( VOID )
{
INET		*inet;
static debug_call = 0;

	if ( do_loop == TRUE )	return;
	
	do_loop = TRUE;
	
	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on Watching\n");
		debug_call--;
		do_loop = FALSE;
		return;
	}
	
	/* Si debug on patiente 1 seconde */

	if(inet_debug_message == INET_USE_DEBUG)
	{
	clock_t wait_timeout = clock()+1*CLK_TCK;
		while( clock() < wait_timeout )
		{
			if ( inet_system_used == INET_SYSTEM_TOS )
				_inet_appl_yield();
		}
	}

	if ( inet_system_used == INET_SYSTEM_TOS )
		_inet_appl_yield();
	
	if ( 	stik_network_ready != TRUE )
	{
	 debug_call --;
	 do_loop = FALSE;
	 return;
	}

	inet = tete_inet;

	while( inet != NULL )
	{
	
		/* ----- Tour des travaux ----- */

		if(inet_debug_message == INET_USE_DEBUG)
		{
			if ( inet->type !=	INET_TYP_PASSIVE_MULTI )
			fprintf( stderr, "<%04d> WATCHING.C todo <%d> status <%d> to send <%ld>\n", inet->handle, inet->todo, inet->status, inet->outbuf.used);
		}

		switch( inet->todo )
		{

			case INET_TODO_LISTEN:
				WatchingProccessPassive( inet );
				inet = InetSuivant( inet );
			break;
		
			case INET_TODO_USER_CONNECTING:
				do_loop = FALSE;
				inet->user_proc( inet->handle, INET_CONNECTING );
				do_loop = TRUE;
				inet->todo = INET_TODO_WAIT_ESTABLISH;
				inet = InetSuivant( inet );
			break;

			case INET_TODO_WAIT_ESTABLISH:
				WatchingLogin( inet );
				inet = InetSuivant( inet );
			break;
			
			case INET_TODO_USER_CONNECTED :
				do_loop = FALSE;
			 	inet->status = inet->user_proc( inet->handle, INET_CONNECTED );
				do_loop = TRUE;
				if ( inet->status == INET_STATUS_FINISH )
					inet->todo = INET_TODO_SENDKILL;
				else if ( inet->status == INET_STATUS_KILL )
					inet->todo = INET_TODO_TOKILL;
				else
					inet->todo = INET_TODO_SENDRECV;
				inet = InetSuivant( inet );
			break;
			
			case INET_TODO_USER_CONTACTED :
				do_loop = FALSE;
			 	inet->status = inet->user_proc( inet->handle, INET_CONTACTED );
				do_loop = TRUE;
				if ( inet->status == INET_STATUS_FINISH )
					inet->todo = INET_TODO_SENDKILL;
				else
					inet->todo = INET_TODO_SENDRECV;
				inet = InetSuivant( inet );
			break;

			case INET_TODO_SENDRECV :
				
				if ( (inet->outbuf.used > 0L) || (inet->fileout_handle > 0) )	/* Priorit  l'envoi */
				{
					if ( inet->status >= 0 )
						Watching_Read_File( inet );
					if ( inet->status >= 0 )
						WatchingSendActive( inet );
					if ( inet->status >= 0 )
						WatchingGetActive( inet );
				}
				else
				{
					if ( inet->status >= 0 )
						WatchingGetActive( inet );
				}
				
				if ( (inet->inbuf.used > 0L) && (inet->status >= 0) )
				{
					do_loop = FALSE;
					inet->status = inet->user_proc( inet->handle , INET_DATA );
					do_loop = TRUE;
				}

				/* status user vers status internes */

				if ( inet->status != INET_STATUS_CONTINUE )
				{
					if ( inet->status == INET_STATUS_FINISH )
					{
#ifdef __DEBUG__
				fprintf( stderr,">>> Il reste encore %ld donnes a envoyer\n", inet->outbuf.used);
#endif
						inet->todo = INET_TODO_SENDKILL;
						inet->status = INET_STATUS_CONTINUE;
					}
					else if ( inet->status == INET_STATUS_KILL )
					{
						inet->todo = INET_TODO_TOKILL;
						inet->status = INET_LEAVED;
					}
					else	/* erreur STinG */
					{
						inet->todo = INET_TODO_TOKILL;
/*					inet->status = INET_STATUS_CONTINUE; ?? */
					}
				}
				else /* if ( inet->status >= 0 ) */ /* Nouveau */
				{
					do_loop = FALSE;
					inet->status = inet->user_proc( inet->handle, INET_TIMER );
					do_loop = TRUE;
				}
				inet = InetSuivant( inet );
			break;
			
			case INET_TODO_SENDKILL :
#ifdef __DEBUG__
				fprintf( stderr,">>> Il reste encore %ld donnes a envoyer\n", inet->outbuf.used);
#endif
				if ( (inet->outbuf.used > 0L) || (inet->fileout_handle > 0) )
				{
					if ( inet->status >= 0 ) /* Nouveau */
						Watching_Read_File( inet );
					if ( inet->status >= 0 )	/* Nouveau */
						WatchingSendActive( inet );
					inet = InetSuivant( inet );
				}
				else
				{
					inet->todo = INET_TODO_TOKILL;
					inet->status = INET_LEAVED;
				}
			break;
			
			case INET_TODO_TOKILL :
				inet->timeout=clock()+TIMEOUT_ACK*CLK_TCK;
				inet->todo = INET_TODO_WAIT_ACK;
			break;
			
			case INET_TODO_WAIT_ACK :
				if ( WatchingLogoff( inet ) == TRUE )
				{
					inet->timeout=clock()+TIMEOUT_CLOSE*CLK_TCK;
					inet->todo = INET_TODO_WAIT_CLOSE;
				}
				inet = InetSuivant( inet ); /* Hummm.... */
			break;
			
			case	INET_TODO_WAIT_CLOSE :

				if ( 	InetWaitCloseNetwork( inet ) == TRUE )
				{
					if ( inet->status == INET_STATUS_KILL )
					{
						do_loop = FALSE;
						inet->user_proc( inet->handle, INET_LEAVED );
						do_loop = TRUE;
					}
					else
					{
						if ( inet->status == E_EOF )	inet->status = 	INET_LEAVE;	/* Nouveau */
						do_loop = FALSE;
						inet->user_proc( inet->handle, inet->status );
						do_loop = TRUE;
					}
					inet =	InetFreeMem( inet );
				}
				else
				{
					inet = InetSuivant( inet );
				}
					
				break;

			default :
#ifdef __DEBUG__
				fprintf( stderr,"WATCHING.C very unknown work <%d>", inet->todo);
#endif
				inet = InetSuivant( inet );
			break;
		}
	}	/* while inet != NULL */
		
 debug_call --;
 do_loop = FALSE;
}

#ifdef USE_TIMER_CALL

VOID cdecl WatchingTimer( VOID )
{
static INET		*inet = NULL;
static debug_call = 0;

	if ( do_loop == TRUE )
	{
		return;
	}
	
	do_loop = TRUE;
	
	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingTimer\n");
		debug_call--;
		do_loop = FALSE;
		return;
	}
	
	if ( 	stik_network_ready != TRUE )
	{
	 debug_call --;
	 do_loop = FALSE;
	 return;
	}

	if ( inet == NULL )
		inet = tete_inet;

	if( inet != NULL )
	{
		if ( inet->type == INET_ACTIVE )
		{
			switch( inet->status )
			{
				case INET_USER_CONTINUE :
					WatchingGetActive( inet );
				case INET_USER_FINISH :
					WatchingSendActive( inet );
					break;
			}
		}
		inet = InetSuivant( inet );
	}

	debug_call --;
	do_loop = FALSE;
}

#endif

LOCAL INET	*WatchingProccessPassive( INET	*inet )
{
INT ret;
static debug_call = 0;
NDB     *ndb;
CIB			*cib;
   
	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingProccessPassive\n");
		debug_call--;
		return(inet);
	}

	if ( inet == NULL )
	{
		debug_call--;
		return(NULL);
	}
	
	if ( (inet->type != INET_TYP_PASSIVE_MONO) && (inet->type != INET_TYP_PASSIVE_MULTI) )
	{
		debug_call--;
		return(inet);
	}

/*

Le nouveau module UDP serait capable d'tre gr comme TCP
mais voila, il reste en E_LISTEN tant que le client n'envoi pas de
donne... :(

J'ai l'impression que meme l'ancienne methode () retourne un pointeur
NULL si aucune donne n'est presente. Mais ma methode est peut-tre
en cause, seul un cib present devrait detecter un client par
cib->address.rport mais ce module UDP ne fixe pas le CIB tant
qu'aucune donne n'est presente.

Donc dans le cas d'un serveur time, rien ne se passe !


>c'est normal dans le proto UDP !

*/



	if ( inet->protocol == INET_TCP )
	{
		ret = CNbyte_count(inet->handle);
	}
	else if ( inet->protocol == INET_UDP )
	{
		if ( UDP_VERSION >= 144 )
		{
			if ( inet->protocol == INET_TCP )
				ret = CNbyte_count(inet->handle);
			else if ( inet->protocol == INET_UDP )
			{
				ret = CNbyte_count(inet->handle);
			}
		}
		else
		{
			cib = CNgetinfo( inet->handle );
			if ( cib == NULL )							/* Problme, handle referm ? */
			{
				UDP_close( inet->handle );		/* Scurit */
				ret = E_BADHANDLE;
			}
			else
			{
				ndb = CNget_NDB (inet->handle);
				if ( ndb != NULL )
					ret = ndb->len;
				else
				{
					ret = E_LISTEN;
				}
			}
		}
	}


	if ( ret  >= 0 ) /* connect */
	{
		/* Crer un nouveau inet si INET_PASSIVE_MULTI */

		if( inet->type == INET_TYP_PASSIVE_MULTI )
		{
			Inet_MultiListen( 1, inet->type, inet->protocol, inet->port, inet->bufsize, inet->user_proc, inet->second);
		}

		/* Transformer en active l'ancien */
		
		if ( InetPassiveToActive(inet) != NULL )
		{
			inet->todo = INET_TODO_USER_CONTACTED;

			if ( UDP_VERSION < 144 )
			{

				/* Replacer les donnes UPD arrives */
	
				if ( inet->protocol == INET_UDP )
				{
					if ( ndb != NULL )
					{
						memcpy((UBYTE*)inet->inbuf.beg, ndb->ndata, ndb->len );
						((UBYTE*)inet->inbuf.beg)[ndb->len]=0;
						inet->inbuf.used = (LONG)ndb->len;
		  	    KRfree (ndb->ptr);
    			  KRfree (ndb);
    		  	ndb = NULL;
					}
				}
			}
		}
	}
	else if ( ( ret <0 ) && (ret != E_LISTEN ) ) /* erreur */
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "<%04d> !Warning on a listen handle <%s>, close & re-open..\n", inet->handle, get_err_text(ret) );
		InetUrgentCloseNetwork( inet );
		inet->handle = InetOpenNetwork( inet );
	}

	debug_call--;

return(inet);	
}

/* Dbut de connection active, TCP_wait_state(TESTABLISH) pour TCP */

LOCAL INT	WatchingLogin( INET	*inet )
{
static debug_call = 0;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingLogin\n");
		debug_call--;
		return(INET_STATUS_CONTINUE);
	}

	if ( inet == NULL )
	{
#ifdef __DEBUG__
		fprintf( stderr, "!WatchingLogin inet NULL\n");
#endif
		debug_call--;
		return(INET_STATUS_CONTINUE);
	}

	if	(	inet->todo != INET_TODO_WAIT_ESTABLISH )
	{
#ifdef __DEBUG__
			fprintf( stderr, "!WatchingLogin no INET_TODO_WAIT_ESTABLISH todo.\n");
#endif
		debug_call--;
		return(INET_STATUS_CONTINUE);
	}
		
	/* Connection en cours */

	if ( inet->protocol == INET_TCP )
	{

#ifdef	WAIT_TCP_TESTABLISH

#ifdef notdef

	INT test;
		
		test = TCP_wait_state ( inet->handle, TSYN_RECV, 10);
		
printf("WATCHING.C TCP_wait_state(TSYN_RECV) <%d>\n", test );

		if ( test < 0 )
		{
			inet->status = test;
			inet->todo = INET_TODO_TOKILL;
			debug_call--;
			return(inet->status);
		}

#endif

		inet->status = TCP_wait_state ( inet->handle, TESTABLISH, 1);

	#ifdef __DEBUG__
	printf("<%04d> WATCHING.C TCP_wait_state <%d><%s> data <%ld>\n", inet->handle, inet->status, get_err_text(inet->status), inet->inbuf.used );
	#endif

#else
		inet->status =	E_NORMAL;
#endif

		/* TCP.STX V1.14 on recois -4, RESET */
		/* On considre que E_RRESET c'est ok ? */
		
#ifdef	FIX_TCP114_RRESET_BUG
		if ( (inet->status >= 0) || (inet->status==E_RRESET) )
#else
		if ( inet->status >= 0 )
#endif

		{
			inet->todo = INET_TODO_USER_CONNECTED;
			if ( inet->second > INET_NO_TIMEOUT )
				inet->timeout=clock()+inet->second*CLK_TCK;
		}
		/* On ne l'attend plus, pas de rponse */
#ifdef	FIX_TCP114_RRESET_BUG
		else if ( ((inet->status == E_CNTIMEOUT )||(inet->status == E_RRESET )) && ( clock() > inet->timeout ) )
#else
		else if ((inet->status == E_CNTIMEOUT ) && ( clock() > inet->timeout ))
#endif
		{
			inet->todo = INET_TODO_TOKILL;
			debug_call--;
			return(inet->status);
		}
#ifdef	FIX_TCP114_RRESET_BUG
		else if ( (inet->status == E_CNTIMEOUT )||(inet->status == E_RRESET ) )	/* on attend */
#else
		else if ( inet->status == E_CNTIMEOUT )
#endif
		{
			inet->status = INET_STATUS_CONTINUE ;
			debug_call--;
			return(inet->status);
		}
		else	/* erreure */
		{
			inet->todo = INET_TODO_TOKILL;
			debug_call--;
			return(inet->status);
		}
	}
	else	/* UDP */
	{
		inet->todo = INET_TODO_USER_CONNECTED;
		inet->status = INET_STATUS_CONTINUE;
		if ( inet->second > INET_NO_TIMEOUT )
			inet->timeout=clock()+inet->second*CLK_TCK;
	}

	debug_call--;

return(INET_STATUS_CONTINUE);
}

/* Fin de connection , TCP_wait_ack pour TCP */

LOCAL BOOLEAN	WatchingLogoff( INET	*inet )
{
static debug_call = 0;
INT ret;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingLogoff\n");
		debug_call--;
		return( FALSE );
	}

	if ( inet == NULL )
	{
#ifdef __DEBUG__
			fprintf( stderr, "!WatchingLogoff inet NULL\n");
#endif
		debug_call--;
		return( FALSE );
	}

	if	(	inet->todo != INET_TODO_WAIT_ACK )
	{
#ifdef __DEBUG__
			fprintf( stderr, "!WatchingLogin no INET_TODO_WAIT_ACK todo.\n");
#endif
		debug_call--;
		return( FALSE );
	}
		
	if ( inet->protocol == INET_TCP )
	{

#ifdef USE_TCPACKWAIT_FUNCTION
		if( inet->is_sender == TRUE )
		{
			ret = TCP_ack_wait( inet->handle, 50);
			#ifdef __DEBUG__
			printf("<%04d> WATCHING.C TCP_ack_wait <%d><%s> data <%ld>\n", inet->handle, ret, get_err_text(ret), inet->inbuf.used );
			#endif
		}
		else	ret = E_NORMAL;
#else
		ret = E_NORMAL;
#endif

		if ( (ret == E_CNTIMEOUT ) && (clock() < inet->timeout) )	/* 	attend */
		{
			debug_call--;
			return( FALSE );
		}

	}

	debug_call--;

return( TRUE );
}

/* Lecture des donnes en entre */

LOCAL INET	*WatchingGetActive( INET	*inet )
{
INT len, ret, maxi;
static debug_call = 0;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingProccessActive\n");
		debug_call--;
		return(inet);
	}

	if ( inet == NULL )
	{
		debug_call--;
		return(NULL);
	}

	if	(	inet->todo != INET_TODO_SENDRECV )
	{
		debug_call--;
		return(inet);
	}
		
	len = CNbyte_count(inet->handle);

#ifdef notdef

	if ( inet->protocol == INET_UDP )
	{
	UDPIB udpib;
	int16	ret;
	
		udpib.request = UDPI_state;
		ret = UDP_info( inet->handle, &udpib );
		printf("<%04d> WATCHING.C <<DEBUG>> UDP UDP_info()=<%d>, udpib.state=<%d>\n", inet->handle, ret, udpib.state);
	
	}

#endif

#ifdef __DEBUG__
	printf("<%04d> WATCHING.C CNbyte_count=<%d><%s> data already stored=<%ld>\n", inet->handle, len, get_err_text(len), inet->inbuf.used );
#endif

	if ( len > 0 )
	{

		if ( inet->second > INET_NO_TIMEOUT )
			inet->timeout=clock()+inet->second*CLK_TCK;
			
		/*
		
			 on ne voit plus de dconnection !!! => bug tcp.stx
		   malgres un TCP_close du client, CNbyte_count retourne toujours
		   155 bytes !! voir avec CAB le TCP_close() utilis avec le
		   bouton "arret".
		
		*/
		
		maxi = min( (INT)(inet->inbuf.len-inet->inbuf.used-1), len ); /* 1 car de reserve (zro?) */
		
		if ( maxi > 0 )
		{
			
			ret = CNget_block(inet->handle,(UBYTE*)inet->inbuf.beg + inet->inbuf.used, maxi);

#ifdef __DEBUG__
	printf("<%04d> WATCHING.C CNget_block <%d><%s> data <%ld>\n", inet->handle, ret, get_err_text(ret), inet->inbuf.used );
#endif

			if ( ret > 0 )
			{
				inet->inbuf.used = inet->inbuf.used + ret;
				((UBYTE*)inet->inbuf.beg)[inet->inbuf.used] = '\0';	/* scurit */
			}
#ifdef	FIX_TCP114_RRESET_BUG
			else if ( ( ret < 0 ) && (ret != E_RRESET) )
#else
			else if (  ret < 0 )
#endif
			{
				inet->timeout=clock()+inet->second*CLK_TCK;
				/* C'est pas ici que l'on a le E_EOF si le client part */
				if ( len == E_EOF )
				{
					inet->status = INET_LEAVE;
					inet->todo = INET_TODO_TOKILL;	/* Nouveau , fait rien !*/
				}
				else
					inet->status = ret;
				debug_call--;
				return( inet );
			}

		}

#ifdef notdef	/* On ne prend rien */

		else
			fprintf( stderr, "! WARNING client buffer too small, contact author\n");

#endif

	} /* len > 0 */
#ifdef	FIX_TCP114_RRESET_BUG
	else if ( ( len < 0 ) && ( len != E_RRESET ) )
#else
	else if ( len < 0 )		/* Erreure STinG sur la connexion */
#endif
	{
		inet->outbuf.used = 0;	/* on n'envoi plus rien */
		inet->todo = INET_TODO_TOKILL;
		inet->status = len;
		debug_call--;
		return( inet );
	}
		
	/* timeout */
		
	else if ( (inet->second > INET_NO_TIMEOUT) && (len == E_NORMAL) && ( clock() > inet->timeout) )
	{
		/* au bout de 'inet->second' , le dconnecter */
		inet->outbuf.used = 0;	/* plus rien a envoyer */
		inet->todo = INET_TODO_TOKILL;
		inet->status = E_CNTIMEOUT;
		debug_call--;
		return( inet );
	}
	
	debug_call--;

return(inet);
}

/* Envoi des donnes en sortie */

INT WatchingSendActive( INET *inet )
{
INT ret = E_BADHANDLE;
INT to_send;
static debug_call = 0;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on WatchingSendActive\n");
		debug_call--;
		return(0);
	}

	if ( inet == (INET *)NULL )
	{
#ifdef __DEBUG__
		fprintf( stderr, "!Warning INET NULL on WatchingSendActive\n");
#endif
		debug_call--;
		return(E_NORMAL); /* c'est la bonne valeur a retourner ? */
	}

	if ( inet->todo < 0 )
	{
#ifdef __DEBUG__
		fprintf( stderr, "!Warning no todo negative <%d>\n", inet->todo);
#endif
		debug_call--;
		return(E_NORMAL); /* c'est la bonne valeur a retourner ? */
	}

	if ( inet->outbuf.used > 0L )
	{

		to_send = min((uint16)inet->outbuf.used,inet->bufsize);

#ifdef __DEBUG__
		printf("<%04d> WATCHING.C UDP/TCP_send <%d/%ld> bytes =>", inet->handle, to_send, inet->outbuf.used);
#endif

		if ( inet->protocol == INET_TCP )
			ret=TCP_send( inet->handle, inet->outbuf.beg, to_send );
		else if ( inet->protocol == INET_UDP )
			ret=UDP_send( inet->handle, inet->outbuf.beg, to_send );

#ifdef __DEBUG__
		printf("XXX_send return <%d><%s>\n", ret, get_err_text(ret));
#endif

		if ( ret == E_NORMAL )
		{

			inet->outbuf.used = inet->outbuf.used - to_send;

			memcpy(inet->outbuf.beg,(UBYTE*)inet->outbuf.beg+to_send,inet->outbuf.used);
			if ( inet->second > INET_NO_TIMEOUT )
				inet->timeout=clock()+inet->second*CLK_TCK; /* more 'second' timeout */
		}

/* E_RRESET n'arrive pas avec send, non ? */
/*	else if ( (ret != E_OBUFFULL) && (ret != E_RRESET) ) */

		/* Erreur */
		
		else if ( ret != E_OBUFFULL )
		{
			inet->outbuf.used = 0;	/* plus rien a envoyer */
			inet->todo = INET_TODO_TOKILL;
			if ( ret == E_EOF )
				inet->status = INET_LEAVE;
			else
				inet->status = ret;
			debug_call--;
			return( ret );
		}else ret = E_NORMAL; /* E_OBUFFULL pas tres grave ? */
	
	}
	else	/* rien  envoyer */
	{
		ret = E_NORMAL;
	}

	debug_call--;
	
return(INET_STATUS_CONTINUE);
}


/* Envoi du fichier ouvert */

LOCAL INT Watching_Read_File( INET *inet )
{
INT maxi;
static debug_call = 0;
LONG	ret;

	debug_call++;
	if ( debug_call > 1 )
	{
		if ( inet_debug_message == INET_USE_DEBUG )
			fprintf( stderr, "!Warning re-entrant on Watching_Read_File\n");
		debug_call--;
		return(E_NORMAL);
	}

	if ( inet == (INET *)NULL )
	{
#ifdef __DEBUG__
		fprintf( stderr, "!Warning INET NULL on Watching_Read_File\n");
#endif
		debug_call--;
		return(E_NORMAL); /* c'est la bonne valeur a retourner ? */
	}

	if ( (inet->todo != INET_TODO_SENDRECV)&&(inet->todo != INET_TODO_SENDKILL) )
	{
		debug_call--;
		return(E_NORMAL); /* c'est la bonne valeur a retourner ? */
	}

	if ( inet->fileout_handle < 0 )
	{
		debug_call--;
		return( E_NORMAL );
	}
	
	maxi = (INT)( inet->outbuf.len - inet->outbuf.used );

	if ( maxi > 0 )
	{
	LONG test;
	INT hi;
	
		test = Fread( inet->fileout_handle, (LONG)maxi, (VOID*)((UBYTE*)inet->outbuf.beg+inet->outbuf.used) );

		ret = (INT)test;
		hi = (INT)((test&0xFFFF0000L)>>16);
		
		/*
			 Hi peut renseigner sur le code d'erreur, ici par U:\ sur une link
		   on a une erreure hi = -36 malgrs un Fopen correct
		   C'est possiblement une erreur de BETADOS ?
		*/
		
		if ( ret > 0L )
			inet->outbuf.used = inet->outbuf.used + ret;
		else
		{
			Fclose(inet->fileout_handle);
			inet->fileout_handle = -1;
/*		if ( (hi < 0) && (inet_debug_message == INET_USE_DEBUG) ) */
			if ( hi < 0 )
				fprintf( stderr, "INET.LIB>>!Warning Fread return an error <%d>\n", hi);
		}
	}

	debug_call--;
return( E_NORMAL );	/* ?! */
}

VOID WatchingClose( VOID )
{
INET *inet;

	if ( 	stik_network_ready != TRUE ) return;

	inet = tete_inet;

	while( inet != NULL )
	{
		InetUrgentCloseNetwork( inet );
		inet =	InetFreeMem( inet );
	}

}

/* ---          EOF                 --- */
