;----------------------------------------------------------------------------
;File name:	UDP_SUBS.S			Revision date:	1999.09.22
;Revised by:	Ulf Ronald Andersson		Creation start:	1999.09.22
;Created by:	Peter Rottengatter		Creation date:	1997.03.11
;----------------------------------------------------------------------------
;Purpose:	Support functions for STinG UDP protocol
;----------------------------------------------------------------------------
	.include	"uran\struct.sh"	;PASM adapted structures
	.include	"sting\sys\udp.sh"
;----------------------------------------------------------------------------
	.export	wait_flag	;Function for waiting for semaphore
	.export	req_flag	;Function for requesting semaphore
	.export	rel_flag	;Function for releasing semaphore
;-------------------------------------
	.export	dis_intrpt	;Function for disabling interupts
	.export	en_intrpt	;Function for enabling interupts
;-------------------------------------
	.export	get_pending	;Function for getting pending data
;-------------------------------------
	.export	check_sum	;Function for checksumming data
;-------------------------------------
	.export	illegal		;AMON breakpoint function
	.export illegal_n	;AMON D0 flagged breakpoint function
;-------------------------------------
	.export	pe_poll_work	;protect_exec called by poll_receive
	.import	timer_work	;reached through poll_work in super mode
;-------------------------------------
	.export	pe_prev_conn	;search list for ptr to conn
	.import	root_list	;list for pe_prev_conn to search
;-------------------------------------
	.export	pe_unlink_conn	;removes a connection from active list
;----------------------------------------------------------------------------
pe_unlink_conn:	;int32 cdecl pe_unlink_conn(CONNEC * conn)
	move.l	4(sp),d1		;d1 = conn
	lea	root_list,a0		;a0.prev = &root_list
	bra.s	.next
;-------
.loop:
	cmpa.l	d1,a1			;is a1.work the one we seek ?
	beq.s	.found			;then goto .found
	lea	CONN_next(a1),a0	;a0.prev = &work->next
.next:
	move.l	(a0),a1			;a1.work = *a0.prev			
	move.l	a1,d0			;a1.work <= 0 ?
	bgt.s	.loop			;loop until list end
.fail:
	move.l	d0,a0			;ret_val = list end mark
	rts				;return (ret_val)
;-------
.found:
	move.l	CONN_next(a1),(a0)	;*prev = work->next  unlink conn
	move.l	a0,d0			;ret_val = prev
	rts				;return (ret_val)
;----------------------------------------------------------------------------
pe_poll_work:	;int32 cdecl poll_doit (CONNEC *conn,uint16 old_status);
	move	8(sp),d0	;d0 = pre_protection sr
	or	#$2000,d0	;set super bit
	move	d0,sr		;int_mask = pre_protection int_mask
	move.l	4(sp),a0	;a0 = CONNEC *connec  for timer_work
	jmp	timer_work
;----------------------------------------------------------------------------
;void	illegal(void)
;void	illegal_n(int16)
;-------------------------------------
illegal:
illegal_n:
;;;patch	illegal
;;;patch	rts
;-------------------------------------
;end of functions illegal_n & illegal
;----------------------------------------------------------------------------
wait_flag:
	tas	(a0)		;Test semaphor, and set bit 7
	bne	wait_flag	;Was set ? Then loop
	or.b	#$ff, (a0)	;Now the lock is ours
	rts			;return
;-------------------------------------
req_flag:
	move.l	#1, d0		;Preset TRUE in case of lock
	tas	(a0)		;Test semaphor, and set bit 7
	bne	denied		;Was set ? Return TRUE
	or.b	#$ff, (a0)	;Now the lock is ours
	clr.l	d0		;And return FALSE
denied:
	nop
	rts			;return
;-------------------------------------
rel_flag:
	clr.b	(a0)		;Clear semaphor
	rts			;return
;----------------------------------------------------------------------------
dis_intrpt:
	move.w	sr,status	;Save CPU status
	or.w	#$0700,sr	;Disable interupts
	rts			;return
;-------------------------------------
en_intrpt:
	move.w	status,sr	;Restore CPU status
	rts			;return
;-------------------------------------
status:	dc.w	0		;CPU status
;----------------------------------------------------------------------------
get_pending:
	move.w	sr,-(sp)	;Save CPU status
	or.w	#$0700,sr	;Disable interupts
	move.l	(a0),-(sp)	;Get value
	clr.l	(a0)		;And reset it
	move.l	(sp)+,a0	;Return value
	move.w	(sp)+,sr	;Restore CPU status
	rts			;return
;----------------------------------------------------------------------------
check_sum:
	and.b	#$ef,ccr	;Clear extended carry
	addx.l	d1,d0		;Add dest_ip to src_ip
	move.l	#$110000,d1	;Prepare UDP pseudo header word
	move.w	d2,d1		;Length for pseudo header word
	addx.l	d1,d0		;Add it to accumulator
	clr.l	d1		;For adding carries
	addx.l	d1,d0		;Add carry to the accumulator
	move.b	d2,remain	;Save last two bits of length
	and.l	#$ffff,d2	;Extend to longword
	move.l	d2,d1		;Save length
	lsr.l	#6,d1		;Length by 64 is loop count
	and.l	#$3c,d2		;Find fraction of a chunk (loop)
	neg.l	d2		;Negate to offset beyond loop body
	and.b	#$ef,ccr	;Clear extended carry
	lea	lp_end,a1	;End of loop body
	jmp	(a1,d2)		;Jump into loop
;-------------------------------------
loop:
	move.l	(a0)+,d2	;Fetch  1st longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  2nd longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  3rd longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  4th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  5th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  6th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  7th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  8th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch  9th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 10th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 11th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 12th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 13th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 14th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 15th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
	move.l	(a0)+,d2	;Fetch 16th longword (4 bytes)
	addx.l	d2,d0		;Add it to accumulator
lp_end:
	dbra	d1,loop		;Loop it
;-------
	move.l	d0,d1		;Save high word
	swap	d1		;Transfer it to low word
	addx.w	d1,d0		;Add both words
	btst	#1,remain	;Do we have 2 or 3 remaining bytes ?
	beq	no_word		;No ...
	move.w	(a0)+,d2	;Else fetch another word
	addx.w	d2,d0		;And add it to the accumulator
no_word:
	btst	#0,remain	;Do we have another remaining byte ?
	beq	no_byte		;No ...
	move.w	(a0)+,d2	;Else fetch another word
	clr.b	d2		;But only use upper byte
	addx.w	d2,d0		;And add it to the accumulator
no_byte:
	clr.w	d2		;For adding carries
	addx.w	d2,d0		;Add carry to the accumulator
	addx.w	d2,d0		;Again if another overflow
	and.l	#$ffff,d0	;And truncate to word length
	eor.w	#$ffff,d0	;Invert the result
	bne	chk_ok		;Is it non-Zero ?
	move.w	#$ffff,d0	;No : Use -0 instead
chk_ok:
	nop			;Done
	rts			;Return
;-------------------------------------
remain:     ds.w	1	;Storage for last two length bits
;----------------------------------------------------------------------------
            .end
;----------------------------------------------------------------------------
;End of file:	UDP_SUBS.S
;----------------------------------------------------------------------------
