/*--------------------------------------------------------------------------*/
/*	File name:	UDP.H							Revision date:	1999.10.14	*/
/*	Revised by:	Ulf Ronald Andersson			Revision start:	1999.09.22	*/
/*	Created by:	Peter Rottengatter				Creation date:	1996.xx.xx	*/
/*--------------------------------------------------------------------------*/
/*	Included into the UDP.STX source code files								*/
/*--------------------------------------------------------------------------*/
#ifndef UDP_H
#define UDP_H
/*--------------------------------------------------------------------------*/
/*	Macros to handle DEFER state and semaphore switching					*/
/*--------------------------------------------------------------------------*/
#define	BEG_lock(x,y,z)		/* args: conn, int16_f, uint32_time */\
	if	(	(y = req_flag (& (x)->sema)) != 0\
		&&	(!((x)->flags & DEFER))\
		&&	(!(protect_exec(NULL, pe_get_imask)&0x0200))\
		)\
	{	uint32	temptime = TIMER_now();\
		while	(	((y = req_flag (& (x)->sema)) != 0)\
				&&	TIMER_elapsed(temptime) < (z)\
				)\
			_appl_yield();\
	}\
	if	(y)\
		return(E_LOCKED)
/*----------------------------------*/
#define	IF_lock(x,y,z)		/* args: conn, int16_f, uint32_time */\
	if	(	(y = req_flag (& (x)->sema)) != 0\
		&&	(!((x)->flags & DEFER))\
		&&	(!(protect_exec(NULL, pe_get_imask)&0x0200))\
		)\
	{	uint32	temptime = TIMER_now();\
		while	(	((y = req_flag (& (x)->sema)) != 0)\
				&&	TIMER_elapsed(temptime) < (z)\
				)\
			_appl_yield();\
	}\
	if	(y)\
/*----------------------------------*/
#define	TRY_lock(x)		req_flag (& (x)->sema)
#define	END_lock(x)		rel_flag (& (x)->sema)
/*--------------------------------------------------------------------------*/
/*	UDP header and chain link structure.									*/
/*--------------------------------------------------------------------------*/
typedef  union header
{	struct
	{	uint16	source_port;	/* Source UDP port						*/
		uint16	dest_port;		/* Destination UDP port					*/
		uint16	length;			/* UDP length of data					*/
		uint16	checksum;		/* UDP checksum							*/
	}	udp;					/* Structure when used as net packet	*/
	struct
	{	union header	*next;	/* Link to next data block in chain		*/
		uint16			length;	/* Amount of data in this block			*/
		uint16			index;	/* Index to data start in this block	*/
	}	chain;					/* Structure when used as queued data	*/
}	UDP_HDR;
/*--------------------------------------------------------------------------*/
/*	UDP connection structure.												*/
/*--------------------------------------------------------------------------*/
typedef  struct connec
{	uint32	remote_IP_address;	/* Foreign socket IP address			*/
	uint16	remote_port;		/* Foreign socket port number			*/
	uint32	local_IP_address;	/* Local socket IP address				*/
	uint16	local_port;			/* Local socket port number				*/
	uint8	state;				/* state of the connection (1==ULISTEN)	*/
	uint8	flags;				/* special flags for connection			*/
	int16	ttl;				/* Time To Live (for IP)				*/
	uint32	total_data;			/* Total real data in queue				*/
	CIB		*info;				/* Connection information link			*/
	int16	net_error;			/* Error to be reported with next call	*/
	UDP_HDR	*receive_queue;		/* Receive queue						*/
	UDP_HDR	*pending;			/* Pending IP datagrams					*/
	int16	sema;				/* Semaphore for locking structures		*/
	uint32	last_work;			/* Last time work has been done			*/
	struct	connec  *next;		/* Link to next connection in chain		*/
}	CONNEC;
/*--------------------------------------------------------------------------*/
/*	UDP connection states.													*/
/*--------------------------------------------------------------------------*/
#define	ULISTEN		1	/* Wait for remote request						*/
#define	UESTABLISH	4	/* Connection established, packet received		*/
/*--------------------------------------------------------------------------*/
/*	Values for flags in CONNEC.												*/
/*--------------------------------------------------------------------------*/
#define	DEFER		128			/* Flag indicating deferred call methods	*/
/*--------------------------------------------------------------------------*/
#endif /* UDP_H */
/*--------------------------------------------------------------------------*/
/* End of file:		UDP.H													*/
/*--------------------------------------------------------------------------*/
