/*
	CHKSUMW2.S                                      Version 980425
	
	Internet checksum algorithm for UDP/IP and TCP/IP (uses D3-D7)
	
	Copyright (c) 1998,1999 Stefan Willer <willer@wtal.de>
	
	
	Peter Rottengatter and Ulf Ronald Andersson	are granted
	the right to include this code with any version of their
	IP stack STinG that is distributed free of charge.
	
	
	While this piece of code has been carefully designed and
	tested over a long period of time, the author will not be
	held responsible for any damages resulting from its use.
*/

	GLOBL chksum_w2

	SUM_PSEUDO = 1		/* sum up pseudo header (switch off for testing) */
IF	PROTOCOL=P_UDP
	UDP_ZERO = 1		/* transmit zero check sum as -0 (UDP) */
ELSE
	UDP_ZERO = 0		/* transmit zero check sum as +0 (TCP) */
ENDIF

/*
	MODULE USAGE (TCP)

		P_TCP    = 6
		P_UDP    = 17
		PROTOCOL = P_TCP
		INCLUDE  "chksumw2.s"


	MODULE USAGE (UDP)

		P_TCP    = 6
		P_UDP    = 17
		PROTOCOL = P_UDP
		INCLUDE  "chksumw2.s"


	REGISTER USAGE
	
	On entry:
	
		A0	addr of packet
		D0	src IP quad from IP header
		D1	dst IP quad from IP header
		D2	size of packet, 16 bits (high word is discarded)
	
	On exit:
	
		D0	check sum, 16 bits, high word is zero
	

	MEMORY USAGE
	
	No memory is accessed, except for the data proper
	and 20 bytes of stack space


	C LANGUAGE PROTOTYPE

	ULONG chksum_w2( UBYTE *addr, ULONG src, ULONG dst, ULONG cnt );
	
	
	REFERENCES
	
	RFC768, RFC1071, RFC1624
	
	
	CAUTION:
	
	This code has been carefully designed to make full use of
	Motorola 68k semantics. Any changes will probably break it.
	
	You have been warned!
*/

chksum_w2:
	MOVEM.L	D3-D7,-(A7)
IF	SUM_PSEUDO
/*
	sum up pseudo header (src, dst, cnt, PROTOCOL)
*/
	ADD.L	D1,D0
	MOVEQ.L	#PROTOCOL,D1
	ADDX.W	D2,D1
	ADDX.L	D1,D0
	MOVEQ.L	#0,D1
	ADDX.L	D1,D0
ELSE
	CLR.L	D0
	CLR.L	D1
ENDIF
	MOVE.W	D2,D1			; D1=0000000000000000xxxxxxxxxxxxxxxx
	MOVEQ.L	#$3C,D2			; D2=00000000000000000000000000111100
	AND.B	D1,D2			; D2=00000000000000000000000000xxxx00
	EOR.B	D2,D1			; D1=0000000000000000xxxxxxxxxx0000xx
	NEG.W	D2				; X=0 or X=1
	ROXR.L	#6,D1			; D1=000xxX0000000000000000xxxxxxxxxx, X=0
	JMP		.base(PC,D2.W)
	REPT	16
	MOVE.L	(A0)+,D2
	ADDX.L	D2,D0
	ENDM
.base:
	BRA.B	.entry
.loop:
REPT 2
	MOVEM.L	(A0)+,D2-D7
	ADDX.L	D2,D0
	ADDX.L	D3,D0
	ADDX.L	D4,D0
	ADDX.L	D5,D0
	ADDX.L	D6,D0
	ADDX.L	D7,D0
ENDM
	MOVEM.L	(A0)+,D2-D5
	ADDX.L	D2,D0
	ADDX.L	D3,D0
	ADDX.L	D4,D0
	ADDX.L	D5,D0
.entry:
	DBRA.W	D1,.loop
	MOVE.L	D0,D2
	SWAP	D0
	ADDX.W	D0,D2
	BTST.L	#28,D1
	BEQ.B	.word
	MOVE.W	(A0)+,D0
	ADDX.W	D0,D2
.word:
	BTST.L	#27,D1
	BEQ.B	.byte
	MOVE.W	(A0)+,D0
	CLR.B	D0
	ADDX.W	D0,D2
.byte:
	MOVEQ.L	#0,D0
	ADDX.W	D0,D2
	MOVE.W	D2,D0
	NOT.W	D0
IF	UDP_ZERO
/*
	zero checksum is transmitted as -0 = 0xFFFF for UDP
*/
	BNE.B	.done
	NOT.W	D0
.done:
ENDIF
	MOVEM.L	(A7)+,D3-D7
	RTS
