/*
	UDP.S
	
	Optimized UDP/IP module for STinG
	
	Copyright (c) 1998 Peter Rottengatter
	Copyright (c) 1998 Stefan Willer
	
	References:
	
		RFC768	User Datagram Protocol
		RFC792	Internet Control Message Protocol
*/

	OPTI = 1	/* switch off to get Peter's original code */
	
	
	EXPORT	main
	
	IMPORT	_BasPag
	IMPORT	_PgmSize

	IMPORT	strcmp
	IMPORT	memcpy
	IMPORT	Ptermres
	IMPORT	Cconws
	IMPORT	Supexec


	P_ICMP =  1
	P_TCP  =  6
	P_UDP  = 17

	PROTOCOL = P_UDP

	HNDLR_REMOVE =  2

	INCLUDE "structs.inc"
	INCLUDE "errors.inc"

           TEXT
           
/*
	int main( int argc, char *argv[] )
	
	Called by STinG with argument "STinG_Load"
*/
main:
           MOVE.L    A2,-(A7)
           MOVE.L    A3,-(A7)
           MOVEA.L   A0,A3
IF OPTI
           LEA.L     s_UDP(PC),A2
ELSE
           LEA.L     s_UDP,A2
ENDIF
           CMP.W     #$0002,D0		; (argc==2)?
           BNE       .L1
           LEA.L     $1D(A2),A1		; s_STinG_Load
           MOVEA.L   $0004(A3),A0
           BSR       strcmp
           TST.W     D0
           BEQ       .L2
IF OPTI
.L1:       LEA.L     s_Only_start_by_STinG(PC),A0
ELSE
.L1:       LEA.L     s_Only_start_by_STinG,A0
ENDIF
           BSR       Cconws
           BRA       .return
IF OPTI
.L2:       LEA.L     STiK_drvs(PC),A3
ELSE
.L2:       LEA.L     STiK_drvs,A3
ENDIF
           LEA.L     find_STiK(PC),A0
           BSR       Supexec
           MOVE.L    D0,(A3)
           TST.L     D0
           BEQ       .return
           LEA.L     $28(A2),A1		; s_STiKmagic
           MOVEA.L   D0,A0
           BSR       strcmp
           TST.W     D0
           BNE       .return
           PEA.L     $32(A2)		; s_TRANSPORT_TCPIP
           MOVEA.L   (A3),A0
           MOVEA.L   $000A(A0),A0
           JSR       (A0)			; tpl = get_dftab(TRANSPORT_DRIVER)
           ADDQ.W    #4,A7
           MOVE.L    D0,$0004(A3)
           PEA.L     $42(A2)		; s_MODULE_LAYER
           MOVEA.L   (A3),A0
           MOVEA.L   $000A(A0),A0
           JSR       (A0)			; mdl = get_dftab(MODULE_DRIVER)
           ADDQ.W    #4,A7
           MOVE.L    D0,$0008(A3)
           MOVE.L    $0004(A3),D1	; tpl
           BEQ       .return
           TST.L     D0				; mdl
           BEQ       .return
IF OPTI
           BSR.B     install
ELSE
           BSR.W     install		; ### word
ENDIF
           TST.W     D0
           BEQ       .return
           CLR.W     D1
           MOVE.L    _PgmSize,D0
           BSR       Ptermres
.return:   MOVEA.L   (A7)+,A3
           MOVEA.L   (A7)+,A2
           RTS
find_STiK:
           MOVEA.L   $05A0.W,A0
           BRA       .start
.loop:     CMPI.L    #'STiK',(A0)
           BNE       .next
           ADDQ.W    #4,A0
           MOVE.L    (A0),D0
           RTS
.next:     ADDQ.W    #8,A0
.start:    MOVE.L    (A0),D0
           BNE       .loop
           MOVEQ.L   #0,D0
           RTS
install:
           MOVEM.L   A2-A4,-(A7)
           SUBQ.W    #4,A7
IF OPTI
           LEA.L     tpl(PC),A2
ELSE
           LEA.L     tpl,A2
ENDIF
           CLR.W     -(A7)			; HNDLR_SET
           PEA.L     ICMP_UDP(PC)
           MOVEA.L   (A2),A0
           MOVEA.L   ICMP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           TST.W     D0
           BEQ       .return0
           CLR.W     -(A7)
           PEA.L     IP_UDP(PC)
           MOVEQ.L   #P_UDP,D0
           MOVE.W    D0,-(A7)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   IP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #8,A7
           TST.W     D0
           BNE       .L1
           MOVEQ.L   #HNDLR_REMOVE,D0
           MOVE.W    D0,-(A7)
           PEA.L     ICMP_UDP(PC)
           MOVEA.L   (A2),A0
           MOVEA.L   ICMP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           BRA       .return0
.L1:       CLR.W     -(A7)
           PEA.L     L0007D7E6(PC)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   TIMER_call(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           TST.W     D0
           BNE       .L2
           MOVEQ.L   #HNDLR_REMOVE,D0
           MOVE.W    D0,-(A7)
           PEA.L     ICMP_UDP(PC)
           MOVEA.L   (A2),A0
           MOVEA.L   ICMP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           MOVEQ.L   #HNDLR_REMOVE,D0
           MOVE.W    D0,-(A7)
           PEA.L     IP_UDP(PC)
           MOVEQ.L   #P_UDP,D1
           MOVE.W    D1,-(A7)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   IP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #8,A7
           BRA       .return0
.L2:       MOVEQ.L   #P_UDP,D0
           MOVE.W    D0,-(A7)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   PRTCL_announce(A0),A0
           JSR       (A0)
           ADDQ.W    #2,A7
           TST.W     D0
           BEQ       .L4
           MOVEQ.L   #HNDLR_REMOVE,D0
           MOVE.W    D0,-(A7)
           PEA.L     ICMP_UDP(PC)
           MOVEA.L   (A2),A0
           MOVEA.L   ICMP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           MOVEQ.L   #HNDLR_REMOVE,D0
           MOVE.W    D0,-(A7)
           PEA.L     IP_UDP(PC)
           MOVEQ.L   #P_UDP,D1
           MOVE.W    D1,-(A7)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   IP_handler(A0),A0
           JSR       (A0)
           ADDQ.W    #8,A7
           MOVEQ.L   #2,D0
           MOVE.W    D0,-(A7)
           PEA.L     L0007D7E6(PC)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   TIMER_call(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
.return0:  CLR.W     D0
           BRA       .return
.L4:
IF OPTI
           LEA.L     lay_desc(PC),A3
           MOVE.L    _BasPag(PC),$0018(A3)
ELSE
           LEA.L     lay_desc,A3
           MOVE.L    _BasPag,$0018(A3)
ENDIF
           PEA.L      (A7)
           CLR.L     -(A7)
           CLR.L     -(A7)
           MOVEA.L   $0004(A2),A0
           MOVEA.L   query_chains(A0),A0
           JSR       (A0)
           LEA.L     $000C(A7),A7
           BRA       .L6
.loop:     MOVEA.L   (A7),A0
           MOVE.L    $0014(A0),(A7)
.L6:       MOVEA.L   (A7),A0
           MOVE.L    $0014(A0),D0
           BNE       .loop
           MOVE.L    A3,        $0014(A0)
           MOVEA.L   (A2),A0
           MOVE.L    #L0007CFDA,$003C(A0)	; UDP_open
           MOVEA.L   (A2),A0
           MOVE.L    #L0007D104,$0040(A0)	; UDP_close
           MOVEA.L   (A2),A0
           MOVE.L    #L0007D1E0,$0044(A0)	; UDP_send
IF OPTI
           PEA.L     s_UDP_PORT(PC)
           MOVEA.L   (A2),A0
           MOVEA.L   getvstr(A0),A4
           JSR       (A4)
           MOVE.B    $0001(A0),D1
           BEQ.B     .L7
           CLR.W     $000A(A3)
           MOVEA.L   D0,A0
           BSR.B     ascii2word
           OR.W      D0,$000A(A3)
.L7:       PEA.L     s_UDP_ICMP(PC)
           JSR       (A4)
           ADDQ.W    #8,A7
           MOVEA.L   D0,A0
           ANDI.W    #$FFFE,$0008(A3)
           CMPI.B    #$30,(A0)
           BEQ.B     .L8
           ORI.W     #$0001,$0008(A3)
.L8:       MOVE.W    $000A(A3),D0
ELSE
           PEA.L     s_UDP_PORT
           MOVEA.L   (A2),A0
           MOVEA.L   getvstr(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   D0,A4
           MOVE.B    $0001(A4),D1
           BEQ       .L7
           ANDI.L    #$FFFF0000,$0008(A3)
           MOVEA.L   A4,A0
           BSR.W     ascii2word		; ### word
           MOVEQ.L   #0,D1
           MOVE.W    D0,D1
           OR.L      D1,$0008(A3)
.L7:       PEA.L     s_UDP_ICMP
           MOVEA.L   (A2),A0
           MOVEA.L   getvstr(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   D0,A4
           ANDI.L    #$FFFEFFFF,$0008(A3)
           CMPI.B    #$30,(A4)
           BEQ       .L8
           MOVE.L    #$00010000,D1
           BRA       .L9
.L8:       MOVEQ.L   #0,D1
.L9:       OR.L      D1,$0008(A3)
           MOVE.W    $000A(A3),D0
           AND.W     #$FFFF,D0			; ### Ahhh!
ENDIF
           MOVE.W    D0,$0008(A2)
           CMP.W     #$7530,D0
           BCS       .LA
           MOVE.W    #$752F,$0008(A2)
.LA:       MOVEQ.L   #1,D0
.return:   ADDQ.W    #4,A7
           MOVEM.L   (A7)+,A2-A4
           RTS

ascii2word:
           CLR.W     D0
           BRA       .start1
.loop1:    ADDQ.W    #1,A0
.start1:   CMPI.B    #' ',(A0)
           BEQ       .loop1
           BRA       .start2
.loop2:    MOVE.W    D0,D1
           LSL.W     #2,D1
           ADD.W     D0,D1
           ADD.W     D1,D1
           CLR.W     D2
           MOVE.B    (A0)+,D2
           ADD.W     #$FFD0,D2
           ADD.W     D2,D1
           MOVE.W    D1,D0
.start2:   CMPI.B    #'0',(A0)
           BCS       .return
           CMPI.B    #'9',(A0)
           BLS       .loop2
.return:   RTS

/*
	Called by UDP_open
*/
L0007CF78: MOVE.L    A2,-(A7)
           LEA.L     IRQoff(PC),A0
           BSR       Supexec
.loop:
IF OPTI
           LEA.L     lay_desc(PC),A0
           LEA.L     L0007DEE0(PC),A2
ELSE
           LEA.L     lay_desc,A0
           LEA.L     L0007DEE0,A2
ENDIF
           ADDQ.W    #1,    (A2)
           CMPI.W    #$7FFD,(A2)
           BHI       .L1
           MOVEQ.L   #0,D0
           MOVE.W    (A2),D0
IF OPTI
           MOVEQ.L   #0,D1
           MOVE.W    $000A(A0),D1
ELSE
           MOVE.L    $0008(A0),D1
           AND.L     #$0000FFFF,D1
ENDIF
           CMP.L     D1,D0			; ### CMP.W should do it
           BCC       .L2
.L1:       MOVE.W    $000A(A0),D0
IFF OPTI
           AND.W     #$FFFF,D0		; ### Ahhh!
ENDIF
           MOVE.W    D0,(A2)
.L2:       MOVEA.L   $003C(A0),A1
           BRA       .start2
.loop2:    MOVE.W    $000A(A1),D0
           CMP.W     (A2),D0
           BEQ       .break2
           MOVEA.L   $0026(A1),A1
.start2:   MOVE.L    A1,D0
           BNE       .loop2
.break2:   MOVE.L    A1,D0
           BNE       .loop
           LEA.L     IRQon(PC),A0
           BSR       Supexec
           MOVE.W    (A2),D0
           MOVEA.L   (A7)+,A2
           RTS
; uint16 cdecl UDP_open(uint32 host, uint16 port)
L0007CFDA: MOVEM.L   D2-D7/A2,-(A7)
           SUBQ.W    #6,A7
IF OPTI
           MOVEQ.L   #0,D3
           MOVE.W    $002A(A7),D7	; port
           MOVE.L    $0026(A7),D4	; host
           BNE.B     .L1
           TST.W     D7
           BNE.B     .L1
           BSR.B     L0007CF78
ELSE
           MOVE.L    $0026(A7),D4
           MOVE.W    $002A(A7),D7
           MOVEQ.L   #0,D3
           TST.L     D4
           BNE       .L1
           TST.W     D7
           BNE       .L1
           BSR.W     L0007CF78		; ### word
ENDIF
           MOVE.W    D0,D7
.L1:       TST.W     D7
           BEQ       .L6
           TST.L     D4
           BEQ       .L2
           BSR       L0007CF78
           MOVE.W    D0,D5
           BRA       .L3
.L2:       MOVE.W    D7,D5
.L3:       TST.L     D4
           BEQ       .L4
           MOVE.W    D7,D6
           BRA       .L5
.L4:       CLR.W     D6
.L5:       BRA       .L8
.L6:       MOVEA.L   D4,A2
           MOVE.L    $0004(A2),D4
           MOVE.W    $0002(A2),D6
           MOVE.L    $0008(A2),D3
           MOVE.W    (A2),D0
           BEQ       .L7
           MOVE.W    D0,D5
           BRA       .L8
.L7:       BSR       L0007CF78
           MOVE.W    D0,D5
.L8:       TST.L     D4
           BEQ       .LC
           CLR.L     -(A7)
           PEA.L     $0004(A7)
           PEA.L     $000A(A7)
           MOVE.L    D4,-(A7)
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_get_parameters(A0),A0
           JSR       (A0)
           LEA.L     $0010(A7),A7
           TST.W     D0
           BEQ       .L9
           MOVEQ.L   #E_UNREACHABLE,D0
           BRA       .return
.L9:       TST.L     D3
           BEQ       .LA
           MOVE.L    D3,D0
           BRA       .LB
.LA:       MOVE.L    $0002(A7),D0
.LB:       MOVE.L    D0,D3
.LC:       MOVEQ.L   #$2A,D0
           MOVE.L    D0,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   D0,A2
           TST.L     D0
           BEQ       .nomem
           PEA.L     cn_funcs
           MOVE.L    A2,-(A7)
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_request(A0),A0
           JSR       (A0)
           ADDQ.W    #8,A7
           MOVE.W    D0,D7
           ADDQ.W    #1,D0
           BNE       .LD
           MOVE.L    A2,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
.nomem:    MOVEQ.L   #E_NOMEM,D0
           BRA       .return
IF OPTI
.LD:       MOVE.L    D4,(A2)+
           MOVE.W    D6,(A2)+
           MOVE.L    D3,(A2)+
           MOVE.W    D5,(A2)+
           MOVE.W  (A7),(A2)+
           CLR.L        (A2)+
           CLR.L        (A2)+
           CLR.L        (A2)+
           CLR.L        (A2)+
           CLR.L        (A2)+
           CLR.L        (A2)+
           LEA.L     IRQoff(PC),A0
           BSR       Supexec
           MOVE.L    CNlist(PC),(A2)+
           LEA.L    -$2A(A2),A2
           MOVE.L    A2,CNlist
           LEA.L     IRQon(PC),A0
           BSR       Supexec
ELSE
.LD:       MOVE.L    D4,     (A2)
           MOVE.W    D6,$0004(A2)
           MOVE.L    D3,$0006(A2)
           MOVE.W    D5,$000A(A2)
           MOVE.W    (A7),$0C(A2)
           CLR.L        $000E(A2)
           CLR.L        $0012(A2)
           CLR.L        $0018(A2)
           CLR.L        $001C(A2)
           CLR.W        $0016(A2)
           CLR.W        $0020(A2)
;          CLR.L        $0022(A2)		### not initialized?!?
           LEA.L     IRQoff(PC),A0
           BSR       Supexec
           MOVE.L    CNlist,$0026(A2)
           MOVE.L    A2,CNlist
           LEA.L     IRQon(PC),A0
           BSR       Supexec
ENDIF
           MOVE.W    D7,D0
.return:   ADDQ.W    #6,A7
           MOVEM.L   (A7)+,D2-D7/A2
           RTS
; int16 cdecl UDP_close( int16 cn )
L0007D104: MOVEM.L   D2-D3/A2-A3,-(A7)
           SUBQ.W    #4,A7
           MOVE.W    $0018(A7),D3
           PEA.L     cn_funcs
           MOVE.W    D3,-(A7)
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_lookup(A0),A0
           JSR       (A0)
           ADDQ.W    #6,A7
           MOVE.L    D0,(A7)
           BNE       .L1
           MOVEQ.L   #E_BADHANDLE,D0
           BRA       .return
.L1:       LEA.L     IRQoff(PC),A0
           BSR       Supexec
IF OPTI
           LEA.L     CNlist(PC),A0
           BRA.B     .start
.loop:     CMPA.L    (A7),A1
           BEQ.B     .break
           LEA.L     $0026(A1),A0
.start:    MOVEA.L   (A0),A1
           MOVE.L    A1,D0
           BNE.B     .loop
           BRA.B     .L2
.break:    MOVE.L    $0026(A1),(A0)
.L2:
ELSE
           LEA.L     CNlist,A0
           MOVEA.L   (A0),A1
           BRA       .start
.loop:     CMPA.L    (A7),A1
           BEQ       .break
           LEA.L     $0026(A1),A0
           MOVEA.L   (A0),A1
.start:    MOVE.L    A1,D0
           BNE       .loop
.break:    MOVE.L    A1,D0
           BEQ       .L2
           MOVE.L    $0026(A1),(A0)
.L2:
ENDIF
           LEA.L     IRQon(PC),A0
           BSR       Supexec
           MOVEA.L   (A7),A0
           MOVE.L    $0012(A0),D0
           BEQ       .L3
           MOVE.L    D0,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A1
ELSE
           MOVEA.L   tpl,A1
ENDIF
           MOVEA.L   KRfree(A1),A0
           JSR       (A0)
           ADDQ.W    #4,A7
.L3:       MOVEA.L   (A7),A0
           MOVEA.L   $0018(A0),A3
           BRA       .start2
.loop2:    MOVEA.L   (A3),A2
           MOVE.L    A3,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   A2,A3
.start2:   MOVE.L    A3,D0
           BNE       .loop2
           MOVEA.L   (A7),A0
           MOVEA.L   $001C(A0),A3
           BRA       .start3
.loop3:    MOVEA.L   (A3),A2
           MOVE.L    A3,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   A2,A3
.start3:   MOVE.L    A3,D0
           BNE       .loop3
           MOVE.L    (A7),-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVE.W    D3,-(A7)
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_release(A0),A0
           JSR       (A0)
           ADDQ.W    #2,A7
           CLR.W     D0
.return:   ADDQ.W    #4,A7
           MOVEM.L   (A7)+,D2-D3/A2-A3
           RTS
; UDP_send( int16 cn, void *data, int16 length )
L0007D1E0: MOVEM.L   D2-D4/A2-A3,-(A7)
           MOVE.W    $001E(A7),D3			; length
IF OPTI
           PEA.L     cn_funcs(PC)
           MOVE.W    $001C(A7),-(A7)		; cn handle
           MOVEA.L   mdl(PC),A0
ELSE
           PEA.L     cn_funcs
           MOVE.W    $001C(A7),-(A7)		; cn handle
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_lookup(A0),A0	; get associated cn data
           JSR       (A0)
           ADDQ.W    #6,A7
           MOVEA.L   D0,A2
           TST.L     D0
           BNE       .L1
           MOVEQ.L   #E_BADHANDLE,D0
           BRA       .return
.L1:       MOVE.L    (A2),D0
           BNE       .L2
           MOVEQ.L   #E_LISTEN,D0
           BRA       .return
.L2:       MOVE.W    $0016(A2),D0
IFF OPTI
           TST.W     D0				; ###
ENDIF
           BPL       .L3
           CLR.W     $0016(A2)
           BRA       .return
.L3:       MOVEQ.L   #8,D4			; UDP hdr length
           ADD.W     D3,D4			; + UDP data length
IF OPTI
           MOVE.L    D4,-(A7)
           MOVEA.L   tpl(PC),A0
ELSE
           MOVE.W    D4,D0
           EXT.L     D0				; ### no sign!
           MOVE.L    D0,-(A7)
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)			; KRmalloc( packet size )
           ADDQ.W    #4,A7
IF OPTI
           MOVEA.L   D0,A0
           TST.L     D0
           BNE.B     .L4
           MOVEQ.L   #E_NOMEM,D0
           BRA.B     .return
.L4:       MOVEA.L   A0,A3
           MOVE.W    $000A(A2),(A0)+	; src port
           MOVE.W    $0004(A2),(A0)+	; dst port
           MOVE.W    D4,       (A0)+	; length
           CLR.W               (A0)+	; chksum
           MOVEQ.L   #0,D0
           MOVE.W    D3,D0
           MOVEA.L   $001A(A7),A1
           BSR.W     memcpy				; (returns dst addr)
           MOVE.W    D4,D2				; length
           SUBQ.L    #8,A0				; UDP packet addr
           MOVE.L         (A2),D1		; dst IP quad
           MOVE.L    $0006(A2),D0		; src IP quad
           BSR.W     chksum
           MOVE.W    D0,$0006(A3)		; chksum
ELSE
           MOVEA.L   D0,A3
           TST.L     D0
           BNE       .L4
           MOVEQ.L   #E_NOMEM,D0
           BRA       .return
.L4:       MOVE.W    $000A(A2),     (A3)	; src port
           MOVE.W    $0004(A2),$0002(A3)	; dst port
           MOVE.W    D4,       $0004(A3)	; length
           CLR.W               $0006(A3)	; chksum, ### use (A3)+
           MOVE.W    D3,D0
           EXT.L     D0						; ### no sign!
           MOVEA.L   $001A(A7),A1
           LEA.L               $0008(A3),A0	; data addr
           BSR       memcpy
           MOVE.W    $0004(A3),D2			; length, ### still in D4
           MOVEA.L   A3,A0					; UDP packet addr
           MOVE.L         (A2),D1			; dst IP quad
           MOVE.L    $0006(A2),D0			; src IP quad
           BSR       chksum
           MOVE.W    D0,$0006(A3)			; chksum
ENDIF
           CLR.W            -(A7)			; options length
           CLR.L            -(A7)			; options
           MOVE.W    D4,    -(A7)			; data length
           MOVE.L    A3,    -(A7)			; data
IF OPTI
           MOVE.W    IPident(PC),-(A7)
           ADDQ.W    #1,IPident
           MOVEQ.L   #P_UDP,D1
           MOVE.B    D1,    -(A7)			; UDP/IP
           MOVE.B    $D(A2),-(A7)			; TTL
           CLR.L            -(A7)			; don't frag / TOS
ELSE
           MOVE.W    IPident,D1
           ADDQ.W    #1,IPident
           MOVE.W    D1,    -(A7)			; ID
           MOVEQ.L   #P_UDP,D1
           MOVE.B    D1,    -(A7)			; UDP/IP
           MOVE.B    $D(A2),-(A7)			; TTL
           CLR.W            -(A7)			; don't frag, ### CLR.L
           CLR.B            -(A7)			; TOS
ENDIF
           MOVE.L      (A2),-(A7)			; dst
           MOVE.L    $6(A2),-(A7)			; src
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   IP_send(A0),A0
           JSR       (A0)
           LEA.L     $001E(A7),A7
IF OPTI
           MOVE.W    D0,D4
           BEQ.B     .L5
           MOVE.L    A3,-(A7)
           MOVEA.L   tpl(PC),A0
           MOVEA.L   check_dgram_ttl(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVE.W    D4,D0
.L5:
ELSE
           MOVE.W    D0,D4
           TST.W     D0						; ###
           BEQ       .L5
           MOVE.L    A3,-(A7)
           MOVEA.L   tpl,A0
           MOVEA.L   check_dgram_ttl(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
.L5:       MOVE.W    D4,D0
ENDIF
.return:   MOVEM.L   (A7)+,D2-D4/A2-A3
           RTS
; CNkick(cn)
IF OPTI
L0007D2D6: MOVE.L    D2,-(A7)
           MOVEA.L   $0008(A7),A0
           BSR.W     L0007D806
           BMI.B     .return
           CLR.W     D0
.return:   MOVE.L    (A7)+,D2
           RTS
ELSE
L0007D2D6: MOVE.L    D2,-(A7)
           MOVE.W    D3,-(A7)
           MOVEA.L   $000A(A7),A0
           BSR       L0007D806
           MOVE.W    D0,D3
           BPL       L0007D2E8
           BRA       L0007D2EA
L0007D2E8: CLR.W     D0
L0007D2EA: MOVE.W    (A7)+,D3
           MOVE.L    (A7)+,D2
           RTS
ENDIF
; CNbyte_count(cn)
IF OPTI
L0007D2F0: MOVE.L    D2,-(A7)
           MOVEA.L   $0008(A7),A0
           BSR.W     L0007D806
           BMI.B     .return
           MOVEA.L   $0008(A7),A0
           MOVE.W    $0010(A0),D0
.return:   MOVE.L    (A7)+,D2
           RTS
ELSE
L0007D2F0: MOVEM.L   D2-D3/A2,-(A7)
           MOVEA.L   $0010(A7),A2
           MOVEA.L   A2,A0
           BSR.W     L0007D806
           MOVE.W    D0,D3
           BPL       .retcnt
           BRA       .return
.retcnt:   MOVE.W    $0010(A2),D0
.return:   MOVEM.L   (A7)+,D2-D3/A2
           RTS
ENDIF
; int16 cdecl CNget_char(CN *cn)
IF OPTI
L0007D30E: MOVEM.L   D2-D3/A2-A3,-(A7)
           MOVEA.L   $0014(A7),A2		; cn
           MOVEA.L   A2,A0
           BSR.W     L0007D806
           BMI.B     .return
.lock:     TAS.B     $0020(A2)			; sema_set
           BNE.B     .lock
.loop:     MOVEA.L   $0018(A2),A3
           MOVE.L    A3,D0
           BEQ.B     .nodata
           MOVE.W    $0006(A3),D0
           CMP.W     $0004(A3),D0
           BCC.B     .free
           MOVEQ.L   #1,D1
           SUB.L     D1,$000E(A2)
           ADD.W     D1,$0006(A3)
           MOVE.W    D0,D1
           CLR.W     D3
           MOVE.B    $08(A3,D1.L),D3
           BRA.B     .break
.free:     MOVE.L    (A3),$0018(A2)
           MOVE.L    A3,-(A7)
           MOVEA.L   tpl(PC),A0
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           BRA.B     .loop
.nodata:   MOVEQ.L   #E_NODATA,D3
.break:    CLR.B     $0020(A2)			; sema_clr
           MOVE.W    D3,D0
.return:   MOVEM.L   (A7)+,D2-D3/A2-A3
           RTS
ELSE
L0007D30E: MOVEM.L   D2-D3/A2-A3,-(A7)
           MOVEA.L   $0014(A7),A2
           MOVEA.L   A2,A0
           BSR       L0007D806
           MOVE.W    D0,D3
           BPL       L0007D322
           BRA       L0007D37E
L0007D322: LEA.L     $0020(A2),A0
           BSR       sema_set
L0007D32A: MOVEA.L   $0018(A2),A3
           MOVE.L    A3,D0
           BEQ       L0007D374
           MOVE.W    $0006(A3),D0
           CMP.W     $0004(A3),D0
           BCC       L0007D35E
           SUBQ.L    #1,$000E(A2)
           MOVE.W    $0006(A3),D0		; ### still there
           ADDQ.W    #1,$0006(A3)
           MOVEQ.L   #0,D1
           MOVE.W    D0,D1
           CLR.W     D3
           MOVE.B    $08(A3,D1.L),D3
           LEA.L     $0020(A2),A0
           BSR       sema_clr
           MOVE.W    D3,D0
           BRA       L0007D37E
L0007D35E: MOVE.L    (A3),$0018(A2)
           MOVE.L    A3,-(A7)
           MOVEA.L   tpl,A0
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           BRA       L0007D32A
L0007D374: LEA.L     $0020(A2),A0
           BSR       sema_clr
           MOVEQ.L   #E_NODATA,D0
L0007D37E: MOVEM.L   (A7)+,D2-D3/A2-A3
           RTS
ENDIF
; NDB * cdecl CNget_NDB(CN *cn)
L0007D384: MOVEM.L   D2/A2-A5,-(A7)
           MOVEA.L   $0018(A7),A2	; cn
           MOVEA.L   A2,A0
           BSR       L0007D806
           TST.W     D0
           BMI       .return0
IF OPTI
.lock:     TAS.B     $0020(A2)			; sema_set
           BNE.B     .lock
.loop:
           LEA.L     tpl(PC),A4
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_set
.loop:
           LEA.L     tpl,A4
ENDIF
           MOVEA.L   $0018(A2),A3
           MOVE.L    A3,D0
           BEQ       .break
           MOVE.W    $0006(A3),D0
           CMP.W     $0004(A3),D0
           BCC       .L1
           MOVEQ.L   #$0E,D1
           MOVE.L    D1,-(A7)
           MOVEA.L   (A4),A0
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   D0,A5
           TST.L     D0
           BEQ       .break
           MOVE.L    A3,     (A5)
           MOVEQ.L   #0,D0
           MOVE.W    $0006(A3),D0
           LEA.L       $08(A3,D0.L),A0
           MOVE.L    A0,$0004(A5)
           MOVE.W    $0004(A3),D0
           SUB.W     $0006(A3),D0
           MOVE.W    D0,$0008(A5)
           CLR.L        $000A(A5)
           MOVE.L         (A3),$0018(A2)
           MOVEQ.L   #0,D0
           MOVE.W       $0008(A5),D0
           SUB.L     D0,      $000E(A2)
IF OPTI
           CLR.B              $0020(A2)			; sema_clr
ELSE
           LEA.L              $0020(A2),A0
           BSR       sema_clr
ENDIF
           MOVE.L    A5,D0
           BRA       .return
.L1:       MOVE.L         (A3),$0018(A2)
           MOVE.L    A3,-(A7)
           MOVEA.L   (A4),A0
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           BRA       .loop
.break:
IF OPTI
           CLR.B              $0020(A2)			; sema_clr
ELSE
           LEA.L              $0020(A2),A0
           BSR       sema_clr
ENDIF
.return0:  MOVEQ.L   #0,D0
.return:   MOVEM.L   (A7)+,D2/A2-A5
           RTS
; int16 cdecl CNget_block(CN *cn, void *block, int16 size)
L0007D428: MOVEM.L   D2-D5/A2-A4,-(A7)
           MOVEA.L   $0020(A7),A2	; cn
           MOVEA.L   $0024(A7),A4	; block
           MOVE.W    $0028(A7),D4	; size
           CLR.W     D3
           MOVEA.L   A2,A0
           BSR       L0007D806
           MOVE.W    D0,D5
           BPL       .L1
           BRA       .return
.L1:       TST.W     D4
           BNE       .L2
           CLR.W     D0
           BRA       .return
.L2:       MOVE.W    D4,D0
           EXT.L     D0
           CMP.L     $000E(A2),D0
           BHI       .L3
IF OPTI
.lock:     TAS.B     $0020(A2)			; sema_set
           BNE.B     .lock
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_set
ENDIF
.loop:     MOVEA.L   $0018(A2),A3
           MOVE.L    A3,D0
           BNE       .L4
IF OPTI
           CLR.B     $0020(A2)			; sema_clr
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_clr
ENDIF
.L3:       MOVEQ.L   #E_NODATA,D0
           BRA       .return
.L4:       MOVE.W    $0004(A3),D5
           SUB.W     $0006(A3),D5
           CMP.W     D4,D5
           BLE       .L5
           MOVE.W    D4,D0
           BRA       .L6
.L5:       MOVE.W    D5,D0
.L6:       MOVE.W    D0,D5
           EXT.L     D0
           MOVEQ.L   #0,D1
           MOVE.W    $0006(A3),D1
           LEA.L       $08(A3,D1.L),A1
           MOVEA.L   A4,A0
           BSR       memcpy
           ADDA.W    D5,A4
           ADD.W     D5,D3
           SUB.W     D5,D4
           ADD.W     D5,$0006(A3)
           MOVE.W    $0006(A3),D0
           CMP.W     $0004(A3),D0
           BCS       .L7
           MOVE.L    (A3),$0018(A2)
           MOVE.L    A3,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
.L7:       TST.W     D4
           BGT       .loop
           MOVE.W    D3,D0
           EXT.L     D0
           SUB.L     D0,$000E(A2)
IF OPTI
           CLR.B     $0020(A2)			; sema_clr
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_clr
           MOVE.W    D3,D0
ENDIF
.return:   MOVEM.L   (A7)+,D2-D5/A2-A4
           RTS
; CIB * cdecl CNgetinfo(CN *cn)
L0007D4E2: MOVE.L    D2,-(A7)
           MOVE.L    A2,-(A7)
IF OPTI
           MOVEA.L   $000C(A7),A2
           MOVE.L    $0012(A2),D0
           BNE.B     .L2
           MOVEQ.L   #$10,D1
           MOVE.L    D1,-(A7)
           MOVEA.L   tpl(PC),A0
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVE.L    D0,$0012(A2)
           BEQ.B     .return
           MOVEA.L   D0,A0
           CLR.W          $000E(A0)		; net_status = NORMAL
.L2:       MOVEA.L   D0,A0
           MOVE.W    #P_UDP,   (A0)+	; protocol = UDP
           MOVE.W    $000A(A2),(A0)+	; local port
           MOVE.W    $0004(A2),(A0)+	; remote port
           MOVE.L         (A2),(A0)+	; remote host
           MOVE.L    $0006(A2),(A0)+	; local host
ELSE
           MOVEA.L   $000C(A7),A2
           MOVE.L    $0012(A2),D0
           BNE       .L2
           MOVEQ.L   #$10,D1
           MOVE.L    D1,-(A7)
           MOVEA.L   tpl,A0
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVE.L    D0,$0012(A2)
           BNE       .L1
           MOVEQ.L   #0,D0					; ### already there
           BRA       .return
.L1:       MOVEA.L   $0012(A2),A0
           CLR.W               $000E(A0)
.L2:       MOVEA.L   $0012(A2),A0
           MOVE.W    #P_UDP,        (A0)
           MOVE.W    $000A(A2),$0002(A0)
           MOVE.W    $0004(A2),$0004(A0)
           MOVE.L         (A2),$0006(A0)
           MOVE.L    $0006(A2),$000A(A0)
           MOVE.L    A0,D0
ENDIF
.return:   MOVEA.L   (A7)+,A2
           MOVE.L    (A7)+,D2
           RTS
; int16 cdecl CNgets(CN *cn, char *buf, int16 buflen, char stop_ch)
L0007D53A: MOVEM.L   D2-D6/A2-A4,-(A7)
           SUBQ.W    #4,A7
           MOVEA.L   $0028(A7),A2	; cn
           MOVEA.L   $002C(A7),A4	; buf
           MOVE.W    $0030(A7),D4	; buflen
           MOVE.B    $0032(A7),D6	; stop_ch
           CLR.W     D3
           MOVEA.L   A2,A0
           BSR       L0007D806
           MOVE.W    D0,D5
           BPL       .L1
           BRA       .return
.L1:       MOVE.L    $000E(A2),D0
           BNE       .L2
           MOVEQ.L   #E_NODATA,D0
           BRA       .return
.L2:       CMP.W     #$0001,D4
           BGT       .L3
           MOVEQ.L   #E_BIGBUF,D0
           BRA       .return
.L3:
IF OPTI
.lock:     TAS.B     $0020(A2)			; sema_set
           BNE.B     .lock
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_set
ENDIF
           MOVEA.L   $0018(A2),A3
           BRA       .L6
.loop:     MOVEQ.L   #0,D0
           MOVE.W    $0006(A3),D0
           LEA.L       $08(A3,D0.L),A0
           CLR.W     D5
           BRA       .L4
.loop2:    CMP.B     (A0),D6
           BEQ       .L5
           MOVE.B    (A0)+,(A4)+
           ADDQ.W    #1,D5
           SUBQ.W    #1,D4
.L4:       MOVE.W    $0004(A3),D0
           SUB.W     $0006(A3),D0
           CMP.W     D0,D5
           BCC       .L5
           CMP.W     #$0001,D4
           BGT       .loop2
.L5:       ADD.W     D5,D3
           CLR.B     (A4)
           CMP.B     (A0),D6
           BEQ       .L7
           CMP.W     #$0001,D4
           BEQ       .L7
           MOVEA.L   (A3),A3
.L6:       MOVE.L    A3,D0
           BNE       .loop
.L7:       CMP.B     (A0),D6
           BEQ       .LA
IF OPTI
           CLR.B     $0020(A2)
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_clr
ENDIF
           CMP.W     #$0001,D4
           BNE       .L8
           MOVEQ.L   #E_BIGBUF,D0
           BRA       .L9
.L8:       MOVEQ.L   #E_NODATA,D0
.L9:       BRA       .return
.LA:       MOVEA.L   $0018(A2),A4
           BRA       .LC
.LB:       MOVE.L    (A4),(A7)
           MOVE.L    A4,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEA.L   (A7),A4
.LC:       CMPA.L    A4,A3
           BNE       .LB
           MOVE.L    A3,$0018(A2)
           MOVEQ.L   #1,D0
           ADD.W     D5,D0
           ADD.W     D0,$0006(A3)
           MOVEQ.L   #1,D1
           ADD.W     D3,D1
           EXT.L     D1
           SUB.L     D1,$000E(A2)
IF OPTI
           CLR.B     $0020(A2)
ELSE
           LEA.L     $0020(A2),A0
           BSR       sema_clr
ENDIF
           MOVE.W    D3,D0
.return:   ADDQ.W    #4,A7
           MOVEM.L   (A7)+,D2-D6/A2-A4
           RTS
/*
	Handler for incoming UDP/IP datagrams
	
	int16 cdecl IP_UDP( IP_DGRAM *dg )
*/
IP_UDP:    MOVEM.L   D2-D3/A2-A5,-(A7)
           LEA.L     -$000C(A7),A7
           MOVEA.L   $0028(A7),A2	; dg
           MOVEA.L   $001A(A2),A3	; pkt_data (UDP)
           MOVE.W    $0006(A3),D0	; UDP chksum (can be zero)
           BEQ       .L1
           MOVE.W    $0004(A3),D2	; UDP length
           MOVEA.L   A3,A0
IF OPTI
           MOVEM.L   $000C(A2),D0-D1	; IP src/dst host
           BSR       chksum
           ADDQ.W    #1,D0				; chksum is 0xFFFF, if packet is ok
ELSE
           MOVE.L    $0010(A2),D1		; IP dst host
           MOVE.L    $000C(A2),D0		; IP src host
           BSR       chksum
           CMP.W     #$FFFF,D0
ENDIF
           BEQ       .L1
* UDP packet is corrupt, drop it
           ADDQ.W    #1,lay_dropd
           BRA       .return1
.L1:
* Find a connection, that matches this packet
IF OPTI
           MOVEA.L   CNlist(PC),A4
ELSE
           MOVEA.L   CNlist,A4
ENDIF
           SUBA.L    A5,A5
           BRA       .start
.loop:     MOVE.W    $0002(A3),D0	; UDP dst port
           CMP.W     $000A(A4),D0	; CN local port
           BNE       .next
           MOVE.W    $0004(A4),D1	; CN remote port (may still be zero)
           BEQ       .L3
           MOVE.W         (A3),D2	; UDP src port (can be zero)
           CMP.W     D1,D2
           BNE       .next
.L3:       MOVE.L    $0006(A4),D0	; CN local host (may still be zero)
           BEQ       .L4
           MOVE.L    $0010(A2),D1	; IP dst host
           CMP.L     D0,D1
           BNE       .next
.L4:       MOVE.L         (A4),D0	; CN remote host (may still be zero)
           BEQ       .L5
           MOVE.L    $000C(A2),D1	; IP src host
           CMP.L     D0,D1
           BNE       .next
.L5:       MOVE.L    $0006(A4),D0	; CN local host
           BEQ       .L6
           MOVE.L         (A4),D1	; CN remote host
           BEQ       .L6
           MOVE.W    $0004(A4),D2	; CN remote port
           BNE       .break
.L6:       MOVEA.L   A4,A5
.next:     MOVEA.L   $0026(A4),A4
.start:    MOVE.L    A4,D0
           BNE       .loop
.break:    MOVE.L    A4,D0
           BNE       .L8
           MOVE.L    A5,D1
           BEQ       .L8
           MOVEA.L   A5,A4
           MOVE.L    $0010(A2),$0006(A4)	; lhost = dst host
           MOVE.L    $000C(A2),     (A5)	; rhost = src host
           MOVE.W         (A3),$0004(A4)	; rport = src port
           MOVE.L    $0012(A4),D0			; cib
           BEQ       .L7
           MOVEA.L   D0,A0
           MOVE.L    $0006(A4),$000A(A0)	; lhost
           MOVEA.L   $0012(A4),A0			; ### Ahhh!
           MOVE.L         (A5),$0006(A0)	; rhost
           MOVEA.L   $0012(A4),A0
           MOVE.W    $0004(A4),$0004(A0)	; rport
           MOVEA.L   $0012(A4),A0
           CLR.W               $000E(A0)	; status
.L7:       CLR.L               -(A7)		; (don't want MTU)
           PEA.L     $000C(A4)				; TTL *
           CLR.L               -(A7)		; (don't want lhost)
           MOVE.L    $000C(A2),-(A7)		; rhost
IF OPTI
           MOVEA.L   mdl(PC),A0
ELSE
           MOVEA.L   mdl,A0
ENDIF
           MOVEA.L   PRTCL_get_parameters(A0),A0
           JSR       (A0)
           LEA.L     $0010(A7),A7
.L8:       MOVE.L    A4,D0
           BNE       .L9
* no CN matches this packet, drop it
           ADDQ.W    #1,lay_dropd
* compose "destination unreachable" message
* including original IPv4 header, options, and UDP header
           MOVE.W    (A2),  D3
           LSR.W     #8,    D3
           AND.W     #$000F,D3		; IP hd_len
           LSL.W     #2,    D3
           ADD.W     #$000C,D3
           MOVEQ.L   #0,D1
           MOVE.W    D3,D1
           MOVE.L    D1,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRmalloc(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVE.L    D0,$0004(A7)
           MOVE.L    D0,(A7)
           BEQ       .return1
           MOVEA.L   D0,A0
           CLR.L     (A0)
           ADDQ.L    #4,(A7)
* copy IPv4 header
           MOVEQ.L   #$14,D0
           MOVEA.L   A2,A1
           MOVEA.L   (A7),A0
           BSR       memcpy
           ADDI.L    #$00000014,(A7)	; ### Ahhh!
* copy options
           MOVE.W    $0018(A2),D0		; opt_length
           EXT.L     D0					; ### no sign!
           MOVEA.L   $0014(A2),A1		; options
           MOVEA.L   (A7),A0
           BSR       memcpy
           MOVE.W    $0018(A2),D0		; opt_length
           EXT.L     D0
           ADD.L     D0,(A7)
* copy UDP header
           MOVEA.L   $001A(A2),A1		; pkt_data
           MOVEA.L   (A7),A0
           MOVEQ.L   #8,D0
           BSR       memcpy
* send "destination unreachable" message
           MOVE.W    D3,       -(A7)	; length
           MOVE.L    $0006(A7),-(A7)	; data, $0004(A7)
           MOVEQ.L   #3,D0
           MOVE.B    D0,       -(A7)	; code=3, port unreachable
           MOVE.B    D0,       -(A7)	; type=3, dst unreachable
           MOVE.L    $000C(A2),-(A7)	; dst host = src host
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   ICMP_send(A0),A0
           JSR       (A0)
           LEA.L     $000E(A7),A7
           MOVE.L    $0004(A7),-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   KRfree(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           BRA       .return1
.L9:
* Unlink UDP packet from IP datagram
           CLR.L     $001A(A2)		; pkt_data = NULL
* Add UDP packet to CN receive chain
IF OPTI
* ($0008(A7) is no longer used)
           LEA.L     $001C(A4),A5
           BRA.B     .start2
.loop2:    MOVEA.L   D0,A5
.start2:   MOVE.L   (A5),D0
           BNE.B     .loop2
           MOVE.L    A3,(A5)
           CLR.L        (A3)+	; next = NULL (actually src/dst port)
           SUBQ.W    #8,(A3)+	; length = UDP length - UDP hdr length
           CLR.W        (A3)	; chksum = 0
ELSE
           SUBQ.W    #8,$0004(A3)	; length = UDP length - UDP hdr length
           CLR.W        $0006(A3)	; chksum = 0
           CLR.L             (A3)	; next = NULL (actually src/dst port)
           LEA.L     $001C(A4),A5
           MOVE.L    (A5),$0008(A7)
           BRA       .start2
.loop2:    MOVEA.L   $0008(A7),A5
           MOVE.L    (A5),$0008(A7)
.start2:   MOVE.L    $0008(A7),D0
           BNE       .loop2
           MOVE.L    A3,(A5)
ENDIF
.return1:  MOVEQ.L   #1,D0
           LEA.L     $000C(A7),A7
           MOVEM.L   (A7)+,D2-D3/A2-A5
           RTS
/*
	Installed via TIMER_call()
*/
L0007D7E6:
           MOVE.L    D2,-(A7)
           MOVE.L    A2,-(A7)
IF OPTI
           MOVEA.L   CNlist(PC),A2
ELSE
           MOVEA.L   CNlist,A2
ENDIF
           BRA       .start
.loop:     MOVEA.L   A2,A0
IF OPTI
           BSR.B     L0007D86E
ELSE
           BSR.W     L0007D86E			; ### word
ENDIF
           MOVEA.L   $0026(A2),A2
.start:    MOVE.L    A2,D0
           BNE       .loop
           MOVEA.L   (A7)+,A2
           MOVE.L    (A7)+,D2
           RTS
/*
	int16 L0007D806(void *A0)
	
	Result:
	
		Result in OPTI mode is CC

	Called by:
	
		CNkick()
		CNbyte_count()
		CNget_char()
		CNget_NDB()
		CNget_block()
		CNgets()
	
	Caveat:
	
		Calls Supexec(), which might clobber D2
*/
IF OPTI
L0007D806: MOVE.W    $0016(A0),D0
           BMI.B     .retA0
           MOVE.L    A2,-(A7)			; save A2
           MOVEA.L   A0,A2
           MOVE.L    $0022(A2),-(A7)
           MOVEA.L   mdl(PC),A0
           MOVEA.L   TIMER_elapsed(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           CMP.L     #$000004B0,D0		; 1200
           BLT.B     .return0
           LEA.L     CNsema(PC),A0
.lock:     TAS.B     (A0)				; sema_set
           BNE.B     .lock
           MOVE.L    A2,L0007DEE2
           LEA.L     L0007D850(PC),A0
           BSR       Supexec
.return0:  CLR.W     D0
           MOVEA.L   (A7)+,A2			; restore A2
           RTS
.retA0:    CLR.W     $0016(A0)
           TST.W     D0					; set flags again
           RTS
ELSE
L0007D806: MOVE.L    A2,-(A7)
           MOVEA.L   A0,A2
           MOVE.W    $0016(A2),D0
           TST.W     D0					; ### Ahhh!
           BPL       .L1
           CLR.W     $0016(A2)
           BRA       .return
.L1:       MOVE.L    $0022(A2),-(A7)
           MOVEA.L   mdl,A0
           MOVEA.L   TIMER_elapsed(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           CMP.L     #$000004B0,D0		; 1200
           BLT       .return0
           LEA.L     CNsema,A0
           BSR       sema_set
           MOVE.L    A2,L0007DEE2
           LEA.L     L0007D850(PC),A0
           BSR       Supexec
.return0:  CLR.W     D0
.return:   MOVEA.L   (A7)+,A2
           RTS
ENDIF

L0007D850:
IF OPTI
           MOVEA.L   L0007DEE2(PC),A0
           CLR.B     CNsema			; sema_clr
           BSR.B     L0007D86E
           MOVEQ.L   #0,D0
           RTS
ELSE
           MOVE.L    A2,-(A7)
           MOVEA.L   L0007DEE2,A2
           LEA.L     CNsema,A0
           BSR       sema_clr
           MOVEA.L   A2,A0
           BSR.W     L0007D86E			; ### word
           MOVEQ.L   #0,D0
           MOVEA.L   (A7)+,A2
           RTS
ENDIF

L0007D86E:
IF OPTI
           MOVE.L    A2,-(A7)
           MOVE.L    D2,-(A7)
           MOVEA.L   A0,A2
           TAS.B     $0020(A2)		; sema_req
           BNE.B     .return
           MOVE.L    $001C(A2),D0
           BEQ.B     .L1
           LEA.L     $001C(A2),A0
           BSR       IRQunlink
           MOVEQ.L   #0,D0
           MOVEQ.L   #0,D1
           MOVEA.L   A0,A1
           BRA.B     .start
.loop:     MOVE.W    $0004(A1),D1
           ADD.L     D1,D0
           MOVEA.L   (A1),A1
.start:    MOVE.L    A1,D2
           BNE.B     .loop
           ADD.L     D0,$000E(A2)
           LEA.L     $0018(A2),A1
           BRA.B     .start2
.loop2:    MOVEA.L   D1,A1
.start2:   MOVE.L    (A1),D1
           BNE.B     .loop2
           MOVE.L    A0,(A1)
.L1:       MOVEA.L   mdl(PC),A0
           MOVEA.L   TIMER_now(A0),A0
           JSR       (A0)
           MOVE.L    D0,$0022(A2)
           CLR.B     $0020(A2)		; sema_clr
.return:   MOVE.L    (A7)+,D2
           MOVEA.L   (A7)+,A2
ELSE
           MOVE.L    A2,-(A7)
           MOVE.L    A3,-(A7)
           MOVEA.L   A0,A2
           LEA.L     $0020(A2),A0
           BSR       sema_req
           TST.W     D0
           BNE       .return
           MOVE.L    $001C(A2),D0
           BEQ       .L1
           LEA.L     $001C(A2),A0
           BSR       IRQunlink
           MOVEQ.L   #0,D0
           MOVEA.L   A0,A1
           BRA       .start
.loop:     MOVEQ.L   #0,D1
           MOVE.W    $0004(A1),D1
           ADD.L     D1,D0
           MOVEA.L   (A1),A1
.start:    MOVE.L    A1,D1
           BNE       .loop
           LEA.L     $0018(A2),A3
           MOVEA.L   (A3),A1
           BRA       .start2
.loop2:    MOVEA.L   A1,A3
           MOVEA.L   (A3),A1
.start2:   MOVE.L    A1,D1
           BNE       .loop2
           MOVE.L    A0,(A3)
           ADD.L     D0,$000E(A2)
.L1:       MOVEA.L   mdl,A0
           MOVEA.L   TIMER_now(A0),A0
           JSR       (A0)
           MOVE.L    D0,$0022(A2)
           LEA.L     $0020(A2),A0
           BSR       sema_clr
.return:   MOVEA.L   (A7)+,A3
           MOVEA.L   (A7)+,A2
ENDIF
           RTS
/*
	ICMP_UDP( IP_DGRAM *dg )
	
	ICMP handler - receives *any* ICMP packets
	
	Returns		1	if ICMP datagram consumed
				0	if ICMP processing switched off or
					if ICMP type not processed or
					if ICMP does not refer to a UDP datagram
	
	This baby is *time critical*
*/
ICMP_UDP:  MOVEM.L   D2-D3/A2-A3,-(A7)
           MOVEA.L   $0014(A7),A2
IF OPTI
           MOVEQ.L	 #1,D0
           AND.W     lay_flags(PC),D0
ELSE
           MOVE.L    lay_flags,D2
           AND.L     #$00010000,D2		; ### Ouch!
ENDIF
           BEQ       .return0
           MOVEA.L   $001A(A2),A1		; pkt_data
           MOVE.B         (A1),D0		; ICMP type
           MOVE.B    $0001(A1),D1		; ICMP code
           CMP.B     #$03,D0			; dst unreachable
           BEQ       .L1
           CMP.B     #$04,D0			; src quench
           BEQ       .L1
           CMP.B     #$0B,D0			; time exceeded
           BNE       .return0
/*
	ICMP: destination unreachable, src quench, or time exceeded
*/
.L1:
IF OPTI
           MOVEA.L   A1,A0				; pkt_data (still in A1)
ELSE
           MOVEA.L   $001A(A2),A0		; pkt_data, ### still in A1
ENDIF
           ADDQ.W    #8,A0				; addr of original datagram
           CMPI.B    #P_UDP,$0009(A0)	; UDP packet?
           BEQ       .L2
.return0:  CLR.W     D0					; ICMP datagram not processed
           BRA       .return
.L2:
IF OPTI
           MOVEQ.L   #$0F,D2
           AND.B     (A0),D2			; hd_len
           LSL.W     #2,D2
           LEA.L     (A0,D2.W),A3		; addr of datagram data
           MOVEA.L   CNlist(PC),A3
ELSE
           MOVE.W    (A0),D2
           LSR.W     #8,D2
           AND.W     #$000F,D2			; hd_len, ### Ouch!
           LSL.W     #2,D2
           MOVEQ.L   #0,D3				; ### Ahhh!
           MOVE.W    D2,D3
           LEA.L     (A0,D3.L),A1		; addr of datagram data
           MOVEA.L   CNlist,A3
ENDIF
           BRA       .L5
.L3:       MOVE.W         (A1),D2
           CMP.W     $000A(A3),D2		; chksum?
           BNE       .L4
           MOVE.W    $0002(A1),D3
           CMP.W     $0004(A3),D3		; ident?
           BNE       .L4
           MOVE.L    $000C(A0),D2
           CMP.L     $0006(A3),D2 
           BNE       .L4
           MOVE.L    $0010(A0),D3
           CMP.L          (A3),D3
           BEQ       .L6
.L4:       MOVEA.L   $0026(A3),A3
.L5:       MOVE.L    A3,D2
           BNE       .L3
.L6:       MOVE.L    A3,D2
           BEQ       .discard
           MOVE.L    $0012(A3),D3
           BEQ       .L7
IF OPTI
           MOVEA.L   $0012(A3),A0
           MOVE.B    D0,$000E(A0)	; ICMP type
           MOVE.B    D1,$000F(A0)	; ICMP code
ELSE
           CLR.W     D2
           MOVE.B    D0,D2			; ICMP type
           LSL.W     #8,D2
           CLR.W     D3
           MOVE.B    D1,D3			; ICMP code
           OR.W      D3,D2			; ### Ahhh!
           MOVEA.L   $0012(A3),A0
           MOVE.W    D2,$000E(A0)
ENDIF
.L7:
IF OPTI
           SUBQ.B    #3,D0
           BEQ.B     .e_unreachable
           SUBQ.B    #1,D0
           BEQ.B     .e_cntimeout
           SUBQ.B    #7,D0
           BEQ.B     .e_ttlexceed
ELSE
           CLR.W     D1
           MOVE.B    D0,D1			; ### Ouch!
           SUBQ.W    #3,D1
           BEQ       .e_unreachable
           SUBQ.W    #1,D1
           BEQ       .e_cntimeout
           SUBQ.W    #7,D1
           BEQ       .e_ttlexceed
ENDIF
           BRA       .discard
.e_unreachable:
           MOVE.W    #E_UNREACHABLE,$0016(A3)
           BRA       .discard
.e_cntimeout:
           MOVE.W    #E_CNTIMEOUT,$0016(A3)
           BRA       .discard
.e_ttlexceed:
           MOVE.W    #E_TTLEXCEED,$0016(A3)
.discard:  MOVE.L    A2,-(A7)
IF OPTI
           MOVEA.L   tpl(PC),A0
ELSE
           MOVEA.L   tpl,A0
ENDIF
           MOVEA.L   ICMP_discard(A0),A0
           JSR       (A0)
           ADDQ.W    #4,A7
           MOVEQ.L   #1,D0			; ICMP datagram consumed
.return:   MOVEM.L   (A7)+,D2-D3/A2-A3
           RTS

IFF OPTI
sema_set:  TAS.B     (A0)
           BNE.B     sema_set
IFF OPTI
           ORI.B     #$FF,(A0)			; ### what for?
ENDIF
           RTS
sema_req:  MOVEQ.L   #1,D0
           TAS.B     (A0)
           BNE       .return
IFF OPTI
           ORI.B     #$FF,(A0)
ENDIF
           CLR.L     D0
.return:   NOP
           RTS
sema_clr:  CLR.B     (A0)
           RTS
ENDIF

IRQoff:    MOVE.W    SR,oldSR
           ORI.W     #$0700,SR
           RTS
IF OPTI
IRQon:     MOVE.W    oldSR(PC),SR
ELSE
IRQon:     MOVE.W    oldSR,SR
ENDIF
           RTS
oldSR:     DC.W      $0000
IRQunlink: MOVE.W    SR,-(A7)		; $40E7
           ORI.W     #$0700,SR
           MOVE.L    (A0),-(A7)
           CLR.L     (A0)
           MOVEA.L   (A7)+,A0
           MOVE.W    (A7)+,SR
           RTS

chksum:
IF OPTI
           INCLUDE   "chksumw2.s"
ELSE
           INCLUDE   "chksumpr.s"
ENDIF

           DATA

; struct lay_desc {
lay_desc:  DC.L      s_UDP		; name
           DC.L      s_version	; version
lay_flags: DC.L      $00010400	; flags
           DC.W      $2466		; date of compilation
           DC.L      s_author	; author
lay_dropd: DC.W      $0000		; stat_dropped
           DC.L      $00000000	; next
           DC.L      $00000000	; basepage
; } LAYER
; struct cn_funcs {
cn_funcs:  DC.L      L0007D2D6	; CNkick
           DC.L      L0007D2F0	; CNbyte_count
           DC.L      L0007D30E	; CNget_char
           DC.L      L0007D384	; CNget_NDB
           DC.L      L0007D428	; CNget_block
           DC.L      L0007D4E2	; CNgetinfo
           DC.L      L0007D53A	; CNgets
; } CN_FUNCS
IPident:   DC.W      $0000		; unique ID
CNsema:    DC.W      $0000		; semaphore
CNlist:    DC.L      $00000000	; connection related data list
s_Only_start_by_STinG:
           DC.B      "UDP.STX : STinG extension module. Only to be started by STinG !",$d,$a,$0
s_UDP:     DC.B      "UDP",0
s_version: DC.B      "01.42",0
s_author:  DC.B      "Peter Rottengatter",0
s_STinG_Load:
           DC.B      "STinG_Load",0
s_STiKmagic:
           DC.B      "STiKmagic",0
s_TRANSPORT_TCPIP:
           DC.B      "TRANSPORT_TCPIP",0
s_MODULE_LAYER:
           DC.B      "MODULE_LAYER",0
s_UDP_PORT:
           DC.B      "UDP_PORT",0
s_UDP_ICMP:
           DC.B      "UDP_ICMP",0,0
           DC.L      $00000000,$00000000,$00000000,$00000000,$00000000

           BSS

STiK_drvs: DS.L 1	/* (DRV_LIST *)          */
tpl:       DS.L 1	/* (DRV_HDR *), (TPL *)  */
mdl:       DS.L 1	/* (STX *)               */
L0007DEE0: DS.W 1
L0007DEE2: DS.L 1

/* ... and 256 bytes of stack space */
