;----------------------------------------------------------------------------
;Here follows eight checksum functions that share most of their code.
;All of these smash d1/d2/a0 and preserve all other regs except d0 (result).
;
;uint16	make_TCP_checksum (uint32 src, uint32 dest, uint16 *blk, uint16 len);
;uint16 make_UDP_checksum (uint32 src, uint32 dest, UDP_HDR *udp_packet);
;uint16	make_ICMP_checksum (uint16 *blk, uint16 len);
;	make_*_checksum calls preclear original checksum before calculation
;
;uint16	calc_TCP_checksum (uint32 src, uint32 dest, uint16 *blk, uint16 len);
;uint16 calc_UDP_checksum (uint32 src, uint32 dest, UDP_HDR *udp_packet);
;uint16	calc_ICMP_checksum (uint16 *blk, uint16 len);
;	calc_*_checksum calls do the same calculations without preclearing
;
;uint16	calc_proto_checksum (uint32 src, uint32 dest, uint16 *blk, uint32 proto_len);
;	calc_proto_checksum is used for UDP and TCP in the above functions
;
;uint16	calc_checksum(uint16 start_value, uint16 *blk, uint16 len);
;	calc_checksum calculates a block checksum regardless of protocol
;	it is used for the data block summing of the other seven functions
;
make_ICMP_checksum:
	clr	ICMP_HD_checksum(a0)	;clear checksum in block
calc_ICMP_checksum:
	move	d0,d1			;d1 = length	(for top bits)
	clr.l	d0			;preclear checksum accumulator
	bra.s	calc_checksum		;add this checksum to block checksum
;
make_UDP_checksum:
	clr	UDP_hdr_checksum(a0)	;clear checksum in packet
calc_UDP_checksum:
	move.l	#P_UDP<<16,d2		;d2 = protocol.zero
	move	UDP_hdr_length(a0),d2	;d2 = protocol.length
	bra.s	calc_proto_checksum
;
make_TCP_checksum:
	clr	tcph_chksum(a0)	;clear checksum in block
calc_TCP_checksum:
	swap	d2		;d2 = length.garbage
	move	#P_TCP,d2	;d2 = length.protocol
	swap	d2		;d2 = protocol.length
calc_proto_checksum:
	add	d0,d1		;X<<16+d1.lo = sum of low IP words
	clr	d0		;d0 = src_ip & 0xFFFF0000
	swap	d0		;d0 = src_ip.hi
	addx	d1,d0		;X<<16+d0.lo = sum of src_IP and dest_IP.lo
	clr	d1		;d1 = dest_ip & 0xFFFF0000
	swap	d1		;d1.lo = dest_ip.hi, d1.hi = 0
	addx.l	d1,d0		;d0 = checksum of both IPs
;
	clr.l	d1		;preclear top bits of d1
	move	d2,d1		;d1 = length
	add.l	d1,d0		;add length word to checksum
	clr	d2		;d2 = protocol.zero
	swap	d2		;d2 = protocol
	add.l	d2,d0		;add protocol word to checksum
;
calc_checksum:
	clr.l	d2			;clear top bits of temp reg
	and.l	#$FFFF,d1		;clear top bits of length count
	ror.l	#1,d1			;d1 = length/2 + (length & 1)<<31
	bra.s	.next_full_word
;
.loop:
	move	(a0)+,d2		;d2.lo = block word, d2.hi remains 0
	add.l	d2,d0			;add block word to checksum
.next_full_word:
	dbra	d1,.loop		;loop back to add all full words
.summed_words:
	tst.l	d1			;odd length ?
	bpl.s	.summed_all		;skip if no byte remains to be summed
	move.b	(a0)+,d2		;d2 = final byte
	asl	#8,d2			;d0 = final byte << 8
	add.l	d2,d0			;add padded final byte to checksum
.summed_all:
;
	move	d0,d2			;d2 = prel_checksum.lo
	clr	d0
	swap	d0			;d0 = prel_checksum.hi
	add	d2,d0			;X+d0.lo = checksum
	clr	d2
	addx	d2,d0			;d0 = final checksum folded to 16 bits
	not	d0			;invert these bits for return value
	rts				;return to caller
;
;end of calc_checksum and seven other related checksum functions
;----------------------------------------------------------------------------
;uint16 make_IP_check (IP_DGRAM *datagram);
;uint16 calc_IP_check (IP_DGRAM *datagram);
;
;make_IP_check clears the checksum in the IP header before calculation
;calc_IP_check just calculates a checksum including the old one in IP header
;	neither stores the new sum anywhere, they just return it to caller.
;	both smash d1/d2/a1 and preserve all other regs except d0 (result).
;
make_IP_check:
	clr	IPDG_hdr+IPHD_hdr_chksum(a0)
calc_IP_check:
	lea	IPDG_hdr(a0),a1			;a1 -> header
	move.l	(a1)+,d0			;check header bytes  0-3
	move.l	(a1)+,d1			;fetch header bytes  4-7
	add.l	d1,d0				;check header bytes  4-7
	move.l	(a1)+,d1			;fetch header bytes  8-11
	addx.l	d1,d0				;check header bytes  8-11
	move.l	(a1)+,d1			;fetch header bytes 12-15
	addx.l	d1,d0				;check header bytes 12-15
	move.l	(a1)+,d1			;fetch header bytes 16-19
	addx.l	d1,d0				;check header bytes 16-19
;
	move	IPDG_opt_length(a0),d2		;d2 = option bytes
	beq.s	.options_checked		;skip options if absent
	roxr	#1,d1				;save X bit in d1
	addq	#3,d2				;prep to round d2
	lsr	#2,d2				;d2 = option longs
	subq	#1,d2				;d2 = fixed for dbra
	roxl	#1,d1				;restore X bit from d1
	movea.l	IPDG_options(a0),a1		;a1 -> options
.option_loop:					;loop start
	move.l	(a1)+,d1				;fetch a long	
	addx.l	d1,d0					;check a long
	dbra	d2,.option_loop			;loop back for all option longs
;
.options_checked:
	move	d0,d1				;d1.lo = sum & 0xFFFF
	clr	d0				;d0.lo = 0  (X bit unaffected)
	swap	d0				;d0.hi = 0,  d0.lo = sum >> 16
	addx	d1,d0				;fold sum to 16 bits
	clr	d1				;d1.lo = 0  (X bit unaffected)
	addx	d1,d0				;add X bit (can give carry)
	addx	d1,d0				;do it again (no carry possible)
	not	d0				;invert the 16 bit checksum
	rts
;
;end of make_IP_check & calc_IP_check
;----------------------------------------------------------------------------
