
#ifndef _atarierr_h
#include <atarierr.h>
#endif

#define CON			2
#define	Ndrive		0x50	/* drive P	*/
#define	MAXTRAP		42		/* posible traps +2	*/
#define	MAXHOSTS	8
#define NETHAN		24
#define	MAX_PATH	128
#define MAXDRIVES	26

#define	SOH		1		/* START OF HEADER CHAR */
#define	EOT		4		/* end of transmission char */
#define	ACK		6		/* acknowledge sector transmission */
#define	NAK		21		/* error in transmission detected */
#define ERRORMAX 5
#define RETRYMAX 2
#define SECSIZ	1024L
#define HDRSIZ	8
#define PACSIZ	8
#define TCPBUF	2*(MAX_PATH+HDRSIZ)
#define	TCPFTP	8192
#define	NPORT	59
#define	FPORT	60

#define CONNECTING		99
#define SHUTING_DOWN	100

#define	DXRDDIR	0x142
#define Dxreaddir(a,b,c,d,e)	gemdos(322, (int)(a), (long)(b), (char *)(c), (long*)(d), (long*)(e))

/*		For alert		*/

#define	NO_RESP	0
#define	NO_INP	1
#define	N_ERR	2
#define TERM	3
#define UNH		4

/* ========== New from 18-7-97 =========== */
typedef unsigned long uint32;         /* Unsigned 32 bit (longword)         */

int 	is_STING (void);
void	wmess (const char *s);
int 	FTP_open (int port, uint32 rhost);
int		buf_out(int cnp, void *tx_buf, int count);

/* Well known hosts */
typedef struct
{
	uint32	ip_addr;
	char	name[8];
	short	dial;
	short	enabled;
	char	phone[20];
	short	cnh;
	short	connected;
} WKH;

typedef	struct
{
	char	fpath[MAX_PATH];
	int		cnh, fhan;
	long	flen;
} FTS;

typedef	struct
{
	char	junk0, junk1, junk2;
	char	han;
	long	len;
} FRW;

typedef struct
{
	long	res;
	int 	func;
	int 	posh, posl;
	int 	han;
	char	fromh, froml;
} FSEEK;

typedef	struct
{
	long	not_used;
	int		buflen;
	int		junk;
	long	dir;
} RDDIR;

typedef struct
{
	long	not_used;
	long	dir_han;
} DIR_RW_CLS;

typedef	struct
{
	char	cmd_st;
	char	station;
	char	cmd;
	char	path_yn;
	long	dummy;
	char	buf[SECSIZ];
}CM_RCSEEK;

typedef	struct
{
	int 	junk;
	long	res;
	int 	xr;
	XATTR	xattr;
	char	name[4 + 512];
} RDXDIR;

/* Indexes for optional calls (not real Gemdos numbers)	*/

#define		DIR_OPN		0x59	/* Dopendir		*/
#define		DIR_RD		0x5A	/* D(x)readdir	*/
#define 	DIR_RWD		0x5B	/* Drewinddir	*/
#define		DIR_CLS		0x5C	/* Dclosedir	*/
#define		FIL_XAT		0x5D	/* Fxattr		*/
#define 	DPH_CNF		0x5E	/* Dpathconf	*/
#define 	FIL_CNTR	0x5F	/* Fcntl		*/

typedef	struct
{
	char	cmd_st;
	char	station;
	char	cmd;
	char	path_yn;
	int		dummy;
	int		timeout;
	char	buf[SECSIZ];
}CM_PACKET;

typedef	struct
{
	char	soh;
	char	stid;
	long	res;
	int		eot;
	char	buf[SECSIZ];
}D_HDR;

typedef struct
{
	void	(*func)(char *);
}TRAP;

/* Struct for the BNET cookie	*/

typedef  struct bnet_f
{
	char	*module;		/* Specific string that can be searched for   */
	char	*author;		/* Any pround Author                          */
	char	*version;		/* Format `00.00' Version:Revision			  */
	int 	X_drive;		/* Network drive (XFS only)		*/
	char	*gl_Path;		/* just in case ...				*/
	CM_PACKET	*packet;	/* The 'send' packet ptr		*/
	D_HDR	*t_hdr;			/* The 'rcved' packet ptr		*/
	WKH		*wkh_arr;		/* Remotes struct ptr			*/
	char	*N_nodes;
	int		*cur_id;		/* Whom are we talking to ?		*/
	int		(*host_conn)(int);	/* Init a connection from XFS	*/
	int 	(*cmd_tx) (int );	/* Send a command from XFS/DOS	*/
	void	(*get_answ) (char *);	/* Get result to XFS/DOS	*/
	int 	(*SetHan)(int );
	void	(*Trace)(char *, int, ...);	/* Debug routine ptr	*/
	BASPAG	*bnet_baspag;	/* Just in case (STinG compatibility) */
#ifdef	CHK_XFS
	void	(*TEST_xfs)(void *, void *, void *);
#endif
} BNET_F ;

extern	BNET_F	*bnet_f;

#define		conn_host(x)			(*bnet_f->host_conn)(x)
#define		req_tx(x)				(*bnet_f->cmd_tx)(x)
#define		get_ransw(x)			(*bnet_f->get_answ)(x)
#define		SetrHan(x)				(*bnet_f->SetHan)(x)
#define 	debug(x,y,z)			(*bnet_f->Trace)(x,y,z)

typedef	struct
{
	char	nodes[MAXHOSTS][MAXDRIVES];
} X_NOD;

/* ===== Prototypes	==== */

void Trp1trp11(void);
void Trap_ins(void);
void net_core(char *);
void N_entry(void);
long S_reset(void);
void Stk_chg(void);
void Stk_rest(void);
int  cmd_tx(int num);
void cmd_tx1(int nobytes);
void get_answ(char	*parm);
void send_back(int cnt);
void fill_buf(int len);
int	 N_path(void);
int R_path(char *parm, int len);
int	ack_wait(void);
void makeRec(int , char *);
void send_RID( int);
/*int	 proc_func(void);	*/
int	 Iget_path(void);
int	 Rget_path(void);

int  N_BTST (int i, long j);
int  N_BSET (int i, long j);
long N_BCLR (int i, long j);
void RELOC(long *buf, long relo);
void L_dcreate(char *parm);
void L_ddelete(char *parm);
void L_dsetpath(char *parm);
void L_fcreate(char *parm);
void L_fopen(char *parm);

void N_dcreate(char *Ibuf);
void N_ddelete(char *Ibuf);
void N_dsetpath(char *parm);
void N_fcreate(char *parm);
void N_fopen(char *parm);
