/* ----------------- NO STRING MERGING / COMPILATION !!! ----------------
//				 ( compilo : verify by Alt+C puis Alt+L  : -K -M -G )
// 
// Module:	bnet_cpx.c
//
// Objet :	Base pour le rglage "on fly" de BNET.
//
// ToDo  :	
//
//
//
// Maintenance :
//
//		 Auteur  :	Olivier Booklage
//		 Version :	V1.0
//		 Date 	 :	12/05/1999
//		 Remarq. :	Ressource dite avec INTERFCE2
//								TAB = 2
//
//
// PureC v1.1 source code written by Olivier Booklage
//--------------------------------------------------------*/


/* ---			 Includes externes			 -- */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<tos.h>
#include	<sting\transprt.h>
#include	<portab.h>
#include	"gem.h"
#include	<vdi.h>
#include	<cpx\cpx.h>

/* Einstellungen wurden nicht gespeichert */
/* MUSS im DATA-Segment (NICHT BSS!!!) liegen */
/* (darf also nicht nur auf 0 gesetzt sein) */
/* MUSS erste Variable im DATA-Segment sein! */

typedef struct
{
	int saved;		/* 0 not set, 1 set */
	int active;
	int bnet_active;
} CONF;

CONF conf={0,1};

#include	"rsc.rh"
#pragma warn -rpt
#include	"rsc.rsh"
#pragma warn .rpt

/* ----- Constantes -----*/


/* ----- Variables Gnrales -----*/

int		errno;											/* for pcstdlib.lib */

XCPB			*params;
GRECT			*cpx_wind;
OBJECT		*dial1;
OBJECT		*dial2;
OBJECT		*alert1;
DRV_LIST  *sting_drivers;
TPL       *tpl;

char			*type[]		=	{"  Local    ","  Dial     "};
char			*status[]	=	{"  Enabled  ","  Disabled "};

/* ----- Prototypes ----- */

int			init_conf(CONF *conf);
void		get_button(CONF *conf);
BOOLEAN IsSTinG( VOID );
VOID		Fix_InterfaceRsh( XCPB *par );

/* ----- Fonctions ----- */

CPXINFO * cdecl init( XCPB *par )
{
int cdecl do_cpx(GRECT *curr_wind);
static CPXINFO info={do_cpx,0l,0l,0l,0l,0l,0l,0l,0l,0l};

	if ( par->booting )
	{

		/* Init stuff if CPX have boot init option */

		return (CPXINFO*)1l; /* nicht set_only */
	}
	else
	{
		/*
				Modul aktiviert
		*/
		params=par;
		if ( !params->SkipRshFix )
		{
			Fix_InterfaceRsh( params );
			dial1=(OBJECT*)rs_trindex[D1];
			dial2=(OBJECT*)rs_trindex[D2];
			alert1=(OBJECT*)rs_trindex[A1];
		}
		return(&info);
	}
}

void draw_object(OBJECT *tree,int object)
{
	objc_draw(tree,object,MAX_DEPTH,cpx_wind->g_x,cpx_wind->g_y,cpx_wind->g_w,cpx_wind->g_h);
}

void draw_tree(OBJECT *tree)
{
	tree[ROOT].ob_x=cpx_wind->g_x;
	tree[ROOT].ob_y=cpx_wind->g_y;
	cpx_wind->g_w=tree[ROOT].ob_width;
	cpx_wind->g_h=tree[ROOT].ob_height;
	draw_object(tree,ROOT);
}

int cdecl do_cpx(GRECT *curr_wind )
{
WORD msg_buff[8],button,abort=0;
OBJECT	*dial;

GRECT	menu;
static INT index_type=0;
static INT index_status=1;
INT r;

	cpx_wind=curr_wind; /* curr_wind global zur Verfgung stellen */

	init_conf(&conf);

	if ( IsSTinG() == FALSE )
		dial = alert1;
	else
		dial = dial1;

	draw_tree(dial);

	do
	{
		button=(*params->Xform_do)(dial,0,msg_buff);

		if ( button>=0 )	button&=0x7FFF;

		if ( button==D1_SWITCH2 && dial==dial1 )
		{
			objc_unselect( dial, button);
			draw_tree(dial=dial2);
		}
		else if ( button==D2_SWITCH1 && dial==dial2 )
		{
			objc_unselect( dial, button);
			draw_tree(dial=dial1);
		}
		else if ( (dial == dial1 && button==D1_OK) )
		{
			objc_unselect( dial, button);

			/*
			
			Do some work ... 
			
			*/
			
			abort=1; 
		}
		else	if ( (dial == dial1 && button==D1_OK) )
		{
			objc_unselect( dial, button);
			abort=1;
		}
		else if ( (dial == dial1 ) && (button == D1_SAVE ))
		{
			get_button(&conf);
			conf.saved=1;
			if ( (*params->XGen_Alert)(0)==1 )
				(*params->CPX_Save)(&conf,sizeof(conf));
			objc_unselect( dial, button);
			draw_object(dial,button);
		}
		else	if ( (dial == dial1 && button==D1_ABORT) )
		{
			objc_unselect( dial, button);
			abort=1;
		} 

		else if ( (dial == dial2 ) && (button == D2_POP1 ))
		{
			objc_offset(dial,D2_POP1,&menu.g_x,&menu.g_y);
			menu.g_w=dial[D2_POP1].ob_width;
			menu.g_h=dial[D2_POP1].ob_height;
			r = params->Popup(type,2,index_type,3,&menu,curr_wind);
			objc_unselect( dial, button);
			if(r!=-1 && r!=index_type)
			{
				index_type = r;
				objc_tedstr( dial, button ) = type[index_type];
			}
			draw_object(dial,button);
		}

		else if ( (dial == dial2 ) && (button == D2_POP2 ))
		{
			objc_offset(dial,D2_POP2,&menu.g_x,&menu.g_y);
			menu.g_w=dial[D2_POP2].ob_width;
			menu.g_h=dial[D2_POP2].ob_height;
			r = params->Popup(status,2,index_status,3,&menu,curr_wind);
			objc_unselect( dial, button);
			if(r!=-1 && r!=index_status)
			{
				index_status = r;
				objc_tedstr( dial, button ) = status[index_status];
			}
			draw_object(dial,button);
		}
		else if ( (dial == dial2 ) && (button == D2_SAVE ))
		{
			get_button(&conf);
			conf.saved=1;
			if ( (*params->XGen_Alert)(0)==1 )
				(*params->CPX_Save)(&conf,sizeof(conf));
			objc_unselect( dial, button);
			draw_object(dial,button);
		}
		else	if ( (dial == dial2 && button==D2_OK) )
		{
			objc_unselect( dial, button);
			abort=1;
		}
		else	if ( (dial == dial2 && button==D2_ABORT) )
		{
			objc_unselect( dial, button);
			abort=1;
		} 

		else	if ( (dial == alert1 && button==A1_ABORT) )
		{
			objc_unselect( dial, button);
			abort=1;
		} 
		else if ( button==-1 )			/* Event-Message */
		{
			switch ( msg_buff[0] )
			{
				case WM_CLOSED:
				case AC_CLOSE:
					abort=1;
			}
		}
	}while ( abort == 0 );

return 0;
}

int init_conf(CONF *conf)
{

	if ( conf->bnet_active )
	{
		objc_select(dial1,D1_ACTIVE);
	}

return(0);
}

void get_button(CONF *conf)
{
	conf->bnet_active=0;
	if ( objc_selected(dial1,D1_ACTIVE) )
	{
		conf->bnet_active=1;
	}
}

BOOLEAN IsSTinG( VOID )
{
	/* STinG Cookie */
		
	if ( (*params->get_cookie)('STiK',(long*)&sting_drivers) )
	{
		if (sting_drivers != NULL)
		{
			if (strcmp (sting_drivers->magic, MAGIC) == SUCCESS)
		  {
				tpl = (TPL *) (*sting_drivers->get_dftab) (TRANSPORT_DRIVER);
			  if (tpl != (TPL *) NULL)
			  {
					return(TRUE);
		    }
	  	}
	  }
	}

return(FALSE);
}

/* ----- Utilitaires ----- */

VOID	Fix_InterfaceRsh( XCPB *par )
{
int tree,obj;

	for (tree = 0 ; tree < NUM_TREE ; tree++) 	/* Pour chaque arbre du RSC intgr */
	{
		obj = 0;																	/* et chaque objet, */
		do
		{ 		/* Tant qu'on n'est pas au dernier objet */
			(*(par->rsh_obfix))((OBJECT*)rs_trindex[tree], obj);
		} while ( !(rs_trindex[tree][obj++].ob_flags & LASTOB) );
	}
	par->SkipRshFix=1;
}
