/*
	LEDPANEL.H - Kontroll-Struktur fr das LED-Panel

	Die folgende C-Struktur dient gleichzeitig als Patch-Area
	fr die Voreinstellungen und zur Kontrolle des LED-Panels
	durch externe Programme, etwa ein Accessory oder CPX-Modul.
	Der 'LEDP'-Cookie enthlt einen Zeiger auf diese Struktur.
*/

#define LEDP_MAGIC 'LEDP'
#define LEDP_VERSION 0x0300
#define LEDP_VERDATE 0x26041995L
#define LEDP_VARLEN 0x20

typedef struct
{
	struct
	{
		long magic; /* magische Zahl MAGIC */
		int version; /* Versionsnummer und */
		long verdate; /* Datum des LED-Panels */
		int varlen; /* Lnge der Patch-Area in Bytes */
		int light; /* Flag fr "light"-Version */
	}	header;
	int active; /* Flag fr Anzeige aktiv */
	long ledbits; /* gewhlte Laufwerke */
	int alldrvs; /* Flag fr angemeldete Laufwerke */
	int delay; /* Nachleuchtdauer der LEDs in VBLs */
	struct
	{
		int top; /* Abstand zum oberen Rand in Zeilen */
		int right; /* Abstand zum rechten Rand in Bytes */
	}	margin;
	struct
	{
		res1: 7; /* reserviert */
		bgcol: 1; /* Hintergrundfarbe des Panels */
		res2: 3; /* reserviert */
		ledfrm: 1; /* Flag fr runde LEDs */
		res3: 3; /* reserviert */
		ledcol: 1; /* Flag fr farbige LEDs */
	}	color;
	struct
	{
		lftspc: 1; /* linker Rand */
		caps: 1; /* CapsLock-Anzeige */
		cpspc: 1; /* Lcke zwischen R/W und CapsLock */
		rwsym: 1; /* R/W-Symbol */
		rwspc: 1; /* Lcke zwischen LEDs und R/W-Symbol */
		onlya: 1; /* Floppys zusammenfassen */
		hrdspc: 1; /* Extra-Lcke vor Harddisk */
		ramspc: 1; /* Extra-Lcke vor RAM-Disk */
		allspc: 1; /* Extra-Lcken zwischen Laufwerken */
		frespc: 1; /* Lcken fr freie Laufwerke zeigen */
		leds: 1; /* LED-Panel anzeigen */
		datspc: 1; /* Abstand zwischen Uhr/Datum und LEDs */
		date: 1; /* Datum */
		clock: 1; /* Uhrensymbol */
		time: 1; /* Uhrzeit */
		rgtspc: 1; /* rechter Rand */
	}	setup;
	int lines; /* Anzahl LED-Zeilen (1/2 oder 0=auto) */
	struct
	{
		char year,sec; /* Flag fr Jahr/Sekunden anzeigen */
	}	dtverb;
	struct
	{
		char date,time; /* Null-Zeichen fr Datum/Uhrzeit */
	}	zero;
	struct
	{
		char off,on; /* Symbol fr Uhrzeit aus/an */
	}	clock;
	struct
	{
		char off,on; /* Symbol fr CapsLock aus/an */
	}	caps;
	struct
	{
		char caps,shft; /* Maske fr CapsLock/Umschalt-Taste */
	}	keymask;
	struct
	{
		char hrd,ram; /* erstes Laufwerk der Harddisk/RAM-Disk */
	}	fstdrv;
	struct
	{
		int x,y,w,h; /* letztes benutztes Rechteck */
	}	lstrect;
	struct
	{
		char *pointer; /* Zeiger auf zu berwachendes Byte */
		char check; /* Default fr zu berprfendes Byte */
		char last; /* letzter Wert des Bytes */
		char andmask; /* Und-Maske zum Zurcksetzen */
		char ormask; /* Oder-Maske zum Zurcksetzen */
		char restime; /* Zeit zum Zurcksetzen */
		char counter; /* Zhler dafr */
		char bit0; /* Zeichen fr 0-Bit */
		char bit1; /* Zeichen fr 1-Bit */
		char bytelft; /* Zeichen links vom Byte */
		char bytergt; /* Zeichen links vom Byte */
	}	watch;
	struct
	{
		int w,h; /* Breite und Hhe des Systemzeichensatzes */
	}	chrsize;
}	LEDP;

/*
	Offsets (dezimal)
	-----------------

	0 header			34 dtverb
		0 magic			36 zero
		4 version		38 clock
		6 verdate		40 caps
		10 varlen		42 keymask
		12 light		44 fstdrv
	14 active			46 lstrect
	16 ledbits			54 watch
	20 alldrvs				54 pointer
	22 delay				58 check
	24 margin				60 andmask
		24 top				62 resttime
		26 right			64 bit0
	28 color				66 bytelft
	30 setup			68 chrsize
	32 lines
*/

/*
	Hinweise
	--------

	magic: XBRA-Kennung des LED-Panels
	version: Hi-Byte: Version, Lo-Byte: Unterversion
	varlen: Lnge der zu speichernden Variablen ab Header
	active:	Bit 0: Anzeige ein/ausschalten,
			Bit 15: Anzeige auffrischen
	dtverb: Die "two in one"-Funktion zum Einblenden des
		Datums anstelle der Zeit wird aktiviert durch Lschen
		des "date"-Flags und Setzen des "year"-Flags
	lastrect: Letztes zur Anzeige benutztes Grafik-Rechteck
	watch: Fr Programmierer zu Debugging-Zwecken,
			hiermit kann ein Byte berwacht werden
		pointer: Zeiger auf das Byte, man mu natrlich	global
			(im Supervisor-Modus) darauf zugreifen knnen
		check: Unbenutzt, man kann den obigen Zeiger darauf
			zeigen lassen (Zugriff garantiert erlaubt)
		andmask: Nachdem ein Zhler abgelaufen ist, wird
			eine Und-Operation mit dieser Maske durchgefhrt,
		ormask: zustzlich auch noch eine Oder-Operation
		restime: Startwert fr den Zhler in VBLs (falls 0,
			dann wird das Byte nie verndert)
		bit0/bit1: Zeichen fr 0-Bit und 1-Bit
		bytelft/bytergt: Zeichen fr Umrahmung des Bytes
	chrsize: wird ab Version 3.0 vom CPX-Modul gesetzt
	
	Vorgehensweise beim Verndern von Parametern:

	1. Header berprfen (magic, version)
	2. LED-Panel abschalten (active=0)
	3. nderungen an der Konfiguration vornehmen
	4. Grafik-Rechteck (lstrect) lschen
	5. LED-Panel einschalten und auffrischen (active=0x8001)

*/
