/*------------------------------------------------
//
// Module: cpx.h
//
// Objet : Header pour CPX
//         Pour C ANSI, de prfrence Turbo C
//
//
// ToDo  : 
//
//
//
// Maintenance :
//
//     Auteur  : Olivier Booklage
//     Version : V1.0
//     Date    : 01/12/1995
//     Remarq. : Modifi pour SozobonX et PureC 1.1
//
//
//-----------------------------------------------*/


/* --- Export Constantes globales   --- */

#ifndef __CPX__
#define __CPX__

#ifdef __SOZOBONX__
	#include	<types.h>
	#ifndef __AES__
		#include	<xgemfast.h>
		#include	<portab.h>
	#endif
#endif


#define VERTICAL	0
#define HORIZONTAL	1
#define NULLFUNC	( void(*)())0L

/* alertes */

#define SAVE_DEFAULTS		0
#define MEM_ERR					1
#define FILE_ERR				2
#define FILE_NOT_FOUND	3

#define MFSAVE		1
#define MFRESTORE	0

#define CT_KEY		53

#define PTRS(r) r->g_x, r->g_y, r->g_w, r->g_h
#define ELTS(r) r.g_x, r.g_y, r.g_w, r.g_h

#ifdef __TURBOC__
	#define	CDECL	cdecl
#else
	#define	CDECL
#endif


/* --- Export Structures globales   --- */

#ifdef __SOZOBONX--
typedef struct moblk
{
	WORD    m_out;
	WORD    m_x;
	WORD    m_y;
	WORD    m_w;
	WORD    m_h;
}MOBLK;
#endif

typedef struct
{
	int		x;
	int		y;
	int		buttons;
	int		kstate;
} MRETS;

typedef struct
{
	int CDECL		(*cpx_call)(GRECT *work);
	void CDECL	(*cpx_draw)(GRECT *clip);
	void CDECL	(*cpx_wmove)(GRECT *work);
	void CDECL	(*cpx_timer)(int *event);
	void CDECL	(*cpx_key)(int kstate,int key,int *event);
	void CDECL	(*cpx_button)(MRETS *mrets,int nclicks,int *event);
	void CDECL	(*cpx_m1)(MRETS *mrets,int *event);
	void CDECL	(*cpx_m2)(MRETS *mrets,int *event);
	int CDECL		(*cpx_hook)(int event,int *msg,MRETS *mrets,
	int *key,int *nclicks);
	void CDECL	(*cpx_close)(int flag);
} CPXINFO;

typedef struct _cpxhead
{
	unsigned int	magic;		/* 100 (0x64) */
	struct
	{
		unsigned reserved:	13;
		unsigned resident:	1;	/* Flag pour un CPX rsidant en ram */
		unsigned bootinit:	1;	/* Flag init. au moment du boot */
		unsigned setonly:	1;	/* Flag pour un CPX 'set only' */
	} flags;
	long			cpx_id;		/* Numro d'identification du CPX */
	unsigned int	cpx_version;/* Numro de version du CPX */
	char			i_text[14];	/* Le texte de l'icne du CPX */
	unsigned int	sm_icon[48];/* Dessin de l'icne - 32x24 points */
	unsigned int	i_color;	/* Couleur de l'icne (numrotation AES) */
	char			title_txt[18];/* Nom du CPX dans le menu de XControl
									Attention: n'utiliser que 16
									caractres, les deux derniers
									octets devant tre nuls. */
	unsigned int	t_color;	/* Couleur du texte (numrotation AES) */
	char			buffer[64];	/* Buffer de stockage en RAM */
	char			reserved[306];/* Reservs pour extension future */
} CPXHEAD;

typedef struct _Prghead
{
	int		magic;		/* 0x601a */
	long	tsize,dsize,bsize,ssize;
	int		fill[5];
} Prghead;

typedef struct cpxnode
{
	char			fname[14];	/* Nom du CPX */
	int				vacant;		/* 1=non libre */
	int				SkipRshFix;	/* Si non nul, ne pas appeler rsh_fix() */
	long			*baseptr;	/* Pointeur vers la zone de chargement du CPX */
	struct cpxnode	*next;  	/* Pointeur vers la prochaine structure CPXNODE */
	CPXHEAD			cpxhead;	/* Structure en-tte du CPX */
	Prghead			prghead;	/* Structure en-tte programme du CPX */
} CPXNODE;

typedef struct
{
	int				handle;	/* Renvoy par Graf_Handle()de XControl */
	int				booting;/* Diffrent de zro si l'appel de cpx_init() courant
						est fait au moment de l'initialisation de XControl */
	int				reserved;
	int				SkipRshFix;	/* si 0, reloger ressource */
	long CDECL		(*Get_Head_Node)(void); /* (CPXNODE*) */
	void CDECL		(*Save_Header)(CPXNODE *ptr);
	void CDECL		(*rsh_fix)(int num_objs,int num_frstr,int num_frimg,
					int num_tree,OBJECT *rs_object,TEDINFO *rs_tedinfo,
					char *rs_strings[],ICONBLK *rs_iconblk,BITBLK *rs_bitblk,
					long *rs_frstr,long *rs_frimg,long *rs_trindex,
					void *rs_imdope);
	void CDECL		(*rsh_obfix)(OBJECT *tree,int curob);
	int CDECL		(*Popup)(char *items[],int num_items,int default_item,
					int font_size,GRECT *button,GRECT *world);
	void CDECL		(*Sl_size)(OBJECT *tree,int base,int slider,
					int num_items,int visible,int direction,int  min_size);
	void CDECL		(*Sl_x)(OBJECT *tree,int base,int slider,int value,
					int num_min,int num_max,void(*foo)());
	void CDECL		(*Sl_y)(OBJECT *tree,int base,int slider,int value,
					int num_min,int num_max,void(*foo)());
	void CDECL		(*Sl_arrow)(OBJECT *tree,int base,int slider,int obj,
					int inc,int min,int max,int *numvar,int direction,
					void(*foo)());
	void CDECL		(*Sl_dragx)(OBJECT *tree,int base,int slider,int min,
					int max,int *numvar,void(*foo)());
	void CDECL	    (*Sl_dragy)(OBJECT *tree,int base,int slider,int min,
					int max,int *numvar,void(*foo)());
	int CDECL		(*Xform_do)(OBJECT *tree,int start_field,int puntmsg[]);
	long CDECL		(*GetFirstRect)(GRECT *prect);	/* (GRECT*) */
	long CDECL		(*GetNextRect)(void);			/* (GRECT*) */
	
	void CDECL		(*Set_Evnt_Mask)(int mask,MOBLK *m1,MOBLK *m2,long time);
	
	int CDECL		(*XGen_Alert)(int id);
	int CDECL		(*CPX_Save)(void *ptr,long num);
	long CDECL		(*Get_Buffer)(void);	/* (void*) */
	int CDECL		(*get_cookie)(long cookie,long *p_value);
	int 			Country_Code;
	void CDECL		(*MFsave)(int saveit,MFORM *mf);
} XCPB;

#endif


/* --- Export Variables globales    --- */

/* ---    Export Prototypage        --- */

/* ---          EOF                 --- */
