;--------------------------------------
; TABSIZE	4
; (c)1993-1997 Vassilis Papathanassiou
;--------------------------------------
	IMPORT	N_main
	IMPORT	Drives
	IMPORT	Parm_buf
	IMPORT	PathStr
	IMPORT	TRAPflg
	IMPORT	_BasPag

	XDEF	Trp1trp11
	XDEF	Trap_ins
	XDEF	S_reset,S_ereset

	EXPORT	N_BTST,N_BCLR
	EXPORT	RELOC, SetCritic

	Ndrabs		EQU	$F		;drive P absolute
	Ndrvbit		EQU	Ndrabs + 1
	MAXFUNC		EQU	90
	NET_HAN		EQU 30		;from 30 on
	
	tr1_exc		EQU $84
	trd_exc		EQU $B4
	etv_critic	EQU $404
	hdv_mediach	EQU $47E
	_drvbits	EQU $4C2
	_nflops		EQU $4A6
	stk_frame	EQU	$59E
	
	TEXT

N_BTST:
	btst		D0,D1
	beq.s		is_zero
	moveq		#1,D0
	rts
is_zero:
	moveq		#0,D0
	rts

N_BCLR:
	bclr		D0,D1
	move.l		D1,D0
	rts

InitFnTbl:
	lea		FuncPtr,A0
	move.w		#MAXFUNC-1,D0
	lea		old_trp1,A1
fill_def:
	move.l		A1,(A0)+
	dbra		D0,fill_def
	lea		FuncPtr,A0
	move.l		#F_sfirst, $4E*4(A0)
	move.l		#F_snext,$4F*4(A0)
	move.l		#D_setpath,$3B*4(A0)
	move.l		#D_getpath,$47*4(A0)
	move.l		#F_open,$3D*4(A0)
	move.l		#M_free,$49*4(A0)
	move.l		#PEXEC,$4B*4(A0)
	move.l		#F_close,$3E*4(A0)
	move.l		#F_read,$3F*4(A0)
	move.l		#F_write,$40*4(A0)
	move.l		#F_create,$3C*4(A0)
	move.l		#F_delete,$41*4(A0)
	move.l		#D_delete,$3A*4(A0)
	move.l		#D_create,$39*4(A0)
	move.l		#F_rename,$56*4(A0)
	move.l		#D_free,$36*4(A0)
	move.l		#F_seek,$42*4(A0)
	move.l		#F_datime,$57*4(A0)
	move.l		#F_attrib,$43*4(A0)
	rts
	
; ==================================================================

;	==== Move Original trap #1 to trap #11 ======
Trp1trp11:
	pea		Trp1_sav(PC)
	move.w		#$26,-(A7) 	;SUPEXEC
	trap		#14
	addq.l		#6,A7
	rts

Trp1_sav:
	movea.w		#$AC,A0
	movea.w		#tr1_exc,A1
	move.l		(A1),(A0)	;trap #11 now contains old trap #1
	rts		;(non NETWork) Only for programmers
; or if i need to check the original (no XBRA!)

; ======= INSTALL NEW VECTORS (GEMDOS & BIOS) ========
Trap_ins:
	movem.l		d3-d7/a2-a6,-(a7)
	bsr		InitFnTbl
	move.l		#NPexc_ptr,NPexc_stk	;Prepare Pexec Stack
	bsr		SetCritic
	pea		TRAP1_inst(PC)
	move.w		#$26,-(A7)	 	;Supexec
	trap		#14
	addq.l		#6,A7
	pea		NBIOS_inst(PC)
	move.w		#$26,-(A7)
	trap		#14
	addq.l		#6,A7
	move.l		#N_main,N_entry
	move.w		#1,NPRN_flg		;since there are no prn routines
	moveq		#0,D0		;we pretent printing in progress
	movem.l		(a7)+,d3-d7/a2-a6
	rts

TRAP1_inst:
	move.w		stk_frame.W,D0
	beq.s		shrt_frm
	move.l		#8,StkFrm
shrt_frm:
	lea		N_GEMDOS(PC),A2
	movea.w		#tr1_exc,A1
	cmpa.l		(A1),A2
	beq.s		No_Ginst
	move.w		#-1,D0
	move.l		(A1),TOS_TRAP1
	move.l		A2,(A1)
	bsr		SetNdrv
No_Ginst:
	rts

NBIOS_inst:
	lea		N_BIOS(PC),A2
	movea.w		#trd_exc,A1
	cmpa.l		(A1),A2
	beq.s		No_Binst
	subq.w		#2,D0
	move.l		(A1),sys_BIOS
;	move.l		A2,(A1)		;Later, but at least it works
No_Binst:
	rts

My_media_change:
	dc.b		'XBRABNeT'
Sys_media:
	dc.l		0
My_media:
	move.w		4(A7),D0
	cmpi.w		#Ndrabs,D0
	beq.s		Med_nch
	move.l		Sys_media,-(A7)
	rts
Med_nch:
	moveq     #0,D0
	rts

SetCritic:
	movem.l		D2/A2,-(A7)
	move.l		#-1,-(A7)
	move.w		#$101,-(A7)
	move.w		#5,-(A7) 	;Setexc
	trap		#13
	addq.l		#8,A7
	move.l		D0,Sevt_critic
	pea		Myevt_critic
	move.w		#$101,-(A7)
	move.w		#5,-(A7)
	trap		#13
	addq.l		#8,A7
	movem.l		(A7)+,D2/A2
	rts
;-------------------------------------
	dc.b		'XBRABNeT'
Sevt_critic:
	dc.l		0
Myevt_critic:
	tst.w		TRAPflg
	beq.s		RetSysCr
	move.w		4(A7),D0	;thanks for the error code
	ext.l		D0
	rts

RetSysCr:
	move.l	Sevt_critic,-(A7)
	rts
; ========= END VECTORS INST =========
SetNdrv:
	move.l		hdv_mediach.W,Sys_media
	move.l		#My_media,hdv_mediach.W
	move.l		_drvbits.W,D0
	move.l		D0,D2
	move.w		_nflops.W,D1
	cmpi.w		#2,D1
	beq.s		FLOP2
	andi.w		#$7FFD,D2	;not more than drive O:
	bra.s		SET_Drive
FLOP2:
	andi.w		#$7fff,D2	;same but with drive B:
SET_Drive:
	move.w		D2,Drives
	move.w		#Ndrabs,D1
	bset		D1,D0
	move.l		D0,_drvbits.W
	rts
; ========= Restore SYStem Vectors ====
; Two names to keep the C compiler happy!

S_ereset:
S_reset:
	movea.w		#trd_exc,A1
	move.l		sys_BIOS,(A1)
	movea.w		#tr1_exc,A1
	move.l		TOS_TRAP1,(A1)
no_res:
	move.l		_drvbits.W,D0
	move.w		#Ndrabs,D1
	bclr		D1,D0
	move.l		D0,_drvbits.W
	move.l		Sys_media,hdv_mediach.W
	move.l		Sevt_critic,etv_critic.W
	rts

; ========= Net BIOS Handler ==========
Bios_han:		dc.b		'XBRABNeT'
sys_BIOS:		dc.l		0
N_BIOS:
	tst.w		TRAPflg
	bne.s		old_bios
	tst.w		NPRN_flg
	bne.s		old_bios
	btst		#5,(A7)
	beq.s		Bfrm_user
	movea.l		StkFrm,A0
	adda.l		A7,A0
	bra.s		NB_main
Bfrm_user:
	move		USP,A0
NB_main:
	cmpi.w		#3,(A0)		;B_conout
	bne.s		B_costat
	tst.w		2(A0)		;to prn?
	bne.s		old_bios
	move.l		#Nbconout,N_func
	bra		Net_exec
B_costat:
	cmpi.w		#8,(A0)		;B_costat
	bne.s		old_bios
	tst.w		2(A0)		;to prn?
	bne.s		old_bios
	move.l		#Nbcostat,N_func
	bra		Net_exec
old_bios:
	move.l		sys_BIOS(PC),-(A7)
	rts

; ============= END of NET BIOS ===========

Gemdos_han:		dc.b		'XBRABNeT'
TOS_TRAP1:		dc.l		0
N_GEMDOS:
	tst.w		TRAPflg
	bne		old_trp1
	btst		#5,(A7)
	beq.s		Gfrm_user
	movea.l		StkFrm,A0
	adda.l		A7,A0		;Skip stack, goto real trap params
	bra.s		D_setdrv	;NG_main for printers
Gfrm_user:
	move		USP,A0
NG_main:
	tst.w		NPRN_flg	;can't be zero (yet)
	bne.s		D_setdrv
	cmpi.w		#5,(A0) 	;C_prnout
	bne.s		C_prnos
	move.l		#Ncprnout,N_func
	bra		Net_exec
C_prnos:
	cmpi.w		#$11,(A0) 	;C_prnos	(prn status)
	bne.s		D_setdrv
	move.l		#Ncprnos,N_func
	bra		Net_exec
D_setdrv:
	cmpi.w		#$E,(A0)	;D_setdrv
	bne.s		NG_anal
	move.w		2(A0),Ndef_drv	;i need it also
	bra		old_trp1
NG_anal:
	move.w		(A0),D0
	cmpi.w		#$58,d0
	bge		old_trp1
	move.l		A1,-(A7)
	lsl.w		#2,D0
	lea		FuncPtr,A1
	move.l		(A1,D0.W),D0
	movea.l		(A7)+,A1
	move.l		D0,-(A7)	;exec network routine
	rts

; ============ End NET Gemdos Handler ========
F_sfirst:
	movea.l		2(A0),A1		;Path
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0		;Is it drive P:?
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nfsfirst,N_func
	bra		Net_exec
F_snext:
	move.l		A0,-(A7)
	move.w		#$2F,-(A7) 	;Fgetdta
	move.w		stk_frame.W,D0
	beq.s		FsShort
	move.w		#0,-(A7)
FsShort:
	pea		FsNfunc
	move		SR,-(A7)
	move.l		TOS_TRAP1,-(A7)
	rts
FsNfunc:
	addq.l		#2,A7
	movea.l		D0,A0
	move.l		D0,FNxtDta	;save dta for multiple Fsetdta
	moveq		#0,D0
	move.b		(A0),D0
	movea.l		(A7)+,A0
	cmpi.w		#$7F,D0		;have i set my 'mark' in DTA?
	bne		old_trp1
	move.l		#Nfsnext,N_func
	bra		Net_exec
D_setpath:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Ndsetpath,N_func
	bra		Net_exec
D_getpath:
	move.w		6(A0),D0	;which drive?
	bne.s		IS_def		;Default?
	bsr		getNdr		;zero, get saved
	cmpi.w		#Ndrabs,D0		;is it drvive P:?
	bne		old_trp1
	bra.s		RN_Dgp
IS_def:
	cmpi.w		#Ndrvbit,D0		;Net drive?
	bne		old_trp1
RN_Dgp:
	move.l		#Ndgetpath,N_func
	bra		Net_exec
F_open:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nopcreat,N_func
	bra		Net_exec

PEXEC:
	tst.w		2(A0)		;load & exec
	beq.s		P_for_me
	cmpi.w		#3,2(A0)	;load & not exec
	beq.s		P_for_me
	bra		old_trp1	;no other pexec mode (yet)
P_for_me:
	movea.l		4(A0),A1
	tst.b		(A1)
	beq		old_trp1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,4(A0)
	move.l		#Npexec,N_func
	bra		Net_exec

F_close:
	move.w		2(A0),D0
	cmpi.w		#NET_HAN,D0		;fhandle (>= 30)
	blt		old_trp1
	move.l		#Nfclose,N_func
	bra		Net_exec

F_read:
	move.w		2(A0),D0
	cmpi.w		#NET_HAN,D0
	blt		old_trp1
	move.l		#Nfread,N_func
	bra		Net_exec

F_write:
	move.w		2(A0),D0
	cmpi.w		#NET_HAN,D0
	blt		old_trp1
	move.l		#Nfwrite,N_func
	bra		Net_exec

F_create:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nopcreat,N_func
	bra		Net_exec

F_delete:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nd_f_dc,N_func
	bra		Net_exec

D_delete:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nd_f_dc,N_func
	bra		Net_exec

D_create:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,2(A0)
	move.l		#Nd_f_dc,N_func
	bra		Net_exec

F_rename:
	movea.l		4(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne		old_trp1
	move.l		A1,4(A0)
	move.l		#Nfrename,N_func
	bra		Net_exec

M_free:
	move.l		2(A0),D0
	cmp.l		_BasPag,D0
	bne		old_trp1
	bsr		S_reset		; the bell rings for us, let's terminate
	bra		old_trp1

D_free:
	move.w		6(A0),D0
	tst.w		D0
	beq.s		D_IS_def
	cmpi.w		#Ndrvbit,D0		;Net drive P?
	bne.s		old_trp1
	bra.s		RN_Dfr
D_IS_def:
	bsr.s		getNdr
	cmpi.w		#Ndrabs,D0
	bne.s		old_trp1
RN_Dfr:
	move.l		#Ndfree,N_func
	bra.s		Net_exec
getNdr:
	move.w		Ndef_drv(PC),D0
	rts

F_seek:
	move.w		6(A0),D0
	cmpi.w		#NET_HAN,D0
	blt.s		old_trp1
	move.l		#Nfseek,N_func
	bra.s		Net_exec

F_datime:
	move.w		6(A0),D0
	cmpi.w		#NET_HAN,D0
	blt.s		old_trp1
	move.l		#Nfdatime,N_func
	bra.s		Net_exec

F_attrib:
	movea.l		2(A0),A1
	bsr		Upcase
	bsr		chk_path
	cmpi.w		#Ndrabs,D0
	bne.s		old_trp1
	move.l		A1,2(A0)
	move.l		#Nfattrib,N_func
	bra.s		Net_exec
old_trp1:
	move.l		TOS_TRAP1,-(A7)
	rts
* ==== Here starts the NET trap execution ====
Net_exec:
	move.w		(A7)+,Old_stat
	move.l		(A7)+,Ret_addr
	movem.l		D0-D7/A0-A6,-(A7)
	movea.l		N_func,A2
	jsr		(A2)
	movem.l		(A7)+,D0-D7/A0-A6
	move.l		Parm_buf(PC),D0
	move.l		Ret_addr(PC),-(A7)
	move.w		Old_stat(PC),-(A7)
	rte
; ==== Pass the TRAP parameters ====
; ==== Result is error by default (not very optimistic but...) ====
Nfattrib:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		8(A0),(A1)+
	move.w		6(A0),(A1)+
	move.l		2(A0),(A1)+
	bra		DO_IT
Nfdatime:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		8(A0),(A1)+
	move.w		6(A0),(A1)+
	move.l		2(A0),(A1)+
	bra		DO_IT
Nbconout:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		#5,(A1)+
	move.w		4(A0),(A1)+
	bra		DO_IT
Nbcostat:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		#$11,(A1)+
	bra		DO_IT
; ==== Printer routines, not much tested ====
Ncprnout:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		2(A0),(A1)+
	bra		DO_IT
Ncprnos:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	bra		DO_IT
; ==== 
Nd_f_dc:
	lea		Parm_buf(PC),A1		;Net dir & file delete/create
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+
	bra		DO_IT
Nfrename:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+
	move.l		8(A0),(A1)+
	bra		DO_IT
Nfsfirst:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+
	move.w		6(A0),(A1)+
	bra		DO_IT
Nfsnext:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		FNxtDta,(A1)+
	bra		DO_IT
Ndsetpath:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+
	bra		DO_IT
Ndgetpath:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		2(A0),(A1)+
	move.w		6(A0),(A1)+
	bra		DO_IT
; ==== same for Fopen and Fcreate ====
Nopcreat:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+
	move.w		6(A0),(A1)+
	bra		DO_IT

Npexec:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		#PathStr,(A1)+	;path
	movem.l		A0-A1,-(A7)		;Save A0-A1
	move.w		#1,TRAPflg		;no local net-traps
	move.l		12(A0),-(A7)	;environment
	move.l		8(A0),-(A7)		;command line
	move.l		4(A0),-(A7)		;file name
	move.w		#5,-(A7)		;Create local Base_page
	move.w		#$4B,-(A7) 		;Pexec
	trap		#1
	lea		$10(A7),A7
	movem.l		(A7)+,A0-A1		;Pop A0-A1
;
	move.w		#0,TRAPflg		;allow traps
	move.l		D0,(A1)+		;BasPag address
	movem.l		D0/A0-A3,-(A7)
	bsr		DO_IT		;in fact load and relocate the file
	lea		Parm_buf,A0
	tst.l		(A0)		;success?
	blt		FreeBP
	movem.l		(A7)+,D0/A0-A3
	
	cmpi.w		#3,2(A0)
	beq		mode_3		;Load but do not exec
	addq.l		#4,A7
	move.w		#4,2(A0)		;exec base page
	lea		Parm_buf(PC),A1
	move.l		#0,4(A0)		;forget other params
	move.l		#0,12(A0)
	move.l		10(A1),8(A0)	;command line
; ==== Who is going to free the basepage? depends on the OS
; ==== For the moment we have only one option
	move.w		NetFlg0,NetFlg0
	bne.s		Pnorm
	movea.l		NPexc_stk,A1
	move.l		Ret_addr,-(A1)
	move.l		8(A0),-(A1)
	move.l		A1,NPexc_stk
	movem.l		(A7)+,D0-D7/A0-A6
	move.l		#FreeBase,-(A7)
	move.w		Old_stat(PC),-(A7)
	bra		old_trp1
Pnorm:
	movem.l		(A7)+,D0-D7/A0-A6
	move.l		Ret_addr,-(A7)
	move.w		Old_stat,-(A7)
	bra		old_trp1
; ==== Multitasking only
FreeBase:
	movem.l		D0/A0,-(A7)
	movea.l		NPexc_stk,A0
	move.l		(A0)+,-(A7)
	move.l		(A0)+,Ret_addr
	move.l		A0,NPexc_stk
	move.w		#1,TRAPflg
	move.w		#$49,-(A7)	;free it
	trap		#1
	addq.l		#6,A7
	movem.l		(A7)+,D0/A0
	move.w		#0,TRAPflg
	move.l		Ret_addr,-(A7)
	rts

mode_3:
	lea		Parm_buf(PC),A1
	move.l		$A(A1),Parm_buf
	rts

FreeBP:
	movem.l		(A7)+,D0/A0-A3
	lea		Parm_buf,A1
	move.l		$A(A1),-(A7)
	move.w		#$49,-(A7) 	;MFREE
	trap		#1
	addq.w		#6,A7
	rts
; ====== End of PEXEC (at last!) ======
Nfclose:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		2(A0),(A1)+
	bra		DO_IT

Nfread:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		2(A0),(A1)+
	move.l		4(A0),(A1)+
	move.l		8(A0),(A1)+
	bra		DO_IT

Nfwrite:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.w		2(A0),(A1)+
	move.l		4(A0),(A1)+
	move.l		8(A0),(A1)+
	bra.s		DO_IT

Nfseek:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		2(A0),(A1)+
	move.w		6(A0),(A1)+
	move.w		8(A0),(A1)+
	bra.s		DO_IT

Ndfree:
	lea		Parm_buf(PC),A1
	move.l		#-3,(A1)+
	move.w		(A0),(A1)+
	move.l		2(A0),(A1)+
	move.w		6(A0),(A1)+

/*	=== OK lets go to C code!! (trying to keep the CPU happy) ===	*/
DO_IT:
	move.w		#1,TRAPflg	;no more net-traps allowed
	bsr.s		preDOIT		;Keep MagiC (and TOS) happy
	movea.l		N_entry(PC),A0
	jsr		(A0)		;call the C routine
	bsr.s		aftDOIT		;restore system stack
	move.w		#0,TRAPflg	;allow net-traps again
	rts

preDOIT:
	move.l		(A7)+,Usr_Stk	;So that everything will come
	move.l		A7,Stk_Sav	;back to normal after the call
	lea		New_Stk,A7	;and MagiC can multitask
	move.l		Usr_Stk,-(A7)	;(even preemptive) with no problem
	rts

aftDOIT:
	move.l		(A7)+,Usr_Stk
	movea.l		Stk_Sav,A7
	move.l		Usr_Stk,-(A7)
	rts

/*	=== End of C NET CALL	===	*/
Upcase:
	movem.l		A1-A2,-(A7)
	lea		PathStr(PC),A2
Uloop:
	move.b		(A1)+,(A2)
	beq.s		U_out
	cmpi.b		#'a',(A2)
	blt.s		U_next
	cmpi.b		#'z',(A2)
	bgt.s		U_next
	subi.b		#32,(A2)+
	bra.s		Uloop
U_next:
	addq.l		#1,A2
	bra.s		Uloop
U_out:
	movem.l		(A7)+,A1-A2
	rts

chk_path:
	movem.l		A0-A1,-(A7)
	moveq		#0,D0
	cmpi.b		#':',1(A1)		; is it ':' ?
	bne.s		Chk_def
	move.b		(A1),D0
	sub.b		#'A',D0
	bra.s		C_exit
Chk_def:
	move.w		GetNewDr,d0
	beq.s		Get_def
	bsr.s		DGETDRV		;this can't happen (until the XFS)

Get_def:
	move.w		Ndef_drv(PC),D0
C_exit:
	movem.l		(A7)+,A0-A1
	rts

DGETDRV:
	move.w		#1,TRAPflg
	movem.l		D0-D2/A0-A2,-(A7)
	move.w		#25,-(A7) 	;Dgetdrv
	trap		#1
	addq.l		#2,A7
	move.w		D0,Ndef_drv
	move.w		#0,GetNewDr
	move.w		#0,TRAPflg
	movem.l		(A7)+,D0-D2/A0-A2
	rts

* ============= Relocate =============
RELOC:
	link		A6,#0
	movem.l		d0-d3/a0-a4,-(A7)
	movea.l		A0,A1
	movea.l		D0,A2
	movea.l		A1,A4
	move.l		8(A1),D3
	movea.l		D3,A0
	move.l		(A2)+,D1
	beq.s		Do_BSS
	adda.l		D1,A0
	moveq		#0,D1
OLoop:
	add.l		D3,(A0)
ILoop:
	move.b		(A2)+,D1
	beq.s		Do_BSS
	cmpi.b		#1,D1
	bne.s		REL_next
	lea		254(A0),A0
	bra.s		ILoop
REL_next:
	adda.w		D1,A0
	bra.s		OLoop
Do_BSS:
	movea.l		24(A4),A1
	move.l		28(A4),D0
	tst.l		D0
	ble.s		REL_exit
	movea.l		A1,A2
	adda.l		D0,A2
BSSinit:
	clr.l		(A1)+
	cmpa.l		A1,A2
	bgt.s		BSSinit
REL_exit:
	movem.l		(A7)+,d0-d3/a0-a4
	unlk		A6
	rts

; ======== End of TEXT Segment =========
	DATA

StkFrm:		dc.l		6
NBasPag:	dc.l		0
NPRN_flg:	dc.w		0
NetFlg0:	dc.w		1
Ndef_drv:	dc.w		1
Old_stat:	dc.w		0
GetNewDr:	dc.w		0
FNxtDta:	dc.l		0

	BSS
Skbdbase:	ds.l	1
Ret_stk:	ds.l	1
Ret_addr:	ds.l	1
N_entry:	ds.l	1
Stk_Sav:	ds.l	2
Usr_Stk:	ds.l	1
N_func:		ds.l	1
NPexc_ptr:	ds.l	1
NPexc_stk:	ds.l	1
FuncPtr:	ds.l	MAXFUNC
dummy:		ds.l	2000	;should be enough
New_Stk:	ds.l	22		;some space up

	END
