/*	================ Local TRAPS	=================== */
/*	Traps from our local station redirected to comm dev	*/
/*  They are NOT used anymore if BNET.XFS is loaded		*/
/*  They will be moved to (or called from) BNET.DOS		*/
/*	===================================================	*/

void	L_dfree (char	*parm)
{
	long	*dptr = (long *)&parm[6];
/*	Dfree set fake values */
	DISKINFO *ptr = (DISKINFO *)*dptr;
	
	ptr->b_free = 500000L;
	ptr->b_total = 1000000L;
	ptr->b_secsiz = 1024L;
	ptr->b_clsiz = 4L;
	dptr = (long *)&Parm_buf;
	*dptr = 0L;
}

void	L_dcreate (char *parm)
{
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		if (! cmd_tx ( N_path()) )
			get_answ (parm);
	}
}

void	L_ddelete (char *parm)
{
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		if (! cmd_tx ( N_path() ) )
			get_answ (parm);
	}
}

void L_dsetpath(char *parm)
{
	char	*path = PathStr, i, *string;
	long	*ptr = (long *)parm;
	
	i = strlen(path);
	if(path[0] == Ndrive) goto norm;
	if(path[0] != '\\' && path[1] != '\\')
	{
		if(path[0] == '.' && path[1] == '.' && i == 2)
			goto dback;
		strcat(tmp_path, path);
		i = strlen(tmp_path);
		if(tmp_path[i-1] != '\\')
		{
			tmp_path[i] = '\\';
			tmp_path[i+1] = 0;
		}
		*ptr = 0L;
		return;
	}
	if(path[0] == '.' && path[1] == '\\')
		if(path[2] == '.' && path[3] == '.' && i == 4)
		{
		dback:
			string = strrchr(tmp_path, '\\');
			if (string )
				*string = 0L;
			string = strrchr (tmp_path, '\\');
			if (string )
				*string = 0L;
			i = strlen(tmp_path);
			if(tmp_path[i-1] != '\\')
			{
				tmp_path[i] = '\\';
				tmp_path[i+1] = 0;
			}else tmp_path[i] = 0;
			*ptr = 0L;
			strcpy(path, lext);
			return;
		}else
		{
			strcat(tmp_path, path);
			i = strlen(tmp_path);
			if(tmp_path[i-1] != '\\')
			{
				tmp_path[i] = '\\';
				tmp_path[i+1] = 0;
			}else tmp_path[i] = 0;
			*ptr = 0L;
			return;
		}
norm:
	strcpy(tmp_path, path);
	if(i > 4 && path[i-1] != '\\')
	{
		strcat(tmp_path, "\\");
		tmp_path[i+1] = 0;
	}
	*ptr = 0L;
	/* check for just slash */
}

/* Ensures unique handles, saves the host it came from */

int 	SetHan (int rhan)
{
	int 	i = 0;
	
	while (Nhans[i][0] != 0)
		if (++i > 209)
			return (ENHNDL);
	Nhans[i][0] = rhan;
	Nhans[i][1] = cur_id;
	return (i + (NETHAN + 6));
}

void	L_fcreate (char *parm)
{
	long	*res = (long *)parm;
	
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		packet->dummy = *(parm+11);
		if (! cmd_tx ( N_path() ) )
			get_answ (parm);
		if (*res > 0)
			*res = SetHan ((int)*res);
	}else
		*res = EFILNF;
}

void	L_fopen (char *parm)
{
	long	*res = (long *)parm;
	
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		packet->dummy = *(parm+11);
		if (! cmd_tx ( N_path() ) )
			get_answ (parm);
		if (*res > 0)
			*res = SetHan ((int)*res);
	}else
		*res = EFILNF;
}

void	L_fclose (char	*parm)
{
	int 	han = *(parm+7) - (NETHAN+6);
	
	packet->cmd = *(parm+5);
	if (han > 0)
	{
		packet->dummy = Nhans[han][0];
		cur_id = Nhans[han][1];
		Nhans[han][0] = 0;
	}
	else
		return;
	if (! cmd_tx (PACSIZ) )
		get_answ (parm);
}

void	L_fread (char	*parm)
{
	long	*ptr, len_to_read, readen = 0L;
	void	*sys_buf = (void *)*(long *)(&parm[12]);
	int 	han = *(parm+7) - (NETHAN+6);
	
	packet->cmd = *(parm+5);
	packet->path_yn = Nhans[han][0];
	cur_id = Nhans[han][1];
	ptr = (long *)&Parm_buf;
	len_to_read = *(ptr + 2);
	while (len_to_read > SECSIZ)
	{
		packet->dummy = (int)SECSIZ;
	last_read:
		if (! cmd_tx (PACSIZ))
		{
			get_answ(parm);
			if (t_hdr->res > 0)
			{
				memcpy (sys_buf, (void *)t_hdr->buf, t_hdr->res );
				len_to_read -= t_hdr->res;
				readen += t_hdr->res;
				(char *)sys_buf += t_hdr->res;
			}else if (t_hdr->res == 0)
				len_to_read = 0L;
			else
				goto	abort_read;
		}
		else
	abort_read:
			{ *ptr = EACCDN; return; }
	}
	if ((packet->dummy = (int)len_to_read) > 0 )
	{
		len_to_read = 0L;
		goto	last_read;
	}
	*ptr = readen;
}

void	L_fwrite (char	*parm)
{
	long	*ptr, len_to_write, writen = 0L;
	void	*sys_buf = (void *)*(long *)(&parm[12]);
	int 	han = *(parm+7) - (NETHAN+6);
	
	packet->cmd = *(parm+5);
	packet->path_yn = Nhans[han][0];
	cur_id = Nhans[han][1];
	ptr = (long *)&Parm_buf;
	len_to_write = *(ptr + 2);
	
	while ( len_to_write > SECSIZ )
	{
		packet->dummy = (int)SECSIZ;
	last_write:
		memcpy (packet->buf, (char *)sys_buf, packet->dummy);
		if (! cmd_tx (packet->dummy + PACSIZ) )
		{
			get_answ (parm);
			if (t_hdr->res > 0)
			{
				len_to_write -= t_hdr->res;
				(char *)sys_buf += t_hdr->res;
				writen += t_hdr->res;
			}
			else if (t_hdr->res == 0)
				len_to_write = 0L;
			else
				goto	abort_write;
		}
		else
	abort_write:
			{ *ptr = EACCDN; return; }
	}
	if ((packet->dummy = (int)len_to_write) > 0 )
	{
		len_to_write = 0L;
		goto	last_write;
	}
	*ptr = writen;
}

void	L_fdelete (char	*parm)
{
	long	*res = (long *)parm;
	
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		if (! cmd_tx (N_path() ) )
			get_answ (parm);
	}
	else
		*res = EPTHNF;
}

void	L_fseek (char	*parm)
{
	FSEEK	*ptr = (FSEEK *)parm;
	int		han = ptr->han - (NETHAN+6);
	
	packet->cmd = ptr->func;
	packet->path_yn = Nhans[han][0];
	cur_id = Nhans[han][1];
	packet->dummy = ptr->posh;
	packet->timeout = ptr->posl;
	packet->buf[0] = 0;
	packet->buf[1] = ptr->froml;

	if (! cmd_tx (PACSIZ + 2))
		get_answ (parm);
}

void	L_fattrib (char	*parm)
{
	long	*res = (long *)parm;
	
	if (val_path() == 3)
	{
		packet->cmd = *(parm+5);
		packet->path_yn = *(parm+9);
		packet->dummy = *(parm+7);
		if (! cmd_tx (N_path()) )
			get_answ (parm);
	}
	else
		*res = EPTHNF;
}

void	L_dgetpath (char *parm)
{
	long	*buf = (long *)&parm[6], *res = (long *)parm;
	int		i;
	char	*cpath;
	
	buf = (long *)*buf;
	if (tmp_path[0] == Ndrive && tmp_path[1] == ':')
		strcpy ((char *)buf, &tmp_path[2]);
	else
		strcpy ((char *)buf, tmp_path);
	cpath = (char *)buf;
	i = strlen (cpath);
	cpath[i-1] = 0;
	*res = 0L;
}

void L_pexec(char	*parm)
{
	long	*ptr, *flen, len;
	int		i, j, han;
	char	dptr[30], *tbase, tmp[40];
	BASPAG	*mybase;
	
	ptr = (long *)&Parm_buf;
	memcpy (tmp, parm, 20);		/* Save the real params	*/
	if (val_path() != 3)
	{
		*ptr = EFILNF;
		return;
	}
	packet->cmd = 0x3D;			/* Fopen	*/
	packet->dummy = FO_READ;
	if (! cmd_tx ( N_path()) )
		get_answ (parm);
	if (*ptr < 0)
	{
		*ptr = EFILNF;
		return;
	}
	packet->cmd = 0x3F;			/* Fread	*/
	packet->path_yn = han = (int)*ptr;
	packet->dummy = 28;		/* File header size	*/
	if (! cmd_tx (PACSIZ))
	{
		get_answ (parm);
		if (t_hdr->res > 0)
			for (i = 0; i < *ptr; i++)
				dptr[i] = t_hdr->buf[i];
	}else
		{ *ptr = EFILNF; return; }
	parm += 10;
	ptr = (long *)*((long *)parm);
	parm -= 10;
	mybase = (BASPAG *)ptr;
	flen = (long *)(dptr+2);
	mybase->p_tbase = (char *)mybase->p_lowtpa + 0x100;
	mybase->p_tlen = *(flen);
	mybase->p_dbase = (char *)mybase->p_tbase + *(flen);
	mybase->p_dlen = *(flen+1);
	mybase->p_bbase = (char *)mybase->p_dbase + *(flen+1);
	mybase->p_blen = *(flen+2);
	len = ((char *)mybase->p_hitpa - (char *)mybase->p_lowtpa) -0x100;
	tbase = (char *)mybase->p_tbase;
	len /= SECSIZ;
	for(i = 0; i <= len; i++)
	{
		packet->cmd = 0x3F;
		packet->path_yn = han;
		packet->dummy = SECSIZ;
		if (! cmd_tx (PACSIZ))
		{
			get_answ (parm);
			if (t_hdr->res > 0)
				memcpy (tbase, t_hdr->buf, t_hdr->res);
			else
				break;
		}else
			{ *ptr = EFILNF; return; }
		tbase += t_hdr->res;
	}
	packet->cmd = 0x3E;			/* Fclose	*/
	packet->dummy = han;
	if (! cmd_tx (PACSIZ))
		get_answ (parm);
	len = *(flen) + *(flen+1) + *(flen+3);
	RELOC (mybase->p_lowtpa, len + (long)mybase->p_tbase);
	memcpy (parm, tmp, 20);		/* restore real params	*/
	ptr = (long *)&Parm_buf;
	*ptr = 0;
}

void	L_fsfirst (char	*parm)
{
	DTA		*dta = Fgetdta();
	long	*ptr;
	int		i=0, cn;
	char	n;
	
	ptr = (long *)&Parm_buf;
	switch (val_path())
	{
	case	0:
		*ptr = EFILNF;
		break;
	case	1:
		while (nodes[++i][0] == 0)
			if (i >= 7)
				goto no_hosts;
		host = i + 1;
		dta->d_reserved[0] = 0x7F;
		dta->d_reserved[1] = 1;
		dta->d_attrib = 0x10;
		dta->d_time = 0x1106;
		dta->d_date = 0x2359;
		dta->d_length = 0L;
		strcpy (dta->d_fname, host_arr[i].name);
		NON = 1;
		*ptr = 0L;
		break;
	case	2:
		if (! host_arr[cur_id].cnh )
			if ((cn = open_connection (host_arr[cur_id].ip_addr)) > 0)
			{
				send_RID (cn);
				if (priv_get (cn))
					makeRec (cur_id, inp_buf);
				else
				{
					close_conn (cn, 2);
					host_arr[cur_id].cnh = 0;
					goto fsf_error;
				}
			}
			else
		no_hosts:
				{ *ptr = EFILNF; FON = 0; return;}
		dta->d_reserved[0] = 0x7F;
		dta->d_reserved[1] = 31;
		dta->d_attrib = 0x10;
		dta->d_time = 0x1106;
		dta->d_date = 0x2359;
		dta->d_length = 0L;
		dta->d_fname[0] = nodes[cur_id][1];
		dta->d_fname[1] = 'x';
		dta->d_fname[2] = 0;
		*ptr = 0L;
		FON = 0;
		NON = 1;
		break;
	case	3:
		FON = NON = 1;
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		packet->dummy = *(parm+11);
		packet->timeout = cur_id;
		if (! cmd_tx (N_path()))
		{
			get_dta();
			dta->d_reserved[1] = 'A' + cur_id;
		}
		else
	fsf_error:
			{ *ptr = EFILNF; FON = 0; return; }
	}
}

void	L_fsnext (char	*parm)
{
	DTA		*dta = Fgetdta();
	long	*ptr;
	static 	char	n = 2;
	char	dr;
	int		i = 1;

	if (!NON) return;
	ptr = (long *)&Parm_buf;
	if (Nodes > 1 && dta->d_reserved[1] == 1)
	{
		for (i = host; i < MAXHOSTS; i++)
		{
			if (nodes[i][0])
			{
				host = i;
				break;
			}
		}
		if ( i == 8) { *ptr = ENMFIL; NON = 0; return; }
		dta->d_reserved[0] = 0x7F;
		dta->d_reserved[1] = 1;
		dta->d_attrib = 0x10;
		dta->d_time = 0x1106;
		dta->d_date = 0x2359;
		dta->d_length = 0L;
		strcpy (dta->d_fname, host_arr[host].name);
		*ptr = 0L;
		host++;
		return;
	}
	if (dta->d_reserved[1] == 31)
	{
		if ((dr = nodes[cur_id][n++]) > 0)
		{
			dta->d_reserved[0] = 0x7F;
			dta->d_reserved[1] = 31;
			dta->d_attrib = 0x10;
			dta->d_time = 0x1106;
			dta->d_date = 0x2359;
			dta->d_length = 0L;
			dta->d_fname[0] = dr;
			dta->d_fname[1] = 'x';
			dta->d_fname[2] = 0;
			*ptr = 0L;
		}
		else
		{
			*ptr = ENMFIL;
			n = 2;
		}
		return;
	}
	if (FON && dta->d_reserved[1] > 'A')
	{
		packet->cmd = *(parm+5);
		packet->path_yn = 0;
		packet->dummy = 0;
		packet->timeout = cur_id = (int)(dta->d_reserved[1] - 'A');
		if (! cmd_tx (PACSIZ))
			get_dta();
		else
			*ptr = EACCDN;
		
	}else
		*ptr = ENMFIL;
}

void	L_frename (char *parm)
{
	int		i, j;
	long	*ptr = (long *)parm;
	
	if ( val_path () == 3 )
	{
		i = N_path();
		i += R_path (parm, i-PACSIZ);
		packet->cmd = *(parm+5);
		packet->path_yn = 1;
		if (! cmd_tx(i) )
			get_answ (parm);
	}
	else *ptr = EACCDN;
}

void	L_fdatime (char	*parm)
{
	long	*buf = (long *)&parm[10];
	char	*timdat;
	int 	han = (int)*(parm+9) - (NETHAN + 6), i;
	
	packet->cmd = *(parm+5);
	packet->path_yn = Nhans[han][0];	/* handle	*/
	cur_id = Nhans[han][1];
	packet->dummy = *(parm+7);			/* flag	*/
	
	buf = (long *)*buf;
	timdat = (char *)buf;
	if (packet->dummy == 1)
	{
		for (i = 0; i < 4; i++)
			packet->buf[i] = timdat[i];
		if (! cmd_tx (i + PACSIZ))
			get_answ (parm);
	}
	else
	{
		if (! cmd_tx (PACSIZ))
			get_answ (parm);
		for (i = 0; i < 4; i++)
			timdat[i] = t_hdr->buf[i];
	}
}

/* =========== End of LOCAL -> REMOTE functions =============*/

void get_dta (void)
{
	char	*dta = (char *)Fgetdta(), i;
	long	*ptr;
	
	ptr = (long *)&Parm_buf;
	get_answ (Parm_buf);
	if (*ptr == 0L)
		memcpy (&dta[20], t_hdr->buf, sizeof(DTA) - 20);

	dta[0] = 0x7F;
}

/* --- Make the Path for output --- */

int 	N_path (void)
{
	char	*Path_ptr = PathStr;
	char	*Npath = packet->buf, *ptr;
	int		i=3;
	
	Path_ptr = strchr (&Path_ptr[3], '\\');
	Npath[1] = *++Path_ptr;
	Path_ptr += 2;
	Npath[2] = ':';
	do
		Npath[i++] = *Path_ptr++;
	while(*Path_ptr);
	Npath[i] = 0; Npath[0] = i-1;	/* make it Pascal	*/
	return (i+PACSIZ + 1);
}

/* --- Make two Paths for output to remote host (Rename only)--- */

int 	R_path ( char *parm, int len )
{
	char	*Path_ptr;
	char	*Npath = &packet->buf[len], *ptr;
	int		i=3;
	
	parm += 10;
	Path_ptr = (char *)*((long *)parm);
	parm -= 10;
	Path_ptr = strchr (&Path_ptr[3], '\\');
	Npath[1] = *++Path_ptr;
	Path_ptr += 2;
	Npath[2] = ':';
	do
		Npath[i++] = *Path_ptr++;
	while (*Path_ptr);
	Npath[i] = 0; Npath[0] = i-1;
	return (i+1);
}

/*	----------------------------------------------------
 * End of functions not needed for XFS
 ---------------------------------------------------- */
