/*
 * xfs_bnet.h started 23.11.1997
 * by Vassilis Papathanassiou
*/

#ifndef _XFS_BNET_H
#define _XFS_BNET_H

#include <magx_xfs.h>
#include "d:\midi_net.c\bnet_app.h"

#define MAX_FD			26		/* Used for open files in Dpathconf */
#define MAX_DHD			48		/* Maximum DIR handles	*/
#define ROOTSIZE		MAXHOSTS
#define DEFSIZE			SECSIZ
#define DEF_DIR			(DEFSIZE / sizeof(DIR_SLOT)) /* Num of entries */
#define ROOT			0
#define ROOT_DE			(DIR_SLOT *)1L	/* Space for ROOT */

#define is_file(x)		((x & S_IFMT) == S_IFREG)
#define is_dir(x)		((x & S_IFMT) == S_IFDIR)
#define is_link(x)		((x & S_IFMT) == S_IFLNK)

#define waccess(x)		((x)->de_xattr.mode & S_IWUSR)
#define raccess(x)		((x)->de_xattr.mode & S_IRUSR)
#define xaccess(x)		((x)->de_xattr.mode & S_IXUSR)

#define parentfd(x)		((x)->fd_parent->fd_file)

#define Dcntl(x, y, z)	gemdos(0x130, (WORD)(x), (char *)(y), (LONG)(z))

/* Just for safety	(Thomas) */
#undef FA_RDONLY
#undef FA_HIDDEN
#undef FA_SYSTEM
#undef FA_LABEL
#undef FA_DIR
#undef FA_CHANGED
#undef FA_SYMLINK
#define FA_RDONLY		0x01
#define FA_HIDDEN		0x02
#define FA_SYSTEM		0x04
#define FA_LABEL		0x08
#define FA_DIR			0x10
#define FA_CHANGED		0x20
#define FA_SYMLINK		0x40
/* safety (and compatibility) again	*/
#undef FSTAT
#undef FIONREAD
#undef FIONWRITE
#undef FUTIME
#define FSTAT		0x4600
#define FIONREAD	0x4601
#define FIONWRITE	0x4602
#define FUTIME		0x4603


typedef struct
{
	char	de_fname[34];	/* Name without Path 		*/
	char	*de_faddr;		/* Data for the dir entry	*/
	WORD	de_nr;			/* Flag for Fsfirst only	*/
	WORD	de_maxnr;		/* Max entries for the SLOT */
	WORD	de_host;		/* Remote (where it belongs)*/
	XATTR	de_xattr;
} DIR_SLOT;

typedef struct bnet_fd
{
	DMD				*fd_dmd;		/* MagiC 			*/
	WORD			fd_refcnt;		/* MagiC 			*/
	WORD			fd_mode;		/* MagiC (file mode)*/
	THE_MGX_DEV		*fd_dev;		/* MagiC (bnet_dev)	*/
	LONG			fd_fpos;		/* Seek pointer 	*/
	WORD			fd_han;			/* Remmote handle	*/
	DIR_SLOT		*fd_file;		/* Dir for the file */
	WORD			fd_is_parent;	/* Num of links		*/
	struct bnet_fd	*fd_parent;		/* 'Parent' struct	*/
	BASPAG			*fd_owner;		/* APP that uses it */
} BNETX_FD;

typedef struct
{
	DMD			*dhd_dmd;		/* MagiC				*/
	DIR_SLOT	*dhd_dir;		/* Pointer to DIR chain	*/
	WORD		dhd_pos;		/* Like seek for FDs	*/
	WORD		dhd_host;		/* Remote host index	*/
	WORD		dhd_tosmode;	/* Dopendir or Fsfirst	*/
	BASPAG		*dhd_owner;		/* APP that uses DIR	*/
} BNETX_DHD;

/* DTA copied from Thomas' Ramdisk	*/
typedef struct
{
	DIR_SLOT	*dta_dir;
	WORD		dta_pos;
	char		dta_mask[13];
	char		dta_attr;
	char		dta_drive;
	char		dta_attribute;
	WORD		dta_time;
	WORD		dta_date;
	LONG		dta_len;
	char		dta_name[14];
} BNETX_DTA;

typedef struct
{
	long	cookie_id;
	long	cookie_value;
} COOKIE;

/* Dummy file block for file operations	*/
typedef struct fblk
{
	char		data[DEFSIZE];
	struct fblk	*next;
} FILEBLOCK;

#include "proto.h"

#endif /* _XFS_BNET_H */
