/*********************************************************************
*
* MagiC 3/4/5
* ===========
*
* Strukturen fr die Einbindung eines XFS.
* Fr die Implementation eines XFS in 'C' sind die korrespondierenden
* CDECL_xxx Strukturen fr MX_XFS und MX_DEV definiert.
* Dies ermglicht die Verwendung eines beliebigen Compilers.
*
* Es wird <portab.h> bentigt.
*
* Version: 10.5.97
*
*********************************************************************/

#ifndef __MX_XFS__
#define __MX_XFS__

#include <tos_old.h>
#include <portab_c.h>
#include "atarierr.h"

#ifndef ELINK
#define ELINK  -300           /* File is symbolic Link */
#define KER_GETINFO	0x100
#define KER_INSTXFS	0x200
#endif

extern void	*real_xfs;

typedef union unsel_union
{
	void	(*unsel)(void *un);
	LONG	status;
} UNSELECT;

typedef struct magx_unsel_struct
{
	UNSELECT	unsel;
	LONG		param;
} MAGX_UNSEL;

typedef struct
{
	void	*d_xfs;
	WORD	d_drive;
	void	*d_root;
	WORD	d_biosdev;
	void	*d_driver;
	LONG	d_devcode;
	void	*d_dfs;
} DMD;

typedef struct
{
	WORD		version;
	void		(*fast_clrmem)		(void *von, void *bis);
	char		(*to_upper)			(WORD c);
	void 		(*_sprintf)			(char *dest, char *source, LONG *p);
	BASPAG		**act_pd;
	void		*act_appl;
	void		*keyb_appl;
	WORD		*pe_slice;
	WORD		*pe_timer;
	void		(*appl_yield)		(void);
	void		(*appl_suspend)		(void);
	void		(*appl_begcritic)	(void);
	void		(*appl_endcritic)	(void);
	LONG		(*event_IO)			(LONG ticks_50hz, MAGX_UNSEL *unsel);
	void		(*event_mIO)		(LONG ticks_50hz, MAGX_UNSEL *unsel, WORD cnt);
	void		(*event_emIO)		(void *ap);
	void		(*appl_IOcomplete)	(void *ap);
#define SEM_FREE	0
#define SEM_SET		1
#define SEM_TEST	2
#define SEM_CSET	3
#define SEM_GET		4
#define SEM_CREATE	5
#define SEM_DEL		6
	LONG		(*evnt_sem)			(WORD mode, void *sem, LONG timeout);
	void		(*Pfree)			(BASPAG *pd);
	WORD		int_msize;
	void		*(*int_malloc)		(void);
	void		(*int_mfree)		(void *memblk);
	void		(*resv_intmem)		(void *mem, LONG bytes);
	LONG		(*diskchange)		(WORD drv);
/* Ab Kernelversion 1: */
	LONG		(*DMD_rdevinit)		(DMD *dmd);
/* Ab Kernelversion 2: */
	LONG		(*proc_info)		(WORD code, BASPAG *pd);
/* Ab Kernelversion 4: */
	void		*(*mxalloc)			(LONG amount, WORD mode, BASPAG *pd);
	LONG		(*mfree)			(void *block);
	void		*(*mshrink)			(void *block, LONG newlen);
} THE_MX_KERNEL;

extern THE_MX_KERNEL *real_kernel;

typedef struct
{
	WORD	version;
	LONG	_dir_srch;
	LONG	reopen_FD;
	LONG	close_DD;
	LONG	match_8_3;
	LONG	conv_8_3;
	LONG	init_DTA;
} MX_DFSKERNEL;

typedef struct
{
	LONG	(*dev_close)	(void *file);
	LONG	(*dev_read)		(void *file, LONG count, char *buffer);
	LONG	(*dev_write)	(void *file, LONG count, char *buffer);
	LONG	(*dev_stat)		(void *file, MAGX_UNSEL *unselect, WORD rwflag, LONG apcode);
	LONG	(*dev_seek)		(void *file, LONG where, WORD mode);
	LONG	(*dev_datime)	(void *file, WORD *d, WORD setflag);
	LONG	(*dev_ioctl)	(void *file, WORD cmd, void *buf);
#define CMODE_RAW		0
#define CMODE_COOKED	1
#define CMODE_ECHO		2
	LONG	(*dev_getc)		(void *file, WORD mode);
	LONG	(*dev_getline)	(void *file, char *buf, WORD mode, LONG size);
	LONG	(*dev_putc)		(void *file, WORD mode, LONG value);
} THE_MGX_DEV;

typedef struct
{
	DMD		*dd_dmd;
	WORD	dd_refcnt;
} MGX_DD;

typedef struct
{
	DMD		*fd_dmd;
	WORD	fd_refcnt;
	WORD	fd_mode;
	void	*fd_dev;
} MGX_FD;

typedef struct
{
	DMD		*dhd_dmd;
} MGX_DHD;

typedef struct _mx_dta {
     char      dta_res1[20];
     char      dta_drive;
     char      dta_attrib;
     WORD      dta_time;
     WORD      dta_date;
     ULONG     dta_len;
     char      dta_name[14];
} MX_DTA;

/* #ifndef S_IFMT */
typedef struct {
    UWORD   mode;           /* Filetyp und -modus */
/* Mgliche Filetypen */
#define S_IFMT  0170000     /* Maske zur Isolierung des Filetyps */
#define S_IFCHR 0020000     /* Spezielles BIOS-File (z.B. Device) */
#define S_IFDIR 0040000     /* Verzeichnis */
#define S_IFREG 0100000     /* Normale Datei */
#define S_IFIFO 0120000     /* FIFO (Pipe mit Namen) */
#define S_IMEM  0140000     /* Speicherblock- oder Prozefile */
#define S_IFLNK 0160000     /* Symbolischer Link */

/*
 * Spezielle Bits (zumindest die ersten beiden knnen unter MagiC
 * ohne nderung des XFS-Konzepts nicht korrekt benutzt werden)
 */
#define S_ISUID 04000       /* User-ID des Eigentmers bei Aufruf setzen */
#define S_ISGID 02000       /* Gruppen-ID bei Aufruf setzen */
#define S_ISVTX 01000       /* "Sticky bit", Bedeutung abhngig vom Filetyp */

/* Zugriffsrechte */
#define S_IRUSR 0400        /* Eigentmer darf Datei lesen */
#define S_IWUSR 0200        /*      "       "    "   beschreiben */
#define S_IXUSR 0100        /*      "       "    "   ausfhren */
#define S_IRGRP 0040        /* Gruppenmitglieder drfen Datei lesen */
#define S_IWGRP 0020        /*          "           "     "   beschreiben */
#define S_IXGRP 0010        /*          "           "     "   ausfhren */
#define S_IROTH 0004        /* Andere drfen Datei lesen */
#define S_IWOTH 0002        /*    "      "     "   beschreiben */
#define S_IXOTH 0001        /*    "      "     "   ausfhren */

    LONG    index;          /* Fileindex, wie bei Dreaddir */
    UWORD   dev;            /* Gert, auf dem die Datei liegt */
    UWORD   rdev;           /* Tatschliches Gert (z.B. bei BIOS-Files) */
    UWORD   nlink;          /* Zahl der "echten" Links auf dieses File */
    UWORD   uid;            /* User-ID des Eigentmers */
    UWORD   gid;            /* Gruppen-ID fr dieses File */
    LONG    size;           /* Lnge in Bytes */
    LONG    blksize;        /* Gre eines Blocks in Bytes */
    LONG    nblocks;        /* Anzahl von Blocks, die die Datei belegt */
    WORD    mtime;          /* Uhrzeit der letzten Modifikation */
    WORD    mdate;          /* Datum der letzten Modifikation */
    WORD    atime;          /* Uhrzeit des letzten Zugriffs auf die Datei */
    WORD    adate;          /* Datum des letzten Zugriffs */
    WORD    ctime;          /* Erzeugungszeit */
    WORD    cdate;          /* Erzeugungsdatum */
    WORD    attr;           /* Standard-TOS-Attribute (wie bei Fattrib) */
    WORD    reserved2;      /* bislang reserviert */
    LONG    reserved3[2];   /* dito */
} XATTR;

/* #endif */

typedef struct
{
	char	xfs_name[8];
	LONG	(*xfs_sync)(DMD *d);
	void	(*xfs_pterm)(DMD *d, BASPAG *pd);
	LONG	(*xfs_garbcoll)(DMD *d);
	void	(*xfs_freeDD)(void *dd);
	LONG	(*xfs_drv_open)(DMD *d);
	LONG	(*xfs_drv_close)(DMD *d, WORD mode);
	LONG	(*xfs_path2DD)(void *reldir, char *pathname, WORD mode,
		char **lastpath, LONG *linkdir, char **symlink);
	LONG	(*xfs_sfirst)(void *srchdir, char *name, MX_DTA *dta,
		WORD attrib, char **symlink);
	LONG	(*xfs_snext)(MX_DTA *dta, DMD *dmd, char **symlink);
#define OM_RPERM	1
#define OM_WPERM	2
#define OM_EXEC		4
#define OM_APPEND	8
#define OM_RDENY	16
#define OM_WDENY	32
#define OM_NOCHECK	64
#define O_CREAT		0x200
#define O_TRUNC		0x400
#define O_EXCL		0x800

	LONG	(*xfs_fopen)(void *dir, char *name, WORD omode,
		WORD attrib, char **symlink);
	LONG	(*xfs_fdelete)(void *dir, char *name);
	LONG	(*xfs_link)(void *olddir, void *newdir, char *oldname,
		char *newname, WORD flag_link);

	LONG	(*xfs_xattr)(void *dir, char *name, XATTR *xattr,
		WORD mode, char **symlink);

	LONG	(*xfs_attrib)(void *dir, char *name, WORD rwflag,
		WORD attrib, char **symlink);
	LONG	(*xfs_chown)(void *dir, char *name, UWORD uid,
		UWORD gid, char **symlink);
	LONG	(*xfs_chmod)(void *dir, char *name, UWORD mode,
		char **symlink);
	LONG	(*xfs_dcreate)(void *dir, char *name);
	LONG	(*xfs_ddelete)(void *dir);
	LONG	(*xfs_DD2name)(void *dir, char *name, WORD bufsize);
	LONG	(*xfs_dopendir)(void *dir, WORD tosflag);
	LONG	(*xfs_dreaddir)(void *dhd, WORD size, char *buf,
		XATTR *xattr, LONG *xr);
	LONG	(*xfs_drewinddir)(void *dhd);
	LONG	(*xfs_dclosedir)(void *dhd);
	LONG	(*xfs_dpathconf)(void *dir, WORD which);
	LONG	(*xfs_dfree)(void *dd, DISKINFO *free);
	LONG	(*xfs_wlabel)(void *dir, char *name);
	LONG	(*xfs_rlabel)(void *dir, char *name, char *buf,
		WORD len);
	LONG	(*xfs_symlink)(void *dir, char *name, char *to);
	LONG	(*xfs_readlink)(void *dir, char *name, char *buf,
		WORD size);

	LONG	(*xfs_dcntl)(void *dir, char *name, WORD cmd, LONG arg,
		char **symlink);
} THE_MGX_XFS;

THE_MX_KERNEL *install_xfs(THE_MGX_XFS *xfs);

#endif