/*
 * proto.h started 23.11.1997
 * by Vassilis Papathanassiou
 * Just Andreas Kromke defines, made private
 * Some names from Thomas Binder's RAMDISK.XFS
*/

#ifndef _XFS_BNET_PROTO_H
#define _XFS_BNET_PROTO_H

#ifndef NULL
#define   NULL   ( (void*) 0L )
#endif
/* ================= Init routines =============*/
void load_bnet_inf (void);
WORD readline (WORD handle, char *buffer);
LONG get_and_set_drive (void);
LONG set_bnet_drive (void);
/* ================= XFS routines =============*/
LONG bnet_sync (DMD *d);
void bnet_pterm (DMD *d, BASPAG *pd);
LONG bnet_garbcoll (DMD *d);
void bnet_freeDD (void *dd);
LONG bnet_drv_open (DMD *d);
LONG bnet_drv_close (DMD *d, WORD mode);
LONG bnet_path2DD (void *reldir, char *pathname, WORD mode,
	char **lastpath, LONG *linkdir, char **symlink);
void inc_refcnt (BNETX_FD *dd);
LONG bnet_sfirst (void *srchdir, char *name, MX_DTA *dta,
	WORD attrib, char **symlink);
LONG bnet_snext (MX_DTA *dta, DMD *dmd, char **symlink);
LONG bnet_fopen (void *dir, char *name, WORD omode, WORD attrib,
	char **symlink);
LONG bnet_fdelete (void *dir, char *name);
LONG bnet_link (void *olddir, void *newdir, char *oldname,
	char *newname, WORD flag_link);
LONG bnet_xattr (void *dir, char *name, XATTR *xattr, WORD mode,
	char **symlink);
LONG bnet_attrib (void *dir, char *name, WORD rwflag, WORD attrib,
	char **symlink);
LONG attrib_action (DIR_SLOT *entry, LONG rwflag, LONG attrib);
LONG bnet_chown (void *dir, char *name, UWORD uid, UWORD gid,
	char **symlink);
LONG bnet_chmod (void *dir, char *name, UWORD mode,
	char **symlink);
LONG chmod_action (DIR_SLOT *entry, LONG _mode, LONG dummy);
LONG bnet_dcreate (void *dir, char *name);
LONG bnet_ddelete (void *dir);
LONG bnet_DD2name (void *dir, char *name, WORD bufsize);
LONG bnet_dopendir (void *dir, WORD tosflag);
LONG bnet_dreaddir (void *dhd, WORD size, char *buf, XATTR *xattr,
	LONG *xr);
LONG bnet_drewinddir (void *dhd);
LONG bnet_dclosedir (void *dhd);
LONG bnet_dpathconf (void *dir, WORD which);
LONG bnet_dfree (void *dd, DISKINFO *free);
LONG get_size (DIR_SLOT *search);
LONG bnet_wlabel (void *dir, char *name);
LONG bnet_rlabel (void *dir, char *name, char *buf, WORD len);
/* LONG bnet_symlink (void *dir, char *name, char *to); */
LONG bnet_readlink (void *dir, char *name, char *buf, WORD size);
LONG bnet_dcntl (void *dir, char *name, WORD cmd, LONG arg,
	char **symlink);
LONG dcntl_action (DIR_SLOT *entry, LONG cmd, LONG arg);

LONG bnet_close (void *file);
LONG bnet_read (void *file, LONG count, char *buffer);
LONG bnet_write (void *file, LONG count, char *buffer);
LONG bnet_stat (void *file, MAGX_UNSEL *unselect, WORD rwflag,
	LONG apcode);
LONG bnet_seek (void *file, LONG where, WORD mode);
LONG bnet_datime (void *file, WORD *d, WORD setflag);
LONG bnet_ioctl (void *file, WORD cmd, void *buf);
LONG bnet_getc (void *file, WORD mode);
LONG bnet_getline (void *file, char *buf, WORD mode, LONG size);
LONG bnet_putc (void *file, WORD mode, LONG value);

void prepare_dir (DIR_SLOT *dir, WORD maxentries, DIR_SLOT *parent);
DIR_SLOT *find_obj (BNETX_FD *dd, char *pathname, WORD spos,
	WORD s_or_e, WORD maybe_dir);
#define FF_SEARCH	0
#define FF_EXIST	1
BNETX_FD *findfd (DIR_SLOT *fname);
DIR_SLOT *new_file (BNETX_FD *curr, char *name);
WORD dir_is_open (DIR_SLOT *dir);
WORD check_name (char *name);
LONG check_dd (BNETX_FD *dd);
LONG check_fd (BNETX_FD *fd);
LONG work_entry (BNETX_FD *dd, char *name, char **symlink,
	WORD writeflag, LONG par1, LONG par2,
	LONG (*action)(DIR_SLOT *entry, LONG par1, LONG par2));
LONG set_amtime (DIR_SLOT *entry, LONG set_atime, LONG unused);
void tostrunc (char *src, char *dest, WORD wildcards);
void fill_tosname (char *dest, char *src);
WORD match_tosname (char *to_check, char *sample);
WORD has_xext (char *name);
void *Kmalloc (LONG len);
void *Krealloc (void *ptr, LONG old_len, LONG new_len);
LONG Pdomain_gemdos (WORD domain);
LONG Pdomain_kernel (WORD ignore);

/* =========== Network routines =============*/
/* WORD	connect_host (WORD cur_id); */
WORD	new_cookie (COOKIE *entry);

#ifdef DEBUG
void trace(char *format, WORD params, ...);
#define TRACE(x) trace x
#else
#define TRACE(x)	/* Nothing */
#endif
LONG *get_cookie(ULONG cookie, ULONG *value);

#ifdef MAIN_BODY
#define _GLOBAL	extern
_GLOBAL	THE_MGX_XFS	bnet_xfs;
_GLOBAL THE_MGX_DEV	bnet_dev;
#else
#define _GLOBAL
THE_MGX_XFS		bnet_xfs = {
	"Bnet_xfs", bnet_sync, bnet_pterm, bnet_garbcoll,
	bnet_freeDD, bnet_drv_open, bnet_drv_close,
	bnet_path2DD, bnet_sfirst, bnet_snext, bnet_fopen,
	bnet_fdelete, bnet_link, bnet_xattr, bnet_attrib,
	bnet_chown, bnet_chmod, bnet_dcreate, bnet_ddelete,
	bnet_DD2name, bnet_dopendir, bnet_dreaddir,
	bnet_drewinddir, bnet_dclosedir, bnet_dpathconf,
	bnet_dfree, bnet_wlabel, bnet_rlabel,NULL,
	bnet_readlink, bnet_dcntl};
THE_MGX_DEV		bnet_dev = {
	bnet_close, bnet_read, bnet_write, bnet_stat,
	bnet_seek, bnet_datime, bnet_ioctl, bnet_getc,
	bnet_getline, bnet_putc};
#endif
_GLOBAL	WORD			bnet_drive, stack,
						starttime,
						startdate;
_GLOBAL	DMD				*bnet_dmd;
_GLOBAL	THE_MX_KERNEL	*kernel;
_GLOBAL	BNETX_FD		fd[MAX_FD];
_GLOBAL	BNETX_DHD		dhd[MAX_DHD];
_GLOBAL	DIR_SLOT		root[ROOTSIZE],
						root_de;
_GLOBAL DIR_SLOT		remote[MAXHOSTS][MAXDRIVES * 2]; /* test */
_GLOBAL DIR_SLOT		def_dir[MAXDRIVES],
						rem_slot[MAXHOSTS][ROOTSIZE * 2];
_GLOBAL	FILEBLOCK		def_file;  /* test */

_GLOBAL	WORD			eight_bit;
_GLOBAL char			volume_label[34], def_slot[(ROOTSIZE * 2) * DEFSIZE];
_GLOBAL COOKIE			bnet_cook;
_GLOBAL LONG			(*Pdomain)(WORD ignore);

#ifdef DEBUG
_GLOBAL	WORD			debug_to_screen;
#endif

#endif /* _XFS_BNET_PROTO_H */

/* EOF */
