*EPROM PROGRAMATOR 
* Petar Putnik 
*New version 1993.

*Note: routines for EPROMs 271002,271004 and 271008 are not implemented yet.

* resource set indicies for EPROM *)

maindial = 0;	(* form/dialog *)
mainbox  = 0;	(* BOX in tree MAINDIAL *)
maintitt = 1;	(* BOXTEXT in tree MAINDIAL *) ted 0
vpptext  = 2;	(* STRING in tree MAINDIAL *)
tsbox    = 3;	(* BOX in tree MAINDIAL *)
t2716    = 4;	(* BUTTON in tree MAINDIAL *)
t2732    = 5;	(* BUTTON in tree MAINDIAL *)
t2764    = 6;	(* BUTTON in tree MAINDIAL *)
t27128   = 7;	(* BUTTON in tree MAINDIAL *)
t27256   = 8;	(* BUTTON in tree MAINDIAL *)
t27512   = 9;	(* BUTTON in tree MAINDIAL *)
t271001  = 10;	(* BUTTON in tree MAINDIAL *)
t271002  = 11;	(* BUTTON in tree MAINDIAL *)
t271004  = 12;	(* BUTTON in tree MAINDIAL *)
t271008  = 13;	(* BUTTON in tree MAINDIAL *)
pt24     = 14;	(* TEXT in tree MAINDIAL *) ted 1
pt28     = 15;	(* TEXT in tree MAINDIAL *) ted 2
pt32     = 16;	(* TEXT in tree MAINDIAL *) ted 3
vppbox   = 17;	(* BOX in tree MAINDIAL *)
vpp12v   = 18;	(* BUTTON in tree MAINDIAL *)
vpp21v   = 19;	(* BUTTON in tree MAINDIAL *)
vpp25v   = 20;	(* BUTTON in tree MAINDIAL *)
emptybut = 21;	(* BUTTON in tree MAINDIAL *)
progbut  = 22;	(* BUTTON in tree MAINDIAL *)
eprcobut = 23;	(* BUTTON in tree MAINDIAL *)
adrtext  = 24;	(* BUTTON in tree MAINDIAL *)
adress   = 25 *ted 4
abortmes = 26;	(* TEXT in tree MAINDIAL *) ted 5
dattext  = 27;	(* BUTTON in tree MAINDIAL *)
data     = 28 *ted 6
loadbut  = 29;	(* BUTTON in tree MAINDIAL *)
savbut   = 30;	(* BUTTON in tree MAINDIAL *)
cmpbut   = 31;	(* BUTTON in tree MAINDIAL *)
ramhtext = 32;	(* FTEXT in tree MAINDIAL *)
ramhted  = 7 ;ted 7
exitbut  = 33;	(* BUTTON in tree MAINDIAL *)
dispbut  = 34;	(* BUTTON in tree MAINDIAL *)
tsbtext  = 35;	(* TEXT in tree MAINDIAL *) ted 8
modebox  = 36;	(* IBOX in tree MAINDIAL *)
normbut  = 37;	(* STRING in tree MAINDIAL *)
fastbut  = 38;	(* STRING in tree MAINDIAL *)
modetxt  = 39;	(* TEXT in tree MAINDIAL *) ted 9

byedial  = 1;	(* form/dialog *)
byebox   = 0
byetext  = 1;  ted 10

dispdial = 2;	(* form/dialog *)
dispbox  = 0;	(* BOX in tree DISPDIAL *)
curstext = 1;	(* STRING in tree DISPDIAL *)
curspos  = 2;	(* TEXT in tree DISPDIAL *)
cursted  = 11 ;ted 11
dispmtxt = 3;	(* STRING in tree DISPDIAL *)
eightbut = 4;	(* BUTTON in tree DISPDIAL *)
sevenbut = 5;	(* BUTTON in tree DISPDIAL *)
savchbut = 6;	(* BUTTON in tree DISPDIAL *)
dispexit = 7;	(* BUTTON in tree DISPDIAL *)
decbut   = 8
hexbut   = 9
searchbu = 10;	(* BUTTON in tree DISPDIAL *)


srchdial = 3;	(* form/dialog *)
srchbox  = 0;	(* BOX in tree SRCHDIAL *)
srchtext = 1;	(* BOXTEXT in tree SRCHDIAL *)
*ted 12
srchentr = 2;	(* FBOXTEXT in tree SRCHDIAL *)
*ted 13
hexbox   = 3
srhexbu  = 4;	(* TEXT in tree SRCHDIAL *)
*ted 14
casbox   = 5;	(* BOX in tree SRCHDIAL *)
casdifbu = 6;	(* TEXT in tree SRCHDIAL *)
*ted 15
inptext  = 7;	(* TEXT in tree SRCHDIAL *)
*ted 16
srchokbu = 8;	(* BUTTON in tree SRCHDIAL *)
captext  = 9;	(* TEXT in tree SRCHDIAL *)
* ted 17



alempty  = 0;	(* Alert string index *)
alnotemp = 1;	(* Alert string index *)
aldiffby = 2;	(* Alert string index *)
alputepr = 3;	(* Alert string index *)
alprgerr = 4;	(* Alert string index *)
alnopld  = 5;	(* Alert string index *)
alsame   = 6;	(* Alert string index *)
alfisel  = 7;	(* Alert string index *)
alsavchg = 8
alstrinf = 9
albadhex = 10


*some macros (speed)
strobed macro

  movep.w d7,(a0)
  endm
   
strobup macro

  movep.w d6,(a0)
  endm
  
  
centrd macro
  movep.w d5,(a0)
  endm  

superv macro *better use xbios 38 !
  pea 0.w
  move.w #32,-(sp)
  trap #1
  addq.l #6,sp
  move.l d0,SSP
  endm

userm macro
  move.l SSP(pc),-(sp)
  move.w #32,-(sp)
  trap #1
  addq.l #6,sp
  endm


*  opt d+  *labels for debug

 
  move.l 4(sp),a4 *basepage
  move.l 4(a4),d0


memtest 
  lea RAM(pc),a0

  add.l #512*1024+7000,a0 *for EPROM 271004 max (for now) + place for RSC
  sub.l a0,d0
  bgt.s mshrink
  lea nomem(pc),a0
  bra prex

mshrink
  
  lea -6000(a0),a0 *sub len for RSC
  sub.l (a4),a0
  pea (a0)
  move.l (a4),-(sp)  *TPA begin
  move.w #0,-(sp)
  move.w #74,-(sp)
  trap #1
   

  lea stend(pc),sp

  bsr AEScall
  dc.w 10,0,1,0,0  *APPL INIT
  move.w intout,ident

rscld  bsr AEScall
  dc.w 110,0,1,1,0
  dc.l rsn
  tst.w intout
  bne.s gadr
  lea fmis(pc),a0
prex  bsr doalert1
 
exit  bsr AEScall
  dc.w 19,0,1,0,0   *APPL exit if RSC not found

  clr.w -(sp)
  trap #1  *END

theend lea 1.w,a0 *byedial
  bsr takeadr
  bsr opdial
  bsr drdial

  move.w #55550,d0
paus divu #55,d1
  dbf d0,paus
 
  lea 0.w,a0 *maindial
  bsr takeadr
  bsr opdial  

  bsr cldial

  bsr AEScall
  dc.w 111,0,1,0,0 *rsrc_free

  bra.s exit



gadr 

*Get aktuell drive 
  move.w #25,-(sp)
  trap #1
  addq.l #2,sp

  lea path(pc),a2
  cmp.b #1,d0 *is floppy
  ble.s pathprep  
  move.w #mloop+2-paff,paff-2-path(a2) *skip pause
pathprep add.b #"A",d0
  move.b d0,(a2)   

  bsr conslt
  move.w d0,consm

  lea $20000+11,a0  *ted of curspos
  bsr takeadr
  move.l (a0),curspo *so is faster

   
drmain  lea 0.w,a0  *Object ident
  bsr takeadr
  bsr opdial
  bsr drdial

  bra paff *changeable
paff  
*pause for floppy- only after load
  move.w #1200,d5
conmsl bsr onems
  dbf d5,conmsl  

  bsr makesb
  move.w #mloop+2-paff,paff-2

mloop  
  bsr ocrd *deselect last button
nodes
  bsr maarr
  bsr fodial

  bsr mabee
  move.w excod(pc),d0
  cmp.w #exitbut,d0
  beq theend
  cmp.w #eprcobut,d0
  beq kopi  *eprom>RAM
  cmp.w #loadbut,d0
  beq load  *disk>RAM
  cmp.w #savbut,d0
  beq save  *RAM>disk
  cmp.w #emptybut,d0
  beq provera  *Is erased?
  cmp.w #cmpbut,d0
  beq compare
  cmp.w #progbut,d0
  beq progr
  cmp.w #dispbut,d0
  beq window
  cmp.w #normbut,d0
  beq normm
  cmp.w #fastbut,d0
  beq fastm
  lea len(pc),a1
  cmp.w #vpp12v,d0
  beq vpp12
  cmp.w #vpp21v,d0
  beq vpp21
  cmp.w #vpp25v,d0
  beq vpp25

  cmp.w #t2716,d0
  blt.s menu
  cmp.w #t271008,d0
  ble.s typesel  

menu 
  lea stend(pc),sp
  bsr consol ****
  bra mloop


typesel

  lea typec(pc),a1
  subq.w #t2716,d0
  move.w d0,d1 
  move.w d1,(a1)+ *type code 0-9
  move.l #1024,d2 *min len/2
lencal  lsl.l #1,d2
  subq.b #1,d1
  bpl.s lencal
  move.l d2,(a1) *store len

  cmp.b #2,d0
  blt.s vpp25
  cmp.b #4,d0
  blt.s vpp21

vpp12  
  move.b #0,voltag-len(a1)
  moveq #vpp12v,d0
  bsr select

  bsr.s des25
  bra.s comdes

vpp21
  move.b #1,voltag-len(a1)
  moveq #vpp21v,d0
  bsr select

  bsr.s des12
  bsr.s des25
  bra.s tsex

vpp25

  move.b #2,voltag-len(a1)
  moveq #vpp25v,d0
  bsr select

  bsr.s des12
comdes  bsr.s des21

tsex  bra nodes

des12  moveq #vpp12v,d0
  bra deselect *retvia

des21  moveq #vpp21v,d0
  bra deselect

des25  moveq #vpp25v,d0
  bra deselect


normm moveq #0,d0
  bra.s commow
fastm moveq #55,d0
commow move.b d0,modeop
  bra nodes  



*Subrutine za EPROM modul
initregs  

  lea $ffff8800.w,a0
  lea 2(a0),a1
  move.w #$0f00,d5 *for port B select -prepare for movep.w
  move.w #$0eff,d6 *for strobe up
  move.w #$0edf,d7 *for strobe down
  rts


makesb

  pea makesbsu(pc)
  move.w #38,-(sp)
  trap #14
  addq.l #6,sp
  rts
  
makesbsu *all pins from EPROM socket on low. Vpp off.
  bsr.s initregs

  strobed
  
  move.b #%11101110,d5 *select latch 1
  centrd
  strobup

*now write in selected latch
  move.b #%00001100,d5 * Vpp off ,6 Volts off
  centrd
  strobed
  
  move.b #%11101101,d5 *select latch 2
  centrd
  strobup  

  move.b #%00010000,d5 *bits 5-7 unused ,bit 1 Vcc on pin 30-high on
  centrd *bits 0-3 are A16-A19 ,bit 4 is Vcc on pin 32 (low-on)
  strobed

  move.b #%11100111,d5 *select latch 4
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

  move.b #%11101011,d5 *select latch 3
  centrd
  strobup

  move.b #%00000000,d5  *all to zero
  centrd
  strobed
  
  rts

conslt move.w #-1,-(sp)
  bra.s kbshift

consol *for restore after disabled interrupt
  move.w consm(pc),-(sp)
kbshift  move.w #11,-(sp)
  trap #13
  addq.l #4,sp
  rts  


 
*BREAK test -right shift taster
breakt  pea $bffff
  trap #13
  addq.l #4,sp
  btst #0,d0
  rts

stavi
  tst.w typec
  bpl.s pripual
  moveq #alfisel,d0
  bsr doalert 
  bra menu

pripual
  moveq #0,d6
  moveq #0,d7
  bsr priadr *clear adress sh.
  moveq #alputepr,d0
  bsr doalert
  bne menu *menu restores stack
  bsr mabee
  rts


*Opcije

progr
  bsr stavi

*Test is FF ?

  superv
  bsr initregs


*Here branch by EPROM type

  move.w typec(pc),d1
  subq.w #1,d1
  bmi pr16 
  subq.w #1,d1
  bmi pr32
  subq.w #1,d1
  bmi pr64
  subq.w #1,d1
  bmi pr128
  subq.w #1,d1
  bmi pr256
  subq.w #1,d1
  bmi pr512
  subq.w #1,d1
  bmi pr1001
  subq.w #1,d1
*  bmi pr1002  
  subq.w #1,d1
*  bmi pr1004
  subq.w #1,d1
*  bmi pr1008
   
   userm
   bra menu



pr64
*next is for 2764 !

  bsr prep64

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  
  cmp.b #1,voltag *-test is A type !
  beq.s pr64_21v
  move.b #%01011111,d2 *Vpp 12.5 V on p3
  bra.s pr64vs  
pr64_21v  move.b #%10011111,d2 *VPP 21V on p3
pr64vs  move.b d2,(a1)
  strobed
 
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  bclr #0,d2 */CE prepare
  move.b d5,(a0)
  move.b d2,(a1) */CE on
  strobed
  
pr64l 

  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk of data latch
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed +high adress+ disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11000111,(a1) *select latch 4-hi adress, open data latch
  strobup


  bclr #6,d1 *pin 27 on low
  move.b d5,(a0)
  move.b d1,(a1)  
  strobed
  bset #6,d1  *prepare for off pulse

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #$1f,d1
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm

  bsr priadr
  
  superv
 
  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup  *close data latch


  move.b d5,(a0)
  move.b d1,(a1)   *prog pulse off
  strobed

 
  addq.b #1,d0
  bne pr64l

  addq.b #1,d1
  cmp.w #$e0,d1
  blt pr64l

pex  bsr makesbsu
  move.w #$2300,sr

  bra comp2




priadr
*Print adress
  lea $20000+4,a0  *ted
  bsr takeadr
  move.l (a0),a1
  move.l d6,d1  *counter
  bsr prhex5
  moveq #adress,d0
  bsr obdr

pridata
*Print data
  lea $20000+6,a0
  bsr takeadr
  move.l (a0),a1
  move.w d7,d1
  bsr prhex2
  moveq #data,d0 
  bra obdr   *ret via


prep64

  move.w #$2700,sr *disable interrupt

  move.b #%11101101,d5 *select latch 2
  centrd
  strobup  

  move.b #%00010010,d5 *bits 5-7 unused ,bit 1 Vcc on pin 30-high on
  centrd *bits 0-3 are A16-A19 ,bit 4 is Vcc on pin 32 (low-on)
  strobed


*reset adress latches
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #%11000000,d5  *adress to zero, a15 high, /PGM high 
  centrd
  strobed

  moveq #0,d0 *adress low
  move.w #%11000000,d1 *adr. high byte to 0 ,pin 1, 27 high, must word!
  moveq #0,d3 *error counter
  
  move.b #%11101110,d5 *select latch 1
  centrd
  strobup

  move.b #%1100,d5  *activate OE & CS
  centrd
  strobed
 
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  lea RAM(pc),a3 *buffer

  rts



compare

  bsr stavi
  superv

comp2  bsr initregs

*Here branch by EPROM type

  move.w typec(pc),d1
  subq.w #1,d1
  bmi cm16 
  subq.w #1,d1
  bmi cm32
  subq.w #1,d1
  bmi cm64
  subq.w #1,d1
  bmi cm128
  subq.w #1,d1
  bmi cm256
  subq.w #1,d1
  bmi cm512
  subq.w #1,d1
  bmi cm1001
  subq.w #1,d1
*  bmi cm1002  
  subq.w #1,d1
*  bmi cm1004
  subq.w #1,d1
*  bmi cm1008
   
   userm
   bra menu


cm64 

  bsr prep64

cm64hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm64l 

  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 


  cmp.b (a3)+,d2
  beq.s sa64
  addq.l #1,d3
sa64 
 
  addq.b #1,d0
  bne.s cm64l

  addq.b #1,d1
  cmp.w #$e0,d1 *for 2764 must word !
  blt.s cm64hl

comcmo
  bsr makesbsu
  move.w #$2300,sr
  move.l d3,d6 
  userm

  move.l d6,-(sp) 
  lea $50000+aldiffby,a0
  bsr takeadr
  lea 7(a0),a1 *text depend
  move.l (sp)+,d1
  beq.s samealp
  bsr prhex5
  moveq #aldiffby,d0
toal1  bsr doalert
  bra menu

samealp moveq #alsame,d0
  bra.s toal1


provera
  bsr stavi
  superv
  bsr initregs

*Here branch by EPROM type

  move.w typec(pc),d1
  subq.w #1,d1
  bmi et16 
  subq.w #1,d1
  bmi et32
  subq.w #1,d1
  bmi et64
  subq.w #1,d1
  bmi et128
  subq.w #1,d1
  bmi et256
  subq.w #1,d1
  bmi et512
  subq.w #1,d1
  bmi et1001
  subq.w #1,d1
*  bmi et1002  
  subq.w #1,d1
*  bmi et1004
  subq.w #1,d1
*  bmi et1008
   
   userm
   bra menu
    
 
et64
  bsr prep64

et64hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

et64l  
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 


  addq.b #1,d2
  beq.s er64
  addq.l #1,d3 *better via adress reg indirekt
er64 
 
  addq.b #1,d0
  bne.s et64l

  addq.b #1,d1
  cmp.w #$e0,d1
  blt.s et64hl

cometo *common exit from all empty test
  bsr makesbsu
  move.w #$2300,sr
  move.l d3,d6
   
  userm

  tst.l d6
  bne.s notcl
  moveq #0,d0
  bra.s clal
notcl  lea $50001,a0
  move.l d6,-(sp)
  bsr takeadr
  lea 26(a0),a1  *text depend!
  move.l (sp)+,d1
  bsr prhex5
  moveq #1,d0
clal bsr doalert
  bra menu

kopi

  bsr stavi
  superv
  bsr initregs

*Here branch by EPROM type

  move.w typec(pc),d1
  subq.w #1,d1
  bmi ko16 
  subq.w #1,d1
  bmi ko32
  subq.w #1,d1
  bmi ko64
  subq.w #1,d1
  bmi ko128
  subq.w #1,d1
  bmi ko256
  subq.w #1,d1
  bmi ko512
  subq.w #1,d1
  bmi ko1001
  subq.w #1,d1
*  bmi ko1002  
  subq.w #1,d1
*  bmi ko1004
  subq.w #1,d1
*  bmi ko1008
   
   userm
   bra menu

ko64
  bsr prep64

ko64hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko64l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 

 
  addq.b #1,d0
  bne.s ko64l

  addq.b #1,d1
  cmp.w #$e0,d1
  blt.s ko64hl

comkoo
  bsr makesbsu
  move.w #$2300,sr
  
  userm

  move.w typec(pc),d2
  subq.w #1,d2
  bpl.s ee1
  move.l #$31362020,d0
  bra.s etwr
ee1  subq.w #1,d2
  bpl.s ee2
  move.l #$33322020,d0
  bra.s etwr  
ee2  subq.w #1,d2
  bpl.s ee3
  move.l #$36342020,d0
  bra.s etwr
ee3  subq.w #1,d2
  bpl.s ee4
  move.l #$31323820,d0
  bra.s etwr  
ee4  subq.w #1,d2
  bpl.s ee5
  move.l #$32353620,d0
  bra.s etwr  
ee5  subq.w #1,d2
  bpl.s ee6
  move.l #$35313220,d0
  bra.s etwr  
ee6  subq.w #1,d2
  bpl.s ee7
  move.l #$31303031,d0
  bra.s etwr  
ee7  subq.w #1,d2
  bpl.s ee8
  move.l #$31303032,d0
  bra.s etwr 
ee8  subq.w #1,d2
  bpl.s ee9
  move.l #$31303034,d0
  bra.s etwr 
ee9
  move.l #$31303038,d0

etwr move.l d0,eprpt+8
  lea $20000+ramhted,a0  *
  bsr takeadr
  move.l (a0),a0
  lea eprpt(pc),a1
  bra eprprt
  
eprpt dc.b "EPROM 271001"
  even



prep16
  move.w #$2700,sr *disable interrupt
*first give Vcc

*High on pin 28 (pin 24 of act. IC)
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #%00101000,d5  *adress to zero, a13,a11 high
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  for read
  moveq #0,d0 *adress low 
  move.w #%00101000,d1 *adress high byte on $28
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS (for read)
  strobed
 
  rts


pr16

  bsr.s prep16
  
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)  *OE, CE high
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%11111110,(a1)  *Vpp -25V on pin 25
  strobed
  
pr16hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr16l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%11111111,(a1)   *pulse on
  strobed

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #7,d1 *mask
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm

  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%11111110,(a1)  *prog pulse off
  strobed

 
  addq.b #1,d0
  bne pr16l

  addq.b #1,d1
  cmp.b #$30,d1
  blt pr16hl

  bra pex



et16
  bsr prep16

et16hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e16l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 


  addq.b #1,d2 *is $ff ?
  beq.s erok16
  addq.l #1,d3 *better via adress reg indirekt
erok16 
 
  addq.b #1,d0
  bne.s e16l

  addq.b #1,d1
  cmp.b #$30,d1 *$28 -$2f work area
  bne.s et16hl 

  bra cometo


ko16
  bsr prep16

  move.w #%10101111,d3 *for line trans. sel -speed


ko16hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko16l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 

 
  addq.b #1,d0
  bne.s ko16l

  addq.b #1,d1
  cmp.b #$30,d1
  bne.s ko16hl
 
  bra comkoo


cm16
  bsr prep16
  
cm16hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm16l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  cmp.b (a3)+,d2
  beq.s cmok16
  addq.l #1,d3 *better via adress reg indirekt
cmok16 
 
  addq.b #1,d0
  bne.s cm16l

  addq.b #1,d1
  cmp.b #$30,d1
  bne.s cm16hl  

  bra comcmo



prep32
  move.w #$2700,sr *disable interrupt
*first give Vcc

*High on pin 28 (pin 24 of act. IC)
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #%00100000,d5  *adress to zero, a13 high
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  for read
  moveq #0,d0 *adress low 
  move.w #%00100000,d1 *adress high byte- on $20
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS (for read)
  strobed
 
  rts


pr32

  bsr.s prep32
  
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)  *OE, CE high
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0) ******for type A 21V !
  move.b #%11101111,(a1)  *Vpp -25V on pin 24
  strobed
  
pr32hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr32l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%11101110,(a1)   *pulse on (A type !?)
  strobed

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #$f,d1 *mask
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm

  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%11101111,(a1)  *prog pulse off (A type !?)
  strobed

 
  addq.b #1,d0
  bne pr32l

  addq.b #1,d1
  cmp.b #$30,d1
  blt pr32hl

  bra pex



et32
  bsr prep32

et32hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e32l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 


  addq.b #1,d2 *is $ff ?
  beq.s erok32
  addq.l #1,d3 *better via adress reg indirekt
erok32 
 
  addq.b #1,d0
  bne.s e32l

  addq.b #1,d1
  cmp.b #$30,d1 *$20 -$2f work area
  bne.s et32hl 

  bra cometo


ko32
  bsr prep32

  move.w #%10101111,d3 *for line trans. sel -speed


ko32hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko32l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 

 
  addq.b #1,d0
  bne.s ko32l

  addq.b #1,d1
  cmp.b #$30,d1
  bne.s ko32hl
 
  bra comkoo


cm32
  bsr prep32
  
cm32hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm32l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  cmp.b (a3)+,d2
  beq.s cmok32
  addq.l #1,d3 *better via adress reg indirekt
cmok32 
 
  addq.b #1,d0
  bne.s cm32l

  addq.b #1,d1
  cmp.b #$30,d1
  bne.s cm32hl  

  bra comcmo





pr128

  bsr prep128

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)

  lea voltc(pc),a2  
  cmp.b #1,voltag-voltc(a2) *-test is A type !
  beq.s pr128_21v
  move.b #%01011111,(a2) *Vpp 12.5 V on p3
  bra.s pr128vs  
pr128_21v  move.b #%10011111,(a2) *VPP 21V on p3
pr128vs  move.b (a2),(a1)
  strobed
 
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  bclr #0,(a2) */CE prepare
  move.b d5,(a0)
  move.b (a2),(a1) */CE on
  strobed
  
  
  tst.b modeop
  bne pr128fl *fast algorithm
  
pr128l 

  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk of data latch
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed +high adress+ disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11000111,(a1) *select latch 4-hi adress, open data latch
  strobup


  bclr #6,d1 *pin 27 on low
  move.b d5,(a0)
  move.b d1,(a1)  
  strobed
  bset #6,d1  *prepare for off pulse

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #$3f,d1
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm

  bsr priadr
  
  superv
 
  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup  *close data latch


  move.b d5,(a0)
  move.b d1,(a1)   *prog pulse off
  strobed

 
  addq.b #1,d0
  bne pr128l

  addq.b #1,d1
  bne pr128l

  bra pex


pr128fl
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3),(a1) *new data
  strobed

  moveq #1,d3
  
  
f128nt  
  
*prog pulse needed +high adress+ disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11000111,(a1) *select latch 4-hi adress, open data latch
  strobup

  bclr #6,d1 *pin 27 on low
  move.b d5,(a0)
  move.b d1,(a1)  
  strobed
  bset #6,d1  *prepare for off pulse

  bsr onems *call delay 1ms

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup  *close data latch

  move.b d5,(a0)
  move.b d1,(a1)   *prog pulse off
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1)
  strobup

  bclr #1,(a2) *OE
  move.b d5,(a0) 
  move.b (a2),(a1)  *,OE activ !
  strobed


  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 

  move.b d5,(a0)
  move.b #%11101110,(a1)
  strobup

  bset #1,(a2) *OE high
  move.b d5,(a0) 
  move.b (a2),(a1)  *,OE inactiv !
  strobed


  cmp.b (a3),d2
  beq.s f128p
  addq.b #1,d3
  cmp.b #25,d3
  bgt errbyp *give alert
  bra f128nt
  
f128p 

  move.b d3,d2
  lsl.b #1,d2
  add.b d2,d3 *mult by 3
  subq.w #1,d3


  move.b d5,(a0)
  move.b #%11000111,(a1) *select latch 4-hi adress, open data latch
  strobup

  bclr #6,d1 *pin 27 on low
  move.b d5,(a0)
  move.b d1,(a1)  
  strobed
  bset #6,d1  *prepare for off pulse


tree128  bsr onems *call delay 1ms
  dbf d3,tree128

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup  *close data latch

  move.b d5,(a0)
  move.b d1,(a1)   *prog pulse off
  strobed


  addq.l #1,a3 
  addq.b #1,d0
  bne pr128fl

  addq.b #1,d1
  beq pex 
  
  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #$3f,d1 *mask
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  bra pr128fl
  


cm128
  bsr prep128
  
cm128hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm128l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  cmp.b (a3)+,d2
  beq.s cmok128
  addq.l #1,d3
cmok128
 
  addq.b #1,d0
  bne.s cm128l

  addq.b #1,d1
  bne.s cm128hl *started by $c0

  bra comcmo


et128
  bsr prep128

e128hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e128l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 


  addq.b #1,d2 *is $ff ?
  beq.s erok128
  addq.l #1,d3
erok128 
 
  addq.b #1,d0
  bne.s e128l

  addq.b #1,d1
  bne.s e128hl *started by $c0

  bra cometo


prep128
  move.w #$2700,sr *disable interrupt

*first give Vcc
  move.b #%11101101,d5 *select latch 2
  centrd
  strobup 

  move.b #%00010010,d5  *a17 = Vcc -on pin 30
  centrd
  strobed

*High on pin 3 (pin 1 of act. IC)
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #%11000000,d5  *adress to zero, a15,a14 high
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  
  moveq #0,d0 *adress low
  move.w #%11000000,d1 *adress high byte to 0 ,pin 3,29 high
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS
  strobed
 
  rts



ko128
  bsr prep128

  move.w #%10101111,d3 *for line trans. sel -speed


ko128hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko128l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 

 
  addq.b #1,d0
  bne.s ko128l

  addq.b #1,d1
  bne.s ko128hl
 
  bra comkoo





pr256
  bsr prep256
  
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)  *OE high
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%01011011,(a1)  *Vpp -13V on pin 3 ,6 V on pin 30
  strobed   *A17 must be high before this!

  tst.b modeop
  bne pr256f *fast algorithm
  
pr256hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr256l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01011010,(a1)   *pulse on
  strobed

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
*  and.b #7,d1 *mask
*  move.b d1,d6
*  lsl.w #8,d6
*  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr pridata

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01011011,(a1)  *prog pulse off
  strobed

 
  addq.b #1,d0
  bne pr256l

  addq.b #1,d1
  beq pex

  bsr prad256

  bra pr256hl
  


pr256f

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr256fl
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3),(a1) *new data
  strobed

  moveq #1,d3
  
  
f256nt  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01011010,(a1)   *pulse on
  strobed

  bsr onems *call delay 1ms

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01011001,(a1)   *pulse off ,OE activ !
  strobed


  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  cmp.b (a3),d2
  beq.s f256p
  addq.b #1,d3
  cmp.b #25,d3
  bgt errbyp *give alert
  bra f256nt
  
f256p 

  move.b d3,d2
  lsl.b #1,d2
  add.b d2,d3 *mult by 3
  subq.w #1,d3


  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01011010,(a1)   *pulse on ,OE off
  strobed

tree256  bsr onems *call delay 1ms
  dbf d3,tree256


  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01011011,(a1)   *pulse off
  strobed


  addq.l #1,a3 
  addq.b #1,d0
  bne pr256fl

  addq.b #1,d1
  beq pex

  bsr.s prad256

  bra pr256f
  

prad256
  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  and.b #$7f,d1 *mask
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr
  rts



errbyp
  bsr makesbsu
  move.w #$2300,sr
  userm
  moveq #alprgerr,d0
  bsr doalert
  bra menu


onems move.w #430,d2
onmsl nop
  dbf d2,onmsl
  moveq #0,d2
  rts



cm256
  bsr prep256
  
cm256hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm256l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  


  cmp.b (a3)+,d2
  beq.s cmok256
  addq.l #1,d3
cmok256 

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 
 
  addq.b #1,d0
  bne.s cm256l

  addq.b #1,d1
  bne.s cm256hl *started by $80

  bra comcmo


et256
  bsr prep256

e256hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e256l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  addq.b #1,d2 *is $ff ?
  beq.s erok256
  addq.l #1,d3 *better via adress reg indirekt
erok256 

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 
 
  addq.b #1,d0
  bne.s e256l

  addq.b #1,d1
  bne.s e256hl *started by $80

  bra cometo


prep256
  move.w #$2700,sr *disable interrupt

*first give Vcc
  move.b #%11101101,d5 *select latch 2
  centrd
  strobup 

  move.b #%00010010,d5  *a17 = Vcc -on pin 30
  centrd
  strobed

*High on pin 3 (pin 1 of act. IC)
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #%10000000,d5  *adress to zero, a15 high
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  
  moveq #0,d0 *adress low
  move.w #%10000000,d1 *adress high byte to 0 ,pin 1 high
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS
  strobed
 
  rts



ko256
  bsr prep256

  move.w #%10101111,d3 *for line trans. sel -speed


ko256hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko256l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 
 
  addq.b #1,d0
  bne.s ko256l

  addq.b #1,d1
  bne.s ko256hl
 
  bra comkoo




pr512
  bsr prep512
  
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)  *CE, OE high
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%01101011,(a1)  *Vpp -13V on pin 24 ,6 V on pin 30
  strobed   *A17 must be high before this!

  tst.b modeop
  bne pr512f *fast algorithm
  
pr512hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr512l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01101010,(a1)   *pulse on
  strobed

  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
*  and.b #7,d1 *mask
*  move.b d1,d6
*  lsl.w #8,d6
*  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr pridata *about 10 ms

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01101011,(a1)  *prog pulse off
  strobed

 
  addq.b #1,d0
  bne pr512l

  addq.b #1,d1
  beq pex

  bsr prad512

  bra pr512hl
  


pr512f

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr512fl
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3),(a1) *new data
  strobed

  moveq #1,d3
  
  
f512nt  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01101010,(a1)   *pulse on
  strobed

  bsr onems *call delay 1ms

  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01101011,(a1)   *pulse off
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *sel latch 1
  strobup

  move.b d5,(a0)
  move.b #%00101001,(a1)   *Vpp off,/OE on
  strobed

  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  cmp.b (a3),d2
  beq.s f512p
  addq.b #1,d3
  cmp.b #25,d3
  bgt errbyp *give alert
  bra f512nt
  
f512p 

  move.b d3,d2
  lsl.b #1,d2
  add.b d2,d3 *mult by 3
  subq.w #1,d3

  move.b d5,(a0)
  move.b #%11101110,(a1) *sel latch 1
  strobup

  move.b d5,(a0)
  move.b #%01101011,(a1)   *Vpp on ,OE off
  strobed


  move.b d5,(a0)
  move.b #%11001110,(a1) *open data latch
  strobup

  move.b d5,(a0)
  move.b #%01101010,(a1)   *pulse on 
  strobed

tree512  bsr onems *call delay 1ms
  dbf d3,tree512


  move.b d5,(a0)
  move.b #%11101110,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b #%01101011,(a1)   *pulse off
  strobed


  addq.l #1,a3 
  addq.b #1,d0
  bne pr512fl

  addq.b #1,d1
  beq pex

  bsr.s prad512

  bra pr512f
  

prad512
  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr
  rts





cm512
  bsr prep512
  
cm512hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm512l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  


  cmp.b (a3)+,d2
  beq.s cmok512
  addq.l #1,d3
cmok512 

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 
 
  addq.b #1,d0
  bne.s cm512l

  addq.b #1,d1
  bne.s cm512hl

  bra comcmo


et512
  bsr prep512

e512hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e512l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  addq.b #1,d2 *is $ff ?
  beq.s erok512
  addq.l #1,d3
erok512

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 
 
  addq.b #1,d0
  bne.s e512l

  addq.b #1,d1
  bne.s e512hl

  bra cometo


prep512
  move.w #$2700,sr *disable interrupt

*first give Vcc
  move.b #%11101101,d5 *select latch 2
  centrd
  strobup 

  move.b #%00010010,d5  *a17 = Vcc -on pin 30
  centrd
  strobed

*High adress reset
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #0,d5  *adress to zero
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  
  moveq #0,d0 *adress low
  moveq #0,d1 *adress high byte to 0
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS
  strobed
 
  rts



ko512
  bsr.s prep512

  move.w #%10101111,d3 *for line trans. sel -speed


ko512hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko512l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 
 
  addq.b #1,d0
  bne.s ko512l

  addq.b #1,d1
  bne.s ko512hl
 
  bra comkoo





pr1001
  bsr prep1001
  
  moveq #%01100,d4 *PGM off, A16 low
   
  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001111,(a1)  *CE, OE high
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%01000111,(a1)  *Vpp -13V on pin 1 ,6 V on pin 32
  strobed   *pin 32 must be high before this!

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%01000110,(a1)  *CE on
  strobed


  tst.b modeop
  bne pr1001f *fast algorithm
  
pr1001hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr1001l
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3)+,(a1) *new data
  strobed
  
*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001101,(a1) *open data latch, sel latch 2
  strobup

  bclr #2,d4 *pulse on prep
  move.b d5,(a0) *in second pass a16 high !
  move.b d4,(a1)   *pulse on
  strobed
  bset #2,d4


  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  move.w #$2300,sr

  userm
  bsr pridata *about 10 ms
  superv
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr

c1  move.b d5,(a0)
  move.b #%11101101,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b d4,(a1)  *prog pulse off
  strobed
 
  addq.b #1,d0
  bne pr1001l

  addq.b #1,d1
  beq.s inca16
  bsr prad1001  
  bra pr1001hl  


inca16  addq.b #1,d4
  bsr prad1001
  cmp.b #%01110,d4
  beq pex

  move.b d5,(a0)
  move.b #%11101101,(a1) *select latch 2 for a16 change
  strobup

  move.b d5,(a0)
  move.b d4,(a1)  
  strobed

  bra pr1001hl
  


pr1001f

  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress,
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

pr1001fl
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup
 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%11111111,(a1) * enable clk
  strobup

  move.b d5,(a0)
  move.b (a3),(a1) *new data
  strobed

  moveq #1,d3
  
f1001nt  

*prog pulse needed + disable clk of IC 5(data latch)

  move.b d5,(a0)
  move.b #%11001101,(a1) *open data latch, sel latch 2
  strobup

  bclr #2,d4 *pulse on prep
  move.b d5,(a0) *in second pass a16 high !
  move.b d4,(a1)   *pulse on
  strobed
  bset #2,d4


  bsr halms *call delay 0.5ms -shorter for 271001 needed !

  move.b d5,(a0)
  move.b #%11101101,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b d4,(a1)   *pulse off
  strobed

  move.b d5,(a0)
  move.b #%11101110,(a1) *sel latch 1
  strobup

  move.b d5,(a0)
  move.b #%01000100,(a1)   *OE on -CE ??
  strobed

  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b #7,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  


  move.b #7,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 


  move.b d5,(a0)
  move.b #%11101110,(a1) *sel latch 1
  strobup

  move.b d5,(a0)
  move.b #%01000110,(a1)   *OE off
  strobed

  cmp.b (a3),d2
  beq.s f1001p
  addq.b #1,d3
  cmp.b #25,d3
  bgt errbyp *give alert
  bra f1001nt
  
f1001p 

  subq.w #1,d3


  move.b d5,(a0)
  move.b #%11001101,(a1) *open data latch, sel latch 2
  strobup

  bclr #2,d4 *pulse on prep
  move.b d5,(a0) *in second pass a16 high !
  move.b d4,(a1)   *pulse on
  strobed
  bset #2,d4


one1001  bsr halms *call delay 0.5 ms -same times
  dbf d3,one1001


  move.b d5,(a0)
  move.b #%11101101,(a1) *close data latch
  strobup

  move.b d5,(a0)
  move.b d4,(a1)   *pulse off
  strobed

  addq.l #1,a3 
  addq.b #1,d0
  bne pr1001fl

  addq.b #1,d1
  beq.s inca16f
  bsr.s prad1001  
  bra pr1001f  


inca16f  addq.b #1,d4
  bsr.s prad1001
  cmp.b #%01110,d4
  beq pex

  move.b d5,(a0)
  move.b #%11101101,(a1) *select latch 2 for a16 change
  strobup

  move.b d5,(a0)
  move.b d4,(a1)  
  strobed

  bra pr1001f

  

prad1001
  lea regsav(pc),a6
  
  movem.l d0-d7/a0-a3,-(a6)  *save regs
  move.b -(a3),d7
  move.b d4,d6
  and.w #3,d6 *mask
  swap d6
  move.b d1,d6
  lsl.w #8,d6
  move.b d0,d6
  move.w #$2300,sr
  userm
  bsr priadr

  superv

  bsr breakt
  bne pex
  
  lea regsav-48(pc),a6
  movem.l (a6)+,a0-a3/d0-d7

  move.w #$2700,sr
  rts

halms move.w #210,d2
halmsl nop
  dbf d2,halmsl
  moveq #0,d2
  rts



cm1001
  bsr prep1001
  
cm1001hl  
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
cm1001l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  


  cmp.b (a3)+,d2
  beq.s cmok1001
  addq.l #1,d3
cmok1001 

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may  via d6) 
 
  addq.b #1,d0
  bne.s cm1001l

  addq.b #1,d1
  bne.s cm1001hl

  swap d4
  addq.b #1,d4
  cmp.b #2,d4
  beq.s tocomcmo

  move.b d5,(a0) 
  move.b #%11101101,(a1) *select latch 2
  strobup 

  move.b d5,(a0)
  move.b #%00001101,(a1)  *a16 high
  strobed 
 
  swap d4
  bra cm1001hl


tocomcmo bra comcmo



et1001
  bsr prep1001

e1001hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

  
e1001l 
  move.b d5,(a0)
  move.b #%11101011,(a1) *select latch 3-low adress
  strobup

  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b #%10101111,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed
  
  move.b d5,(a0)
  move.b (a0),d2 *read byte from eprom  

  addq.b #1,d2 *is $ff ?
  beq.s erok1001
  addq.l #1,d3
erok1001

  move.b d4,(a0)
  move.b d6,(a1)  *port B out (may d6) 
 
  addq.b #1,d0
  bne.s e1001l

  addq.b #1,d1
  bne.s e1001hl

  swap d4
  addq.b #1,d4
  cmp.b #2,d4
  beq.s tocometo

  move.b d5,(a0) 
  move.b #%11101101,(a1) *select latch 2
  strobup 

  move.b d5,(a0)
  move.b #%00001101,(a1)  *a16 high
  strobed 
 
  swap d4
  bra e1001hl


tocometo  bra cometo


prep1001
  move.w #$2700,sr *disable interrupt

*first give Vcc
  move.b #%11101101,d5 *select latch 2
  centrd
  strobup 

  move.b #%00001100,d5  *a17 = Vcc -on pin 32 (low active)
  centrd  *PGM high ,pin 1 high
  strobed

*High adress reset
  move.b #%11100111,d5 *select latch 4
  centrd
  strobup

  move.b #0,d5  *adress to zero
  centrd
  strobed


*reset adress latch low
  move.b #%11101011,d5 *select latch 3
  centrd
  strobup 

  move.b #0,d5  *adress to zero
  centrd
  strobed

*prep registers  
  moveq #0,d0 *adress low
  moveq #0,d1 *adress high byte to 0
  moveq #0,d3 *error counter
  moveq #15,d5 *for fastest adress write
  moveq #7,d4  *for portdir select
  move.w #%11101011,d2 *for select latch 3 (low adress)
  lea RAM(pc),a3

  move.b d5,(a0)
  move.b #%11101110,(a1) *select latch 1
  strobup

  move.b d5,(a0)
  move.b #%00001100,(a1)  *activate OE & CS
  strobed
 
  rts



ko1001
  bsr.s prep1001

  move.w #%10101111,d3 *for line trans. sel -speed


ko1001hl
  move.b d5,(a0)
  move.b #%11100111,(a1) *select latch 4-hi adress
  strobup

  move.b d5,(a0)
  move.b d1,(a1)  
  strobed

ko1001l 

  move.b d5,(a0)
  move.b d2,(a1) *select latch 3-low adress
  strobup

 
  move.b d5,(a0)
  move.b d0,(a1) *new adress  
  strobed
 
  move.b d5,(a0)
  move.b d3,(a1) *select line transc.
  strobup

  move.b d4,(a0)
  move.b #$7f,(a1) *port B input
  strobed *this activates line transc. (for 1-2 micro sec)
  
  move.b d5,(a0)
  move.b (a0),(a3)+ *read byte from eprom  

  move.b d4,(a0)
  move.b d6,(a1)  *port B out -d6 hold $ff ! 
 
  addq.b #1,d0
  bne.s ko1001l

  addq.b #1,d1
  bne.s ko1001hl
 
  swap d4
  addq.b #1,d4
  cmp.b #2,d4
  beq.s tocomko

  move.b d5,(a0) 
  move.b #%11101101,(a1) *select latch 2
  strobup 

  move.b d5,(a0)
  move.b #%00001101,(a1)  *a16 high
  strobed 
 
  swap d4
  bra ko1001hl
 
tocomko  bra comkoo

 
filesel  bsr AEScall
  dc.w 90,0,2,2,0
  dc.l path
  dc.l dats
  bsr mabee
  bsr drdial
  lea intout(pc),a1
  tst.w (a1)+
  beq menu
  tst.w (a1)
  beq menu
  lea pada(pc),a1

  lea path(pc),a0
  bsr.s pdcopy
*Now drop attributes of select
droat 
  cmp.b #"\",-(a1)  *is subdir end marker
  bne.s droat
  addq.l #1,a1  *move forward

  lea dats(pc),a0

pdcopy
  tst.b (a0)
  beq.s pdret 
  move.b (a0)+,(a1)+
  bra.s pdcopy

pdret move.b (a0),(a1)  *Ako je pre bio duzi fajl 
  rts


load  bsr filesel

  move.w #0,-(sp)
  pea pada
  move.w #61,-(sp)
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi menu  *error
 
  move.w d0,handl
  pea RAM(pc)
  move.l len,-(sp) *eprom type depend!!
  move.w d0,-(sp)
  move.w #63,-(sp)
  trap #1
  lea 12(sp),sp
  tst.l d0
  bmi loerr
 
  bsr fclose
  
*Copy name in info box
  lea $20000+ramhted,a0
  bsr takeadr
  move.l (a0),a0
  lea dats(pc),a1
  
eprprt  moveq #11,d1
namcl  move.b (a1)+,(a0)+
  dbf d1,namcl
  moveq #ramhtext,d0
  bsr obdr
  bra menu

loerr bsr fclose
  bra menu

save  bsr filesel
  move.w #0,-(sp)
  pea pada
  move.w #60,-(sp) *Fcreate
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi menu  *error- GEM gives alerts+
  move.w d0,handl
  pea RAM(pc)
  move.l len,-(sp) *eprom type depend!!
  move.w d0,-(sp)
  move.w #64,-(sp)
  trap #1
  lea 12(sp),sp
  cmp.w len+2,d0
  bne.s noplace
sane  bsr fclose
  bra menu 
noplace  moveq #5,d0
  bsr doalert
  bra.s sane

fclose move.w handl,-(sp)
  move.w #62,-(sp)
  trap #1
  addq.l #4,sp
  rts


wisize dc.w 6,18,572,146
witype equ %000111000011

window

  lea 2.w,a0 *dispdial
  bsr takeadr
  move.l a0,coor+4 *prep for OBJC_FIND
  bsr opdial
  bsr drdial

  lea wisize(pc),a0

  lea wic1(pc),a1
  lea wic2(pc),a2
  move.l (a0),(a2)+
  move.l (a0)+,(a1)+
  move.l (a0),(a2)
  move.l (a0),(a1)


  bsr AEScall
  dc.w 100,5,1,0,0 *wind create
  dc.w witype
wic1  ds.w 4


  lea wihan(pc),a1
  move.w intout(pc),d0  
  move.w d0,(a1)  *put handle where needed
  move.w d0,wih1-wihan(a1)
  move.w d0,wih2-wihan(a1) 
  move.w d0,wih3-wihan(a1)
  move.w d0,wih4-wihan(a1)
  move.w d0,wih5-wihan(a1)

*Calc totsem -page number
  move.l len(pc),d1
  divu #256,d1
  lea totsem(pc),a2
  move.w d1,(a2)
  clr.w offset-totsem(a2)
  
  tst.b infdh-totsem(a2)
  beq.s todecw
  bsr hexwin
  bra.s vslsize

todecw  bsr decwin

*Calc Wf_ Vslsize

vslsize  clr.l d1
  move.w totsem(pc),d1
sixt move.l #1000,d2
  divu d1,d2

  move.w  d2,wih4+4
  bsr AEScall
  dc.w 105,6,1,0,0
wih4 dc.w 0,16
  dc.w 0,0,0,0

  bsr windopen  

  bsr maarr 
  bsr copyinb

  bra dispbw

wiloop
  bsr AEScall
  dc.w 25,16,7,1,0 *EVNT_MULTI
  dc.w %10011 *event_message ,event_button, event_keybd
  dc.w 1,1,1 *bclick, bmask, bstate
  ds.w 12 *fill
  dc.l mesbuf
  
  move.w intout(pc),d2
  btst #4,d2 *is wslide ?
  bne vslida

  btst #0,d2 *is key
  bne keypre

  lea intout+2(pc),a0
  lea coor(pc),a1
  move.l (a0),(a1)
    
  
  bsr AEScall
  dc.w 43,4,1,1,0 *OBJC_FIND
  dc.w 0,1
coor ds.w 2
  ds.l 1  
  
  move.w intout(pc),d0

  cmp.w #eightbut,d0
  beq disp8
  cmp.w #sevenbut,d0
  beq disp7

  cmp.w #savchbut,d0
  beq savchen
  cmp.w #dispexit,d0
  beq windclo
  cmp.w #decbut,d0
  beq decinf
  cmp.w #hexbut,d0
  beq hexinf
  cmp.w #searchbu,d0
  beq searchdi


*Show cursor pos -on which byte is

showpos
  lea coor(pc),a2
  move.w (a2),d2 * X pos
  sub.w #15,d2
  blt wiloop
  move.w #400,d3 *asci field beg
  sub.w d3,d2
  blt hexpart
  cmp.w #127,d2
  bgt wiloop
  lsr.w #3,d2
  st disppart-coor(a2) *flag

ypspos
  move.w 2(a2),d1 * Y pos
  sub.w #32,d1
  blt wiloop
  cmp.w #126,d1
  bgt wiloop
  
  and.w #$f8,d1 *drop 3 last bits
  lsl.w #1,d1 *mult by 2
  add.w d2,d1
storcup
  movem.l d1/a2,-(sp)
  move.b curson-coor(a2),d1 *take previos pos
  lea showbuf(pc),a3
*  add.w d1,a3
  move.b (a3,d1),d0  
  bsr calcpos  
  bsr prialn
  movem.l (sp)+,d1/a2

  move.b d1,curson-coor(a2) *store new pos

cursshow  
  lea showbuf(pc),a3
*  add.w d1,a3
  move.b (a3,d1),d0  
  bsr calcpos

tinfdh
  move.l curspo(pc),a1
  tst.b infdh-coor(a2)
  beq.s curdec
  move.b #"&",(a1)+
  bsr prhex2
  bra.s printinv

curdec  bsr prindec3
printinv 
  bsr prihn

curpout  moveq #curspos,d0
  bsr obdr
  bra wiloop


hexpart add.w d3,d2 *restore d2
  cmp.w #377,d2
  bgt wiloop
  ext.l d2
  move.l d2,d4
  lsr.w #3,d4 *div by 8
  divu #3,d4
  swap d4 *look rest
  cmp.b #1,d4
  bgt wiloop
  seq hexnibb-coor(a2) *flag
  divu #24,d2
  sf disppart-coor(a2)
  bra ypspos 

keypre *cursor keys in high byte !
  lea coor(pc),a2
  move.w intout+10-coor(a2),d0
  moveq #0,d1
  move.b curson-coor(a2),d1 *curs pos
  tst.b d0
  bne.s whicdp
  lsr.w #8,d0
  cmp.b #$4b,d0
  beq.s culeft
  cmp.b #$50,d0
  beq.s cudown
  cmp.b #$48,d0
  beq.s cuup
  cmp.b #$4d,d0
  beq.s curight
  cmp.b #$47,d0
  beq.s cuhom
  cmp.b #$62,d0
  beq.s cutoha
  cmp.b #$61,d0 
  bne wiloop
  st disppart-coor(a2)
  bra.s lbr1
cuhom  moveq #0,d1 *home
lbr1 clr.b hexnibb-coor(a2)
  bra storcup
culeft subq.b #1,d1
  bra.s lbr1
cudown add.b #16,d1
  bra.s lbr1
cuup sub.b #16,d1      
  bra.s lbr1
curight addq.b #1,d1
  bra.s lbr1
cutoha  sf disppart-coor(a2)
  bra.s lbr1 

whicdp 
  lea showbuf(pc),a3
  add.w d1,a3 
  tst.b disppart-coor(a2)
  bne.s schflag
  
hexclic cmp.b #"0",d0
  blt wiloop
  cmp.b #"9",d0
  ble.s nument
  bclr #5,d0
  cmp.b #"A",d0
  blt wiloop
  cmp.b #"F",d0
  bgt wiloop
  sub.b #7,d0
nument sub.b #"0",d0
  move.b (a3),d2
  tst.b hexnibb-coor(a2)
  beq.s hexmsb
  and.b #$f0,d2
  bra.s hexmix
hexmsb and.b #$f,d2
  lsl.b #4,d0
hexmix or.b d2,d0 *new hex value      
  
schflag  st chang-coor(a2) *flag
  move.b d0,(a3)   *write change

  tst.b disppart-coor(a2)
  bne.s advcu
  eor.b #$ff,hexnibb-coor(a2)
  bne.s noadvy  

advcu
  addq.b #1,d1
noadvy
  bra storcup

prihn
  tst.b disppart-coor(a2)
  beq.s prihi
  bsr mahid
  pea showcuhn(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  
priinv
  pea showcua(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp

  bra mashow *ret via

prihi bsr mahid
  pea showcuhi(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  
priasn
  pea showcua+2(pc) *skip inverse mode
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp

  bra mashow *ret via  

prialn bsr mahid
  pea showcuhn(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  bra.s priasn


calcpos *d1 -curspos ,d0-byte for show ,a2=coor

*calc vert curs pos from d1 (curson)
  move.b d1,d4
  lsr.b #4,d4 *div by 16
  add.b #36,d4
  move.b d4,showcua+4-coor(a2)
  move.b d4,showcuhn+2-coor(a2)
  move.b d4,showcuhi+4-coor(a2)  
*calc horpos from d1
  move.b d1,d4
  and.b #$f,d4
  moveq #0,d5
  move.b d4,d5
  mulu #3,d5
  add.b #34,d5
  move.b d5,showcuhn+3-coor(a2) *for hex normal
  move.b hexnibb-coor(a2),d3
  and.b #1,d3
  add.b d3,d5
  move.b d5,showcuhi+5-coor(a2)

  add.b #84,d4   *for asci
  move.b d4,showcua+5-coor(a2)

  move.b d0,d4

  moveq #".",d3
  cmp.b #32,d4
  bcs.s wricc
  tst.b howdisp-coor(a2)
  beq.s eighbs
  bclr #7,d4  
  cmp.b #32,d4
  bcs.s wricc  
eighbs  move.b d4,d3
wricc  
  move.b d3,showcua-coor+6(a2)
  
hexcu 
  lea showcuhn+4(pc),a0
  bsr hexbyt
  subq.l #2,a0
  move.b hexnibb-coor(a2),d3
  and.w #1,d3
  add.w d3,a0
  move.b (a0),showcuhi+6-coor(a2)
  rts
    
  
vslida  lea mesbuf(pc),a3

*test close but
  cmp.w #22,(a3)
  beq windclo
  cmp.w #26,(a3)
  bne.s arrow
  
  move.w 8(a3),d1
  move.w totsem(pc),d0

  subq.w #1,d0
  mulu d0,d1
  divu #1000,d1
  bra.s todisp

arrow cmp.w #24,(a3)
  bne wiloop
  move.w 8(a3),d0
  tst.w d0
  beq.s sup
  cmp.w #1,d0
  beq.s sdown
  cmp.w #2,d0
  beq.s lup
  cmp.w #3,d0
  bne wiloop
  moveq #1,d1
  bra.s addofs
sup
  move.w #-10,d1
  tst.b infdh-mesbuf(a3)
  beq.s addofs
  addq.w #2,d1 *paging by 8 by hex
  bra.s addofs
sdown moveq #10,d1
  tst.b infdh-mesbuf(a3)
  beq.s addofs
  subq.w #2,d1
  bra.s addofs
lup move.w #-1,d1
addofs add.w offset(pc),d1
  tst.w d1
  bpl.s todisp
  moveq #0,d1
todisp
  lea totsem(pc),a2
  move.w (a2)+,d2 *offset next
  subq.w #1,d2
  cmp.w d1,d2
  bge.s wnoff
  move.w d2,d1
wnoff
  bsr.s savech
  move.w d1,(a2)  
  bsr printoff
  bsr copyinb
  bra dispbw      


savech * keep d1 !
  lea offset(pc),a2
  tst.b chang-offset(a2) *changed something ?
  beq.s donoth1
  clr.b chang-offset(a2)
  movem.l d1/a2,-(sp)
  moveq #alsavchg,d0
  bsr doalert
  movem.l (sp)+,d1/a2  
  bne donoth1

*copy buffer to RAM
savech2  moveq #0,d3
  move.w (a2),d3
  lsl.l #8,d3 *mult by 256
  lea RAM(pc),a3
  add.l d3,a3
  lea showbuf(pc),a4
  moveq #63,d3
butrl move.l (a4)+,(a3)+
  dbf d3,butrl    
  
donoth1 rts    

savchen lea offset(pc),a2
  bsr.s savech2
  clr.b chang-offset(a2)
  bra dispbw

copyinb
  lea RAM(pc),a3
  lea showbuf(pc),a6
  clr.l d7
  move.w offset(pc),d7
  lsl.l #8,d7 *mult by 256
  add.l d7,a3
  
  moveq #63,d7
insbl move.l (a3)+,(a6)+
  dbf d7,insbl
  clr.b chang
  rts


windclo
  bsr savech

  bsr AEScall
  dc.w 102,1,1,0,0 *WIND_CLOSE
wih2 ds.w 1

  bsr AEScall
  dc.w 103,1,1,0,0 *WIND_DELETE
wih3 ds.w 1

  bsr cldial
  bra drmain  



disp8
  moveq #0,d2
  bra.s writway
disp7  move.w #$100,d2
writway move.w d2,howdisp  
  bsr select
  move.w exd(pc),d1
  moveq #eightbut,d0  
  cmp.w d1,d0
  bne.s dels
delb moveq #sevenbut,d0
dels 
  bsr deselect
  bra.s dispbw1

dispbw 
  st howdisp+1

dispbw1
  bsr mahid
 
  pea home(pc) *cursor to left up corner
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp


  lea showbuf(pc),a6  

  moveq #15,d7  

  
*Display 256 bytes hex 

  
  
filll  lea aline+3(pc),a0
 
  moveq #" ",d4 *space
  moveq #15,d2
clell  move.b (a6)+,d0
  bsr.s hexbyt
  move.b d4,(a0)+ *razmak
  
  dbf d2,clell   
  lea -16(a6),a6 *same bytes again
    
  move.b d4,(a0)+ *razmak  
  move.b d4,(a0)+ *razmak

*display 256 bytes ASCI,if no char then "."
  
*fill line  forth 
  
  moveq #".",d3
  moveq #15,d2
aclell  move.b (a6)+,d0
  cmp.b d4,d0
  bcc.s char
  move.b d3,(a0)+
  bra.s nextbyt
char 
  tst.b howdisp
  beq.s eighb
  bclr #7,d0  
  cmp.b d4,d0
  bcc.s eighb
  move.b d3,(a0)+
  bra.s nextbyt  
eighb  move.b d0,(a0)+
nextbyt
  dbf d2,aclell   
    
  lea linend(pc),a2
  moveq #3,d2
addel move.b (a2)+,(a0)+
  dbf d2,addel

 
*show 1 line of 16

  pea aline(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  
  dbf d7,filll
  bsr mashow
  lea coor(pc),a2
  moveq #0,d1
  tst.b howdisp+1-coor(a2)
  beq.s nocupoch

  move.b d1,curson-coor(a2) 
lbr2  bra cursshow
nocupoch move.b curson-coor(a2),d1
  bra.s lbr2  


hexbyt move.b d0,d5
  and.b #$f0,d5
  lsr.b #4,d5
  bsr.s convl
nibbl  move.b d0,d5
  and.b #$0f,d5 
convl  add.b #"0",d5
  cmp.b #"9",d5
  ble.s nolet
  addq.b #7,d5  *slovo A-F
nolet  move.b d5,(a0)+
  rts


wfname moveq #2,d0
  move.w d0,wih1+2


windset
  bsr AEScall
  dc.w 105,6,1,0,0
wih1 dc.w 0,2 *WF_NAME
  dc.l winam,0 *0 is dummy
  rts

windopen  
  bsr AEScall
  dc.w 101,5,1,0,0 *WIND_OPEN
wihan ds.w 1
wic2  ds.w 4
  rts


*print offset in title
 

printoff 
  tst.b infdh
  beq.s todecoff
  bsr hexoff
  bra.s cvslide
  
todecoff  bsr decoff
    
*Calc Vslide
cvslide  moveq #0,d0
  moveq #0,d1
  move.w offset(pc),d0
  mulu #1000,d0
  move.w totsem(pc),d1
  subq.w #1,d1
  divu d1,d0

  move.w d0,wih5+4
  bsr AEScall
  dc.w 105,6,1,0,0
wih5 dc.w 0,9
  dc.w 0,0,0,0  
  rts

decinf bsr select
  moveq #hexbut,d0
  bsr deselect
  
*restore . , KB etc 
  lea winam+12(pc),a2
  lea winamd(pc),a1 
  moveq #22,d2
widcl move.b (a1)+,(a2)+  
  dbf d2,widcl 
  
  bsr decwin
  moveq #0,d0
comine
  lea coor(pc),a2
  move.b d0,infdh-coor(a2)  
  moveq #0,d1
  move.b curson(pc),d1
  bra tinfdh
  
  
hexinf bsr select
  moveq #decbut,d0
  bsr deselect
  
  bsr.s hexwin

  moveq #33,d0
  bra comine

  
*Create hex. val. for winam    

hexwin  move.l len(pc),d1
  lea winam+26(pc),a1 *text depend
  move.b #"&",(a1)+
  bsr prhex6  

hexoff  move.w offset(pc),d1
  lea winam+8(pc),a1
  moveq #" ",d2
  move.b d2,(a1)+
  move.b d2,(a1)+
  move.b #"&",(a1)+ 
  ext.l d1
  lsl.l #8,d1 *mult by 256
   
  bsr prhex5
  move.b d2,(a1)

  bra wfname *ret via

  
*Create decim. val. for winam    

decwin  move.w totsem(pc),d1
  lsr.w #2,d1  *divide by 4 for KB
  lea winam+27(pc),a1 *text depend
  bsr prindec4  

decoff  move.w offset(pc),d1
  lea winam+8(pc),a1
  move.w d1,d0
  lsr.w #2,d1 *div by 4

  bsr prindec4
  addq.l #1,a1 *skip coma
  and.b #3,d0
  subq.b #1,d0
  bmi.s twoz
  subq.b #1,d0
  bmi.s quart
  subq.b #1,d0
  bmi.s half
  move.b #"7",(a1)+
  bra.s quar2
twoz move.b #"0",(a1)+    
  bra.s hal2
half move.b #"5",(a1)+
hal2  move.b #"0",(a1) 
  bra.s comwr
quart move.b #"2",(a1)+
quar2 move.b #"5",(a1)    
 
comwr
  bra wfname *ret via

*Search rutines

searchdi
  bsr savech
  lea 3.w,a0  *Object ident
  bsr takeadr
  bsr opdial
  bsr drdial
seardl
  bsr fodial
  move.w excod(pc),d0
  cmp.w #srhexbu,d0
  beq.s setshm
  cmp.w #casdifbu,d0
  beq setcasd
  cmp.w #srchokbu,d0
  beq search



setshm
  lea $20000+14,a0
  bsr takeadr
  move.l (a0),a1
  lea howsr1(pc),a2
  eor.b #1,(a2)
  lea ascist(pc),a2
  moveq #4,d2 *text len max 5 char !

chahl move.b (a2),d0 *exchange texts
  move.b (a1),(a2)+
  move.b d0,(a1)+
  dbf d2,chahl
  move.w excod(pc),d0
  bsr obdr
  bsr ocrd
   
  bra seardl


setcasd
  lea $20000+15,a0
  bsr takeadr
  move.l (a0),a1
  lea howsr2(pc),a2
  eor.b #1,(a2)
  lea samst(pc),a2
  moveq #8,d2 *text len max 9 char !
  bra.s chahl


search
  
  bsr mabee
  lea $2000d,a0 *ted 13
  bsr takeadr
  move.l (a0),a0 *entry adress
*find len
  move.l a0,a3
  tst.b (a3)+
  beq notfound *zero len entered
  moveq #0,d4
  
finll addq.b #1,d4
  tst.b (a3)+
  bne.s finll  
  
  lea howsr1(pc),a5
  tst.b (a5)
  bne.s ascisear
    
*hex search
  btst #0,d4
  bne badhexe *char # must be even
  move.w d4,d5
  subq.w #1,d5
  lsr.w #1,d4
  lea hexsebuf(pc),a3 
  
hexsecl
  move.b (a0)+,d0 
  cmp.b #"0",d0
  blt badhexe *ignore incorrect entry
  cmp.b #"9",d0
  ble.s nument1
  bclr #5,d0
  cmp.b #"A",d0
  blt notfound
  cmp.b #"F",d0
  bgt badhexe
  sub.b #7,d0
nument1 sub.b #"0",d0
  btst #0,d5
  beq.s hexmix2
  lsl.b #4,d0
  move.b d0,d2
  subq.w #1,d5
  bra.s hexsecl
  
hexmix2 or.b d0,d2 *new hex value      
  move.b d2,(a3)+
  dbf d5,hexsecl 

  lea hexsebuf(pc),a0
  
  
ascisear  subq.w #2,d4
  move.w d4,d5

  lea RAM(pc),a3
  move.l a3,a4
  add.l len(pc),a4 *end
*add offset needed
  moveq #0,d0
  move.w offset(pc),d0
  lsl.l #8,d0 *mult by 256
  add.b curson(pc),d0 *no carry sure
  add.l d0,a3 *search begin here
  addq.l #1,a3 *step forward
  move.l a4,d1
  sub.l a3,d1 *len of search area
  move.w d1,d2
  swap d1 *for fastest search
  subq.w #1,d2 
  move.w #$ffff,d3  
  move.b (a0)+,d0 *first byte in d0
  move.l a0,a1
  move.l a3,a2
  tst.b (a5)
  beq.s searab1
  tst.b howsr2-howsr1(a5)
  bne uplos

searab1  move.l a1,a0 *restore string adress+1
  move.l a2,a3 *one step only if not found whole string
  move.w d5,d4 *restore len
  cmp.w d2,d3
  beq.s hiwl
searl1  cmp.b (a3)+,d0 
  dbeq d2,searl1 *fastest system (i hope so)
  beq.s foun1s

hiwl  dbf d1,searl1

  bra.s notfound
  
foun1s 
  move.l a3,a2
  tst.w d4
  bmi.s strif *if len of string is 1
founl1  cmp.b (a3)+,(a0)+
  dbne d4,founl1
     
  bne.s searab1 *not found whole len

strif
  cmp.l a3,a4 *is out from area
  blt.s notfound
*calc offset & curson
  addq.w #2,d5
  sub.w d5,a3
  lea RAM(pc),a2
  sub.l a2,a3
  move.l a3,d5
  divu #256,d5
  move.w d5,offset-RAM(a2)
  swap d5
  move.b d5,curson-RAM(a2)
  clr.b hexnibb-RAM(a2)
  move.b howsr1-RAM(a2),disppart-RAM(a2) *field set
  bsr printoff
  bra.s offokk

badhexe
  moveq #albadhex,d0
  bra.s nfalert
notfound
*leave search dialog
  moveq #alstrinf,d0
nfalert  bsr doalert
offokk
  bsr copyinb *for no change reprint
  bsr obcnor
  bsr maarr
  lea 2.w,a0 *dispdial
  bsr takeadr
  bsr opdial
  move.w #dispbut,excod *for main dial
  clr.b howdisp+1 *flag

  bra dispbw1

*search if upper/lower case is same
*make all letters in entered string to upper
uplos
  subq.l #1,a0
  lea hexsebuf(pc),a3
  move.l a3,a1
  addq.w #1,d4
mallul move.b (a0)+,(a3)
  bclr #5,(a3)+
  dbf d4,mallul  
  move.b (a1)+,d0

searab2  move.l a1,a0 *restore string adress+1
  move.l a2,a3 *one step only if not found whole string
  move.w d5,d4 *restore len
  cmp.w d2,d3
  beq.s hiwl2
searl2 move.b (a3)+,d6
  bclr #5,d6
  cmp.b d6,d0 
  dbeq d2,searl2
  beq.s foun1s2

hiwl2  dbf d1,searl2

  bra.s notfound
  
foun1s2 
  move.l a3,a2
  tst.w d4
  bmi strif *if len of string is 1
founl12 move.b (a3)+,d6
  bclr #5,d6
  cmp.b (a0)+,d6
  dbne d4,founl12
     
  bne.s searab2 *not found whole len
  bra strif *here check -is letters !!



prindec4 move.l #1000,d2 *max 4 digit
  moveq #3,d4
  bra.s dec2

prindec3  *Input: d1- value, a1 -dest for ASCI decimal

  moveq #100,d2 *3 digits max
  moveq #2,d4
dec2  moveq #10,d3
  move.b #-$10,d5 *Space code prepare
hdlp and.l #$ffff,d1 *
  divu d2,d1
  beq.s less
  clr.b d5
  bra.s moretz
less tst.b d4  *If is 0!
  bne.s skip
  clr.b d5
skip  move.b d5,d1
moretz add.b #$30,d1
  move.b d1,(a1)+
  swap d1
  divu d3,d2
  dbf d4,hdlp
  rts




*DO DIALOG SUBRUTINE
*In parameter:a0-tree adress

*First centre objekt
opdial 
  lea fca(pc),a1
  move.l a0,(a1)
  move.l a0,oda-fca(a1) 
  move.l a0,fda-fca(a1)
  move.l a0,oca-fca(a1)
  move.l a0,oda2-fca(a1)
  move.l a0,oca2-fca(a1)

  bsr AEScall
  dc.w 54,0,5,1,0
fca ds.l 1

*Enter coords
  lea cost(pc),a1 
  lea intout+2(pc),a0
  bsr.s copint2
  bsr.s copints
  lea odp+4(pc),a1 
  bsr.s copints
  lea odp2+4(pc),a1
  bsr.s copints
  lea fdf+2(pc),a1
  bsr.s copints
  bsr.s copints
  lea exc+4(pc),a1
  bsr.s copints
  lea exd+4(pc),a1
   
copints lea cost(pc),a0
copint2 moveq #3,d0
copil move.w (a0)+,(a1)+
  dbf d0,copil
  rts

*Reserve screen part

drdial  bsr AEScall
  dc.w 51,9,1,0,0
  dc.w 0
cost ds.w 8 


  bsr AEScall
  dc.w 42,6,1,1,0
odp dc.w 0,30
  ds.w 4
oda ds.l 1
  rts


*Object exit rutine "Form do"
fodial  bsr AEScall
  dc.w 50,1,1,1,0
  dc.w 0
fda ds.l 1
  move.w intout(pc),excod  *Save exit button
  rts


cldial
*Back screenpart
  bsr AEScall
  dc.w 51,9,1,0,0
fdf dc.w 3
  ds.w 8
  rts


*object change for dispdial+ for type select

select moveq #1,d2 *in d0 must be object No
  bra.s objch
 
deselect  moveq #0,d2
*  bra.s setstat
objch  move.w d0,exd *object number
setstat  move.w d2,statusd  *0=normal status ;1=selected
 
  bsr AEScall
  dc.w 47,8,1,1,0
exd dc.w 0,0,0,0,0,0
statusd  dc.w 0,1 *redraw
oca2 ds.l 1
  rts




*Object change
obcnor
*  clr.w exc+14  *No redraw by leave dialog
ocrd
  lea exc(pc),a1
  move.w excod-exc(a1),(a1)
  clr.w status-exc(a1)  *normal status
ochl 
  bsr AEScall
  dc.w 47,8,1,1,0
exc dc.w 0,0,0,0,0,0
status  dc.w 0,1
oca ds.l 1
*  move.w #1,exc+14 *back redraw
  rts


AEScall  move.l (sp),a0  * control block
  lea AESPB(pc),a2
  move.l a0,(a2)
  lea 10(a0),a1
  move.l a1,pintin-AESPB(a2)
  move.w 2(a0),d0  *# of intin
  lsl.w #1,d0  
  add.w d0,a1  *adress of addrin
  tst.w 6(a0)
  beq.s noadrin
  move.l a1,paddrin-AESPB(a2)
  addq.l #4,a1 
  cmp.w #2,6(a0)
  bne.s noadrin
  addq.l #4,a1
noadrin  move.l a1,(sp)  *Skip datas!
  move.l a2,d1
  move.w #200,d0
  trap #2  *Call AES function
  rts

AESPB ds.l 1  * pcontrol
pglobal dc.l global
pintin ds.l 1
pintout dc.l intout
paddrin ds.l 1
paddrout dc.l addrout



prhex6 move.l d1,d5 
  swap d5
  and.w #$00f0,d5
  moveq #4,d4
  bsr.s conv

prhex5 move.l d1,d5 
  swap d5
  and.w #$000f,d5
  bsr.s conv1

prhex4 move.w d1,d5 
  and.w #$f000,d5
  moveq #12,d4
  bsr.s conv
prhex3  move.w d1,d5
  and.w #$0f00,d5
  moveq #8,d4
  bsr.s conv
prhex2 move.w d1,d5
  and.w #$00f0,d5
  moveq #4,d4
  bsr.s conv
  move.w d1,d5
 and.w #$000f,d5 
  bra.s conv1
conv  lsr.w d4,d5
conv1  add.b #"0",d5
  cmp.b #"9",d5
  ble.s notlet
  addq.b #7,d5  *slovo A-F
notlet  move.b d5,(a1)+
  rts



*Take adress
takeadr move.l a0,tap
  bsr AEScall
  dc.w 112,2,1,0,1
tap  dc.w 0,0
  move.l addrout(pc),a0
  rts    

doalert
  lea $00050000,a0
  add.l d0,a0
  bsr.s takeadr
doalert1  move.l a0,ala
  bsr AEScall
  dc.w $34,1,1,1,0
  dc.w 1  *Default
ala  dc.l 0 
  cmp.w #1,intout
  rts

obdr move.w d0,odp2
  bsr AEScall
  dc.w 42,6,1,1,0
odp2 dc.w 0,0
  ds.w 4
oda2 ds.l 1
  rts

mahid move.w #256,d2
  bra.s grafmo
mashow move.w #257,d2
  bra.s grafmo   

maarr moveq #0,d2
  bra.s grafmo
mabee moveq #2,d2
grafmo move.w d2,mousf
  bsr AEScall
  dc.w 78,1,1,1,0
mousf dc.w 3
  dc.l $20000 *Not used
  rts


*begup  bsr AEScall *wind update
*  dc.w 107,1,1,0,0
*  dc.w 1
*  bra.s mabee *ret via

*endup  bsr AEScall
*  dc.w 107,1,1,0,0
*  dc.w 0
*  bra.s maarr *ret via


  section data

typec dc.w -1 *init val -mean type not set
len dc.l 16384
excod dc.w dispbut *for first
infdh dc.b 0
modeop dc.b 0
voltag dc.b 0 *0-12.5V ,1-21V ,2-25V
  even
howsr1 ds.b 1
howsr2 ds.b 1

howdisp dc.w 0
nomem dc.b "[3][ | |No enough free memory!][ABORT]",0  
rsn dc.b "EPROM.RSC",0
fmis dc.b "[3][ | |File EPROM.RSC missing !][ABORT]",0
  even
path dc.b "A:\*.*",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

winam dc.b " OFFSET 0999.5 KB / TOTAL    2 KB ",0
winamd dc.b ".5 KB / TOTAL    2 KB ",0

home dc.b 27,"Y",36,32,0 
linend  dc.b 32,10,13,0
showcua dc.b 27,"p",27,"Y",36,34,"X",27,"q",0
showcuhn dc.b 27,"Y",36,34,"F","F",0
showcuhi dc.b 27,"p",27,"Y",36,34,"F",27,"q",0
ascist dc.b "ASCII"
samst dc.b "  SAME   "

  even
chang dc.b 0,0 *0 -no change ;1- change occured
curson dc.b 0 *0-255
disppart dc.b 0 *0-hex ;1-asci
hexnibb dc.b 0 *0-ms. nibble, 1-ls. nibble

*aline to odd
aline dc.b 27,"C",32 *curs right

  section bss

  ds.b 80 *for aline
dats ds.b 16
pada ds.b 40
handl ds.w 1
mainex ds.w 1

SSP ds.l 1
ident ds.w 1
voltc ds.w 1 *byte enough

totsem ds.w 1 *must together with offset !
offset ds.w 1 *in pages of 256 bytes

curspo ds.l 1
consm ds.w 1

global ds.l 16  
intout ds.w 7  *max 7
addrout ds.l 1  *max 1

mesbuf ds.b 16
  ds.b 350
sups  
  ds.b 350  * stack !
stend
  ds.b 100
regsav ds.b 4
hexsebuf ds.b 30
showbuf ds.b 256  
RAM  *must be last


   

