; 
; TAG-Liste fr Verweise von Worten auf Dateien
; Es gibt dafr einige Kommandos, um die Aktion zu steuern.

;
;  Ein TAG (also die Zeichenkette, die als TAG-Link agiert) darf bis zu
;   128 Zeichen lang sein.
;  Eine TAG-Datei trgt die Dateiendung '.tag' bzw. '.TAG'.

;
; Kommando        Wirkung
; ---------------------------------------------------------------
;
; @file$("<",">")  
;
; extrahiert den TAG-Link-Dateipfad aus dem Text, der nach dem TAG 
; folgt und der sich innerhalb der beiden anzugebenden Zeichen befindet. 



; Die eigentliche Tagfunktion '@tag(..)' und ihre Parameter:
; ========================================================== 

; Der Text des ersten Parameters innerhalb der Gnsefchen ist der 
; Suchtext, bei dessen bergabe das Tag ausgefhrt wird. 

; Der Text des zweiten Parameters innerhalb der Gnsefchen 
; oder das einsetzen einer Textfunktion wie '@file$()', bezeichnet 
; den Suchpfad der Datei, die dann durch das TAG geffnet werden 
; soll.

; newflag: Wenn man hier TRUE eingetragen hat, wird ein neues
; Fenster fr die TAG-Link-Datei geffnet. Wenn der aktuelle Text 
; (aus dem das TAG aktiviert wurde) berladen werden soll, ist hier
; FALSE einzutragen.

; saveflag: Wenn man hier TRUE eingetragen hat, wird die aktuelle 
; Datei (aus dem das TAG aktiviert wurde) vor dem ffnen der im 
; TagLink definierten Datei gespeichert.

; Beispiel 1 :
; ================================================================

;@tag("hallo","f:\test.txt",true,false)

; wird der Text 'hallo' (ohne Hochkommas) selektiert und als
; Tag aktiviert (also F1 drcken), dann wird die Datei test.txt 
; von f:\ in ein neues Fenster geladen.

; Beispiel 2 :
; ================================================================

;@tag("include",@file$("<",">"),false,true)

; wird der Text 'include' (ohne Hochkommas) selektiert und als
; Tag aktiviert, dann wird die Datei, dessen Dateipfad nach 'include' 
; in spitzen Klammern steht, in das aktuelle Fenster berladen. 
; Vorher wird noch der aktive Text gespeichert (weil als saveflag 
; 'true' steht).

; zum Testen:

@tag("hallo","f:\test.txt",true,false)
@tag("include",@file$("<",">"),false,true)
@tag("class",@file$("<",">"),false,true)
@tag("modul",@file$("<",">"),false,true)




