/*      transprt.h        (c) Steve Adam 1995   steve@netinfo.com.au
 *
 *      Include this file to use functions from the tcp module.
 *      ie: tcp/udp, etc....
 */

#ifndef STIK_TRANSPRT_H
#define STIK_TRANSPRT_H

#ifndef   STIK_DRIVERS_H
#include  "drivers.h"
#endif /* STIK_DRIVERS_H */

#define TRANSPORT_DRIVER    "TRANSPORT_TCPIP"
#define STATUS_DRIVER		"STACK_STATUS"

/* TCP connection states    */
#define TCLOSED     0   /* No connection.  Null, void, absent, .....        */
#define TLISTEN     1   /* Wait for remote request.                         */
#define TSYN_SENT   2   /* Connect request sent.  Await matching request    */
#define TSYN_RECV   3   /* Wait for connection ACK.  (Listener only??)      */
#define TESTABLISH  4   /* Connection is established.  Handshake completed  */
#define TFIN_WAIT1  5   /* Await termination request or acknowledgement     */
#define TFIN_WAIT2  6   /* Await termination request.                       */
#define TCLOSE_WAIT 7   /* Await termination request from local user        */
#define TCLOSING    8   /* Await termination acknowledge from remote TCP    */
#define TLAST_ACK   9   /* Await acknowledgement of terminate request sent  */
#define TTIME_WAIT 10   /* Delay to ensure remote has received term' ACK    */

/* Connection information block	*/

typedef struct cib {        /* Connection Information Block.    */
    uint16      protocol;   /* TCP or UDP or ... 0 means CCB not in use */
    uint16      lport;      /* TCP client port.  (ie: At this machine)  */
    uint16      rport;      /* TCP server port.  (ie: remote machine)   */
    uint32      rhost;      /* TCP server IP addr. (ie: remote machine) */
	uint32		lhost;		/* TCP client IP addr. (ie: At this machine)*/
} CIB;

/*  Values for protocol field    */
#define P_ICMP   1
#define P_TCP    6
#define P_UDP   17

/*  status structure/functions   */

typedef struct status_l {
    char    *module;    /* specific string that can be searched for */
    char    *author;    /* Any string                               */
    char    *version;   /* Format `00.00' Version:Revision          */
    long  * cdecl (*get_elog)(void);
	PPP_ST *cdecl (*query_state)(void);
	int16   cdecl (*Set_DNS)(char *);
    } STATUS_L;
    
/*  Transport structure/functions   */

typedef struct tpl {
    char    *module;    /* specific string that can be searched for */
    char    *author;    /* Any string                               */
    char    *version;   /* Format `00.00' Version:Revision          */
    char  * cdecl (*KRmalloc)(int32);
    void    cdecl (*KRfree)(char *);
    int32   cdecl (*KRgetfree)(int16 x);
    char  * cdecl (*KRrealloc)(char *, int32);
    char  * cdecl (*get_err_text)(int16);
    char  * cdecl (*getvstr)(char *);
    int16   cdecl (*carrier_detect)(void);
    int16   cdecl (*TCP_open)(uint32, int16, int16, uint16);
    int16   cdecl (*TCP_close)(int16, int16);
    int16   cdecl (*TCP_send)(int16, char *, int16);
    int16   cdecl (*TCP_wait_state)(int16, int16, int16);
    int16   cdecl (*TCP_ack_wait)(int16, int16);
    int16   cdecl (*UDP_open)(uint32, int16);
    int16   cdecl (*UDP_close)(int16);
    int16   cdecl (*UDP_send)(int16, char *, int16);
    int16   cdecl (*CNkick)(int16);
    int16   cdecl (*CNbyte_count)(int16);
    int16   cdecl (*CNget_char)(int16);
    NDB   * cdecl (*CNget_NDB)(int16);
    int16   cdecl (*CNget_block)(int16, char *, int16);
    void    cdecl (*housekeep)(void);
    int16   cdecl (*resolve)(char *, char **, uint32 *, int16);
    void    cdecl (*ser_disable)(void);
    void    cdecl (*ser_enable)(void);
    int16	cdecl (*set_flag)(int16);
    void	cdecl (*clear_flag)(int16);
    CCB   * cdecl (*CNgetinfo)(int16);
   	int16 	cdecl (*on_port)(char *port);
	void 	cdecl (*off_port)(char *port);
	int16   cdecl (*setvstr)(char *vs, char *value);
	int16 	cdecl (*query_port)(char *port);
	int16	cdecl (*CNgets)(int16, char *, int16, char);
	int16	cdecl (*ICMP_send)(uint32, uint8, uint8, void *, uint16);
	int16	cdecl (*ICMP_handler)(void *,int16);
	int16	cdecl (*ICMP_discard)(void *);
	int16   cdecl (*TCP_info)(int16, TCPIB *);
	int16   cdecl (*cntrl_port)(char *, uint32, int16);
	int16   cdecl (*UDP_info)(int16, void *);
	int16	cdecl (*RAW_open)(uint32);
	int16	cdecl (*RAW_close)(int16);
	int16	cdecl (*RAW_out)(int16, void *, int16, uint32);
	int16 	cdecl (*CN_setopt)(int16, int16, const void *, int16);
	int16 	cdecl (*CN_getopt)(int16, int16, void *, int16 *);
	void	cdecl (*CNfree_NDB)(int16, NDB *);
 } TPL;

extern TPL *tpl;

#define KRmalloc(x)             (*tpl->KRmalloc)(x)
#define KRfree(x)               (*tpl->KRfree)(x)		
#define KRgetfree(x)            (*tpl->KRgetfree)(x)
#define KRrealloc(x,y)          (*tpl->KRrealloc)(x,y)
#define get_err_text(x)         (*tpl->get_err_text)(x)
#define getvstr(x)              (*tpl->getvstr)(x)
#define carrier_detect()        (*tpl->carrier_detect)()
#define TCP_open(h,p,t,o)       (*tpl->TCP_open)(h,p,t,o)
#define TCP_close(x,y)          (*tpl->TCP_close)(x,y)
#define TCP_send(x,y,z)         (*tpl->TCP_send)(x,y,z)
#define TCP_wait_state(x,y,z)   (*tpl->TCP_wait_state)(x,y,z)
#define TCP_ack_wait(x,y)       (*tpl->TCP_ack_wait)(x,y)
#define UDP_open(x,y)           (*tpl->UDP_open)(x,y)
#define UDP_close(x)            (*tpl->UDP_close)(x)
#define UDP_send(x,y,z)         (*tpl->UDP_send)(x,y,z)
#define CNkick(x)               (*tpl->CNkick)(x)
#define CNbyte_count(x)         (*tpl->CNbyte_count)(x)
#define CNget_char(x)           (*tpl->CNget_char)(x)
#define CNget_NDB(x)            (*tpl->CNget_NDB)(x)
#define CNget_block(x,y,z)      (*tpl->CNget_block)(x,y,z)
#define housekeep()             (*tpl->housekeep)()
#define resolve(w,x,y,z)        (*tpl->resolve)(w,x,y,z)
#define ser_disable()           (*tpl->ser_disable)()
#define ser_enable()            (*tpl->ser_enable)()
#define set_flag(x)             (*tpl->set_flag)(x)
#define clear_flag(x)           (*tpl->clear_flag)(x)
#define CNgetinfo(x)            (*tpl->CNgetinfo)(x)
#define	on_port(x)				(*tpl->on_port)(x)
#define off_port(x)				(*tpl->off_port)(x)
#define setvstr(x,y)			(*tpl->setvstr)(x,y)
#define query_port(x)			(*tpl->query_port)(x)
#define CNgets(w,x,y,z)			(*tpl->CNgets)(w,x,y,z)
#define ICMP_send(v,w,x,y,z)	(*tpl->ICMP_send)(v,w,x,y,z)
#define ICMP_handler(x,y)		(*tpl->ICMP_handler)(x,y)
#define ICMP_discard()			(*tpl->ICMP_discard)(x)
#define TCP_info(x,y)			(*tpl->TCP_info)(x,y);
#define cntrl_port(x,y,z)		(*tpl->cntrl_port)(x,y,z);
#define UDP_info(x,y)			(*tpl->UDP_info)(x,y);
#define	RAW_open(x)				(*tpl->RAW_open)(x)
#define	RAW_close(x)			(*tpl->RAW_close)(x)
#define	RAW_out(w,x,y,z)		(*tpl->RAW_out)(w,x,y,z)
#define	CN_setopt(w,x,y,z)		(*tpl->CN_setopt)(w,x,y,z)
#define	CN_getopt(w,x,y,z)		(*tpl->CN_getopt)(w,x,y,z)
#define CNfree_NDB(x,y)			(*tpl->CNfree_NDB)(x,y)

extern STATUS_L *stats;

#define get_elog()             (*stats->get_elog)()
#define query_state()		   (*stats->query_state)()
#define Set_DNS(x)			   (*stats->Set_DNS)(x)

#endif /* STIK_TRANSPRT_H */

