;----------------------------------------------------------------------------
;File name:	AUTOTAKE.T			Revision date:	1998.06.22
;Revised by:	Ronald Andersson		Revision start:	1998.06.22
;----------------------------------------------------------------------------
; @(#)autotake.t, Dirk Haun, 05.05.1996
; Auto-Takefile fr Pure C
;
env PURE=d:\pure_c			; Pure-C-Verzeichnis
env LIB=$PURE\lib			; Verzeichnis, in dem die Libs stehen
env PRGEXT=app				; Default-Extension fr neue Programme
env OPTC=-Y				; Default-Compileroptionen
env OPTL=-L -G -Y			; Default-Linkeroptionen
env OPTA=-Y				; Default-Assembleroptionen
env DEFINES=-DGERMAN			; sonstige Compileropt., z.B. Defines
env TAKE=$HOME\defaults\chatwin.cnf\pure_c	; Verzeichnis fr die Takefiles
;
; das fertige Programm lt sich so einfach mit "run" starten
alias run $PRGPATH\%%.$PRGEXT $*
;
;----------------------------------------------------------------------------
;----- Makros fr Project-Files in Chatwin ---------------------------
;----------------------------------------------------------------------------
macro	setup_paths
  env SRC=$CD			;Source directory
  env OBJ=$CD			;Object directory
  env PRGPATH=$CD		;Target program directory
endm
;----------------------------------------------------------------------------
; @(#)find_src.t, Ronald Andersson, 1998.06.22
;
; This macro will erase any old ChatWin filelist, and create a
; new list containing all ".H", ".C", and ".S" files found in the
; current work directory.  They will be entered in groups for each
; of the three file types, in the order used for the search as is
; given above.
;
; Usage:	Call it from an 'AUTOTAKE.T', or through the entry
;		"anderes Takefile..." in the "Take" menu.
;
macro	make_src_list
dellist *
fsdir *.h
if !env(FSNAME=) && !env(FSPATH=)
  repeat
    addlist $FSPATH\$FSNAME.$FSEXT
    fsdir
  until env(FSNAME=) && env(FSPATH=)
endif
fsdir *.c
if !env(FSNAME=) && !env(FSPATH=)
  repeat
    addlist $FSPATH\$FSNAME.$FSEXT
    fsdir
  until env(FSNAME=) && env(FSPATH=)
endif
fsdir *.s
if !env(FSNAME=) && !env(FSPATH=)
  repeat
    addlist $FSPATH\$FSNAME.$FSEXT
    fsdir
  until env(FSNAME=) && env(FSPATH=)
endif
endm	make_src_list
;----------------------------------------------------------------------------
macro project
  setup_paths
  echo Project: $0
  env THECURRPATH=$CD
  env FNREM=%
  fname $0
  env PROJECT=%%
  if !$TAKE\$PROJECT.lnk || time($TAKE\$PROJECT.lnk<$TAKE\$PROJECT.t)
    echo $-O=$PRGPATH\$PROJECT.$PRGEXT >$TAKE\$PROJECT.lnk
    env CREATE=NEW
  else
    env CREATE
  endif
  env BREAK
endm
;----------------------------------------------------------------------------
macro use
  if !env(BREAK=TRUE)
    shift
    fname $SHIFT
    fsplit $SHIFT
    if env(FSEXT=c) || env(FSEXT=C)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.c)
        env CCEXT=c
        $TAKE\compile.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=s) || env(FSEXT=S)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.s)
        $TAKE\assemble.t
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=o) || env(FSEXT=O)
      if env(CREATE=NEW)
        echo %.O >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=lib) || env(FSEXT=LIB)
      if env(CREATE=NEW)
        echo %.LIB >>$TAKE\$PROJECT.lnk
      endif
    else ; alles andere wird wie *.c behandelt
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.$FSEXT)
        env CCEXT=$FSEXT
        $TAKE\compile.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    endif
  endif
  if env(BREAK=TRUE) && env(CREATE=NEW)
    rm -q $TAKE\$PROJECT.lnk
  endif
endm
;----------------------------------------------------------------------------
macro link
  if !env(BREAK=TRUE)
    echo Linking "$PROJECT.$PRGEXT"
    ld $OPTL $* -C=$TAKE\$PROJECT.lnk >$OBJ\linker.err
    if $?
      more $OBJ\linker.err
    else
      rm $OBJ\linker.err
    endif
  endif
  fname $FNREM
  cd $THECURRPATH
  env THECURRPATH
  env FNREM
  env CREATE
  env BREAK
  env PROJECT
  env CCEXT
endm
;------------------------------------
setup_paths
make_src_list
;----------------------------------------------------------------------------
;End of file:	AUTOTAKE.T
;----------------------------------------------------------------------------
